/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.config;

import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.util.Log4jConfig;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class StationProfile {
    static Logger logger;
    String networkID = "";
    String discrip = "";
    String version = "1.0";
    double clat;
    double clon;
    double calt = 0.0;
    Vector stationList = new Vector();
    Vector netStationList = new Vector();
    Vector stations = new Vector(10);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.seis.config.StationProfile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain("StationProfile.properties");
        try {
            StationProfile sprofile = new StationProfile();
            sprofile.parseNetwork(new FileInputStream("/tmp/network.xml"));
            logger.info("Clat: " + sprofile.getClat());
            logger.info("Clon: " + sprofile.getClon());
            logger.info("Calt: " + sprofile.getCalt());
            logger.info("Calt: " + sprofile.getCalt());
            logger.info("Total Station: " + sprofile.getNStation());
            logger.info("Total Channel: " + sprofile.getNChannel());
            sprofile.writeXML("/tmp/network_doc.xml");
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public void writeXML(String xmlFile) throws IOException {
        Document doc = this.buidDocument();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            FileOutputStream fos = new FileOutputStream(xmlFile);
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(fos);
            Transformer transformer = tFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException tce) {
            logger.warn("\n** Transformer Factory error");
            logger.warn("   " + tce.getMessage());
        }
        catch (TransformerException tranFunEx) {
            logger.warn("\n** Transformation error");
            logger.warn("   " + tranFunEx.getMessage());
        }
    }

    Document buidDocument() {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        Element root = doc.createElement("NETWORK");
        root.setAttribute("Name", this.networkID);
        root.setAttribute("Version", this.version);
        root.setAttribute("CLat", "" + this.clat);
        root.setAttribute("CLon", "" + this.clon);
        root.setAttribute("Discrip", this.discrip);
        root.appendChild(doc.createTextNode("\n"));
        doc.appendChild(root);
        int size = this.stations.size();
        int i = 0;
        while (i < size) {
            Station sttn = (Station)this.stations.get(i);
            Element station = doc.createElement("STATION");
            root.appendChild(station);
            root.appendChild(doc.createTextNode("\n"));
            station.setAttribute("Net", sttn.getNet());
            station.setAttribute("Sta", sttn.getSta());
            station.setAttribute("Cname", sttn.getCname());
            station.setAttribute("Sname", sttn.getSname());
            station.setAttribute("StaType", sttn.getStaType());
            station.setAttribute("Lat", "" + sttn.getLat());
            station.setAttribute("Lon", "" + sttn.getLon());
            station.setAttribute("Coordsys", sttn.getCoordsys());
            station.setAttribute("Elev", "" + sttn.getElev());
            station.setAttribute("MType", sttn.getMtype());
            station.setAttribute("TransmitType", sttn.getTransmitType());
            station.setAttribute("Ondate", sttn.getOndate());
            station.setAttribute("Offdate", sttn.getOffdate());
            station.setAttribute("Comment", sttn.getComment());
            station.appendChild(doc.createTextNode("\n"));
            int chn = 0;
            while (chn < sttn.chans.size()) {
                Channel chnnl = (Channel)sttn.chans.get(chn);
                Element channel = doc.createElement("CHANNEL");
                station.appendChild(channel);
                station.appendChild(doc.createTextNode("\n"));
                channel.setAttribute("Cha", chnnl.getCha());
                channel.setAttribute("LocID", chnnl.getLocID());
                channel.setAttribute("Hang", "" + chnnl.getHang());
                channel.setAttribute("Vang", "" + chnnl.getVang());
                channel.setAttribute("SampleRate", "" + chnnl.getSampleRate());
                channel.appendChild(doc.createTextNode("\n"));
                Element response = doc.createElement("RESPONSE");
                channel.appendChild(response);
                channel.appendChild(doc.createTextNode("\n"));
                response.appendChild(doc.createTextNode("\n"));
                Element paz = doc.createElement("PAZ");
                response.appendChild(paz);
                response.appendChild(doc.createTextNode("\n"));
                paz.setAttribute("Snum", "" + chnnl.tranFun.getSnum());
                paz.setAttribute("Iunits", chnnl.tranFun.getIunits());
                paz.setAttribute("Ounits", chnnl.tranFun.getOunits());
                paz.setAttribute("Sfactor", "" + chnnl.tranFun.getSfactor());
                paz.setAttribute("Sensitivity", "" + chnnl.tranFun.getSensitivity());
                paz.setAttribute("Calper", "" + chnnl.tranFun.getCalper());
                paz.setAttribute("Deci", chnnl.tranFun.getDeci());
                paz.setAttribute("Corr", chnnl.tranFun.getCorr());
                paz.setAttribute("Nzero", "" + chnnl.tranFun.getNzero());
                paz.setAttribute("Npole", "" + chnnl.tranFun.getNpole());
                paz.setAttribute("Descrip", chnnl.tranFun.getDescrip());
                paz.appendChild(doc.createTextNode("\n"));
                Element zero = doc.createElement("ZERO");
                paz.appendChild(zero);
                paz.appendChild(doc.createTextNode("\n"));
                zero.appendChild(doc.createTextNode(chnnl.tranFun.zero));
                Element pole = doc.createElement("POLE");
                paz.appendChild(pole);
                paz.appendChild(doc.createTextNode("\n"));
                pole.appendChild(doc.createTextNode(chnnl.tranFun.pole));
                ++chn;
            }
            ++i;
        }
        return doc;
    }

    public void addStation(Station station) {
        this.stationList.add(station.getSta());
        this.netStationList.add(String.valueOf(station.getNet()) + "/" + station.getSta());
        this.stations.add(station);
    }

    public void removeStation(String stn) {
        this.stationList.remove(stn);
        int size = this.stations.size();
        Station station = null;
        int i = 0;
        while (i < size) {
            station = (Station)this.stations.get(i);
            if (station.getSta().equals(stn)) {
                this.stations.remove(station);
                break;
            }
            ++i;
        }
    }

    public void addChannel(Channel chan) {
    }

    public void removeChannel(Channel chan) {
    }

    public double getClat() {
        return this.clat;
    }

    public double getClon() {
        return this.clon;
    }

    public double getCalt() {
        return this.calt;
    }

    public int getNStation() {
        return this.stations.size();
    }

    public int getNChannel() {
        int nsum = 0;
        int size = this.stations.size();
        int i = 0;
        while (i < size) {
            nsum += ((Station)this.stations.get(i)).chans.size();
            ++i;
        }
        return nsum;
    }

    public Vector getStationList() {
        return this.stationList;
    }

    public Vector getNetStationList() {
        return this.netStationList;
    }

    public void setClat(double clat) {
        this.clat = clat;
    }

    public void setClon(double clon) {
        this.clon = clon;
    }

    public void setDiscrip(String discrip) {
        this.discrip = discrip;
    }

    public String getNetworkID() {
        return this.networkID;
    }

    public void setNetworkID(String networkID) {
        this.networkID = networkID;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setCalt(double calt) {
        this.calt = calt;
    }

    public Station getStation(String stnCode) {
        int size = this.stations.size();
        int i = 0;
        while (i < size) {
            Station stn = (Station)this.stations.get(i);
            if (stn.getSta().equals(stnCode)) {
                return stn;
            }
            ++i;
        }
        return null;
    }

    public Channel getChannel(String stnCode, String locID, String chan) {
        int size = this.stations.size();
        int i = 0;
        while (i < size) {
            Station station = (Station)this.stations.get(i);
            int j = 0;
            while (j < station.chans.size()) {
                Channel chn = (Channel)station.chans.get(j);
                if (chn.getSta().equals(stnCode) && chn.getLocID().equals(locID) && chn.getCha().equals(chan)) {
                    return chn;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public Channel[] getAllChannel() {
        Channel[] chs = new Channel[this.getNChannel()];
        int n = 0;
        int size = this.stations.size();
        int i = 0;
        while (i < size) {
            Station station = (Station)this.stations.get(i);
            int j = 0;
            while (j < station.chans.size()) {
                chs[n++] = (Channel)station.chans.get(j);
                ++j;
            }
            ++i;
        }
        return chs;
    }

    public ChannelLocator[] getAllChannelLocator() {
        ChannelLocator[] cls = new ChannelLocator[this.getNChannel()];
        Channel[] chs = this.getAllChannel();
        int i = 0;
        while (i < cls.length) {
            cls[i] = chs[i].getChannelLocator();
            ++i;
        }
        return cls;
    }

    public Channel[] getAllChannel(String stnCode) {
        Object[] ch = null;
        int size = this.stations.size();
        int i = 0;
        while (i < size) {
            Station station = (Station)this.stations.get(i);
            if (station.getSta().equals(stnCode)) {
                ch = new Channel[station.chans.size()];
                station.chans.copyInto(ch);
                break;
            }
            ++i;
        }
        return ch;
    }

    public Channel[] getAllChannel(String stnCode, String locId) {
        Vector<Channel> cVec = new Vector<Channel>();
        Object[] ch = null;
        int size = this.stations.size();
        int i = 0;
        while (i < size) {
            Station station = (Station)this.stations.get(i);
            if (station.getSta().equals(stnCode)) {
                int j = 0;
                while (j < station.chans.size()) {
                    Channel chn = (Channel)station.chans.get(j);
                    if (chn.getLocID().equals(locId)) {
                        cVec.add(chn);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (cVec.size() == 0) {
            return null;
        }
        ch = new Channel[cVec.size()];
        cVec.copyInto(ch);
        return ch;
    }

    public void parseNetwork(InputStream in) {
        ParseHandler handler = new ParseHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(in, (DefaultHandler)handler);
        }
        catch (SAXParseException spe) {
            logger.warn("\n** Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
            logger.warn("   " + spe.getMessage());
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            logger.warn(((Throwable)x).getMessage(), x);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            logger.warn(((Throwable)x).getMessage(), x);
        }
        catch (ParserConfigurationException pce) {
            logger.warn(pce.getMessage(), pce);
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    public String getDiscrip() {
        return this.discrip;
    }

    public static class Channel {
        private String net = null;
        private String sta;
        private String cha;
        private String locID;
        private double hang;
        private double vang;
        private double sampleRate = 50.0;
        private TransferFunction tranFun = new TransferFunction();

        public ChannelLocator getChannelLocator() {
            ChannelLocator cl = new ChannelLocator();
            cl.setChannelLocator(this.net, this.sta, this.locID, this.cha);
            return cl;
        }

        public TransferFunction getTranFun() {
            return this.tranFun;
        }

        public void setTranFun(TransferFunction newTranFun) {
            this.tranFun = newTranFun;
        }

        public String getCha() {
            return this.cha;
        }

        public double getHang() {
            return this.hang;
        }

        public String getLocID() {
            return this.locID;
        }

        public String getNet() {
            return this.net;
        }

        public double getSampleRate() {
            return this.sampleRate;
        }

        public String getSta() {
            return this.sta;
        }

        public double getVang() {
            return this.vang;
        }

        public void setVang(double vang) {
            this.vang = vang;
        }

        public void setSta(String sta) {
            this.sta = sta;
        }

        public void setSampleRate(double sampleRate) {
            this.sampleRate = sampleRate;
        }

        public void setNet(String net) {
            this.net = net;
        }

        public void setLocID(String locID) {
            this.locID = locID;
        }

        public void setHang(double hang) {
            this.hang = hang;
        }

        public void setCha(String cha) {
            this.cha = cha;
        }

        public String toString() {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(this.sta);
            strBuf.append('\t');
            strBuf.append(this.cha);
            strBuf.append('\t');
            strBuf.append(this.locID);
            strBuf.append('\t');
            strBuf.append(this.hang);
            strBuf.append('\t');
            strBuf.append(this.vang);
            strBuf.append('\t');
            strBuf.append(this.sampleRate);
            return strBuf.toString();
        }
    }

    class ParseHandler
    extends DefaultHandler {
        private String sta;
        private String locID;
        private String chan;
        private Station station;
        private Channel channel;
        private boolean bzero;
        private boolean bpole;

        ParseHandler() {
        }

        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            if (qName.equals("NETWORK")) {
                StationProfile.this.clat = Double.parseDouble(attrs.getValue("CLat"));
                StationProfile.this.clon = Double.parseDouble(attrs.getValue("CLon"));
                StationProfile.this.networkID = attrs.getValue("Name");
                StationProfile.this.version = attrs.getValue("Version");
                StationProfile.this.discrip = attrs.getValue("Discrip");
            }
            if (qName.equals("STATION")) {
                this.station = new Station();
                StationProfile.this.stationList.add(attrs.getValue("Sta"));
                StationProfile.this.netStationList.add(String.valueOf(attrs.getValue("Net")) + "/" + attrs.getValue("Sta"));
                logger.info("process station: " + attrs.getValue("Sta"));
                this.station.setCname(attrs.getValue("Cname"));
                this.station.setComment(attrs.getValue("Comment"));
                this.station.setCoordsys(attrs.getValue("Coordsys"));
                this.station.setElev(Double.parseDouble(attrs.getValue("Elev")));
                this.station.setLat(Double.parseDouble(attrs.getValue("Lat")));
                this.station.setLon(Double.parseDouble(attrs.getValue("Lon")));
                this.station.setMtype(attrs.getValue("MType"));
                this.station.setNet(attrs.getValue("Net"));
                this.station.setOffdate(attrs.getValue("Offdate"));
                this.station.setOndate(attrs.getValue("Ondate"));
                this.station.setSname(attrs.getValue("Sname"));
                this.station.setSta(attrs.getValue("Sta"));
                this.station.setStaType(attrs.getValue("StaType"));
                this.station.setTransmitType(attrs.getValue("TransmitType"));
                this.sta = this.station.getSta();
            }
            if (qName.equals("CHANNEL")) {
                this.channel = new Channel();
                this.channel.setNet(this.station.getNet());
                this.channel.setSta(this.sta);
                this.channel.setCha(attrs.getValue("Cha"));
                logger.info("process channel: " + attrs.getValue("Cha"));
                this.channel.setLocID(attrs.getValue("LocID"));
                this.channel.setHang(Double.parseDouble(attrs.getValue("Hang")));
                this.channel.setVang(Double.parseDouble(attrs.getValue("Vang")));
                this.channel.setSampleRate(Double.parseDouble(attrs.getValue("SampleRate")));
                this.chan = this.channel.getCha();
                this.locID = this.channel.getLocID();
            }
            if (qName.equals("PAZ")) {
                if (this.channel == null) {
                    logger.warn("Counld not find some CHANNEL for: " + this.sta);
                }
                this.channel.tranFun.setSnum(Integer.parseInt(attrs.getValue("Snum")));
                this.channel.tranFun.setIunits(attrs.getValue("Iunits"));
                this.channel.tranFun.setOunits(attrs.getValue("Ounits"));
                this.channel.tranFun.setSfactor(Double.parseDouble(attrs.getValue("Sfactor")));
                this.channel.tranFun.setSensitivity(Double.parseDouble(attrs.getValue("Sensitivity")));
                this.channel.tranFun.setCalper(Double.parseDouble(attrs.getValue("Calper")));
                this.channel.tranFun.setDeci(attrs.getValue("Deci"));
                this.channel.tranFun.setNzero(Integer.parseInt(attrs.getValue("Nzero")));
                this.channel.tranFun.setNpole(Integer.parseInt(attrs.getValue("Npole")));
                this.channel.tranFun.setDescrip(attrs.getValue("Descrip"));
            }
            if (qName.equals("ZERO")) {
                this.bzero = true;
            }
            if (qName.equals("POLE")) {
                this.bpole = true;
            }
        }

        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            if (qName.equals("STATION")) {
                StationProfile.this.stations.add(this.station);
                this.station = null;
            }
            if (qName.equals("CHANNEL")) {
                this.station.chans.add(this.channel);
                this.channel = null;
            }
            if (qName.equals("ZERO")) {
                this.bzero = false;
            }
            if (qName.equals("POLE")) {
                this.bpole = false;
            }
        }

        public void characters(char[] buf, int offset, int len) throws SAXException {
            if (this.bzero) {
                TransferFunction transferFunction = this.channel.tranFun;
                transferFunction.zero = String.valueOf(transferFunction.zero) + new String(buf, offset, len);
            }
            if (this.bpole) {
                TransferFunction transferFunction = this.channel.tranFun;
                transferFunction.pole = String.valueOf(transferFunction.pole) + new String(buf, offset, len);
            }
        }

        public void error(SAXParseException e) throws SAXParseException {
            throw e;
        }

        public void warning(SAXParseException err) throws SAXParseException {
            logger.warn("** Warning, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            logger.warn("   " + err.getMessage());
        }
    }

    public static class Station {
        private String net = null;
        private String sta = null;
        private String cname = null;
        private String sname = null;
        private String staType = null;
        private double lat;
        private double lon;
        private String coordsys = "WGS-84";
        private double elev;
        private String mtype = null;
        private String transmitType = null;
        private String ondate = "2001/06/01";
        private String offdate = "";
        private String comment = "";
        private Vector chans = new Vector(3);

        public Vector getChans() {
            return this.chans;
        }

        public String getCname() {
            return this.cname;
        }

        public void setCname(String cname) {
            this.cname = cname;
        }

        public String getComment() {
            return this.comment;
        }

        public String getCoordsys() {
            return this.coordsys;
        }

        public double getElev() {
            return this.elev;
        }

        public double getLat() {
            return this.lat;
        }

        public double getLon() {
            return this.lon;
        }

        public String getMtype() {
            return this.mtype;
        }

        public String getNet() {
            return this.net;
        }

        public String getOffdate() {
            return this.offdate;
        }

        public String getOndate() {
            return this.ondate;
        }

        public String getSname() {
            return this.sname;
        }

        public String getSta() {
            return this.sta;
        }

        public String getStaType() {
            return this.staType;
        }

        public String getTransmitType() {
            return this.transmitType;
        }

        public void setTransmitType(String transmitType) {
            this.transmitType = transmitType;
        }

        public void setStaType(String staType) {
            this.staType = staType;
        }

        public void setSta(String sta) {
            this.sta = sta;
        }

        public void setSname(String sname) {
            this.sname = sname;
        }

        public void setOndate(String ondate) {
            this.ondate = ondate;
        }

        public void setOffdate(String offdate) {
            this.offdate = offdate;
        }

        public void setNet(String net) {
            this.net = net;
        }

        public void setMtype(String mtype) {
            this.mtype = mtype;
        }

        public void setLon(double lon) {
            this.lon = lon;
        }

        public void setLat(double lat) {
            this.lat = lat;
        }

        public void setElev(double elev) {
            this.elev = elev;
        }

        public void setCoordsys(String coordsys) {
            this.coordsys = coordsys;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String toString() {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(this.net);
            strBuf.append('\t');
            strBuf.append(this.sta);
            strBuf.append('\t');
            strBuf.append(this.cname);
            strBuf.append('\t');
            strBuf.append(this.sname);
            strBuf.append('\t');
            strBuf.append(this.staType);
            strBuf.append('\t');
            strBuf.append(this.lat);
            strBuf.append('\t');
            strBuf.append(this.lon);
            strBuf.append('\t');
            strBuf.append(this.coordsys);
            strBuf.append('\t');
            strBuf.append(this.elev);
            strBuf.append('\t');
            strBuf.append(this.mtype);
            strBuf.append('\t');
            strBuf.append(this.transmitType);
            strBuf.append('\t');
            strBuf.append(this.ondate);
            strBuf.append('\t');
            strBuf.append(this.offdate);
            strBuf.append('\t');
            strBuf.append(this.comment);
            return strBuf.toString();
        }
    }

    public static class TransferFunction {
        private int snum;
        private String iunits = "um/s";
        private String ounits = "C";
        private double sfactor = 1.264053E12;
        private double sensitivity = 440.0;
        private double calper = 5.0;
        private String deci = "";
        private String corr = "";
        private int nzero;
        private int npole;
        private String descrip;
        private String zero = "";
        private String pole = "";

        public double getCalper() {
            return this.calper;
        }

        public String getCorr() {
            return this.corr;
        }

        public String getDeci() {
            return this.deci;
        }

        public String getDescrip() {
            return this.descrip;
        }

        public String getIunits() {
            return this.iunits;
        }

        public int getNpole() {
            return this.npole;
        }

        public int getNzero() {
            return this.nzero;
        }

        public String getOunits() {
            return this.ounits;
        }

        public String getPole() {
            return this.pole;
        }

        public double getSensitivity() {
            return this.sensitivity;
        }

        public double getSfactor() {
            return this.sfactor;
        }

        public int getSnum() {
            return this.snum;
        }

        public String getZero() {
            return this.zero;
        }

        public void setZero(String zero) {
            this.zero = zero;
        }

        public void setSnum(int snum) {
            this.snum = snum;
        }

        public void setSfactor(double sfactor) {
            this.sfactor = sfactor;
        }

        public void setSensitivity(double sensitivity) {
            this.sensitivity = sensitivity;
        }

        public void setPole(String pole) {
            this.pole = pole;
        }

        public void setOunits(String ounits) {
            this.ounits = ounits;
        }

        public void setNzero(int nzero) {
            this.nzero = nzero;
        }

        public void setNpole(int npole) {
            this.npole = npole;
        }

        public void setIunits(String iunits) {
            this.iunits = iunits;
        }

        public void setDescrip(String descrip) {
            this.descrip = descrip;
        }

        public void setDeci(String deci) {
            this.deci = deci;
        }

        public void setCorr(String corr) {
            this.corr = corr;
        }

        public void setCalper(double calper) {
            this.calper = calper;
        }

        public String toString() {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(this.snum);
            strBuf.append('\t');
            strBuf.append(this.iunits);
            strBuf.append('\t');
            strBuf.append(this.ounits);
            strBuf.append('\t');
            strBuf.append(this.sfactor);
            strBuf.append('\t');
            strBuf.append(this.sensitivity);
            strBuf.append('\t');
            strBuf.append(this.calper);
            strBuf.append('\t');
            strBuf.append(this.deci);
            strBuf.append('\t');
            strBuf.append(this.corr);
            strBuf.append('\t');
            strBuf.append(this.nzero);
            strBuf.append('\t');
            strBuf.append(this.npole);
            strBuf.append('\t');
            strBuf.append(this.descrip);
            strBuf.append('\t');
            strBuf.append(this.zero);
            strBuf.append('\t');
            strBuf.append(this.pole);
            return strBuf.toString();
        }
    }
}

