/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.convert;

import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.CatalogA;
import cn.org.gddsn.jopens.entity.EventInfo;
import cn.org.gddsn.jopens.entity.Mag;
import cn.org.gddsn.jopens.entity.NetworkInfo;
import cn.org.gddsn.jopens.entity.PhaseA;
import cn.org.gddsn.jopens.entity.Pick;
import cn.org.gddsn.jopens.message.EventInfoReference;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.seis.EventInfoUtils;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.convert.EdasPhase;
import cn.org.gddsn.seis.location.AutoMag;
import cn.org.gddsn.seis.location.CalMagnitude;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.location.LocalPlusCountry;
import cn.org.gddsn.seis.location.TauPToolkit;
import cn.org.gddsn.util.Log4jConfig;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.springframework.context.support.FileSystemXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdasPhase2JOPENS {
    static Logger logger = Logger.getLogger(EdasPhase2JOPENS.class);
    private SeedVolumeService seedVolumeService;
    private String phasePath;
    private double maxOriginDiff;
    private int minPhaseCount;
    private List<Catalog> cataList = new LinkedList<Catalog>();

    public void importPhase() {
        List<EdasPhase.PHA> list = this.readAllPhase();
        this.weavePhase(list);
        this.calcMag();
        logger.info(String.format("total %d event", this.cataList.size()));
        for (Catalog c : this.cataList) {
            if (c.getPhases().size() < this.minPhaseCount) continue;
            this.writeCatalog(c);
        }
    }

    private void calcMag() {
        CalMagnitude mag = new CalMagnitude();
        for (Catalog c : this.cataList) {
            int cnt = 0;
            double msum = 0.0;
            for (cn.org.gddsn.jopens.entity.Phase p : c.getPhases()) {
                if (p.getPhaseType().equals("time")) continue;
                double m = mag.getML(p.getAmp(), (double)p.getDistance());
                if (!Double.isNaN(m)) {
                    p.setMagVal((float)m);
                    ++cnt;
                    msum += m;
                    continue;
                }
                p.setMagVal(-99999.0f);
            }
            if (cnt != 0) {
                double ml = msum / (double)cnt;
                double ms = CalMagnitude.Ml2Ms(ml);
                c.setM((float)ms);
                c.setMSource("ML");
                continue;
            }
            c.setM(-99999.0f);
            c.setMSource("ML");
        }
    }

    private Catalog getClosestCatalog(Date origin) {
        Catalog found = null;
        for (Catalog c : this.cataList) {
            if (!(Math.abs((double)c.getOriginTime().getTime() / 1000.0 - (double)origin.getTime() / 1000.0) < this.maxOriginDiff)) continue;
            found = c;
            break;
        }
        return found;
    }

    private void weavePhase(List<EdasPhase.PHA> list) {
        NetworkInfo ni = this.seedVolumeService.findNetworkInfoSelf();
        LocalPlusCountry lpc = new LocalPlusCountry();
        TauPToolkit tp = new TauPToolkit("iasp91");
        for (EdasPhase.PHA ep : list) {
            for (EdasPhase.STN_PHASE sp : ep.stn_phase_list) {
                Date origin = this.getOriginTime(sp, lpc);
                if (origin == null) {
                    origin = this.getOriginTime(sp, tp);
                }
                if (origin == null) {
                    logger.warn("ignore: " + ep.phaFile);
                    for (Phase p : sp.toPhases(ni.getId())) {
                        logger.warn(" " + p);
                    }
                    continue;
                }
                Catalog c = this.getClosestCatalog(origin);
                if (c == null) {
                    c = new CatalogA();
                    c.setLat(-99999.0f);
                    c.setLon(-99999.0f);
                    c.setDepth(0.0f);
                    c.setEpicId("00");
                    c.setSourceId("00");
                    c.setOriginTime(origin);
                    c.setOriginTimeFrac(0);
                    c.setNetCode(ni.getId());
                    c.setSaveTime(new Date());
                    c.setPhases(new LinkedList<cn.org.gddsn.jopens.entity.Phase>());
                    c.setMags(new HashSet<Mag>());
                    c.setOperator("EdasPhaImporter");
                    this.cataList.add(c);
                }
                for (Phase p : sp.toPhases(ni.getId())) {
                    PhaseA p1 = new PhaseA();
                    EventInfoUtils.phase2EntityPhase(p, p1, this.seedVolumeService);
                    p1.setCatalog(c);
                    c.getPhases().add(p1);
                }
                c.setLocation("Edas Pha \u5bfc\u5165: " + c.getPhases().size());
                c.setCataName(c.getOriginTime().toString());
                c.setRemark("\u9707\u76f8\u6570\u4e3a" + c.getPhases().size());
            }
        }
    }

    private Date getOriginTime(EdasPhase.STN_PHASE sp, ComputedTravelTime computedTravelTime) {
        NetworkInfo ni = this.seedVolumeService.findNetworkInfoSelf();
        List<Phase> stnPhases = sp.toPhases(ni.getId());
        Vector<Phase> sv = new Vector<Phase>();
        for (Phase p : stnPhases) {
            if (p.getPhaType() != 0 || p.getPhaseName().startsWith("Lg")) continue;
            sv.add(p);
        }
        int size = sv.size();
        if (size < 2) {
            return null;
        }
        Collections.sort(sv);
        Phase fp = (Phase)sv.get(0);
        Phase lp = (Phase)sv.get(size - 1);
        double difTime = (double)lp.getPhaseTime().getTime() / 1000.0 - (double)fp.getPhaseTime().getTime() / 1000.0;
        if (difTime < 3.0) {
            return new Date(fp.getPhaseTime().getTime());
        }
        String strPhaseType = String.valueOf(fp.getPhaseName()) + "," + lp.getPhaseName();
        double depth = 10.0;
        double delta = Double.NaN;
        try {
            delta = computedTravelTime.calDelta(depth, difTime, strPhaseType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Double.isNaN(delta)) {
            return null;
        }
        for (Phase p : stnPhases) {
            p.setDistance((float)(delta * 111.19));
        }
        double trvlTime = computedTravelTime.calTravelTime(depth, delta, strPhaseType);
        if (Double.isNaN(trvlTime)) {
            return null;
        }
        return new Date(fp.getPhaseTime().getTime() - (long)(trvlTime * 1000.0));
    }

    private List<EdasPhase.PHA> readAllPhase() {
        File[] files;
        LinkedList<EdasPhase.PHA> list = new LinkedList<EdasPhase.PHA>();
        File pathFile = new File(this.phasePath);
        logger.info(pathFile);
        File[] fileArray = files = pathFile.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                File f = fileArray[n2];
                EdasPhase.PHA pr = null;
                try {
                    pr = EdasPhase.readPha(f);
                }
                catch (IOException ex) {
                    logger.warn("error in reading " + f);
                    break block4;
                }
                if (pr != null) {
                    list.add(pr);
                }
            }
            ++n2;
        }
        return list;
    }

    public EventInfoReference writeCatalog(Catalog cata) {
        EventInfo info;
        String event_id;
        long now;
        block8: {
            NetworkInfo ni = this.seedVolumeService.findNetworkInfoSelf();
            if (cata.getPhases().size() == 0) {
                return null;
            }
            Date on = cata.getPhases().get(0).getPhaseTime();
            cn.org.gddsn.jopens.entity.Phase last = cata.getPhases().get(0);
            for (cn.org.gddsn.jopens.entity.Phase p : cata.getPhases()) {
                if (on.getTime() > p.getPhaseTime().getTime()) {
                    on = p.getPhaseTime();
                }
                if (last.getPhaseTime().getTime() >= p.getPhaseTime().getTime()) continue;
                last = p;
            }
            Date evt_beg = new Date(on.getTime() - 90000L);
            double delta = (double)last.getDistance() / 111.19;
            double mag = cata.getM();
            Date evt_end = new Date(on.getTime() + (long)(AutoMag.getDelayTime(delta, mag) * 60.0 * 1000.0));
            now = System.currentTimeMillis();
            event_id = EventInfoUtils.getEventId(on, ni.getId(), this.seedVolumeService);
            int len = event_id.length() - 1;
            event_id = String.valueOf(event_id.substring(0, len)) + "1";
            logger.info("Importing " + event_id);
            info = this.seedVolumeService.findEventInfo(event_id);
            if (info == null) {
                this.seedVolumeService.updateRtsEventInfo(event_id, evt_beg, evt_end);
                info = this.seedVolumeService.findEventInfo(event_id);
                break block8;
            }
            logger.info(String.valueOf(event_id) + " is exist, not import again.");
            return null;
        }
        try {
            cata.setId(String.valueOf(event_id) + ".A.001");
            for (cn.org.gddsn.jopens.entity.Phase ph : cata.getPhases()) {
                Pick pck = new Pick();
                pck.setChannelLocator(ph.getChannelLocator());
                pck.setCreateTime(new Date());
                pck.setCreateTimeFrac(0);
                pck.setFilterId("Butterworth bandpass 0.7Hz~2Hz, 4");
                pck.setPhaseHintCode("P");
                pck.setPickerId("STA/LTA");
                pck.setPickTime(ph.getPhaseTime());
                pck.setPickTimeFrac(ph.getPhaseTimeFrac());
                pck.setStatus("automatic");
                pck.setId(Pick.buildId(pck));
                ph.setPick(pck);
            }
            cata.setEventInfo(info);
            info.getCatalogs().add(cata);
            now = System.currentTimeMillis();
            info.setCreateTime(new Date(now));
            info.setCreateTimeFrac(0);
            this.seedVolumeService.updateEventInfo(info);
            logger.info("updateEventInfo: " + (System.currentTimeMillis() - now));
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        EventInfoReference eir = new EventInfoReference();
        eir.eventId = event_id;
        return eir;
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain("EdasPhase2JOPENS.properties");
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(new String[]{"EdasPhase2JOPENS.xml"});
        EdasPhase2JOPENS ep2j = (EdasPhase2JOPENS)ctx.getBean("ep2j");
        ep2j.importPhase();
    }

    public List<Catalog> getCataList() {
        return this.cataList;
    }

    public void setCataList(List<Catalog> cataList) {
        this.cataList = cataList;
    }

    public double getMaxOriginDiff() {
        return this.maxOriginDiff;
    }

    public void setMaxOriginDiff(double maxOriginDiff) {
        this.maxOriginDiff = maxOriginDiff;
    }

    public int getMinPhaseCount() {
        return this.minPhaseCount;
    }

    public void setMinPhaseCount(int minPhaseCount) {
        this.minPhaseCount = minPhaseCount;
    }

    public String getPhasePath() {
        return this.phasePath;
    }

    public void setPhasePath(String phasePath) {
        this.phasePath = phasePath;
    }

    public void setSeedVolumeService(SeedVolumeService svs) {
        this.seedVolumeService = svs;
    }
}

