/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.db;

import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import edu.iris.timeutils.TimeStamp;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlRes {
    static Logger logger = Logger.getLogger(XmlRes.class);
    private Document doc;
    private SourceParam source = null;
    private Phase[] phases = null;

    private XmlRes() {
    }

    public SourceParam getSourceParam() {
        return this.source;
    }

    public Phase[] getPhases() {
        return this.phases;
    }

    public static XmlRes XmlResFactory(String xmlResFileName) throws IOException {
        XmlRes xmlRes = new XmlRes();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            xmlRes.doc = builder.parse(xmlResFileName);
        }
        catch (SAXException saxEx) {
            logger.warn(saxEx.getMessage(), saxEx);
            xmlRes = null;
        }
        catch (ParserConfigurationException pcEx) {
            logger.warn(pcEx.getMessage(), pcEx);
            xmlRes = null;
        }
        return xmlRes;
    }

    public static XmlRes XmlResFactory(SourceParam source, Phase[] phases) {
        XmlRes xmlRes = new XmlRes();
        xmlRes.source = source;
        xmlRes.phases = phases;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            xmlRes.doc = builder.newDocument();
            xmlRes.buildThis(source, phases);
        }
        catch (ParserConfigurationException pcEx) {
            logger.warn(pcEx.getMessage(), pcEx);
        }
        return xmlRes;
    }

    private void buildThis(SourceParam source, Phase[] phases) {
        Element root = this.doc.createElement("LOCATION");
        Element catalog = this.doc.createElement("CATLOG");
        this.doc.appendChild(root);
        root.appendChild(catalog);
        root.appendChild(this.doc.createTextNode("\n"));
        Element tmp = null;
        tmp = this.doc.createElement("cata_id");
        tmp.appendChild(this.doc.createTextNode(source.getCataId()));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("event_id");
        tmp.appendChild(this.doc.createTextNode(source.eventId));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("operator");
        tmp.appendChild(this.doc.createTextNode(source.operator));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("save_time");
        tmp.appendChild(this.doc.createTextNode(new TimeStamp(source.saveTime.getTime()).toSeedString()));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("SEISMIC_BEGIN");
        tmp.appendChild(this.doc.createTextNode(new TimeStamp(source.originTime.getTime()).toSeedString()));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("lat");
        tmp.appendChild(this.doc.createTextNode("" + source.lat));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("lon");
        tmp.appendChild(this.doc.createTextNode("" + source.lon));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("Ml");
        tmp.appendChild(this.doc.createTextNode("" + source.ml));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("Ms");
        tmp.appendChild(this.doc.createTextNode("" + source.ms));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("Md");
        tmp.appendChild(this.doc.createTextNode("" + source.md));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("Mb");
        tmp.appendChild(this.doc.createTextNode("" + source.mb));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("mmB");
        tmp.appendChild(this.doc.createTextNode("  "));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("Mm");
        tmp.appendChild(this.doc.createTextNode("  "));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("depth");
        tmp.appendChild(this.doc.createTextNode("" + source.depth));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("distance");
        tmp.appendChild(this.doc.createTextNode("  "));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("S_P");
        tmp.appendChild(this.doc.createTextNode("  "));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("accuracy");
        tmp.appendChild(this.doc.createTextNode("  "));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("used_stn");
        tmp.appendChild(this.doc.createTextNode("  "));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("used_pha");
        tmp.appendChild(this.doc.createTextNode("  "));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("azimuth");
        tmp.appendChild(this.doc.createTextNode("  "));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("explosion");
        tmp.appendChild(this.doc.createTextNode(source.eqType));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("epic_id");
        tmp.appendChild(this.doc.createTextNode(source.epicId));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("location");
        tmp.appendChild(this.doc.createTextNode(source.location));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("orgin_id");
        tmp.appendChild(this.doc.createTextNode(source.sourceId));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("dep_accuracy");
        tmp.appendChild(this.doc.createTextNode("  "));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("dis_accuracy");
        tmp.appendChild(this.doc.createTextNode("  "));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("comment");
        tmp.appendChild(this.doc.createTextNode(source.remark));
        catalog.appendChild(tmp);
        catalog.appendChild(this.doc.createTextNode("\n"));
        if (phases == null) {
            return;
        }
        int i = 0;
        while (i < phases.length) {
            this.addPhase(phases[i]);
            ++i;
        }
    }

    public void addPhase(Phase phase) {
        NodeList list = this.doc.getElementsByTagName("LOCATION");
        Node root = list.item(0);
        Element pha = this.doc.createElement("PHASE");
        Element tmp = null;
        tmp = this.doc.createElement("cata_id");
        tmp.appendChild(this.doc.createTextNode(phase.getCataId()));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("sta");
        tmp.appendChild(this.doc.createTextNode(phase.getStationCode()));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("loc_id");
        tmp.appendChild(this.doc.createTextNode("00"));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("chan");
        tmp.appendChild(this.doc.createTextNode(phase.getChanCode()));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("rec_type");
        tmp.appendChild(this.doc.createTextNode("V" + phase.getRecType()));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("pha_type");
        tmp.appendChild(this.doc.createTextNode("" + phase.getAmpType()));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("phase_name");
        tmp.appendChild(this.doc.createTextNode(phase.getPhaseName()));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("phase_time");
        tmp.appendChild(this.doc.createTextNode(new TimeStamp(phase.getPhaseTime().getTime()).toSeedString()));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("amp_type");
        tmp.appendChild(this.doc.createTextNode("" + phase.getAmpType()));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("amp");
        tmp.appendChild(this.doc.createTextNode("" + phase.getAmp()));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("period");
        tmp.appendChild(this.doc.createTextNode("" + phase.getPeriod()));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("amp_unit");
        tmp.appendChild(this.doc.createTextNode("um/s"));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("weight");
        tmp.appendChild(this.doc.createTextNode("" + phase.getWeight()));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("orgin_id");
        tmp.appendChild(this.doc.createTextNode("  "));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("clarity");
        tmp.appendChild(this.doc.createTextNode(phase.getClarity() == null ? "" : phase.getClarity()));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        tmp = this.doc.createElement("wsign");
        tmp.appendChild(this.doc.createTextNode(phase.getWsign() == null ? "" : phase.getWsign()));
        pha.appendChild(tmp);
        pha.appendChild(this.doc.createTextNode("\n"));
        root.appendChild(pha);
        root.appendChild(this.doc.createTextNode("\n"));
    }

    public void writeXML(String xmlFile) throws IOException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            FileOutputStream fos = new FileOutputStream(xmlFile);
            DOMSource source = new DOMSource(this.doc);
            StreamResult result = new StreamResult(fos);
            Transformer transformer = tFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException tce) {
            logger.warn("\n** Transformer Factory error");
            logger.warn("   " + tce.getMessage(), tce);
        }
        catch (TransformerException tfEx) {
            logger.warn("\n** Transformation error");
        }
    }

    public static void main(String[] args) throws IOException {
        XmlRes xmlRes1 = XmlRes.XmlResFactory(null, null);
        xmlRes1.writeXML("testXml.xml");
    }
}

