/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import JSci.maths.Complex;
import cn.org.gddsn.convert.CStringToJava;
import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.io.LittleEndianOutputStream;
import cn.org.gddsn.seis.evtformat.CHA_PAR;
import cn.org.gddsn.seis.evtformat.EVT_HEAD;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.GeoDevEvtData;
import cn.org.gddsn.seis.evtformat.Response;
import cn.org.gddsn.seis.evtformat.StationInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoDevEvent
extends GeoDevEvtData
implements Cloneable {
    static Logger logger = Logger.getLogger(GeoDevEvent.class);
    EVT_HEAD evt_head = new EVT_HEAD();
    private Date EventDate = null;
    private static final int[] toEdas;

    static {
        int[] nArray = new int[6];
        nArray[0] = 2;
        nArray[1] = 1;
        nArray[3] = 5;
        nArray[4] = 4;
        nArray[5] = 3;
        toEdas = nArray;
    }

    public GeoDevEvent() {
        this.evtFormat = 0;
    }

    public GeoDevEvent(EvtData evtData) {
        this.evtFormat = 0;
        this.ts2GeoDev(evtData);
    }

    private void ts2GeoDev(EvtData evtData) {
        this.evt_head.rectype = 1;
        this.evt_head.process = 0;
        this.evt_head.netpar.centalt = -1.0f;
        this.evt_head.netpar.centlat = -1.0f;
        this.evt_head.netpar.centlon = -1.0f;
        this.evt_head.netpar.stn_sum = evtData.getTSN();
        this.evt_head.data_begin = (int)(evtData.getArrivalTime(0).getTime() / 1000L);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(evtData.getArrivalTime(0).getTime() / 1000L * 1000L));
        this.evt_head.data_start.year = (short)calendar.get(1);
        this.evt_head.data_start.mon = (short)calendar.get(2);
        this.evt_head.data_start.day = (short)calendar.get(5);
        this.evt_head.data_start.hour = (short)calendar.get(11);
        this.evt_head.data_start.min = (short)calendar.get(12);
        this.evt_head.data_start.sec = (short)calendar.get(13);
        this.TRL = this.evt_head.rec_length = evtData.getMaxTRL();
        this.TCN = evtData.TCN;
        this.TSN = evtData.TSN;
        logger.info("Total Chanels=" + this.TCN);
        logger.info("Total Station=" + this.TSN);
        this.aEventDate = new Date[this.TSN];
        this.aTRL = new int[this.TSN];
        int i = 0;
        while (i < this.TSN) {
            this.aEventDate[i] = evtData.getArrivalTime(0);
            this.aTRL[i] = this.maxTRL;
            ++i;
        }
        this.EventDate = evtData.getArrivalTime(0);
        this.SI = new StationInfo[this.TSN];
        this.Rspns = new Response[this.TCN];
        i = 0;
        while (i < this.TSN) {
            this.SI[i] = new StationInfo();
            int chn = this.getCN(i);
            logger.info("Process Station info of " + evtData.getStationCode(chn));
            this.SI[i].stn_par.no = i;
            this.SI[i].stn_par.name = evtData.getStationCode(chn).getBytes();
            this.SI[i].stn_par.DASType = "EDAS".getBytes();
            this.SI[i].stn_par.wlen = (short)24;
            this.SI[i].stn_par.VLtd = 5.0f;
            this.SI[i].stn_par.samp = (int)evtData.getSampleRate(chn);
            this.SI[i].stn_par.comp = evtData.getChanOrder(chn).length;
            this.SI[i].stn_par.TranMode = (short)10;
            this.SI[i].stn_par.TranIns = "IP".getBytes();
            this.SI[i].stn_par.TimerMode = 0;
            this.SI[i].stn_par.ClkType = "GPS".getBytes();
            this.SI[i].stn_par.ClkErr = 0.0f;
            this.SI[i].stn_par.latitude = (float)evtData.getStationLocation(chn).getLatitude();
            this.SI[i].stn_par.longitude = (float)evtData.getStationLocation(chn).getLongtitude();
            this.SI[i].stn_par.altitude = (float)evtData.getStationLocation(chn).getAltitude();
            this.SI[i].stn_par.azimuth = 0.0f;
            this.SI[i].stn_par.incident = 0.0f;
            this.SI[i].stn_par.weight = 1;
            this.SI[i].stn_par.veloc = (short)2;
            this.SI[i].stn_par.oritype = 1;
            this.SI[i].stn_par.seismometer = evtData.getInstrumentType(chn).getBytes();
            String chnCode = evtData.getChannelCode(chn);
            this.SI[i].stn_par.SMMode = chnCode.startsWith("S") ? 0 : (chnCode.startsWith("B") ? 1 : 2);
            int comp = this.SI[i].stn_par.comp;
            logger.info("comp=" + comp);
            this.SI[i].cha_par = new CHA_PAR[comp];
            int j = 0;
            while (j < comp) {
                int ch = chn + toEdas[j];
                logger.info("ch=" + ch);
                this.SI[i].cha_par[j] = new CHA_PAR();
                this.SI[i].cha_par[j].factor = (float)evtData.getCalibFactor(ch);
                switch (ch) {
                    case 0: {
                        this.SI[i].cha_par[j].name = "U-D";
                        break;
                    }
                    case 1: {
                        this.SI[i].cha_par[j].name = "E-W";
                        break;
                    }
                    case 2: {
                        this.SI[i].cha_par[j].name = "N-S";
                    }
                }
                this.SI[i].cha_par[j].no = j;
                this.SI[i].cha_par[j].respstep = 1;
                this.Rspns[ch] = new Response();
                this.Rspns[ch].type = 1;
                this.Rspns[ch].ntrip = 5;
                this.Rspns[ch].Factor = this.SI[i].cha_par[j].factor;
                this.Rspns[ch].Freq = new double[this.Rspns[ch].ntrip];
                this.Rspns[ch].Amp = new double[this.Rspns[ch].ntrip];
                this.Rspns[ch].Phase = new double[this.Rspns[ch].ntrip];
                int k = 0;
                while (k < this.Rspns[ch].ntrip) {
                    this.Rspns[ch].Freq[k] = 1.0;
                    this.Rspns[ch].Amp[k] = 1.0;
                    this.Rspns[ch].Phase[k] = 0.0;
                    ++k;
                }
                this.Rspns[ch].Freq[0] = 0.01;
                this.Rspns[ch].Freq[1] = 0.1;
                this.Rspns[ch].Freq[2] = 1.0;
                this.Rspns[ch].Freq[3] = 10.0;
                this.Rspns[ch].Freq[4] = 100.0;
                ++j;
            }
            ++i;
        }
        this.Flag = new int[this.TSN][this.TRL];
        this.WDat = new double[this.TCN][];
        int s = 0;
        while (s < this.TSN) {
            int ch = this.getCN(s);
            int comp = this.SI[s].stn_par.comp;
            int c = 0;
            while (c < comp) {
                this.WDat[ch + c] = evtData.getSampData(ch + toEdas[c]);
                ++c;
            }
            ++s;
        }
    }

    private void ts2GeoDev_new(EvtData evtData) {
        Hashtable<String, ChanMap> tbl = this.fillChanMap(evtData);
        this.TSN = tbl.size();
        this.TCN = evtData.TCN;
        this.evt_head.rectype = 1;
        this.evt_head.process = 0;
        this.evt_head.netpar.centalt = -1.0f;
        this.evt_head.netpar.centlat = -1.0f;
        this.evt_head.netpar.centlon = -1.0f;
        this.evt_head.netpar.stn_sum = this.TSN;
        this.evt_head.data_begin = (int)(evtData.getArrivalTime(0).getTime() / 1000L);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(evtData.getArrivalTime(0).getTime() / 1000L * 1000L));
        this.evt_head.data_start.year = (short)calendar.get(1);
        this.evt_head.data_start.mon = (short)calendar.get(2);
        this.evt_head.data_start.day = (short)calendar.get(5);
        this.evt_head.data_start.hour = (short)calendar.get(11);
        this.evt_head.data_start.min = (short)calendar.get(12);
        this.evt_head.data_start.sec = (short)calendar.get(13);
        this.TRL = this.evt_head.rec_length = evtData.getMaxTRL();
        logger.info("Total Chanels=" + this.TCN);
        logger.info("Total Station=" + this.TSN);
        this.aEventDate = new Date[this.TSN];
        this.aTRL = new int[this.TSN];
        int i = 0;
        while (i < this.TSN) {
            this.aEventDate[i] = evtData.getArrivalTime(0);
            this.aTRL[i] = this.maxTRL;
            ++i;
        }
        this.EventDate = evtData.getArrivalTime(0);
        this.SI = new StationInfo[this.TSN];
        this.Rspns = new Response[this.TCN];
        this.Flag = new int[this.TSN][this.TRL];
        this.WDat = new double[this.TCN][];
        Enumeration<String> enu = tbl.keys();
        int i2 = 0;
        int ch = 0;
        while (enu.hasMoreElements()) {
            String key = enu.nextElement();
            if (logger.isDebugEnabled()) {
                logger.debug("key=" + key);
            }
            ChanMap chanMap = tbl.get(key);
            this.SI[i2] = new StationInfo();
            int chn = chanMap.chanOrder[0];
            logger.info("Process Station info of " + key);
            this.SI[i2].stn_par.no = i2;
            this.SI[i2].stn_par.name = key.getBytes();
            this.SI[i2].stn_par.DASType = "EDAS".getBytes();
            this.SI[i2].stn_par.wlen = (short)24;
            this.SI[i2].stn_par.VLtd = 5.0f;
            this.SI[i2].stn_par.samp = (int)evtData.getSampleRate(chn);
            this.SI[i2].stn_par.comp = chanMap.chanOrder.length;
            this.SI[i2].stn_par.TranMode = (short)10;
            this.SI[i2].stn_par.TranIns = "IP".getBytes();
            this.SI[i2].stn_par.TimerMode = 0;
            this.SI[i2].stn_par.ClkType = "GPS".getBytes();
            this.SI[i2].stn_par.ClkErr = 0.0f;
            this.SI[i2].stn_par.latitude = (float)evtData.getStationLocation(chn).getLatitude();
            this.SI[i2].stn_par.longitude = (float)evtData.getStationLocation(chn).getLongtitude();
            this.SI[i2].stn_par.altitude = (float)evtData.getStationLocation(chn).getAltitude();
            this.SI[i2].stn_par.azimuth = 0.0f;
            this.SI[i2].stn_par.incident = 0.0f;
            this.SI[i2].stn_par.weight = 1;
            this.SI[i2].stn_par.veloc = (short)2;
            this.SI[i2].stn_par.oritype = 1;
            this.SI[i2].stn_par.seismometer = evtData.getInstrumentType(chn).getBytes();
            String chnCode = evtData.getChannelCode(chn);
            this.SI[i2].stn_par.SMMode = chnCode.startsWith("S") ? 0 : (chnCode.startsWith("B") ? 1 : 2);
            int comp = this.SI[i2].stn_par.comp;
            this.SI[i2].cha_par = new CHA_PAR[comp];
            int j = 0;
            while (j < comp) {
                int tmp = comp == 1 ? chanMap.chanOrder[j] : chanMap.chanOrder[2 - j];
                this.SI[i2].cha_par[j] = new CHA_PAR();
                this.SI[i2].cha_par[j].factor = (float)evtData.getCalibFactor(tmp);
                this.SI[i2].cha_par[j].name = evtData.getChannelCode(tmp);
                this.SI[i2].cha_par[j].no = j;
                this.SI[i2].cha_par[j].respstep = 1;
                this.Rspns[ch] = new Response();
                this.Rspns[ch].type = 0;
                this.Rspns[ch].setFactor(this.SI[i2].cha_par[j].factor);
                this.Rspns[ch].setF0(evtData.getCalper(tmp));
                this.Rspns[ch].setTfGain(evtData.getScaleFactor(tmp));
                this.Rspns[ch].setZeroNum(evtData.getZeroNum(tmp));
                this.Rspns[ch].setZero(evtData.getZero(tmp));
                this.Rspns[ch].setPoleNum(evtData.getPoleNum(tmp));
                this.Rspns[ch].setPole(evtData.getPole(tmp));
                this.WDat[ch] = evtData.getSampData(tmp);
                ++ch;
                ++j;
            }
            ++i2;
        }
    }

    @Override
    public boolean readEvtFile(String fileName) {
        try {
            File file = new File(fileName);
            if (!file.isDirectory()) {
                FileInputStream FileIn = new FileInputStream(fileName);
                BufferedInputStream BufferedIn = new BufferedInputStream(FileIn, 4096);
                LittleEndianInputStream DatIn = new LittleEndianInputStream(BufferedIn);
                this.getEvtData(DatIn);
                DatIn.close();
                BufferedIn.close();
                FileIn.close();
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            return false;
        }
        this.convertToTimeSeries();
        return true;
    }

    @Override
    public boolean writeEvtFile(String fileName) {
        int[] stn = new int[this.TSN];
        int i = 0;
        while (i < this.TSN) {
            stn[i] = i;
            ++i;
        }
        return this.writeEvtFile(fileName, stn, 0, this.TRL);
    }

    @Override
    public boolean readEvtFile(URL urlFile) {
        return false;
    }

    @Override
    public boolean writeEvtFile(URL urlFile) {
        return false;
    }

    public boolean writeEvtFile(String fileName, int[] stn, int begTime, int cutLen) {
        try {
            File file = new File(fileName);
            LittleEndianOutputStream leOut = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(file), 4096));
            this.writeEvtHeadInfo(leOut, stn, begTime, cutLen);
            int sec = begTime;
            while (sec < begTime + cutLen) {
                this.writeOneSecondData(leOut, stn, sec);
                ++sec;
            }
            leOut.flush();
            leOut.close();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            return false;
        }
        return true;
    }

    private void getEvtData(LittleEndianInputStream DatIn) {
        int zeroTRL = 0;
        try {
            this.getEvtHeadInfo(DatIn);
            int dataFrameSize = 0;
            int i = 0;
            while (i < this.TSN) {
                dataFrameSize += (1 + this.SI[i].stn_par.samp * this.SI[i].stn_par.comp) * (this.SI[i].stn_par.wlen == 16 ? 2 : 4);
                ++i;
            }
            if (this.TRL < 10) {
                this.TRL = DatIn.available() / dataFrameSize;
            }
            this.TCN = this.getCN(this.TSN);
            this.Flag = new int[this.TSN][this.TRL];
            this.WDat = new double[this.TCN][];
            i = 0;
            while (i < this.TCN) {
                double[] ArraryTemp = new double[this.SI[this.toStn((int)i)].stn_par.samp * this.TRL];
                this.WDat[i] = ArraryTemp;
                ++i;
            }
            int L = 0;
            while (L < this.TRL) {
                ++zeroTRL;
                int k = 0;
                while (k < this.TSN) {
                    this.Flag[k][L] = DatIn.readInt();
                    int j = 0;
                    while (j < this.SI[k].stn_par.comp) {
                        int i2 = 0;
                        while (i2 < this.SI[k].stn_par.samp) {
                            int dat;
                            if (this.SI[k].stn_par.wlen != 16) {
                                dat = DatIn.readInt();
                                this.WDat[this.getCN((int)k) + j][this.SI[k].stn_par.samp * L + i2] = this.Flag[k][L] != 1 ? (double)dat : 0.0;
                            } else {
                                dat = DatIn.readShort();
                                this.WDat[this.getCN((int)k) + j][this.SI[k].stn_par.samp * L + i2] = this.Flag[k][L] != 1 ? (double)dat : 0.0;
                            }
                            ++i2;
                        }
                        ++j;
                    }
                    ++k;
                }
                ++L;
            }
        }
        catch (EOFException eofE) {
            this.TRL = --zeroTRL;
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), e);
        }
    }

    void getEvtHeadInfo(LittleEndianInputStream DatIn) {
        try {
            DatIn.readFully(this.evt_head.EvtFlag, 0, 16);
            CStringToJava.tailToZero(this.evt_head.EvtFlag, 16);
            DatIn.readFully(this.evt_head.hostype, 0, 16);
            CStringToJava.tailToZero(this.evt_head.hostype, 16);
            this.evt_head.rectype = DatIn.readInt();
            this.evt_head.process = DatIn.readInt();
            DatIn.readFully(this.evt_head.netpar.NetName, 0, 80);
            CStringToJava.tailToZero(this.evt_head.netpar.NetName, 80);
            this.TSN = this.evt_head.netpar.stn_sum = DatIn.readInt();
            this.evt_head.netpar.centlat = DatIn.readFloat();
            this.clat = this.evt_head.netpar.centlat;
            this.evt_head.netpar.centlon = DatIn.readFloat();
            this.clon = this.evt_head.netpar.centlon;
            this.evt_head.netpar.centalt = DatIn.readFloat();
            this.calt = this.evt_head.netpar.centalt;
            DatIn.readFully(this.evt_head.netpar.remark, 0, 120);
            CStringToJava.tailToZero(this.evt_head.netpar.remark, 120);
            this.evt_head.data_begin = DatIn.readInt();
            this.evt_head.data_start.year = DatIn.readShort();
            if (this.evt_head.data_start.year < 1900) {
                this.evt_head.data_start.year = (short)(this.evt_head.data_start.year + 1900);
            }
            this.evt_head.data_start.mon = DatIn.readShort();
            this.evt_head.data_start.day = DatIn.readShort();
            this.evt_head.data_start.hour = DatIn.readShort();
            this.evt_head.data_start.min = DatIn.readShort();
            this.evt_head.data_start.sec = DatIn.readShort();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(this.evt_head.data_start.year, this.evt_head.data_start.mon, this.evt_head.data_start.day, this.evt_head.data_start.hour, this.evt_head.data_start.min, this.evt_head.data_start.sec);
            this.EventDate = calendar.getTime();
            long ms = (long)this.evt_head.data_begin * 1000L;
            this.EventDate.setTime(ms);
            this.TRL = this.evt_head.rec_length = DatIn.readInt();
            this.SI = new StationInfo[this.TSN];
            int i = 0;
            while (i < this.TSN) {
                this.SI[i] = new StationInfo();
                this.SI[i].stn_par.no = DatIn.readInt();
                DatIn.readFully(this.SI[i].stn_par.name, 0, 20);
                CStringToJava.tailToZero(this.SI[i].stn_par.name, 20);
                DatIn.readFully(this.SI[i].stn_par.DASType, 0, 10);
                CStringToJava.tailToZero(this.SI[i].stn_par.DASType, 10);
                this.SI[i].stn_par.wlen = DatIn.readShort();
                this.SI[i].stn_par.VLtd = DatIn.readFloat();
                this.SI[i].stn_par.samp = DatIn.readInt();
                this.SI[i].stn_par.comp = DatIn.readInt();
                this.SI[i].stn_par.TranMode = DatIn.readShort();
                DatIn.readFully(this.SI[i].stn_par.TranIns, 0, 12);
                CStringToJava.tailToZero(this.SI[i].stn_par.TranIns, 12);
                this.SI[i].stn_par.TimerMode = DatIn.readShort();
                DatIn.readFully(this.SI[i].stn_par.ClkType, 0, 12);
                CStringToJava.tailToZero(this.SI[i].stn_par.ClkType, 12);
                this.SI[i].stn_par.ClkErr = DatIn.readFloat();
                this.SI[i].stn_par.latitude = DatIn.readFloat();
                this.SI[i].stn_par.longitude = DatIn.readFloat();
                this.SI[i].stn_par.altitude = DatIn.readFloat();
                this.SI[i].stn_par.azimuth = DatIn.readFloat();
                this.SI[i].stn_par.incident = DatIn.readFloat();
                this.SI[i].stn_par.weight = DatIn.readShort();
                this.SI[i].stn_par.veloc = DatIn.readShort();
                this.SI[i].stn_par.oritype = DatIn.readInt();
                DatIn.readFully(this.SI[i].stn_par.seismometer, 0, 8);
                CStringToJava.tailToZero(this.SI[i].stn_par.seismometer, 8);
                this.SI[i].stn_par.SMMode = DatIn.readInt();
                this.SI[i].cha_par = new CHA_PAR[this.SI[i].stn_par.comp];
                int j = 0;
                while (j < this.SI[i].stn_par.comp) {
                    this.SI[i].cha_par[j] = new CHA_PAR();
                    byte[] byName = new byte[12];
                    DatIn.readFully(byName, 0, 12);
                    CStringToJava.tailToZero(byName, 12);
                    this.SI[i].cha_par[j].name = new String(byName);
                    this.SI[i].cha_par[j].no = DatIn.readInt();
                    this.SI[i].cha_par[j].factor = DatIn.readFloat();
                    this.SI[i].cha_par[j].respstep = DatIn.readInt();
                    DatIn.readFully(this.SI[i].cha_par[j].resp, 0, 12288);
                    ++j;
                }
                ++i;
            }
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), e);
        }
        this.TCN = this.getCN(this.TSN);
        this.aEventDate = new Date[this.TCN];
        this.aTRL = new int[this.TCN];
        int i = 0;
        while (i < this.TCN) {
            this.aTRL[i] = this.TRL;
            this.aEventDate[i] = new Date(this.EventDate.getTime());
            ++i;
        }
        this.fillResponse();
    }

    private void fillPoleAndZero(int chn) {
        String fname = "";
        String LineStr = null;
        try {
            Properties attrib = new Properties();
            attrib.load(new FileInputStream("cfg/pz.cfg"));
            int stn = this.toStn(chn);
            String sta = new String(this.SI[stn].stn_par.name).trim();
            fname = attrib.getProperty(sta);
            if (fname == null) {
                logger.warn("\"Main.cfg\" did not include  station " + sta + " section !");
            }
            fname = "cfg" + File.separator + fname;
            FileReader fs = new FileReader(fname);
            BufferedReader ds = new BufferedReader(fs);
            LineStr = ds.readLine();
            StringTokenizer st = new StringTokenizer(LineStr);
            this.Rspns[chn].tfGain = Double.valueOf(st.nextToken());
            this.Rspns[chn].f0 = Double.valueOf(st.nextToken());
            LineStr = ds.readLine();
            st = new StringTokenizer(LineStr);
            int zn = Integer.parseInt(st.nextToken());
            int pn = Integer.parseInt(st.nextToken());
            this.Rspns[chn].zero = new Complex[zn];
            this.Rspns[chn].nz = zn;
            this.Rspns[chn].pole = new Complex[pn];
            this.Rspns[chn].np = pn;
            int i = 0;
            while (i < zn) {
                LineStr = ds.readLine();
                st = new StringTokenizer(LineStr);
                this.Rspns[chn].zero[i] = new Complex(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
                ++i;
            }
            i = 0;
            while (i < pn) {
                LineStr = ds.readLine();
                st = new StringTokenizer(LineStr);
                this.Rspns[chn].pole[i] = new Complex(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
                ++i;
            }
            ds.close();
            fs.close();
        }
        catch (IOException e) {
            logger.warn(String.valueOf(fname) + " file data format ERROR!");
        }
    }

    private void fillResponse() {
        this.Rspns = new Response[this.TCN];
        int i = 0;
        while (i < this.TCN) {
            this.Rspns[i] = new Response();
            ++i;
        }
        int n = 0;
        int i2 = 0;
        while (i2 < this.TSN) {
            int k = 0;
            while (k < this.SI[i2].stn_par.comp) {
                this.Rspns[n].Factor = this.SI[i2].cha_par[k].factor;
                byte[] rsp = this.SI[i2].cha_par[k].resp;
                ByteArrayInputStream BIn = new ByteArrayInputStream(rsp);
                LittleEndianInputStream DatIn = new LittleEndianInputStream(BIn);
                try {
                    this.Rspns[n].type = DatIn.readInt();
                    if (this.Rspns[n].type == 1) {
                        this.Rspns[n].ntrip = DatIn.readInt();
                        this.Rspns[n].Freq = new double[this.Rspns[n].ntrip];
                        this.Rspns[n].Amp = new double[this.Rspns[n].ntrip];
                        this.Rspns[n].Phase = new double[this.Rspns[n].ntrip];
                        int L = 0;
                        while (L < this.Rspns[n].ntrip) {
                            this.Rspns[n].Freq[L] = DatIn.readFloat();
                            this.Rspns[n].Amp[L] = DatIn.readFloat();
                            this.Rspns[n].Phase[L] = DatIn.readFloat();
                            ++L;
                        }
                        this.fillPoleAndZero(n);
                    } else if (this.Rspns[n].type == 0) {
                        this.Rspns[n].tfGain = DatIn.readFloat();
                        this.Rspns[n].f0 = 1.0;
                        int pn = DatIn.readInt();
                        this.Rspns[n].pole = new Complex[pn];
                        this.Rspns[n].np = pn;
                        int j = 0;
                        while (j < pn) {
                            this.Rspns[n].pole[j] = new Complex(DatIn.readFloat(), DatIn.readFloat());
                            ++j;
                        }
                        int zn = DatIn.readInt();
                        this.Rspns[n].zero = new Complex[zn];
                        this.Rspns[n].nz = zn;
                        int j2 = 0;
                        while (j2 < zn) {
                            this.Rspns[n].zero[j2] = new Complex(DatIn.readFloat(), DatIn.readFloat());
                            ++j2;
                        }
                    } else {
                        logger.warn("Response data format ERROR! Not support Response.FIRTYPE ");
                    }
                }
                catch (IOException ex) {
                    logger.warn(ex.getMessage(), ex);
                }
                ++k;
                ++n;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.TSN) {
            int j = 0;
            while (j < this.SI[i2].stn_par.comp) {
                this.SI[i2].cha_par[j].resp = null;
                ++j;
            }
            ++i2;
        }
    }

    public void writeEvtHeadInfo(LittleEndianOutputStream leOut, int[] stn, int begTime, int cutLen) throws IOException {
        leOut.writeBytes("digital event", 16);
        leOut.writeBytes("PC", 16);
        leOut.writeInt(1);
        leOut.writeInt(0);
        leOut.writeBytes("NetName", 80);
        leOut.writeInt(stn.length);
        leOut.writeFloat((float)this.clat);
        leOut.writeFloat((float)this.clon);
        leOut.writeFloat((float)this.calt);
        leOut.writeBytes("", 120);
        leOut.writeInt((int)(this.EventDate.getTime() / 1000L) + begTime);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(this.aEventDate[0].getTime() + (long)begTime * 1000L));
        leOut.writeShort(calendar.get(1));
        leOut.writeShort(calendar.get(2) + 1);
        leOut.writeShort(calendar.get(5));
        leOut.writeShort(calendar.get(11));
        leOut.writeShort(calendar.get(12));
        leOut.writeShort(calendar.get(13));
        leOut.writeInt(cutLen);
        int i = 0;
        while (i < stn.length) {
            int n = stn[i];
            logger.info("write Station info of " + this.SI[n].stn_par.name);
            leOut.writeInt(this.SI[n].stn_par.no);
            leOut.writeBytes(this.SI[n].stn_par.name, 20);
            leOut.writeBytes(this.SI[n].stn_par.DASType, 10);
            leOut.writeShort(this.SI[n].stn_par.wlen);
            leOut.writeFloat(this.SI[n].stn_par.VLtd);
            leOut.writeInt(this.SI[n].stn_par.samp);
            leOut.writeInt(this.SI[n].stn_par.comp);
            leOut.writeShort(this.SI[n].stn_par.TranMode);
            leOut.writeBytes(this.SI[n].stn_par.TranIns, 12);
            leOut.writeShort(this.SI[n].stn_par.TimerMode);
            leOut.writeBytes(this.SI[n].stn_par.ClkType, 12);
            leOut.writeFloat(this.SI[n].stn_par.ClkErr);
            leOut.writeFloat(this.SI[n].stn_par.latitude);
            leOut.writeFloat(this.SI[n].stn_par.longitude);
            leOut.writeFloat(this.SI[n].stn_par.altitude);
            leOut.writeFloat(this.SI[n].stn_par.azimuth);
            leOut.writeFloat(this.SI[n].stn_par.incident);
            leOut.writeShort(this.SI[n].stn_par.weight);
            leOut.writeShort(this.SI[n].stn_par.veloc);
            leOut.writeInt(this.SI[n].stn_par.oritype);
            leOut.writeBytes(this.SI[n].stn_par.seismometer, 8);
            leOut.writeInt(this.SI[n].stn_par.SMMode);
            int j = 0;
            while (j < this.SI[n].stn_par.comp) {
                leOut.writeBytes(this.SI[n].cha_par[j].name, 12);
                leOut.writeInt(this.SI[n].cha_par[j].no);
                leOut.writeFloat(this.SI[n].cha_par[j].factor);
                leOut.writeInt(this.SI[n].cha_par[j].respstep);
                leOut.writeBytes(this.getResponseBytes(this.getCN(n) + j), 12288);
                ++j;
            }
            ++i;
        }
    }

    public void writeEvtHeadInfo(LittleEndianOutputStream leOut) throws IOException {
        int[] stn = new int[this.TSN];
        int i = 0;
        while (i < this.TSN) {
            stn[i] = i;
            ++i;
        }
        this.writeEvtHeadInfo(leOut, stn, 0, this.TRL);
    }

    private byte[] getResponseBytes(int chn) throws IOException {
        ByteArrayOutputStream bOutStream = new ByteArrayOutputStream(1024);
        LittleEndianOutputStream leOut = new LittleEndianOutputStream(bOutStream);
        logger.info("chn=" + chn);
        if (this.Rspns[chn].type == 1) {
            leOut.writeInt(this.Rspns[chn].type);
            leOut.writeInt(this.Rspns[chn].ntrip);
            int i = 0;
            while (i < this.Rspns[chn].ntrip) {
                leOut.writeFloat((float)this.Rspns[chn].Freq[i]);
                leOut.writeFloat((float)this.Rspns[chn].Amp[i]);
                leOut.writeFloat((float)this.Rspns[chn].Phase[i]);
                ++i;
            }
        } else if (this.Rspns[chn].type == 0) {
            leOut.writeInt(this.Rspns[chn].type);
            leOut.writeFloat((float)this.Rspns[chn].getTfGain());
            leOut.writeInt(this.Rspns[chn].getPoleNum());
            int i = 0;
            while (i < this.Rspns[chn].getPoleNum()) {
                leOut.writeFloat((float)this.Rspns[chn].getPole()[i].real());
                leOut.writeFloat((float)this.Rspns[chn].getPole()[i].imag());
                ++i;
            }
            leOut.writeInt(this.Rspns[chn].getZeroNum());
            i = 0;
            while (i < this.Rspns[chn].getZeroNum()) {
                leOut.writeFloat((float)this.Rspns[chn].getZero()[i].real());
                leOut.writeFloat((float)this.Rspns[chn].getZero()[i].imag());
                ++i;
            }
        }
        leOut.flush();
        leOut.close();
        bOutStream.flush();
        return bOutStream.toByteArray();
    }

    private void writeOneSecondData(LittleEndianOutputStream leOut, int[] stn, int sec) throws IOException {
        int k = 0;
        while (k < stn.length) {
            int n = stn[k];
            leOut.writeInt(this.Flag[n][sec]);
            int j = 0;
            while (j < this.SI[n].stn_par.comp) {
                int i = 0;
                while (i < this.SI[n].stn_par.samp) {
                    if (this.SI[n].stn_par.wlen != 16) {
                        leOut.writeInt((int)this.WDat[this.getCN(n) + j][this.SI[n].stn_par.samp * sec + i]);
                    } else {
                        leOut.writeShort((int)this.WDat[this.getCN(n) + j][this.SI[n].stn_par.samp * sec + i]);
                    }
                    ++i;
                }
                ++j;
            }
            ++k;
        }
    }

    private void writeOneSecondData(LittleEndianOutputStream leOut, int sec) throws IOException {
        int k = 0;
        while (k < this.TSN) {
            leOut.writeInt(this.Flag[k][sec]);
            int j = 0;
            while (j < this.SI[k].stn_par.comp) {
                int i = 0;
                while (i < this.SI[k].stn_par.samp) {
                    if (this.SI[k].stn_par.wlen != 16) {
                        leOut.writeInt((int)this.WDat[this.getCN(k) + j][this.SI[k].stn_par.samp * sec + i]);
                    } else {
                        leOut.writeShort((int)this.WDat[this.getCN(k) + j][this.SI[k].stn_par.samp * sec + i]);
                    }
                    ++i;
                }
                ++j;
            }
            ++k;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private Hashtable<String, ChanMap> fillChanMap(EvtData evtData) {
        Hashtable<String, ChanMap> tbl = new Hashtable<String, ChanMap>();
        int tcn = evtData.getTCN();
        int i = 0;
        while (i < tcn) {
            String network = evtData.getNetworkCode(i);
            String stationCode = evtData.getStationCode(i);
            String locId = evtData.getAuxId(i);
            String chan2 = evtData.getChannelCode(i).substring(0, 2);
            String key = String.valueOf(network) + "/" + stationCode + "/" + locId + "/" + chan2;
            ChanMap chanMap = tbl.get(key);
            if (chanMap == null) {
                chanMap = new ChanMap();
                chanMap.network = network;
                chanMap.stationCode = stationCode;
                chanMap.locId = locId;
                chanMap.chan2 = chan2;
                chanMap.chanOrder = evtData.getChanOrder(network, stationCode, locId, chan2);
                tbl.put(key, chanMap);
            }
            ++i;
        }
        return tbl;
    }

    public static void main(String[] args) {
        EvtData evtdata = EvtData.readEvtData("/tmp/xj200610100242.evt");
    }

    private static class ChanMap {
        public String network;
        public String stationCode;
        public String locId;
        public String chan2;
        public int[] chanOrder;

        private ChanMap() {
        }
    }
}

