/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.gse;

import cn.org.gddsn.seis.evtformat.gse.GSEDataType;
import cn.org.gddsn.seis.evtformat.gse.GSEFieldFormat;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.LinkedList;

abstract class FieldsInOneBlock
extends GSEDataType {
    GSEFieldFormat[] gseFieldFormat = null;
    Object[][] fieldValue = null;
    int nColumn;
    int nRow;
    String headText = "";

    public Object getFieldValue(int nField, int nRecord) {
        if (nField < 0 || nField >= this.nColumn || nRecord < 0 || nRecord >= this.nRow) {
            throw new IllegalArgumentException("the field or record is exceed.");
        }
        return this.fieldValue[nField][nRecord];
    }

    public void setFieldValue(int nField, int nRecord, Object newObj) {
        if (nField < 0 || nField >= this.nColumn || nRecord < 0 || nRecord >= this.nRow) {
            throw new IllegalArgumentException("the field or record is exceed.");
        }
        GSEFieldFormat.checkValid(newObj, this.gseFieldFormat[nField]);
        this.fieldValue[nField][nRecord] = newObj;
    }

    public void deCod(String aheadLine, BufferedReader reader) throws IOException {
        LinkedList<Object[]> list = new LinkedList<Object[]>();
        String msg = reader.readLine();
        while (!this.isDataMessageHead(msg) && !this.isDataMessageHead(msg)) {
            Object[] fValue = GSEFieldFormat.deCod(aheadLine, this.gseFieldFormat);
            list.add(fValue);
            msg = reader.readLine();
        }
        Object[] rows = list.toArray();
        this.nRow = rows.length;
        this.fieldValue = new Object[this.nRow][];
        int i = 0;
        while (i < this.nRow) {
            this.fieldValue[i] = (Object[])rows[i];
            ++i;
        }
        this.nColumn = this.fieldValue[0].length;
        this.headLine = msg;
    }

    public void enCod(BufferedWriter writer) throws IOException {
        writer.write(this.headText);
        int i = 0;
        while (i < this.nRow) {
            writer.write(GSEFieldFormat.enCod(this.fieldValue[i], this.gseFieldFormat));
            writer.newLine();
            ++i;
        }
    }
}

