/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.gse;

import cn.org.gddsn.convert.DateToString;
import cn.org.gddsn.convert.cs_printf;
import cn.org.gddsn.seis.evtformat.gse.GSEFormatException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

class GSEFieldFormat {
    static Logger logger = Logger.getLogger(GSEFieldFormat.class);
    public String name;
    public String format;
    public String description;

    public GSEFieldFormat(String name, String format, String description) {
        this.name = name;
        this.format = format;
        this.description = description;
        this.checkValid();
    }

    public static Object[] deCod(String strLine, GSEFieldFormat[] format) {
        ArrayList<Object> list = new ArrayList<Object>();
        StringBuffer sbLine = new StringBuffer(strLine);
        sbLine.append(' ');
        StringBuffer sb = new StringBuffer();
        try {
            int i = 0;
            while (i < format.length) {
                int len;
                char pre = format[i].format.charAt(0);
                switch (pre) {
                    case 'a': {
                        len = Integer.parseInt(format[i].format.substring(1));
                        list.add(sbLine.substring(0, len));
                        break;
                    }
                    case 'i': {
                        len = Integer.parseInt(format[i].format.substring(1));
                        list.add(new Integer(sbLine.substring(0, len)));
                        break;
                    }
                    case 'f': {
                        int dotIdx = format[i].format.indexOf(46);
                        if (dotIdx == -1) {
                            throw new GSEFormatException("Field Format invalid");
                        }
                        len = Integer.parseInt(format[i].format.substring(1, dotIdx));
                        list.add(new Double(sbLine.substring(0, len)));
                        break;
                    }
                    case 'e': {
                        int dotIdx = format[i].format.indexOf(46);
                        if (dotIdx == -1) {
                            throw new GSEFormatException("Field Format invalid");
                        }
                        len = Integer.parseInt(format[i].format.substring(1, dotIdx));
                        list.add(new Double(sbLine.substring(0, len)));
                        break;
                    }
                    case 'H': 
                    case 'M': 
                    case 'd': 
                    case 'm': 
                    case 'y': {
                        len = format[i].format.length();
                        list.add(DateToString.GSE2Date(sbLine.substring(0, len), format[i].format));
                        break;
                    }
                    default: {
                        throw new GSEFormatException("Field Format invalid");
                    }
                }
                sbLine.delete(0, len + 1);
                ++i;
            }
        }
        catch (NumberFormatException nfe) {
            throw new GSEFormatException("Field Format invalid");
        }
        catch (ParseException pe) {
            throw new GSEFormatException("Field Format invalid");
        }
        return list.toArray();
    }

    public static String enCod(Object[] obj, GSEFieldFormat[] format) {
        if (obj.length > format.length) {
            throw new IllegalArgumentException();
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < obj.length) {
            GSEFieldFormat.checkValid(obj[i], format[i]);
            char pre = format[i].format.charAt(0);
            switch (pre) {
                case 'a': {
                    int len = Integer.parseInt(format[i].format.substring(1));
                    sb.append(((String)obj[i]).substring(0, len));
                    break;
                }
                case 'i': {
                    sb.append('%');
                    sb.append(format[i].format.substring(1));
                    sb.append('d');
                    list.add(obj[i]);
                    break;
                }
                case 'f': {
                    sb.append('%');
                    sb.append(format[i].format.substring(1));
                    sb.append('f');
                    list.add(obj[i]);
                    break;
                }
                case 'e': {
                    sb.append('%');
                    sb.append(format[i].format.substring(1));
                    sb.append('g');
                    list.add(obj[i]);
                    break;
                }
                case 'H': 
                case 'M': 
                case 'd': 
                case 'm': 
                case 'y': {
                    sb.append(DateToString.Date2GSE((Date)obj[i], format[i].format));
                }
                default: {
                    throw new GSEFormatException("Field Format invalid");
                }
            }
            sb.append(' ');
            ++i;
        }
        return cs_printf.vsprintf(sb.toString(), list.toArray());
    }

    public static void checkValid(Object obj, GSEFieldFormat format) {
        if (obj == null) {
            throw new IllegalArgumentException("obj is null in GSEFieldFormat.checkValid()");
        }
        Matcher match = null;
        Pattern re = Pattern.compile("[aifeyMdHm]");
        match = re.matcher(format.format);
        boolean b = match.matches();
        if (!b) {
            throw new GSEFormatException("Field Format invalid");
        }
        String matchStr = match.toString();
        if (matchStr.equalsIgnoreCase("i") && obj instanceof Integer) {
            return;
        }
        if (matchStr.equalsIgnoreCase("f") && obj instanceof Double) {
            return;
        }
        if (matchStr.equalsIgnoreCase("e") && obj instanceof Double) {
            return;
        }
        if (matchStr.equalsIgnoreCase("a") && obj instanceof String) {
            return;
        }
        if (matchStr.equalsIgnoreCase("y") && obj instanceof Date) {
            return;
        }
        if (matchStr.equalsIgnoreCase("m") && obj instanceof Date) {
            return;
        }
        if (matchStr.equalsIgnoreCase("d") && obj instanceof Date) {
            return;
        }
        if (matchStr.equalsIgnoreCase("h") && obj instanceof Date) {
            return;
        }
        throw new GSEFormatException("Obj Type is Invalid");
    }

    private void checkValid() {
        Matcher match = null;
        Pattern re = Pattern.compile("[aifeyMdHm]");
        match = re.matcher(this.format);
        boolean b = match.matches();
        if (!b) {
            throw new GSEFormatException("Field Format invalid");
        }
        String matchStr = match.toString();
        if (matchStr.equalsIgnoreCase("i")) {
            return;
        }
        if (matchStr.equalsIgnoreCase("f")) {
            return;
        }
        if (matchStr.equalsIgnoreCase("e")) {
            return;
        }
        if (matchStr.equalsIgnoreCase("a")) {
            return;
        }
        if (matchStr.equalsIgnoreCase("y")) {
            return;
        }
        if (matchStr.equalsIgnoreCase("m")) {
            return;
        }
        if (matchStr.equalsIgnoreCase("d")) {
            return;
        }
        if (matchStr.equalsIgnoreCase("h")) {
            return;
        }
        throw new GSEFormatException("Field Format invalid");
    }
}

