/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.seed;

import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.liss.port.event.MiniSeedAction;
import cn.org.gddsn.liss.port.event.MiniSeedPortEvent;
import cn.org.gddsn.liss.port.event.MiniSeedPortEventListener;
import cn.org.gddsn.liss.port.sss.SSSPort;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.evtformat.TimeWindow;
import cn.org.gddsn.seis.evtformat.seed.SeedVolumePlugin;
import cn.org.gddsn.signal.Numeric;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import edu.iris.miniseedutils.steim.MiniSeedRecord;
import edu.iris.miniseedutils.steim.MiniSeedRecordDouble;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeedVolumeSSSPlugin
implements SeedVolumePlugin,
MiniSeedPortEventListener,
TimeWindow {
    static Logger logger = Logger.getLogger(SeedVolumeSSSPlugin.class);
    private Hashtable<String, List<MiniSeedRecord>> wfHash = new Hashtable();
    private List<MiniSeedRecord> wfList = Collections.synchronizedList(new LinkedList());
    private Iterator<MiniSeedRecord> wfIterator;
    private int maxSize = 1024;
    private int bufferLength = 1200;
    private SeedVolumeService seedVolumeService = null;
    private SSSPort sssPort = null;
    private Dataless dl = null;
    private Object lock = new Object();
    private MiniSeedAction miniSeedAction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MiniSeedRecordDouble getTimeWindow(ChannelLocator cl, double start, double end) {
        MiniSeedRecordDouble msr = new MiniSeedRecordDouble();
        msr.setNetwork(cl.getNetCode());
        msr.setStation(cl.getStationCode());
        msr.setLocID(cl.getLocID());
        msr.setChannel(cl.getChanCode());
        msr.setStartTime(start);
        msr.setEndTime(end);
        String key = cl.toString();
        LinkedList<MiniSeedRecord> wlist = new LinkedList<MiniSeedRecord>();
        Object object = this.lock;
        synchronized (object) {
            List<MiniSeedRecord> list;
            block11: {
                list = this.wfHash.get(key);
                if (list != null) break block11;
                return null;
            }
            for (MiniSeedRecord m : list) {
                if (m.getStartTime() >= msr.getStartTime() && m.getStartTime() <= msr.getEndTime()) {
                    wlist.add(m);
                    continue;
                }
                if (!(m.getEndTime() >= msr.getStartTime()) || !(m.getEndTime() <= msr.getEndTime())) continue;
                wlist.add(m);
            }
        }
        if (wlist.size() == 0) {
            return null;
        }
        double sr = ((MiniSeedRecord)wlist.get(0)).getSampleRate();
        msr.setSampleRate(sr);
        int nsamp = (int)Math.round((end - start) * sr);
        msr.setNumSamples(nsamp);
        double[] data = new double[nsamp];
        msr.setData(data);
        Collections.sort(wlist);
        double es = ((MiniSeedRecord)wlist.get(0)).getEndTime();
        int n = 0;
        for (MiniSeedRecord m : wlist) {
            if (n++ > 0 && !(Math.abs(m.getStartTime() - es) > 1.0E-5)) {
                es = m.getEndTime();
            }
            int st = (int)Math.round((m.getStartTime() - start) * sr);
            int[] mdat = m.getData();
            int i = 0;
            while (i < mdat.length) {
                if (st >= 0 && st < nsamp) {
                    data[st] = mdat[i];
                }
                ++i;
                ++st;
            }
        }
        Numeric.linearFillGaps(data);
        return msr;
    }

    void testGTW(ChannelLocator cl) {
        double st = System.currentTimeMillis() / 1000L - 60L;
        double ed = st + 20.0;
        this.getTimeWindow(cl, st, ed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void miniSeedEvent(MiniSeedPortEvent mspEvent) {
        GenericMiniSeedRecord g = mspEvent.getGenericMiniSeedRecord();
        MiniSeedRecord m = MiniSeedRecord.build(g);
        if (m == null) {
            logger.warn("MiniSeedRecord should not be null: " + g);
            return;
        }
        String cl = String.valueOf(g.getNetwork()) + "/" + g.getStation() + "/" + g.getLocID() + "/" + g.getChannel();
        List<MiniSeedRecord> list = this.wfHash.get(cl);
        if (list == null) {
            list = Collections.synchronizedList(new LinkedList());
            this.wfHash.put(cl, list);
        }
        Object object = this.lock;
        synchronized (object) {
            list.add(m);
            while (list.size() > this.maxSize) {
                MiniSeedRecord rm = list.remove(0);
                rm.setData(null);
                rm = null;
            }
            if (this.miniSeedAction != null) {
                this.miniSeedAction.action(m);
            }
        }
    }

    public void init() throws Exception {
        if (this.sssPort != null) {
            this.sssPort.addMiniSeedPortEventListener(this);
        } else {
            logger.warn("sssPort is null!");
        }
    }

    @Override
    public void setSource(Object source, Object extra) {
        Date current = (Date)source;
        int length = extra != null ? (Integer)extra : this.bufferLength;
        this.getDataless();
        this.dl.getVolumeIndex().getBlockette010().setStartTime(new Timestamp(current.getTime() - (long)length * 1000L));
        this.dl.getVolumeIndex().getBlockette010().setEndTime(new Timestamp(current.getTime()));
        Enumeration<List<MiniSeedRecord>> enu = this.wfHash.elements();
        while (enu.hasMoreElements()) {
            this.wfList.addAll((Collection<MiniSeedRecord>)enu.nextElement());
        }
        this.wfIterator = this.wfList.iterator();
    }

    @Override
    public void cleanUpSource() {
        this.wfList.clear();
        this.wfIterator = null;
    }

    @Override
    public boolean accept(ChannelLocator cl, double sampRate) {
        return true;
    }

    @Override
    public Dataless getDataless() {
        if (this.dl == null) {
            long ct = System.currentTimeMillis();
            this.dl = this.seedVolumeService.findDefaultDataless();
            logger.info("load dataless time: " + (System.currentTimeMillis() - ct));
        }
        return this.dl;
    }

    @Override
    public List<MiniSeedRecord> getNextChannel() {
        return null;
    }

    @Override
    public MiniSeedRecord getNextMiniSeedData() {
        if (this.wfIterator.hasNext()) {
            return this.wfIterator.next();
        }
        return null;
    }

    @Override
    public void setChannelFilter(String filter) {
    }

    @Override
    public void setPreFetchSize(int preFetchSize) {
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public SeedVolumeService getSeedVolumeService() {
        return this.seedVolumeService;
    }

    public void setSeedVolumeService(SeedVolumeService seedVolumeService) {
        this.seedVolumeService = seedVolumeService;
    }

    public SSSPort getSssPort() {
        return this.sssPort;
    }

    public void setSssPort(SSSPort sssPort) {
        this.sssPort = sssPort;
    }

    public int getBufferLength() {
        return this.bufferLength;
    }

    public void setBufferLength(int bufferLength) {
        this.bufferLength = bufferLength;
    }

    public void setMiniSeedAction(MiniSeedAction miniSeedAction) {
        this.miniSeedAction = miniSeedAction;
    }
}

