/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.LocationMath;
import cn.org.gddsn.seis.location.PeriodBound;
import java.util.Date;

public class AutoMag {
    private static int MS_MIN_DIST = 10;
    private static int MS_MAX_DIST = 150;
    private static int MS_STEP = 5;
    private static double[] AIRY_sigma = new double[]{4.5, 7.0, 9.5, 11.0, 13.5, 15.5, 18.5, 21.0, 24.0, 26.0, 28.5, 31.0, 33.0, 35.0, 37.0, 39.5, 42.0, 43.0, 45.5, 47.5, 48.5, 53.0, 55.0, 57.0, 60.0, 62.0, 64.0, 67.0, 70.0, 73.0};
    private static double ML_STEP = 0.5;
    private static double[] RICHARD_sigma = new double[]{8.0, 30.0, 30.0, 30.0, 40.0, 50.0, 65.0, 90.0, 100.0, 110.0, 130.0, 160.0, 170.0, 180.0, 200.0, 200.0, 210.0, 230.0, 240.0, 250.0, 280.0, 290.0};
    private static double[] DELAY_TIME = new double[]{2.0, 4.0, 6.0, 8.0, 12.0, 20.0, 40.0};
    private EvtData evt;

    public static double getDelayTime(double delta, double mag) {
        int imag = (int)Math.round(mag) - 2;
        if (imag < 0) {
            imag = 0;
        }
        if (imag > 6) {
            imag = 6;
        }
        if (delta < (double)MS_MIN_DIST) {
            int idist = (int)delta;
            int idx = (int)((double)idist / ML_STEP);
            double d = (delta - (double)idx * ML_STEP) / ML_STEP;
            double min = (RICHARD_sigma[idx] + (d *= RICHARD_sigma[idx + 1] - RICHARD_sigma[idx])) / 60.0;
            return min + DELAY_TIME[imag];
        }
        int idist = (int)delta;
        if (idist > MS_MAX_DIST) {
            idist = MS_MAX_DIST;
        }
        int idx = (idist - MS_MIN_DIST) / MS_STEP;
        double d = (delta - (double)MS_MIN_DIST - (double)(idx * MS_STEP)) / (double)MS_STEP;
        double min = AIRY_sigma[idx] + (d *= AIRY_sigma[idx + 1] - AIRY_sigma[idx]);
        return min + DELAY_TIME[imag];
    }

    public void autoMeasure() {
        this.autoMeasureMl();
        this.autoMeasureMB();
        this.autoMeasureMs();
    }

    public void autoMeasureMB() {
        int TCN = this.evt.getTCN();
        PeriodBoundMB pb = new PeriodBoundMB();
        int chn = 0;
        while (chn < TCN) {
            double delta = this.evt.getStationLocation(chn).getDelta();
            int idist = (int)Math.round(delta);
            if (idist >= 16 && idist <= 120) {
                Phase phaseP = this.evt.getPhase(chn, "P");
                Phase phasePMZ = this.evt.getPhase(chn, "PMZ");
                if (phaseP != null && phasePMZ == null) {
                    double mean;
                    double[] wdat = this.evt.getSampData(chn);
                    double sr = this.evt.getSampleRate(chn);
                    int start = phaseP.offset = (int)((double)(phaseP.getPhaseTime().getTime() - this.evt.getArrivalTime(chn).getTime()) * this.evt.getSampleRate(chn) / 1000.0);
                    int end = phaseP.offset + (int)(sr * 5.0);
                    int max = this.evt.getMaxPPCountWithPeriod(chn, start = Math.max(0, start), end = Math.min(end, wdat.length), mean = this.evt.getMean(chn, start, end), pb);
                    double[] par = LocationMath.measurePeriod(wdat, max, start, end, sr, mean);
                    if (pb.accept(par)) {
                        phasePMZ = new Phase();
                        phasePMZ.setPhaseName("PMZ");
                        phasePMZ.setStationCode(this.evt.getStationCode(chn));
                        phasePMZ.setBelongedChannelID(this.evt.toComp(chn) - 1);
                        phasePMZ.setChanCode(this.evt.getChannelCode(chn));
                        phasePMZ.setRecType(this.evt.getOriginalType(chn));
                        phasePMZ.setInstrumentName(this.evt.getInstrumentType(chn));
                        phasePMZ.setNetCode(this.evt.getNetworkCode(chn));
                        phasePMZ.setPhaType(1);
                        phasePMZ.setAmpType(0);
                        phasePMZ.offset = max;
                        phasePMZ.iPeriod = (int)(sr * par[0]);
                        phasePMZ.setPeriod(par[0]);
                        double amp = this.evt.getMaxPPCount(chn, phasePMZ.offset - phasePMZ.iPeriod / 2, phasePMZ.offset + phasePMZ.iPeriod / 2) / 2.0;
                        phasePMZ.setAmp(amp / this.evt.getCalibFactor(chn));
                        long date = this.evt.getArrivalTime(chn).getTime() + (long)((double)((long)phasePMZ.offset * 1000L) / sr);
                        phasePMZ.setPhaseTime(new Date(date));
                        this.evt.getPhases(chn).addElement(phasePMZ);
                    }
                }
            }
            ++chn;
        }
    }

    public static double getAiryWaveMaxAmpTime(double delta) {
        int idist = (int)delta;
        if (idist < MS_MIN_DIST || idist > MS_MAX_DIST) {
            return Double.NaN;
        }
        int idx = (idist - MS_MIN_DIST) / MS_STEP;
        double d = (delta - (double)MS_MIN_DIST - (double)(idx * MS_STEP)) / (double)MS_STEP;
        double second = (int)((AIRY_sigma[idx] + (d *= AIRY_sigma[idx + 1] - AIRY_sigma[idx])) * 60.0);
        return second;
    }

    public void autoMeasureMs() {
        int TCN = this.evt.getTCN();
        PeriodBoundMs pb = new PeriodBoundMs();
        int chn = 0;
        while (chn < TCN) {
            block7: {
                double mean;
                int max;
                double[] par;
                double sr;
                int end;
                int start;
                double[] wdat;
                Phase phaseAMP;
                String ampName;
                block8: {
                    String sta;
                    double delta = this.evt.getStationLocation(chn).getDelta();
                    double sec = AutoMag.getAiryWaveMaxAmpTime(delta);
                    if (Double.isNaN(sec)) break block7;
                    int second = (int)sec;
                    String chan = this.evt.getChannelCode(chn);
                    if (chan.endsWith("Z")) break block7;
                    ampName = "LE";
                    if (chan.endsWith("N")) {
                        ampName = "LN";
                    }
                    Phase phaseP = this.evt.getTheoreticPhase(chn, "P");
                    phaseAMP = this.evt.getPhase(chn, ampName);
                    String net = this.evt.getNetworkCode(chn);
                    if (!this.evt.hasPhase(net, sta = this.evt.getStationCode(chn)) || phaseAMP != null) break block7;
                    wdat = this.evt.getSampData(chn);
                    start = 0;
                    end = wdat.length;
                    sr = this.evt.getSampleRate(chn);
                    if (phaseP == null) break block8;
                    phaseP.offset = (int)((double)(phaseP.getPhaseTime().getTime() - this.evt.getArrivalTime(chn).getTime()) * this.evt.getSampleRate(chn) / 1000.0);
                    start = Math.max(0, phaseP.offset + (int)((double)(second - 120) * sr));
                    Phase phaseS = this.evt.getTheoreticPhase(chn, "S");
                    if (phaseS != null) {
                        start = Math.max(start, phaseS.offset);
                    }
                    end = Math.min(phaseP.offset + (int)((double)(second + 120) * sr), wdat.length);
                    if ((start = Math.max(0, start)) > (end = Math.min(end, wdat.length))) break block7;
                }
                if (pb.accept(par = LocationMath.measurePeriod(wdat, max = this.evt.getMaxPPCountWithPeriod(chn, start, end, mean = this.evt.getMean(chn, start, end), pb), start, end, sr, mean))) {
                    phaseAMP = new Phase();
                    phaseAMP.setPhaseName(ampName);
                    phaseAMP.setStationCode(this.evt.getStationCode(chn));
                    phaseAMP.setBelongedChannelID(this.evt.toComp(chn) - 1);
                    phaseAMP.setChanCode(this.evt.getChannelCode(chn));
                    phaseAMP.setRecType(this.evt.getOriginalType(chn));
                    phaseAMP.setInstrumentName(this.evt.getInstrumentType(chn));
                    phaseAMP.setNetCode(this.evt.getNetworkCode(chn));
                    phaseAMP.setPhaType(1);
                    phaseAMP.setAmpType(0);
                    phaseAMP.offset = max;
                    phaseAMP.iPeriod = (int)(sr * par[0]);
                    phaseAMP.setPeriod(par[0]);
                    double amp = this.evt.getMaxPPCount(chn, phaseAMP.offset - phaseAMP.iPeriod / 2, phaseAMP.offset + phaseAMP.iPeriod / 2) / 2.0;
                    phaseAMP.setAmp(amp / this.evt.getCalibFactor(chn));
                    long date = this.evt.getArrivalTime(chn).getTime() + (long)((double)((long)phaseAMP.offset * 1000L) / sr);
                    phaseAMP.setPhaseTime(new Date(date));
                    this.evt.getPhases(chn).addElement(phaseAMP);
                }
            }
            ++chn;
        }
    }

    public void autoMeasureMl() {
        int TCN = this.evt.getTCN();
        PeriodBoundMl pb = new PeriodBoundMl();
        int chn = 0;
        while (chn < TCN) {
            block7: {
                double mean;
                int max;
                double[] par;
                double sr;
                int end;
                int start;
                double[] wdat;
                Phase phaseAMP;
                String ampName;
                block8: {
                    String sta;
                    String chan;
                    double delta = this.evt.getStationLocation(chn).getDelta();
                    int idist = (int)delta;
                    if ((double)idist > 10.0 || (chan = this.evt.getChannelCode(chn)).endsWith("Z")) break block7;
                    ampName = "SME";
                    if (chan.endsWith("N")) {
                        ampName = "SMN";
                    }
                    Phase phaseP = this.evt.getTheoreticPhase(chn, "P");
                    Phase phaseS = this.evt.getTheoreticPhase(chn, "S");
                    phaseAMP = this.evt.getPhase(chn, ampName);
                    String net = this.evt.getNetworkCode(chn);
                    if (!this.evt.hasPhase(net, sta = this.evt.getStationCode(chn)) || phaseAMP != null) break block7;
                    wdat = this.evt.getSampData(chn);
                    start = 0;
                    Phase phaseSg = this.evt.getPhase(net, sta, "Sg");
                    if (phaseSg != null) {
                        start = phaseSg.offset;
                    }
                    end = wdat.length;
                    sr = this.evt.getSampleRate(chn);
                    if (phaseS == null || phaseP == null) break block8;
                    phaseS.offset = (int)((double)(phaseS.getPhaseTime().getTime() - this.evt.getArrivalTime(chn).getTime()) * this.evt.getSampleRate(chn) / 1000.0);
                    phaseP.offset = (int)((double)(phaseP.getPhaseTime().getTime() - this.evt.getArrivalTime(chn).getTime()) * this.evt.getSampleRate(chn) / 1000.0);
                    start = Math.max(start, phaseS.offset);
                    int idx = (int)((double)idist / ML_STEP);
                    double d = (delta - (double)idx * ML_STEP) / ML_STEP;
                    int second = (int)(RICHARD_sigma[idx] + (d *= RICHARD_sigma[idx + 1] - RICHARD_sigma[idx]));
                    end = Math.min(phaseP.offset + (int)(sr * (double)second), wdat.length);
                    if (start > end) break block7;
                }
                if (pb.accept(par = LocationMath.measurePeriod(wdat, max = this.evt.getMaxPPCountWithPeriod(chn, start, end, mean = this.evt.getMean(chn, start, end), pb), start, end, sr, mean))) {
                    phaseAMP = new Phase();
                    phaseAMP.setPhaseName(ampName);
                    phaseAMP.setStationCode(this.evt.getStationCode(chn));
                    phaseAMP.setBelongedChannelID(this.evt.toComp(chn) - 1);
                    phaseAMP.setChanCode(this.evt.getChannelCode(chn));
                    phaseAMP.setRecType(this.evt.getOriginalType(chn));
                    phaseAMP.setInstrumentName(this.evt.getInstrumentType(chn));
                    phaseAMP.setNetCode(this.evt.getNetworkCode(chn));
                    phaseAMP.setPhaType(1);
                    phaseAMP.setAmpType(0);
                    phaseAMP.offset = max;
                    phaseAMP.iPeriod = (int)(sr * par[0]);
                    phaseAMP.setPeriod(par[0]);
                    double amp = this.evt.getMaxPPCount(chn, phaseAMP.offset - phaseAMP.iPeriod / 2, phaseAMP.offset + phaseAMP.iPeriod / 2) / 2.0;
                    phaseAMP.setAmp(amp / this.evt.getCalibFactor(chn));
                    long date = this.evt.getArrivalTime(chn).getTime() + (long)((double)((long)phaseAMP.offset * 1000L) / sr);
                    phaseAMP.setPhaseTime(new Date(date));
                    this.evt.getPhases(chn).addElement(phaseAMP);
                }
            }
            ++chn;
        }
    }

    public EvtData getEvt() {
        return this.evt;
    }

    public void setEvt(EvtData evt) {
        this.evt = evt;
    }

    private static class PeriodBoundMB
    implements PeriodBound {
        private PeriodBoundMB() {
        }

        public boolean accept(double[] par) {
            return !Double.isNaN(par[0]) && !(par[1] > 2.0) && !(par[0] > 4.0) && !(par[0] < 0.2);
        }
    }

    private static class PeriodBoundMl
    implements PeriodBound {
        private PeriodBoundMl() {
        }

        public boolean accept(double[] par) {
            return !Double.isNaN(par[0]) && !(par[1] > 1.0) && !(par[0] > 5.0);
        }
    }

    private static class PeriodBoundMs
    implements PeriodBound {
        private PeriodBoundMs() {
        }

        public boolean accept(double[] par) {
            return !Double.isNaN(par[0]) && !(par[1] > 5.0) && !(par[0] > 30.0) && !(par[0] < 5.0);
        }
    }
}

