/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.optimization.AEAMin;
import cn.org.gddsn.optimization.DoubleEncodeToDoubleFunction;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.location.IterateNearlocL1Residual;

public class GaAndL1Loc
extends IterateNearlocL1Residual {
    double residual;
    double OTime;
    private double width = 2.5;
    private double maxDepth = 50.0;

    public GaAndL1Loc() {
    }

    public GaAndL1Loc(SourceParam newTrySource) {
        this.trySource = newTrySource;
    }

    public boolean findSourceLoc() {
        double[] trialLoc = new double[]{this.trySource.lat, this.trySource.lon, 10.0};
        DoubleEncodeToDoubleFunction df = new DoubleEncodeToDoubleFunction();
        int size = 3;
        double[] paraMin = new double[size];
        double[] paraMax = new double[size];
        int i = 0;
        while (i < size - 1) {
            paraMin[i] = trialLoc[i] - this.width;
            paraMax[i] = trialLoc[i] + this.width;
            ++i;
        }
        paraMin[2] = 0.0;
        paraMax[2] = this.maxDepth;
        df.setParaMin(paraMin);
        df.setParaMax(paraMax);
        df.setFunk(this);
        AEAMin gm = new AEAMin();
        gm.setPopulationSize(20);
        gm.setMutationP(0.25);
        gm.setSelectP(0.8);
        gm.setInversionP(0.1);
        gm.setFunk(df);
        gm.setIterateMax(600);
        gm.setEps(5.0E-5);
        gm.SearchMin();
        double[] res = gm.getResult();
        this.sourceParam.lat = res[0];
        this.sourceParam.lon = res[1];
        this.sourceParam.depth = res[2];
        this.sourceParam.rms = gm.getResidual();
        this.sourceParam.originTime.setTime(this.BaseDate.getTime() + Math.round(this.getOTime() * 1000.0));
        return true;
    }

    public SourceParam getSourceParam() {
        SourceParam sp = super.getSourceParam();
        sp.setLocProgram("GA");
        return sp;
    }

    private double getOTime() {
        double tt;
        double delta;
        int stnSum = this.getStnSum();
        double[] stnLat = new double[stnSum];
        double[] stnLon = new double[stnSum];
        double[] arriveT = new double[stnSum];
        double OTimeSum = 0.0;
        int OTimeCount = 0;
        int counts = this.getLocationData(stnLat, stnLon, arriveT, 3);
        int i = 0;
        while (i < counts) {
            delta = SphereUtil.distOnSphere(stnLat[i], stnLon[i], this.sourceParam.lat, this.sourceParam.lon);
            tt = this.computedTravelTime.calTravelTime(this.sourceParam.depth, delta, 3);
            if (!Double.isNaN(tt)) {
                OTimeSum += arriveT[i] - tt;
                ++OTimeCount;
            }
            ++i;
        }
        counts = this.getLocationData(stnLat, stnLon, arriveT, 1);
        i = 0;
        while (i < counts) {
            delta = SphereUtil.distOnSphere(stnLat[i], stnLon[i], this.sourceParam.lat, this.sourceParam.lon);
            tt = this.computedTravelTime.calTravelTime(this.sourceParam.depth, delta, 1);
            if (!Double.isNaN(tt)) {
                OTimeSum += arriveT[i] - tt;
                ++OTimeCount;
            }
            ++i;
        }
        counts = this.getLocationData(stnLat, stnLon, arriveT, 8);
        i = 0;
        while (i < counts) {
            delta = SphereUtil.distOnSphere(stnLat[i], stnLon[i], this.sourceParam.lat, this.sourceParam.lon);
            tt = this.computedTravelTime.calTravelTime(this.sourceParam.depth, delta, 8);
            if (!Double.isNaN(tt)) {
                OTimeSum += arriveT[i] - tt;
                ++OTimeCount;
            }
            ++i;
        }
        this.OTime = OTimeSum / (double)OTimeCount;
        return this.OTime;
    }

    public double getMaxDepth() {
        return this.maxDepth;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setMaxDepth(double maxDepth) {
        this.maxDepth = maxDepth;
    }
}

