/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class Hypomh {
    public static boolean DEBUG = false;
    public static boolean CHK_RSLT = false;
    private static double VPVS2 = 3.0;
    private static double VPVS = Math.sqrt(VPVS2);
    private static double P2 = 1.5707963267948966;
    private static double PD = 57.29577951308232;
    private static double EPS1 = 1.0E-8;
    private static double EPS2 = 1.0E-14;
    private static int LIT1 = 30;
    private static int LIT2 = 10;
    private static int FACTOR = 3;
    private BufferedReader fp_11;
    private BufferedReader fp_13;
    private BufferedReader fp_init;
    private PrintWriter fp_21;
    private PrintWriter fp_22;
    private String txtbuf;
    double alat00;
    double alng00;
    double dept00;
    double elat00;
    double elng00;
    double edpt00;
    int iyear;
    int imont;
    int iday;
    int ihour;
    int iminu;
    double secc;
    double amag00;
    double alat0;
    double alng0;
    double dept0;
    double va;
    double vb;
    double vlct;
    double eot;
    double[] ex1 = new double[3];
    STRUCT strc = new STRUCT();
    STRUCT strc1 = new STRUCT();
    double zmin;
    double zmax;
    double zmin1;
    double zmax1;
    String vst;
    String svst;
    int na;
    int npd;
    int nsd;
    int nd;
    int iyr;
    int mnt;
    int idy;
    int ihr;
    int min;
    STATION[] sta;
    CALC[] calc;
    double cot;
    double[] xm0 = new double[3];
    double[] ex0 = new double[3];
    int judg;
    double[] xm1 = new double[3];
    double[] rsl = new double[3];
    double[][] h = new double[3][3];
    int smode = 0;
    byte[] sstrname = new byte[256];
    byte[] schname = new byte[256];
    int sstanum;
    String[] ssta;
    String[] argv;

    public static void main(String[] args) throws IOException {
        String[] args1 = new String[]{"", "TestData/hypomh/struct.tbl", "TestData/hypomh/win.seis.52102", "TestData/hypomh/win.final.52102", "TestData/hypomh/win.report.52102", "TestData/hypomh/win.init.52102"};
        Hypomh hypo = new Hypomh();
        hypo.argv = args1;
        hypo.locate();
    }

    private static void usage() {
        System.out.println("Usage : hypomh <STATION, STRUCTURE> <ARRIVAL TIME DATA> <FINAL RESULTS> <REPORT> (<INITIAL GUESS>)");
    }

    public int locate() throws IOException {
        this.FOPEN();
        this.fp_21.printf(" HYPOCENTER LOCATION USING A BAYESIAN APPROACH\n", new Object[0]);
        this.fp_21.printf(" ---------------------------------------------\n", new Object[0]);
        this.VLSTR();
        this.SDATA();
        if (this.nd == 0) {
            return this.HYPEND();
        }
        this.START();
        do {
            this.NLINV();
            if (this.judg >= 10) {
                return this.HYPEND();
            }
            this.FINAL();
        } while (this.judg == 4);
        return this.HYPEND();
    }

    private int FOPEN() throws IOException {
        boolean cflag = false;
        boolean sflag = false;
        if (cflag && sflag) {
            this.smode = 1;
        }
        System.out.print("************ HYPOMH ***********\n");
        if (this.argv.length != 5 && this.argv.length != 6) {
            System.out.print("****** END OF HYPOMH ******\n");
            Hypomh.usage();
            return this.end_hypomhc(0);
        }
        try {
            this.fp_11 = new BufferedReader(new FileReader(this.argv[1]));
        }
        catch (IOException ex) {
            System.out.format("Cannot open FILE : %s\n", this.argv[1]);
        }
        try {
            this.fp_11 = new BufferedReader(new FileReader(this.argv[1]));
        }
        catch (IOException ex) {
            System.out.format("Cannot open FILE : %s\n", this.argv[1]);
            Hypomh.usage();
            return this.end_hypomhc(1);
        }
        try {
            this.fp_13 = new BufferedReader(new FileReader(this.argv[2]));
        }
        catch (IOException ex) {
            System.out.format("Cannot open FILE : %s\n", this.argv[2]);
            Hypomh.usage();
            return this.end_hypomhc(1);
        }
        try {
            this.fp_22 = new PrintWriter(new FileWriter(this.argv[3]));
        }
        catch (IOException ex) {
            System.out.format("Cannot open FILE : %s\n", this.argv[3]);
            Hypomh.usage();
            return this.end_hypomhc(1);
        }
        try {
            this.fp_21 = new PrintWriter(new FileWriter(this.argv[4]));
        }
        catch (IOException ex) {
            System.out.format("Cannot open FILE : %s\n", this.argv[4]);
            Hypomh.usage();
            return this.end_hypomhc(1);
        }
        this.iyear = -1;
        if (this.argv.length == 6) {
            try {
                this.fp_init = new BufferedReader(new FileReader(this.argv[5]));
            }
            catch (IOException ex) {
                System.out.format("Cannot open FILE : %s\n", this.argv[5]);
                Hypomh.usage();
                return this.end_hypomhc(1);
            }
            this.txtbuf = this.fp_init.readLine();
            Scanner s = new Scanner(this.txtbuf);
            this.alat00 = s.nextDouble();
            this.alng00 = s.nextDouble();
            this.dept00 = s.nextDouble();
            s.close();
            this.txtbuf = this.fp_init.readLine();
            s = new Scanner(this.txtbuf);
            this.elat00 = s.nextDouble();
            this.elng00 = s.nextDouble();
            this.edpt00 = s.nextDouble();
            s.close();
            this.txtbuf = this.fp_init.readLine();
            if (this.txtbuf != null) {
                s = new Scanner(this.txtbuf);
                this.iyear = s.nextInt();
                this.imont = s.nextInt();
                this.iday = s.nextInt();
                this.ihour = s.nextInt();
                this.iminu = s.nextInt();
                this.secc = s.nextDouble();
                this.alat00 = s.nextDouble();
                this.alng00 = s.nextDouble();
                this.dept00 = s.nextDouble();
                this.amag00 = s.nextDouble();
                s.close();
            }
            this.fp_init.close();
            if (DEBUG) {
                System.out.format("alat00=%f alng00=%f dept00=%f\n", this.alat00, this.alng00, this.dept00);
                System.out.format("elat00=%f elng00=%f edpt00=%f\n", this.elat00, this.elng00, this.edpt00);
                System.out.format("iyear=%d\n", this.iyear);
            }
        }
        return 0;
    }

    private void VLSTR() throws IOException {
        this.txtbuf = this.fp_11.readLine();
        Scanner s = new Scanner(this.txtbuf);
        this.alat0 = s.nextDouble();
        this.alng0 = s.nextDouble();
        this.dept0 = s.nextDouble();
        s.close();
        this.txtbuf = this.fp_11.readLine();
        s = new Scanner(this.txtbuf);
        int nn = s.nextInt();
        this.vst = s.next();
        if (s.hasNext()) {
            this.va = s.nextDouble();
            this.vb = s.nextDouble();
        }
        s.close();
        this.strc.n1 = nn + 1;
        this.strc.vr = new double[this.strc.n1 + 1];
        this.strc.y = new double[this.strc.n1 + 1];
        double[] th = new double[this.strc.n1];
        this.strc.vlg = new double[this.strc.n1];
        this.strc.v = new double[this.strc.n1];
        this.vlct = 0.0;
        int i = 0;
        while (i <= this.strc.n1) {
            this.txtbuf = this.fp_11.readLine();
            s = new Scanner(this.txtbuf);
            while (s.hasNext()) {
                this.strc.vr[i++] = s.nextDouble();
                if (i > this.strc.n1) break;
            }
            s.close();
        }
        this.txtbuf = this.fp_11.readLine();
        s = new Scanner(this.txtbuf);
        i = 0;
        while (i < this.strc.n1) {
            th[i] = s.nextDouble();
            ++i;
        }
        s.close();
        this.txtbuf = this.fp_11.readLine();
        s = new Scanner(this.txtbuf);
        this.eot = s.nextDouble();
        this.ex1[1] = s.nextDouble();
        this.ex1[0] = s.nextDouble();
        this.ex1[2] = s.nextDouble();
        s.close();
        if (DEBUG) {
            System.out.format("eot=%f ex1[0]=%f ex1[1]=%f ex1[2]=%f\n", this.eot, this.ex1[0], this.ex1[1], this.ex1[2]);
        }
        i = 0;
        while (i < this.strc.n1) {
            this.strc.vlg[i] = (this.strc.vr[i + 1] - this.strc.vr[i]) / th[i];
            ++i;
        }
        this.strc.y[0] = 0.0;
        i = 0;
        while (i < this.strc.n1) {
            this.strc.y[i + 1] = this.strc.y[i] + th[i];
            ++i;
        }
        this.strc.v[0] = this.strc.vr[0] / this.strc.vlg[0];
        i = 1;
        while (i < this.strc.n1) {
            this.strc.v[i] = (this.strc.vlg[i - 1] * this.strc.v[i - 1] + (this.strc.vlg[i - 1] - this.strc.vlg[i]) * this.strc.y[i]) / this.strc.vlg[i];
            ++i;
        }
        this.zmin = -this.strc.vr[0] / this.strc.vlg[0] + 0.1;
        this.zmax = this.strc.y[this.strc.n1] - 0.1;
        if (DEBUG) {
            System.out.format("%f %f\n", this.zmin, this.zmax);
        }
        this.fp_21.printf(" ***** VELOCITY STRUCTURE (%s) *****\n", this.vst);
        this.fp_21.printf("         I    Y(I)      VR(I)     ALPHA(I)    VLG(I)\n", new Object[0]);
        i = 0;
        while (i < this.strc.n1) {
            this.fp_21.printf("     %5d%10.4f%10.4f\n", i, this.strc.y[i], this.strc.vr[i]);
            this.fp_21.printf("                              %12.3E%12.3E\n", this.strc.v[i], this.strc.vlg[i]);
            ++i;
        }
        this.fp_21.printf("     %5d%10.4f%10.4f\n", this.strc.n1, this.strc.y[this.strc.n1], this.strc.vr[this.strc.n1]);
        th = null;
        if (DEBUG) {
            System.out.format("%f %f\n", this.zmin, this.zmax);
        }
    }

    private int SDATA() throws IOException {
        this.na = 0;
        while ((this.txtbuf = this.fp_13.readLine()) != null) {
            ++this.na;
        }
        this.fp_13.close();
        if (DEBUG) {
            System.out.format("na_dum = %d\n", this.na);
        }
        if (this.na == 2) {
            return this.HYPEND();
        }
        try {
            this.fp_13 = new BufferedReader(new FileReader(this.argv[2]));
        }
        catch (IOException ex) {
            System.out.format("Cannot open FILE : %s\n", this.argv[2]);
            Hypomh.usage();
            return this.end_hypomhc(1);
        }
        this.na -= 2;
        this.txtbuf = this.fp_13.readLine();
        Scanner s = new Scanner(this.txtbuf).useDelimiter(" |:|/");
        this.iyr = s.nextInt();
        this.mnt = s.nextInt();
        this.idy = s.nextInt();
        this.ihr = s.nextInt();
        this.min = s.nextInt();
        s.close();
        if (DEBUG) {
            System.out.format("na = %d\n", this.na);
            System.out.format("%02d %02d %02d %02d:%02d\n", this.iyr, this.mnt, this.idy, this.ihr, this.min);
        }
        this.sta = new STATION[this.na];
        int i = 0;
        while (i < this.na) {
            this.sta[i] = new STATION();
            this.txtbuf = this.fp_13.readLine();
            s = new Scanner(this.txtbuf);
            this.sta[i].sa1 = s.next();
            this.sta[i].pola1 = s.next();
            s.close();
            this.sta[i].pt1 = Hypomh.str2double(this.txtbuf, 12, 8);
            this.sta[i].pe1 = Hypomh.str2double(this.txtbuf, 20, 6);
            this.sta[i].st1 = Hypomh.str2double(this.txtbuf, 26, 8);
            this.sta[i].se1 = Hypomh.str2double(this.txtbuf, 34, 6);
            double xt = Hypomh.str2double(this.txtbuf, 40, 6);
            this.sta[i].amp = Hypomh.str2double(this.txtbuf, 46, 9);
            this.sta[i].alat = Hypomh.str2double(this.txtbuf, 55, 11);
            this.sta[i].alng = Hypomh.str2double(this.txtbuf, 66, 11);
            this.sta[i].ahgt = Hypomh.str2double(this.txtbuf, 77, 7);
            this.sta[i].stcp = Hypomh.str2double(this.txtbuf, 84, 7);
            this.sta[i].stcs = Hypomh.str2double(this.txtbuf, 91, 7);
            if (this.sta[i].stcp == 9999.0) {
                this.sta[i].stcp = 0.0;
            }
            if (this.sta[i].stcs == 9999.0) {
                this.sta[i].stcs = 0.0;
            }
            this.sta[i].fmp = this.sta[i].pe1 > 0.0 && xt > this.sta[i].pt1 ? xt - this.sta[i].pt1 : 0.0;
            this.sta[i].ahgt *= 0.001;
            this.sta[i].flag = 0;
            if (this.smode == 1) {
                int j = 0;
                while (j < this.sstanum) {
                    if (this.sta[i].sa1.equals(this.ssta[j])) {
                        this.sta[i].flag = 1;
                    }
                    ++j;
                }
            }
            if (DEBUG) {
                System.out.format("%s %s %f %f %d\n", this.sta[i].sa1, this.sta[i].pola1, this.sta[i].stcp, this.sta[i].stcs, this.sta[i].flag);
            }
            ++i;
        }
        this.fp_21.printf(" ***** EARTHQUAKE %02d%02d%02d%02d%02d *****\n", this.iyr, this.mnt, this.idy, this.ihr, this.min);
        this.nsd = 0;
        this.npd = 0;
        int k = 0;
        this.calc = new CALC[this.na];
        i = 0;
        while (i < this.na) {
            this.calc[i] = new CALC();
            ++i;
        }
        i = 0;
        while (i < this.na) {
            this.fp_21.printf("%-10s %s%8.3f%6.3f%8.3f%6.3f%6.1f%10.3E%11.5f%11.5f%7.3f%7.3f%7.3f %d\n", this.sta[i].sa1, this.sta[i].pola1, this.sta[i].pt1, this.sta[i].pe1, this.sta[i].st1, this.sta[i].se1, this.sta[i].fmp, this.sta[i].amp, this.sta[i].alat, this.sta[i].alng, this.sta[i].ahgt, this.sta[i].stcp, this.sta[i].stcs, this.sta[i].flag);
            if (this.sta[i].alat == 0.0 && this.sta[i].alng == 0.0) {
                this.fp_21.printf("*** %s IS NOT CATALOGUED ***\n", this.sta[i].sa1);
            } else {
                doubleW _t1 = new doubleW(this.sta[i].alat);
                doubleW _t2 = new doubleW(this.sta[i].alng);
                doubleW _t3 = new doubleW(this.sta[i].xst);
                doubleW _t4 = new doubleW(this.sta[i].yst);
                Hypomh.pltxy(this.alat0, this.alng0, _t1, _t2, _t3, _t4, 0);
                this.sta[i].alat = _t1.val;
                this.sta[i].alng = _t2.val;
                this.sta[i].xst = _t3.val;
                this.sta[i].yst = _t4.val;
                this.calc[k].org_num = i;
                this.calc[k].sa = this.sta[i].sa1;
                this.calc[k].sc[0] = this.sta[i].xst;
                this.calc[k].sc[1] = -this.sta[i].yst;
                this.calc[k].sc[2] = -this.sta[i].ahgt - this.vlct * this.sta[i].stcp;
                if (this.sta[i].pe1 <= 0.0) {
                    this.calc[k].pt = 0.0;
                } else {
                    this.calc[k].pt = this.sta[i].pt1 + this.sta[i].stcp;
                    ++this.npd;
                }
                if (this.sta[i].se1 <= 0.0) {
                    this.calc[k].st = 0.0;
                } else {
                    this.calc[k].st = this.sta[i].st1 + this.sta[i].stcs;
                    ++this.nsd;
                }
                this.calc[k].pe = this.sta[i].pe1;
                this.calc[k].se = this.sta[i].se1;
                this.calc[k].apt = this.sta[i].pt1;
                this.calc[k].pola = this.sta[i].pola1;
                this.calc[k].flag = this.sta[i].flag;
                ++k;
            }
            ++i;
        }
        this.nd = k;
        if (DEBUG) {
            System.out.format("npd=%d nsd=%d\n", this.npd, this.nsd);
        }
        return 0;
    }

    private void START() {
        double a = VPVS;
        double b = 1.0 / (a - 1.0);
        double c = a * b;
        int k = 0;
        double svr = 0.0;
        double sot = 0.0;
        double fat = 100000.0;
        int i = 0;
        while (i < this.nd) {
            if (this.calc[i].pe > 0.0) {
                fat = Math.min(fat, this.calc[i].pt);
            }
            if (this.calc[i].se > 0.0) {
                fat = Math.min(fat, this.calc[i].st);
            }
            if (!(this.calc[i].pe <= 0.0) && !(this.calc[i].se <= 0.0)) {
                double otm = b * (a * this.calc[i].pt - this.calc[i].st);
                double pe2 = Hypomh.MULT2(this.calc[i].pe) + Hypomh.MULT2((this.calc[i].pt - otm) / 100.0);
                double se2 = Hypomh.MULT2(this.calc[i].se) + Hypomh.MULT2((this.calc[i].st - otm) / 50.0);
                double var = pe2 * c * c + se2 * b * b;
                sot += otm / var;
                svr += 1.0 / var;
                ++k;
            }
            ++i;
        }
        this.cot = k == 0 ? fat - 1.0 : sot / svr;
        if (this.argv.length == 6) {
            doubleW _t1 = new doubleW(this.alat00);
            doubleW _t2 = new doubleW(this.alng00);
            doubleW _t3 = new doubleW(this.xm0[0]);
            doubleW _t4 = new doubleW(this.xm0[1]);
            Hypomh.pltxy(this.alat0, this.alng0, _t1, _t2, _t3, _t4, 0);
            this.alat00 = _t1.val;
            this.alng00 = _t2.val;
            this.xm0[0] = _t3.val;
            this.xm0[1] = _t4.val;
            this.xm0[1] = -this.xm0[1];
            this.xm0[2] = this.dept00;
            this.ex0[0] = this.elng00;
            this.ex0[1] = this.elat00;
            this.ex0[2] = this.edpt00;
        } else {
            this.xm0[1] = 0.0;
            this.xm0[0] = 0.0;
            this.xm0[2] = this.dept0;
            i = 0;
            while (i < 3) {
                this.ex0[i] = this.ex1[i];
                ++i;
            }
        }
        this.fp_21.printf(" *** ADOPTED INITIAL VALUES *** X(KM)   Y(KM)  Z(KM)\n", new Object[0]);
        this.fp_21.printf("   0  %3d%3d%3d%3d%3d%8.3f%8.3f%8.3f%8.3f\n", this.iyr, this.mnt, this.idy, this.ihr, this.min, this.cot, this.xm0[0], this.xm0[1], this.xm0[2]);
        this.fp_21.printf("                             %8.3f%8.3f%8.3f\n", this.ex0[0], this.ex0[1], this.ex0[2]);
        i = 0;
        while (i < this.nd) {
            if (this.calc[i].pe > 0.0) {
                double ptrv = (this.calc[i].pt - this.cot) / 100.0;
                this.calc[i].pe = Math.hypot(this.calc[i].pe, ptrv);
            }
            if (this.calc[i].se > 0.0) {
                double strv = (this.calc[i].st - this.cot) / 50.0;
                this.calc[i].se = Math.hypot(this.calc[i].se, strv);
            }
            ++i;
        }
    }

    private void NLINV() {
        int j;
        int jj = 0;
        int ln = 0;
        int ln1 = 0;
        int np = 0;
        int np1 = 0;
        double[] xw = new double[3];
        double[] rvx = new double[3];
        double[][] dp = new double[3][3];
        double[][] ds = new double[3][3];
        double[][] bb = new double[3][3];
        double[][] cc = new double[3][3];
        double[] xmc = new double[3];
        xmc[2] = 0.0;
        xmc[1] = 0.0;
        xmc[0] = 0.0;
        double acp = 0.0;
        double sra = 0.0;
        double[] vxm = new double[3];
        double[] ang1 = null;
        double[] trv1 = null;
        double[] bng1 = null;
        int ll = 0;
        int lm = 20;
        int jm = 10;
        this.judg = 0;
        double ccp = 0.001;
        double al2 = VPVS2;
        double alp = VPVS;
        this.fp_21.printf(" ***** INVERSION OF ARRIVAL TIME DATA *****\n", new Object[0]);
        this.fp_21.printf("  LL    SR                      CP                   JJ    X       Y       Z\n", new Object[0]);
        int i = 0;
        while (i < 3) {
            this.xm1[i] = this.xm0[i];
            vxm[i] = 1.0 / Hypomh.MULT2(this.ex0[i]);
            ++i;
        }
        double as = 0.0;
        i = 0;
        while (i < this.nd) {
            this.calc[i].vpt = this.calc[i].pe <= 0.0 ? 0.0 : 1.0 / Hypomh.MULT2(this.calc[i].pe);
            this.calc[i].vst = this.calc[i].se <= 0.0 ? 0.0 : 1.0 / Hypomh.MULT2(this.calc[i].se);
            this.calc[i].vps = this.calc[i].vpt + alp * this.calc[i].vst;
            as += this.calc[i].vpt + this.calc[i].vst;
            ++i;
        }
        i = 0;
        while (i < this.nd) {
            this.calc[i].fp = new double[this.nd];
            this.calc[i].fs = new double[this.nd];
            ++i;
        }
        i = 0;
        while (i < this.nd) {
            j = 0;
            while (j < this.nd) {
                this.calc[i].fp[j] = -this.calc[i].vps / as;
                this.calc[i].fs[j] = this.calc[i].fp[j] / alp;
                if (i == j) {
                    int n = j;
                    this.calc[i].fp[n] = this.calc[i].fp[n] + 1.0;
                    int n2 = j;
                    this.calc[i].fs[n2] = this.calc[i].fs[n2] + 1.0;
                }
                int n = j;
                this.calc[i].fp[n] = this.calc[i].fp[n] * this.calc[j].vpt;
                int n3 = j;
                this.calc[i].fs[n3] = this.calc[i].fs[n3] * this.calc[j].vst;
                ++j;
            }
            ++i;
        }
        double[] ang = new double[this.strc.n1 + 1];
        double[] trv = new double[this.strc.n1 + 1];
        double[] bng = new double[this.strc.n1 + 1];
        if (this.smode == 1) {
            ang1 = new double[this.strc.n1 + 1];
            trv1 = new double[this.strc.n1 + 1];
            bng1 = new double[this.strc.n1 + 1];
        }
        boolean gotoLine200 = false;
        while (true) {
            int l;
            if (!gotoLine200) {
                jj = 0;
            }
            intW _t_ln = new intW(ln);
            Hypomh.where(this.strc, this.xm1[2], _t_ln);
            ln = _t_ln.val;
            if (this.smode == 1) {
                intW _t_ln1 = new intW(ln1);
                Hypomh.where(this.strc1, this.xm1[2], _t_ln1);
                ln1 = _t_ln1.val;
            }
            if (DEBUG) {
                this.fp_21.printf("depth=%f where=%d where1=%d\n", this.xm1[2], ln, ln1);
            }
            i = 0;
            while (i < this.nd) {
                double xx = this.xm1[0] - this.calc[i].sc[0];
                double yy = this.xm1[1] - this.calc[i].sc[1];
                double rr = Math.hypot(xx, yy);
                if (DEBUG) {
                    System.out.format("rr=%f\n", rr);
                    System.out.format("xm1[0]=%f  xm1[1]=%f  xm1[2]= %f\n", this.xm1[0], this.xm1[1], this.xm1[2]);
                }
                if (this.smode == 1 && this.calc[i].flag == 1) {
                    intW _t_np1 = new intW(np1);
                    Hypomh.travel(rr, this.xm1[2], this.calc[i].sc[2], _t_np1, ang1, trv1, bng1, this.strc1);
                    np1 = _t_np1.val;
                    if (np1 == 0) {
                        this.fp_21.printf(" *** RAY PATH TO %d-STATION IS NOT FOUND ***\n", i);
                        this.judg = 10;
                        return;
                    }
                } else {
                    intW _t_np = new intW(np);
                    Hypomh.travel(rr, this.xm1[2], this.calc[i].sc[2], _t_np, ang, trv, bng, this.strc);
                    np = _t_np.val;
                    if (np == 0) {
                        this.fp_21.printf(" *** RAY PATH TO %d-STATION IS NOT FOUND ***\n", i);
                        this.judg = 10;
                        return;
                    }
                }
                if (DEBUG) {
                    if (this.smode == 1 && this.calc[i].flag == 1) {
                        System.out.format("np1=%d\n", np1);
                        j = 0;
                        while (j < np1) {
                            System.out.format("%d ang1=%f trv1=%f bng1=%f\n", j, ang1[j], trv1[j], bng1[j]);
                            ++j;
                        }
                    } else {
                        System.out.format("np=%d\n", np);
                        j = 0;
                        while (j < np) {
                            System.out.format("%d ang=%f trv=%f bng=%f\n", j, ang[j], trv[j], bng[j]);
                            ++j;
                        }
                    }
                }
                this.calc[i].tpt = 100000.0;
                if (this.smode == 1 && this.calc[i].flag == 1) {
                    j = 0;
                    while (j < np1) {
                        if (!(trv1[j] > this.calc[i].tpt)) {
                            this.calc[i].tpt = trv1[j];
                            this.calc[i].tag = ang1[j];
                            this.calc[i].tbg = bng1[j];
                        }
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < np) {
                        if (!(trv[j] > this.calc[i].tpt)) {
                            this.calc[i].tpt = trv[j];
                            this.calc[i].tag = ang[j];
                            this.calc[i].tbg = bng[j];
                        }
                        ++j;
                    }
                }
                double sn = Math.sin(this.calc[i].tag);
                double cn = Math.cos(this.calc[i].tag);
                double vre = this.smode == 1 && this.calc[i].flag == 1 ? this.strc1.vlg[ln1] * (this.xm1[2] + this.strc1.v[ln1]) : this.strc.vlg[ln] * (this.xm1[2] + this.strc.v[ln]);
                this.calc[i].a[0] = sn * xx / rr / vre;
                this.calc[i].a[1] = sn * yy / rr / vre;
                this.calc[i].a[2] = -cn / vre;
                ++i;
            }
            if (this.iyear >= 0) {
                i = 0;
                while (i < this.nd) {
                    this.calc[i].pe = this.calc[i].pt;
                    this.calc[i].se = this.calc[i].st;
                    this.calc[i].pt = this.secc + this.calc[i].tpt - this.calc[i].pt;
                    this.calc[i].st = this.secc + alp * this.calc[i].tpt - this.calc[i].st;
                    this.calc[i].rpt = 0.0;
                    this.calc[i].rst = 0.0;
                    ++i;
                }
                this.iyr = this.iyear;
                this.mnt = this.imont;
                this.idy = this.iday;
                this.ihr = this.ihour;
                this.min = this.iminu;
                this.cot = this.secc;
                this.judg = 0;
                return;
            }
            double src = 0.0;
            double srb = 0.0;
            i = 0;
            while (i < this.nd) {
                this.calc[i].rpt = this.calc[i].pe <= 0.0 ? 0.0 : this.calc[i].pt - this.calc[i].tpt;
                this.calc[i].rst = this.calc[i].se <= 0.0 ? 0.0 : this.calc[i].st - alp * this.calc[i].tpt;
                double wpt = this.calc[i].vpt * this.calc[i].rpt;
                double wst = this.calc[i].vst * this.calc[i].rst;
                srb += wpt * this.calc[i].rpt + wst * this.calc[i].rst;
                src += wpt + wst;
                ++i;
            }
            srb -= Hypomh.MULT2(src) / as;
            double bcp = 0.0;
            i = 0;
            while (i < 3) {
                xw[i] = 0.0;
                j = 0;
                while (j < this.nd) {
                    this.calc[j].tw = 0.0;
                    int k = 0;
                    while (k < this.nd) {
                        this.calc[j].tw += this.calc[j].fp[k] * this.calc[k].rpt + alp * this.calc[j].fs[k] * this.calc[k].rst;
                        ++k;
                    }
                    int n = i;
                    xw[n] = xw[n] + this.calc[j].a[i] * this.calc[j].tw;
                    ++j;
                }
                double rmx = this.xm0[i] - this.xm1[i];
                rvx[i] = xw[i] + vxm[i] * rmx;
                srb += vxm[i] * Hypomh.MULT2(rmx);
                bcp += Hypomh.MULT2(rvx[i]);
                ++i;
            }
            bcp = Math.sqrt(bcp / 3.0);
            if (ll != 0) {
                if (srb >= sra) {
                    if (++jj <= jm) {
                        double aa = Math.pow(0.5, jj);
                        i = 0;
                        while (i < 3) {
                            int n = i;
                            this.xm1[n] = this.xm1[n] - aa * xmc[i];
                            ++i;
                        }
                        gotoLine200 = true;
                        break;
                    }
                    this.judg = 3;
                    lm = ll;
                } else {
                    double zm1 = Math.abs(this.zmin - this.xm1[2]);
                    double zm2 = Math.abs(this.zmax - this.xm1[2]);
                    if (zm1 > ccp && zm2 > ccp) {
                        if (bcp <= ccp) {
                            lm = ll;
                        }
                    } else if (zm1 <= ccp) {
                        this.judg = 1;
                        lm = ll;
                    } else if (zm2 <= ccp) {
                        this.judg = 2;
                        lm = ll;
                    }
                }
                this.fp_21.printf("%3d%12.5E%12.5E%12.5E%12.5E%3d%8.3f%8.3f%8.3f\n", ll, srb, sra, bcp, acp, jj, this.xm1[0], this.xm1[1], this.xm1[2]);
                if (DEBUG) {
                    System.out.printf("%3d%12.5E%12.5E%12.5E%12.5E%3d%8.3f%8.3f%8.3f\n", ll, srb, sra, bcp, acp, jj, this.xm1[0], this.xm1[1], this.xm1[2]);
                }
            }
            i = 0;
            while (i < this.nd) {
                j = 0;
                while (j < 3) {
                    this.calc[i].cs[j] = 0.0;
                    this.calc[i].cp[j] = 0.0;
                    l = 0;
                    while (l < this.nd) {
                        int n = j;
                        this.calc[i].cp[n] = this.calc[i].cp[n] + this.calc[i].fp[l] * this.calc[l].a[j];
                        int n4 = j;
                        this.calc[i].cs[n4] = this.calc[i].cs[n4] + this.calc[i].fs[l] * this.calc[l].a[j];
                        ++l;
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < 3) {
                j = 0;
                while (j < 3) {
                    ds[i][j] = 0.0;
                    dp[i][j] = 0.0;
                    l = 0;
                    while (l < this.nd) {
                        double[] dArray = dp[i];
                        int n = j;
                        dArray[n] = dArray[n] + this.calc[l].a[i] * this.calc[l].cp[j];
                        double[] dArray2 = ds[i];
                        int n5 = j;
                        dArray2[n5] = dArray2[n5] + this.calc[l].a[i] * this.calc[l].cs[j];
                        ++l;
                    }
                    bb[i][j] = dp[i][j] + al2 * ds[i][j];
                    if (i == j) {
                        double[] dArray = bb[i];
                        int n = j;
                        dArray[n] = dArray[n] + vxm[i];
                    }
                    ++j;
                }
                ++i;
            }
            cc[0][0] = bb[1][1] * bb[2][2] - bb[1][2] * bb[1][2];
            cc[0][1] = bb[0][2] * bb[1][2] - bb[0][1] * bb[2][2];
            cc[0][2] = bb[0][1] * bb[1][2] - bb[0][2] * bb[1][1];
            cc[1][1] = bb[0][0] * bb[2][2] - bb[0][2] * bb[0][2];
            cc[1][2] = bb[0][1] * bb[0][2] - bb[0][0] * bb[1][2];
            cc[2][2] = bb[0][0] * bb[1][1] - bb[0][1] * bb[0][1];
            double dtb = bb[0][0] * cc[0][0] + bb[0][1] * cc[0][1] + bb[0][2] * cc[0][2];
            if (dtb <= 0.0) {
                this.fp_21.printf(" *** THE MATRIX IS NOT POSITIVE-DEFINITE ***\n", new Object[0]);
                this.judg = 11;
                return;
            }
            i = 0;
            while (i < 3) {
                j = i;
                while (j < 3) {
                    this.h[i][j] = cc[i][j] / dtb;
                    if (i != j) {
                        this.h[j][i] = this.h[i][j];
                    }
                    ++j;
                }
                ++i;
            }
            if (ll == lm) {
                double srt = 0.0;
                i = 0;
                while (i < this.nd) {
                    srt += this.calc[i].rpt * this.calc[i].vpt + this.calc[i].rst * this.calc[i].vst;
                    ++i;
                }
                this.cot = srt / as;
                this.eot = 1.0 / as;
                i = 0;
                while (i < 3) {
                    this.ex1[i] = Math.sqrt(this.h[i][i]);
                    ++i;
                }
                double r3 = 0.0;
                double r2 = 0.0;
                double r1 = 0.0;
                i = 0;
                while (i < 3) {
                    j = 0;
                    while (j < 3) {
                        r1 += this.h[i][j] * dp[j][i];
                        r2 += this.h[i][j] * ds[j][i];
                        ++j;
                    }
                    r3 += this.h[i][i] * vxm[i];
                    ++i;
                }
                this.rsl[0] = 100.0 * r1 / 3.0;
                this.rsl[1] = 100.0 * r2 * al2 / 3.0;
                this.rsl[2] = 100.0 * r3 / 3.0;
                i = 0;
                while (i < this.nd) {
                    if (this.calc[i].pe > 0.0) {
                        this.calc[i].rpt -= this.cot;
                    }
                    if (this.calc[i].se > 0.0) {
                        this.calc[i].rst -= this.cot;
                    }
                    ++i;
                }
                break;
            }
            i = 0;
            while (i < 3) {
                xmc[i] = 0.0;
                j = 0;
                while (j < 3) {
                    int n = i;
                    xmc[n] = xmc[n] + this.h[i][j] * rvx[j];
                    ++j;
                }
                if (i == 2) {
                    double xmz = this.xm1[i] + xmc[i];
                    if (xmz < this.zmin) {
                        xmc[i] = this.zmin - this.xm1[i];
                    }
                    if (xmz > this.zmax) {
                        xmc[i] = this.zmax - this.xm1[i];
                    }
                }
                int n = i;
                this.xm1[n] = this.xm1[n] + xmc[i];
                ++i;
            }
            sra = srb;
            acp = bcp;
            ++ll;
        }
    }

    private void FINAL() {
        String[] diag = new String[]{"CONV", "AIRF", "DEEP", "NOCN"};
        int npr = 3;
        double alati = 0.0;
        double alngi = 0.0;
        double alatf = 0.0;
        double alngf = 0.0;
        this.xm0[1] = -this.xm0[1];
        this.xm1[1] = -this.xm1[1];
        doubleW _t_alati = new doubleW(alati);
        doubleW _t_alngi = new doubleW(alngi);
        doubleW _t_xm00 = new doubleW(this.xm0[0]);
        doubleW _t_xm01 = new doubleW(this.xm0[1]);
        Hypomh.pltxy(this.alat0, this.alng0, _t_alati, _t_alngi, _t_xm00, _t_xm01, 1);
        alati = _t_alati.val;
        alngi = _t_alngi.val;
        this.xm0[0] = _t_xm00.val;
        this.xm0[1] = _t_xm01.val;
        doubleW _t_alatf = new doubleW(alatf);
        doubleW _t_alngf = new doubleW(alngf);
        doubleW _t_xm10 = new doubleW(this.xm1[0]);
        doubleW _t_xm11 = new doubleW(this.xm1[1]);
        Hypomh.pltxy(this.alat0, this.alng0, _t_alatf, _t_alngf, _t_xm10, _t_xm11, 1);
        alatf = _t_alatf.val;
        alngf = _t_alngf.val;
        this.xm1[0] = _t_xm10.val;
        this.xm1[1] = _t_xm11.val;
        this.xm0[1] = -this.xm0[1];
        this.xm1[1] = -this.xm1[1];
        int nmag = 0;
        int nsrs = 0;
        int nsrp = 0;
        double amag = 0.0;
        double srs = 0.0;
        double srp = 0.0;
        int i = 0;
        while (i < this.nd) {
            double xx = this.calc[i].sc[0] - this.xm1[0];
            double yy = this.calc[i].sc[1] - this.xm1[1];
            this.calc[i].dl = Math.hypot(xx, yy);
            this.calc[i].az = PD * Math.atan2(xx, -yy);
            if (this.calc[i].az < 0.0) {
                this.calc[i].az += 360.0;
            }
            this.calc[i].ta = PD * this.calc[i].tag;
            this.calc[i].tb = PD * this.calc[i].tbg;
            if (this.calc[i].pe > 0.0) {
                ++nsrp;
                srp += Hypomh.MULT2(this.calc[i].rpt);
            }
            if (this.calc[i].se > 0.0) {
                ++nsrs;
                srs += Hypomh.MULT2(this.calc[i].rst);
            }
            this.calc[i].bmag = 9.9;
            if (this.sta[this.calc[i].org_num].fmp != 0.0 || this.sta[this.calc[i].org_num].amp != 0.0) {
                double hdist = Math.hypot(this.calc[i].dl, this.xm1[2]);
                this.calc[i].bmag = this.sta[this.calc[i].org_num].amp > 0.0 ? (hdist < 200.0 ? (Math.log10(this.sta[this.calc[i].org_num].amp * 100.0) + 1.73 * Math.log10(hdist) + 2.5) / 0.85 : (Math.log10(this.sta[this.calc[i].org_num].amp * 100.0) + 1.73 * Math.log10(hdist) + 2.5 + 0.0015 * (hdist - 200.0)) / 0.85) : (hdist < 200.0 ? -2.36 + 2.85 * Math.log10(this.sta[this.calc[i].org_num].fmp) : -2.53 + 2.58 * Math.log10(this.sta[this.calc[i].org_num].fmp) + 0.0014 * hdist);
                ++nmag;
                amag += this.calc[i].bmag;
            }
            ++i;
        }
        amag = nmag > 0 ? (amag /= (double)nmag) : 9.9;
        if (this.iyear >= 0) {
            alatf = this.alat00;
            alngf = this.alng00;
            amag = this.amag00;
        }
        this.fp_21.printf("***** FINAL RESULTS *****\n", new Object[0]);
        this.fp_21.printf("%3d%3d%3d   %3d%3d%8.3f%11.5f%11.5f%8.3f%6.1f\n", this.iyr, this.mnt, this.idy, this.ihr, this.min, this.cot, alatf, alngf, this.xm1[2], amag);
        this.fp_22.printf("%3d%3d%3d   %3d%3d%8.3f%11.5f%11.5f%8.3f%6.1f\n", this.iyr, this.mnt, this.idy, this.ihr, this.min, this.cot, alatf, alngf, this.xm1[2], amag);
        System.out.printf("%3d%3d%3d   %3d%3d%8.3f%11.5f%11.5f%8.3f%6.1f\n", this.iyr, this.mnt, this.idy, this.ihr, this.min, this.cot, alatf, alngf, this.xm1[2], amag);
        this.fp_21.printf("   %s           %8.3f%9.3f  %9.3f  %8.3f\n", diag[this.judg], this.eot, this.ex1[1], this.ex1[0], this.ex1[2]);
        this.fp_22.printf("   %s           %8.3f%9.3f  %9.3f  %8.3f\n", diag[this.judg], this.eot, this.ex1[1], this.ex1[0], this.ex1[2]);
        System.out.printf("   %s           %8.3f%9.3f  %9.3f  %8.3f\n", diag[this.judg], this.eot, this.ex1[1], this.ex1[0], this.ex1[2]);
        this.fp_21.printf("%10.3f%10.3f%10.3f%10.3f%10.3f%10.3f\n", this.h[0][0], -this.h[0][1], this.h[0][2], this.h[1][1], -this.h[1][2], this.h[2][2]);
        this.fp_22.printf("%10.3f%10.3f%10.3f%10.3f%10.3f%10.3f\n", this.h[0][0], -this.h[0][1], this.h[0][2], this.h[1][1], -this.h[1][2], this.h[2][2]);
        System.out.printf("%10.3f%10.3f%10.3f%10.3f%10.3f%10.3f\n", this.h[0][0], -this.h[0][1], this.h[0][2], this.h[1][1], -this.h[1][2], this.h[2][2]);
        this.fp_21.printf("            %7.3f %5.1f %7.3f %5.1f %7.3f %5.1f\n", alati, this.ex0[1], alngi, this.ex0[0], this.xm0[2], this.ex0[2]);
        this.fp_22.printf("            %7.3f %5.1f %7.3f %5.1f %7.3f %5.1f\n", alati, this.ex0[1], alngi, this.ex0[0], this.xm0[2], this.ex0[2]);
        System.out.printf("            %7.3f %5.1f %7.3f %5.1f %7.3f %5.1f\n", alati, this.ex0[1], alngi, this.ex0[0], this.xm0[2], this.ex0[2]);
        this.fp_21.printf("  %3d %4s %3d (%5.1f%% ) %3d (%5.1f%% ) %3d (%5.1f%% )\n", this.nd, this.vst, this.npd, this.rsl[0], this.nsd, this.rsl[1], npr, this.rsl[2]);
        this.fp_22.printf("  %3d %4s %3d (%5.1f%% ) %3d (%5.1f%% ) %3d (%5.1f%% )\n", this.nd, this.vst, this.npd, this.rsl[0], this.nsd, this.rsl[1], npr, this.rsl[2]);
        System.out.printf("  %3d %4s %3d (%5.1f%% ) %3d (%5.1f%% ) %3d (%5.1f%% )\n", this.nd, this.vst, this.npd, this.rsl[0], this.nsd, this.rsl[1], npr, this.rsl[2]);
        i = 0;
        while (i < this.nd) {
            double fmag = this.sta[this.calc[i].org_num].amp > 0.0 ? this.sta[this.calc[i].org_num].amp : (this.sta[this.calc[i].org_num].fmp > 0.0 ? this.sta[this.calc[i].org_num].fmp : 0.0);
            this.fp_21.printf("%-10s %-2s%8.3f%6.1f%6.1f%6.1f%7.3f%6.3f%7.3f%7.3f%6.3f%7.3f%10.3E%5.1f\n", this.calc[i].sa, this.calc[i].pola, this.calc[i].dl, this.calc[i].az, this.calc[i].ta, this.calc[i].tb, this.calc[i].pt, this.calc[i].pe, this.calc[i].rpt, this.calc[i].st, this.calc[i].se, this.calc[i].rst, fmag, this.calc[i].bmag);
            this.fp_22.printf("%-10s %-2s%8.3f%6.1f%6.1f%6.1f%7.3f%6.3f%7.3f%7.3f%6.3f%7.3f%10.3E%5.1f\n", this.calc[i].sa, this.calc[i].pola, this.calc[i].dl, this.calc[i].az, this.calc[i].ta, this.calc[i].tb, this.calc[i].pt, this.calc[i].pe, this.calc[i].rpt, this.calc[i].st, this.calc[i].se, this.calc[i].rst, fmag, this.calc[i].bmag);
            System.out.printf("%-10s %-2s%8.3f%6.1f%6.1f%6.1f%7.3f%6.3f%7.3f%7.3f%6.3f%7.3f%10.3E%5.1f\n", this.calc[i].sa, this.calc[i].pola, this.calc[i].dl, this.calc[i].az, this.calc[i].ta, this.calc[i].tb, this.calc[i].pt, this.calc[i].pe, this.calc[i].rpt, this.calc[i].st, this.calc[i].se, this.calc[i].rst, fmag, this.calc[i].bmag);
            ++i;
        }
        if (nsrp > 0) {
            srp = Math.sqrt(srp / (double)nsrp);
        }
        if (nsrs > 0) {
            srs = Math.sqrt(srs / (double)nsrs);
        }
        this.fp_21.printf("                                                    %7.3f             %7.3f\n", srp, srs);
        this.fp_22.printf("                                                    %7.3f             %7.3f\n", srp, srs);
        System.out.printf("                                                    %7.3f             %7.3f\n", srp, srs);
        if (CHK_RSLT) {
            int icheck = 0;
            i = 0;
            while (i < this.nd) {
                if (Math.abs(this.calc[i].rpt) > (double)FACTOR * srp) {
                    this.calc[i].pe = -2.0;
                    ++icheck;
                    --this.npd;
                }
                if (Math.abs(this.calc[i].rst) > (double)FACTOR * srs) {
                    this.calc[i].se = -2.0;
                    ++icheck;
                    --this.nsd;
                }
                ++i;
            }
            if (icheck > 0) {
                this.judg = 4;
            }
        }
    }

    private int HYPEND() {
        System.out.format("****** END OF HYPOMH ******\n", new Object[0]);
        try {
            this.fp_11.close();
            this.fp_13.close();
            this.fp_21.close();
            this.fp_22.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.end_hypomhc(0);
    }

    private int end_hypomhc(int status) {
        return status;
    }

    private static void rpcod(double y1, int l1, double y2, int l2, double[] xc, double[] tac, STRUCT strc) {
        doubleW xa = new doubleW(0.0);
        doubleW xb = new doubleW(0.0);
        doubleW a = new doubleW(0.0);
        doubleW b = new doubleW(0.0);
        xc[l1] = 0.0;
        tac[l1] = Math.PI;
        int i = l1;
        while (i < strc.n1) {
            int j = i + 1;
            double pp = 1.0 / strc.vr[j];
            Hypomh.rxinc(0, pp, y1, l1, y2, l2, xa, a, strc);
            Hypomh.rxinc(1, pp, strc.y[j], i, y1, l1, xb, b, strc);
            xc[j] = xa.val + 2.0 * xb.val;
            double sc = pp * strc.vlg[l1] * (y1 + strc.v[l1]);
            if (sc > 1.0) {
                sc = 1.0;
            }
            tac[j] = Math.asin(sc);
            ++i;
        }
    }

    private static void rxcod(double y1, int l1, double y2, int l2, double ta, doubleW x, doubleW a, STRUCT strc) {
        doubleW xd = new doubleW(0.0);
        doubleW b = new doubleW(0.0);
        double pp = Math.sin(ta) / (strc.vlg[l1] * (y1 + strc.v[l1]));
        Hypomh.rxinc(0, pp, y1, l1, y2, l2, x, a, strc);
        if (ta >= P2) {
            a.val = -a.val;
            return;
        }
        double pn = 1.0 / pp;
        int nl = 0;
        while (nl < strc.n1) {
            if (strc.vr[nl + 1] >= pn) break;
            ++nl;
        }
        double yn = pn / strc.vlg[nl] - strc.v[nl];
        Hypomh.rxinc(1, pp, yn, nl, y1, l1, xd, b, strc);
        x.val += 2.0 * xd.val;
        a.val += 2.0 * b.val;
    }

    private static void trvel(double y1, int l1, double y2, int l2, double ta, doubleW tt, STRUCT strc) {
        doubleW td = new doubleW(0.0);
        double pp = Math.sin(ta) / (strc.vlg[l1] * (y1 + strc.v[l1]));
        Hypomh.rtinc(pp, y1, l1, y2, l2, tt, strc);
        if (ta >= P2) {
            return;
        }
        double pn = 1.0 / pp;
        int nl = 0;
        while (nl < strc.n1) {
            if (strc.vr[nl + 1] >= pn) break;
            ++nl;
        }
        double yn = pn / strc.vlg[nl] - strc.v[nl];
        Hypomh.rtinc(pp, yn, nl, y1, l1, td, strc);
        tt.val += 2.0 * td.val;
    }

    public static void travel(double rr, double ya, double yb, intW np, double[] ang, double[] trv, double[] bng, STRUCT strc) {
        double y2;
        double y1;
        double[] xc = new double[strc.n1 + 1];
        double[] tac = new double[strc.n1 + 1];
        intW l1 = new intW(0);
        intW l2 = new intW(0);
        doubleW x0 = new doubleW(0.0);
        doubleW a0 = new doubleW(0.0);
        double ta0 = 0.0;
        double tag = 0.0;
        if (ya >= yb) {
            y1 = ya;
            y2 = yb;
        } else {
            y1 = yb;
            y2 = ya;
        }
        Hypomh.where(strc, y1, l1);
        Hypomh.where(strc, y2, l2);
        Hypomh.rpcod(y1, l1.val, y2, l2.val, xc, tac, strc);
        np.val = 0;
        int i = l1.val;
        while (i < strc.n1) {
            double t1 = rr - xc[i];
            int j = i + 1;
            double t2 = xc[j] - rr;
            if (!(t1 * t2 < 0.0)) {
                double sang;
                ++np.val;
                double x1 = xc[i];
                double x2 = xc[j];
                double ta1 = tac[i];
                double ta2 = tac[j];
                int k = 0;
                while (k < LIT1) {
                    double xr = x1 - x2;
                    if (Math.abs(xr / rr) < EPS1) break;
                    ta0 = (ta1 + ta2) / 2.0;
                    Hypomh.rxcod(y1, l1.val, y2, l2.val, ta0, x0, a0, strc);
                    double t0 = rr - x0.val;
                    if (t0 * t1 <= 0.0) {
                        x2 = x0.val;
                        ta2 = ta0;
                    } else {
                        x1 = x0.val;
                        ta1 = ta0;
                    }
                    ++k;
                }
                double dt0 = Math.abs((rr - x0.val) / rr);
                k = 0;
                while (k < LIT2) {
                    double dta = (rr - x0.val) / a0.val;
                    tag = ta0 + dta;
                    if (Math.abs(dta) < EPS2) break;
                    Hypomh.rxcod(y1, l1.val, y2, l2.val, tag, x0, a0, strc);
                    double dtc = Math.abs((rr - x0.val) / rr);
                    if (dt0 <= dtc) {
                        tag = ta0;
                        break;
                    }
                    if (dtc < EPS2) break;
                    ++k;
                }
                doubleW _tt = new doubleW(trv[np.val - 1]);
                Hypomh.trvel(y1, l1.val, y2, l2.val, tag, _tt, strc);
                trv[np.val - 1] = _tt.val;
                if (ya >= yb) {
                    ang[np.val - 1] = tag;
                    sang = Math.sin(tag) * strc.vlg[l2.val] * (y2 + strc.v[l2.val]) / strc.vlg[l1.val] / (y1 + strc.v[l1.val]);
                    bng[np.val - 1] = Math.asin(sang);
                } else {
                    sang = Math.sin(tag) * strc.vlg[l2.val] * (y2 + strc.v[l2.val]) / strc.vlg[l1.val] / (y1 + strc.v[l1.val]);
                    ang[np.val - 1] = Math.asin(sang);
                    bng[np.val - 1] = tag;
                }
            }
            ++i;
        }
    }

    private static void rtinc(double pp, double y1, int l1, double y2, int l2, doubleW tt, STRUCT strc) {
        int k1;
        double[] sn = new double[strc.n1 + 1];
        double[] cn = new double[strc.n1 + 1];
        tt.val = 0.0;
        if (y1 == y2) {
            return;
        }
        int i = k1 = l2 - 1;
        while (i <= l1) {
            int j = i + 1;
            sn[j] = i == l1 ? pp * strc.vlg[l1] * (y1 + strc.v[l1]) : (i == k1 ? pp * strc.vlg[l2] * (y2 + strc.v[l2]) : pp * strc.vr[j]);
            if (Math.abs(sn[j]) > 1.0) {
                sn[j] = 1.0;
            }
            cn[j] = Math.sqrt(1.0 - Hypomh.MULT2(sn[j]));
            ++i;
        }
        i = l2;
        while (i <= l1) {
            double cnr = (1.0 - cn[i + 1]) * (1.0 + cn[i]) / ((1.0 + cn[i + 1]) * (1.0 - cn[i]));
            tt.val += Math.log(cnr) / 2.0 / strc.vlg[i];
            if (DEBUG) {
                System.out.format("i=%d tt=%.14f cnr=%.14f cn[i+1]=%.14f\n", i, tt.val, cnr, cn[i + 1]);
            }
            ++i;
        }
    }

    private static void rxinc(int id, double pp, double y1, int l1, double y2, int l2, doubleW x, doubleW a, STRUCT strc) {
        int j;
        int lm = 0;
        double[] sn = new double[strc.n1 + 1];
        double[] cn = new double[strc.n1 + 1];
        double[] rn = new double[strc.n1 + 1];
        x.val = 0.0;
        a.val = 0.0;
        if (y1 == y2) {
            return;
        }
        int k1 = l2 - 1;
        if (id == 0) {
            lm = l1 + 1;
        } else if (id == 1) {
            lm = l2 + 1;
        }
        int i = k1;
        while (i <= l1) {
            j = i + 1;
            sn[j] = i == l1 ? pp * strc.vlg[l1] * (y1 + strc.v[l1]) : (i == k1 ? pp * strc.vlg[l2] * (y2 + strc.v[l2]) : pp * strc.vr[j]);
            if (sn[j] > 1.0) {
                sn[j] = 1.0;
            }
            cn[j] = Math.sqrt(1.0 - Hypomh.MULT2(sn[j]));
            ++i;
        }
        i = k1;
        while (i <= l1) {
            j = i + 1;
            rn[j] = i == l1 ? (id == 1 ? 0.0 : 1.0) : (i == k1 ? (id == 1 ? 1.0 : cn[lm] / cn[j]) : cn[lm] / cn[j]);
            ++i;
        }
        i = l2;
        while (i <= l1) {
            j = i + 1;
            x.val += (cn[i] - cn[j]) / strc.vlg[i];
            a.val += (rn[i] - rn[j]) / strc.vlg[i];
            ++i;
        }
        x.val /= pp;
        a.val /= -(pp * sn[lm]);
    }

    private static void where(STRUCT strc, double yy, intW ln) {
        int i = 0;
        while (i < strc.n1) {
            if (strc.y[i + 1] >= yy) break;
            ++i;
        }
        ln.val = i;
    }

    private static void pltxy(double alt0, double alng0, doubleW alat, doubleW along, doubleW x, doubleW y, int ind) {
        double a = 6378.16;
        double e2 = 0.0066944541;
        double e12 = 0.0067395719;
        double d = 57.2958;
        double rd = 1.0 / d;
        if (ind == 0) {
            double rlat = rd * alat.val;
            double slat = Math.sin(rlat);
            double clat = Math.cos(rlat);
            double v2 = 1.0 + e12 * clat * clat;
            double al = along.val - alng0;
            double ph1 = alat.val + v2 * al * al * slat * clat / (2.0 * d);
            double rph1 = ph1 * rd;
            double rph2 = (ph1 + alt0) * 0.5 * rd;
            double r = a * (1.0 - e2) / Math.sqrt(Math.pow(1.0 - e2 * Math.pow(Math.sin(rph2), 2.0), 3.0));
            double an = a / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(rph1), 2.0));
            double c1 = d / r;
            double c2 = d / an;
            y.val = (ph1 - alt0) / c1;
            x.val = al * clat / c2 + al * al * al * clat * Math.cos(2.0 * rlat) / (6.0 * c2 * d * d);
        } else {
            double rlato = alt0 * rd;
            double slato = Math.sin(rlato);
            double r = a * (1.0 - e2) / Math.sqrt(Math.pow(1.0 - e2 * slato * slato, 3.0));
            double an = a / Math.sqrt(1.0 - e2 * slato * slato);
            double v2 = 1.0 + e12 * Math.pow(Math.cos(rlato), 2.0);
            double c1 = d / r;
            double c2 = d / an;
            double ph1 = alt0 + c1 * y.val;
            double rph1 = ph1 * rd;
            double tphi1 = Math.tan(rph1);
            double cphi1 = Math.cos(rph1);
            alat.val = ph1 - c2 * x.val * (c2 * x.val) * v2 * tphi1 / (2.0 * d);
            along.val = alng0 + c2 * x.val / cphi1 - Math.pow(c2 * x.val, 3.0) * (1.0 + 2.0 * tphi1 * tphi1) / (6.0 * d * d * cphi1);
        }
    }

    private static double str2double(String t, int n, int m) {
        if (t.length() < n + m) {
            return 9999.0;
        }
        return Double.parseDouble(t.substring(n, n + m));
    }

    private static double MULT2(double x) {
        return x * x;
    }

    static /* synthetic */ double access$0() {
        return VPVS2;
    }

    private static class CALC {
        int org_num;
        String sa;
        double[] sc = new double[3];
        double pt;
        double st;
        double pe;
        double se;
        double apt;
        double ast;
        double vpt;
        double vst;
        double vps;
        double[] fp;
        double[] fs;
        double tpt;
        double tag;
        double tbg;
        double[] a = new double[3];
        double rpt;
        double rst;
        double tw;
        double[] cp = new double[3];
        double[] cs = new double[3];
        double dl;
        double az;
        double ta;
        double tb;
        double bmag;
        String pola;
        int flag;

        private CALC() {
        }
    }

    private static class STATION {
        String sa1;
        String pola1;
        double pt1;
        double st1;
        double pe1;
        double se1;
        double fmp;
        double amp;
        double alat;
        double alng;
        double ahgt;
        double stcp;
        double stcs;
        double xst;
        double yst;
        int flag;

        private STATION() {
        }
    }

    public static class STRUCT {
        public String vst;
        public double vpvs = Math.sqrt(Hypomh.access$0());
        public double zmin;
        public double zmax;
        public int n1;
        public double[] y;
        public double[] vr;
        public double[] v;
        public double[] vlg;

        public STRUCT build(String vst, int nlayer, double[] th, double[] vp) {
            STRUCT strc = new STRUCT();
            strc.vst = vst;
            strc.n1 = nlayer;
            strc.vr = vp;
            strc.vr = new double[strc.n1 + 1];
            strc.y = new double[strc.n1 + 1];
            strc.vlg = new double[strc.n1];
            strc.v = new double[strc.n1];
            int i = 0;
            while (i < strc.n1) {
                strc.vlg[i] = (strc.vr[i + 1] - strc.vr[i]) / th[i];
                ++i;
            }
            strc.y[0] = 0.0;
            i = 0;
            while (i < strc.n1) {
                strc.y[i + 1] = strc.y[i] + th[i];
                ++i;
            }
            strc.v[0] = strc.vr[0] / strc.vlg[0];
            i = 1;
            while (i < strc.n1) {
                strc.v[i] = (strc.vlg[i - 1] * strc.v[i - 1] + (strc.vlg[i - 1] - strc.vlg[i]) * strc.y[i]) / strc.vlg[i];
                ++i;
            }
            this.zmin = -strc.vr[0] / strc.vlg[0] + 0.1;
            this.zmax = strc.y[strc.n1] - 0.1;
            return strc;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(String.format(" ***** VELOCITY STRUCTURE (%s) *****\n", this.vst));
            sb.append(String.format("         I    Y(I)      VR(I)     ALPHA(I)    VLG(I)\n", new Object[0]));
            int i = 0;
            while (i < this.n1) {
                sb.append(String.format("     %5d%10.4f%10.4f\n", i, this.y[i], this.vr[i]));
                sb.append(String.format("                              %12.3E%12.3E\n", this.v[i], this.vlg[i]));
                ++i;
            }
            sb.append(String.format("     %5d%10.4f%10.4f\n", this.n1, this.y[this.n1], this.vr[this.n1]));
            return sb.substring(0);
        }
    }
}

