/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.IterateNearloc;
import cn.org.gddsn.seis.location.StationMapping;
import cn.org.gddsn.seis.location.hyposat.HyposatStation;
import cn.org.gddsn.seis.location.hyposat.Phase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Hyposat
extends IterateNearloc {
    static Logger logger = Logger.getLogger(Hyposat.class);
    private String workingPath = "/usr/local/jopens/msdp/work";
    private String[] envp;
    private String program = "/usr/local/jopens/lib/hyposat/bin/hyposat.freebsd";
    private StringBuffer result = new StringBuffer();
    private EvtData evtData;
    private StationMapping smap = new StationMapping();

    public boolean findSourceLoc() {
        this.smap.buildStationMap(this.evtData);
        File out = new File(this.workingPath, "hyposat-out");
        if (out.isFile() && out.canWrite()) {
            out.delete();
        }
        return this.exportStation() && this.exportPhase() && this.shell();
    }

    public SourceParam getSourceParam() {
        SourceParam sp = super.getSourceParam();
        sp.setLocProgram("Hyposat");
        return sp;
    }

    private boolean exportStation() {
        File allStation = new File(this.workingPath, "hyposat-sta");
        try {
            FileWriter fos = new FileWriter(allStation);
            int TCN = this.evtData.getTCN();
            Hashtable<String, String> tbl = new Hashtable<String, String>();
            int i = 0;
            while (i < TCN) {
                HyposatStation s = new HyposatStation();
                String net = this.evtData.getNetworkCode(i);
                String sta = this.evtData.getStationCode(i);
                String key = String.valueOf(net) + "/" + sta;
                if (tbl.get(key) == null && this.evtData.hasPhase(net, sta)) {
                    s.parse(this.evtData.getTimeSeries(i), this.smap.ns2s);
                    fos.write(s.format());
                    fos.write("\n");
                    tbl.put(key, key);
                }
                ++i;
            }
            fos.close();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
            return false;
        }
        return true;
    }

    private boolean exportPhase() {
        File phaseFile = new File(this.workingPath, "hyposat-in");
        try {
            FileWriter fos = new FileWriter(phaseFile);
            fos.write("MSDP generate phase\n");
            int tch = this.evtData.getTCN();
            int i = 0;
            while (i < tch) {
                Vector<cn.org.gddsn.seis.Phase> phs = this.evtData.getPhases(i);
                for (cn.org.gddsn.seis.Phase p : phs) {
                    Phase hp = new Phase();
                    if (p.getPhaType() != 0) continue;
                    hp.parse(p, this.smap.ns2s);
                    fos.write(hp.format());
                    fos.write("\n");
                }
                ++i;
            }
            fos.close();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
            return false;
        }
        return true;
    }

    private boolean shell() {
        String sourceLine;
        Hashtable<String, Float> tblDelta;
        Hashtable<String, Float> tblAzi;
        Hashtable<String, Float> tbl;
        BufferedReader br;
        int ret;
        block20: {
            ret = -1;
            final Process process = Runtime.getRuntime().exec(this.program, this.envp, new File(this.workingPath));
            Thread thr1 = new Thread(){

                public void run() {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        String line = null;
                        while ((line = bufferedReader.readLine()) != null) {
                            System.out.println(line);
                        }
                        bufferedReader.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            thr1.start();
            Thread thr2 = new Thread(){

                public void run() {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        String line = null;
                        while ((line = bufferedReader.readLine()) != null) {
                            System.out.println(line);
                        }
                        bufferedReader.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            thr2.start();
            String line = null;
            ret = process.waitFor();
            br = new BufferedReader(new FileReader(new File(this.workingPath, "hyposat-out")));
            tbl = new Hashtable<String, Float>();
            tblAzi = new Hashtable<String, Float>();
            tblDelta = new Hashtable<String, Float>();
            line = null;
            sourceLine = null;
            boolean found = false;
            boolean foundPhase = false;
            while ((line = br.readLine()) != null) {
                int idx;
                if (line.indexOf("The new source parameters") != -1) {
                    found = true;
                    foundPhase = false;
                    this.result = new StringBuffer();
                }
                if (found) {
                    this.result.append(String.valueOf(line) + "\n");
                    if (line.startsWith(" Stat  Delta   Azi")) {
                        foundPhase = true;
                        br.readLine();
                        continue;
                    }
                    if (foundPhase) {
                        if (line.length() == 0) {
                            foundPhase = false;
                        }
                        if (line.length() < 59) continue;
                        String sta = line.substring(0, 6).trim();
                        String phase = line.substring(21, 29).trim();
                        String resStr = line.substring(51, 58).trim();
                        if (resStr.length() != 0) {
                            tbl.put(String.valueOf(sta) + "_" + phase, Float.valueOf(Float.parseFloat(resStr)));
                        }
                        if ((resStr = line.substring(59, 65).trim()).length() != 0) {
                            tblAzi.put(String.valueOf(sta) + "_" + phase, Float.valueOf(Float.parseFloat(resStr)));
                        }
                        if ((resStr = line.substring(6, 13).trim()).length() != 0) {
                            tblDelta.put(String.valueOf(sta) + "_" + phase, Float.valueOf(Float.parseFloat(resStr)));
                        }
                    }
                }
                if (line.startsWith("Flinn-Engdahl Region") && (idx = line.indexOf(58)) != -1 && line.length() > idx + 1) {
                    this.sourceParam.setFeRegion(line.substring(idx + 1).trim());
                    this.sourceParam.setLocation(this.sourceParam.getFeRegion());
                }
                if (!line.startsWith("T0                         LAT      LON")) continue;
                sourceLine = br.readLine();
                this.result.append(String.valueOf(sourceLine) + "\n");
            }
            if (found) break block20;
            return false;
        }
        try {
            Vector<cn.org.gddsn.seis.Phase>[] vec = this.getStnPhases();
            int i = 0;
            while (i < vec.length) {
                for (cn.org.gddsn.seis.Phase p : vec[i]) {
                    Float delta;
                    Float azi;
                    String sta;
                    if (p.getPhaType() != 0 || (sta = this.smap.getStation(String.valueOf(p.getNetCode()) + "/" + p.getStationCode())) == null) continue;
                    String key = String.valueOf(sta) + "_" + p.getPhaseName();
                    Float re = (Float)tbl.get(key);
                    if (re != null) {
                        p.setResi(re.floatValue());
                    }
                    if ((azi = (Float)tblAzi.get(key)) != null) {
                        float a = azi.floatValue();
                        if ((a += 180.0f) >= 360.0f) {
                            a -= 360.0f;
                        }
                        p.setAzimuth(a);
                    }
                    if ((delta = (Float)tblDelta.get(key)) == null) continue;
                    p.setDistance(delta.floatValue() * 111.19f);
                }
                ++i;
            }
            logger.info("sourcLine=" + sourceLine);
            String OTIME_FMT = "yyyy-MM-dd HH mm ss.SSS";
            SimpleDateFormat sdf = new SimpleDateFormat(OTIME_FMT);
            Date otime = sdf.parse(sourceLine.substring(0, OTIME_FMT.length()));
            this.sourceParam.setOriginTime(otime);
            StringTokenizer st = new StringTokenizer(sourceLine.substring(OTIME_FMT.length()));
            this.sourceParam.setLat(Float.parseFloat(st.nextToken()));
            this.sourceParam.setLon(Float.parseFloat(st.nextToken()));
            this.sourceParam.setDepth(Float.parseFloat(st.nextToken()));
            st.nextToken();
            float dlat = Float.parseFloat(st.nextToken());
            float dlon = Float.parseFloat(st.nextToken());
            this.sourceParam.setErh((double)Math.max(dlat, dlon) * 111.19);
            String DZ = st.nextToken();
            if (DZ.equals("Fixed")) {
                this.sourceParam.setErz(-99999.0);
                this.sourceParam.setRemark("Depth Fixed");
            } else {
                this.sourceParam.setErz(Float.parseFloat(DZ));
            }
            st.nextToken();
            st.nextToken();
            st.nextToken();
            this.sourceParam.setRms(Float.parseFloat(st.nextToken()));
            this.sourceParam.setOperator("hyposat");
            br.close();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
        }
        return ret == 0;
    }

    public String getDetailLocationResult() {
        String buf = super.getDetailLocationResult();
        return String.valueOf(buf) + this.result.substring(0);
    }

    public double getDetailResidual(int stn, String phaseName) {
        cn.org.gddsn.seis.Phase phase = this.getPhase(stn, phaseName);
        if (phase == null) {
            return -99999.0;
        }
        return phase.getResi();
    }

    public void setProgram(String program) {
        this.program = program;
    }

    public String getWorkingPath() {
        return this.workingPath;
    }

    public void setWorkingPath(String workingPath) {
        this.workingPath = workingPath;
    }

    public EvtData getEvtData() {
        return this.evtData;
    }

    public void setEvtData(EvtData evtData) {
        this.evtData = evtData;
    }

    public String[] getEnvp() {
        return this.envp;
    }

    public void setEnvp(String[] envp) {
        this.envp = envp;
        int i = 0;
        while (i < this.envp.length) {
            this.envp[i] = this.envp[i].trim();
            ++i;
        }
    }
}

