/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.convert.DoubleFormat;
import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.convert.cs_printf;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.BaseLocationInf;
import cn.org.gddsn.seis.location.CalMagnitude;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.location.LocData;
import cn.org.gddsn.seis.location.MagnitudeInf;
import cn.org.gddsn.seis.location.OutputInfoForLoc;
import cn.org.gddsn.seis.regions.RegionsFE;
import cn.org.gddsn.seis.regions.geotools.GeoRegion;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;

abstract class IterateNearloc
extends LocData
implements BaseLocationInf {
    protected ComputedTravelTime computedTravelTime;
    private MagnitudeInf magnitudeInf = new CalMagnitude();
    protected SourceParam trySource = new SourceParam();

    public void setTrySource(SourceParam trySource) {
        this.trySource = trySource;
    }

    public void setEvtData(EvtData mainEvent) {
    }

    public SourceParam loopFindBestSource(String[] phns, int minStn, double minResidual) {
        Enumeration Enu;
        int stn;
        Phase phase;
        double cres = 0.0;
        int bad_stn = 0;
        String bad_phsnm = null;
        Vector<Phase>[] phases = this.getStnPhases();
        Vector<Phase> vec = new Vector<Phase>();
        int i = 0;
        while (i < phases.length) {
            Enumeration Enu2 = this.stnPhases[i].elements();
            while (Enu2.hasMoreElements()) {
                phase = (Phase)Enu2.nextElement();
                if (phase.getPhaType() != 0) continue;
                vec.add(phase);
            }
            ++i;
        }
        Collections.sort(vec);
        for (Phase ph : vec) {
            logger.info(ph);
        }
        int n = 0;
        int size = vec.size();
        int nf = 0;
        int nl = 0;
        do {
            if (n % 4 == 0) {
                int s = this.isolateStation();
                if (s != -1) {
                    logger.info("remove isolate station: " + this.getStnLocations()[s].getSta());
                }
            } else if (n % 4 == 1) {
                phase = (Phase)vec.get(size - 1 - nl++);
                this.setWeightByStation(phase.getStationCode(), 0);
                logger.info("remove first arrival station: " + phase.getStationCode());
            } else if (n % 4 == 2) {
                phase = (Phase)vec.get(nf++);
                this.setWeightByStation(phase.getStationCode(), 0);
                logger.info("remove last arrival station: " + phase.getStationCode());
            } else {
                cres = 0.0;
                int i2 = 0;
                while (i2 < phases.length) {
                    Enumeration Enu3 = this.stnPhases[i2].elements();
                    while (Enu3.hasMoreElements()) {
                        phase = (Phase)Enu3.nextElement();
                        if (phase.getPhaType() != 0) continue;
                        double sres = Math.abs(this.getDetailResidual(i2, phase.getPhaseName()));
                        if (phase.getWeight() != 1 || !(cres < sres)) continue;
                        cres = sres;
                        bad_stn = i2;
                        bad_phsnm = phase.getPhaseName();
                    }
                    ++i2;
                }
                phase = this.getPhase(bad_stn, bad_phsnm);
                if (phase != null) {
                    phase.setWeight(0);
                    logger.info("remove phase: " + phase);
                }
            }
            ++n;
            stn = this.getUsedStation();
            this.findSourceLoc();
            logger.info("residual: " + this.sourceParam.rms);
        } while (!(!Double.isNaN(this.sourceParam.rms) && this.sourceParam.rms < minResidual && this.sourceParam.rms > 0.01) && stn >= minStn);
        logger.info("Step 1, After remove bad phase, Location Result: ");
        this.printSourceParam(this.sourceParam);
        String[] choosePhs = new String[]{"Pn", "Pg", "P", "Sn", "Sg", "S"};
        int i3 = 0;
        while (i3 < phases.length) {
            Enu = this.stnPhases[i3].elements();
            while (Enu.hasMoreElements()) {
                phase = (Phase)Enu.nextElement();
                if (phase.getPhaType() != 0) continue;
                String origPh = phase.getPhaseName();
                double origRsdl = Math.abs(this.getDetailResidual(i3, phase.getPhaseName()));
                logger.info("origRsdl=" + origRsdl);
                int j = 0;
                while (j < choosePhs.length) {
                    if (!phase.getPhaseName().equals(choosePhs[j])) {
                        Phase tmp = this.getPhase(i3, choosePhs[j]);
                        if (tmp != null) {
                            String tmpPh = tmp.getPhaseName();
                            double tmpRsdl = Math.abs(this.getDetailResidual(i3, tmp.getPhaseName()));
                            tmp.setPhaseName("XXX");
                            phase.setPhaseName(choosePhs[j]);
                            double newRsdl = Math.abs(this.getDetailResidual(i3, phase.getPhaseName()));
                            logger.info("tmpRsdl=" + tmpRsdl + ",newRsdl=" + newRsdl);
                            if (newRsdl < tmpRsdl && newRsdl < origRsdl) {
                                tmp.setPhaseName(origPh);
                                logger.info(tmp + " change from " + tmpPh);
                                logger.info(phase + " change from " + origPh);
                                origPh = phase.getPhaseName();
                                origRsdl = Math.abs(this.getDetailResidual(i3, phase.getPhaseName()));
                            } else {
                                phase.setPhaseName(origPh);
                                tmp.setPhaseName(tmpPh);
                            }
                        } else {
                            phase.setPhaseName(choosePhs[j]);
                            double rsdl = Math.abs(this.getDetailResidual(i3, phase.getPhaseName()));
                            if (rsdl >= origRsdl) {
                                phase.setPhaseName(origPh);
                            } else {
                                logger.info("rsdl=" + rsdl);
                                logger.info(phase + " change from " + origPh);
                                origPh = phase.getPhaseName();
                                origRsdl = Math.abs(this.getDetailResidual(i3, phase.getPhaseName()));
                            }
                        }
                    }
                    ++j;
                }
                this.findSourceLoc();
                logger.info("residual: " + this.sourceParam.rms);
                if (!Double.isNaN(this.sourceParam.rms) && this.sourceParam.rms < minResidual && !(this.sourceParam.rms > 0.01)) continue;
            }
            ++i3;
        }
        logger.info("Step 2, after switch phase name, Location Result: ");
        this.printSourceParam(this.sourceParam);
        i3 = 0;
        while (i3 < phases.length) {
            Enu = this.stnPhases[i3].elements();
            while (Enu.hasMoreElements()) {
                phase = (Phase)Enu.nextElement();
                if (phase.getPhaType() != 0 || phase.getWeight() != 0) continue;
                phase.setWeight(1);
                stn = this.getUsedStation();
                this.findSourceLoc();
                logger.info("residual: " + this.sourceParam.rms);
                if (!Double.isNaN(this.sourceParam.rms) && this.sourceParam.rms < minResidual && this.sourceParam.rms > 0.01) {
                    logger.info(phase + " set Weight 1");
                    continue;
                }
                phase.setWeight(0);
            }
            ++i3;
        }
        logger.info("Step 3, after put good phase back, Location Result: ");
        this.printSourceParam(this.sourceParam);
        return this.getSourceParam();
    }

    public int getUsedStation() {
        int stn = 0;
        Vector<Phase>[] phases = this.getStnPhases();
        int i = 0;
        while (i < phases.length) {
            Enumeration Enu = this.stnPhases[i].elements();
            while (Enu.hasMoreElements()) {
                Phase phase = (Phase)Enu.nextElement();
                if (phase.getWeight() != 1 || phase.getPhaType() != 0) continue;
                ++stn;
                break;
            }
            ++i;
        }
        return stn;
    }

    private void printSourceParam(SourceParam res) {
        logger.info("The Residual is: " + res.getRms());
        logger.info("OTime = " + res.getOriginTime());
        logger.info("Lontidude = " + DoubleFormat.toString(res.getLon(), 2));
        logger.info("Latidude = " + DoubleFormat.toString(res.getLat(), 2));
        logger.info("ML = " + DoubleFormat.toString(res.getMl(), 2));
        logger.info("Ms = " + DoubleFormat.toString(res.getMs(), 2));
        logger.info("Depth = " + DoubleFormat.toString(res.getDepth(), 2));
    }

    public abstract boolean findSourceLoc();

    public SourceParam getSourceParam() {
        this.sourceParam.ml = this.getML();
        this.sourceParam.ms = this.getMs();
        this.sourceParam.mb = this.getMb();
        this.sourceParam.setFeRegion(GeoRegion.getName(this.sourceParam.getLat(), this.sourceParam.getLon()));
        this.sourceParam.setFeNum(RegionsFE.getFeGeoRegionNum(this.sourceParam.getLat(), this.sourceParam.getLon()));
        this.sourceParam.setLocation(this.sourceParam.getFeRegion());
        if (Double.isNaN(this.sourceParam.getRms())) {
            this.sourceParam.setRms(-99999.0);
        }
        if (this.sourceParam.ms > 0.0) {
            this.sourceParam.setM(this.sourceParam.getMs());
            this.sourceParam.setMSource("Ms");
        } else {
            this.sourceParam.setM(CalMagnitude.Ml2Ms(this.sourceParam.getMl()));
            this.sourceParam.setMSource("ML");
        }
        if (Double.isNaN(this.sourceParam.getErh())) {
            this.sourceParam.setQloc("0");
        } else if (this.sourceParam.getErh() <= 5.0) {
            this.sourceParam.setQloc("1");
        } else if (this.sourceParam.getErh() <= 15.0) {
            this.sourceParam.setQloc("2");
        } else if (this.sourceParam.getErh() <= 30.0) {
            this.sourceParam.setQloc("3");
        } else {
            this.sourceParam.setQloc("4");
        }
        return this.sourceParam;
    }

    public OutputInfoForLoc getOutputInfoForLoc() {
        OutputInfoForLoc outputInfoForLoc = new OutputInfoForLoc();
        double[] ML = new double[this.getStnSum()];
        double[] Ms = new double[this.getStnSum()];
        double[] Mb = new double[this.getStnSum()];
        double[] delta = new double[this.getStnSum()];
        double[] r = new double[this.getLocPhaSum()];
        int tmp = 0;
        int i = 0;
        while (i < this.getStnSum()) {
            ML[i] = this.getDetailMl(i);
            Ms[i] = this.getDetailMs(i);
            Mb[i] = this.getDetailMb(i);
            delta[i] = this.getDetailDelta(i);
            Enumeration Enu = this.stnPhases[i].elements();
            while (Enu.hasMoreElements()) {
                Phase phase = (Phase)Enu.nextElement();
                phase.setDistance((float)delta[i]);
                r[tmp++] = this.getDetailResidual(i, phase.getPhaseName());
            }
            ++i;
        }
        outputInfoForLoc.setDetailDelta(delta);
        outputInfoForLoc.setDetailML(ML);
        outputInfoForLoc.setDetailMs(Ms);
        outputInfoForLoc.setDetailMb(Mb);
        outputInfoForLoc.setLocPhaSum(this.getLocPhaSum());
        outputInfoForLoc.setLocStnSum(this.getStnSum());
        outputInfoForLoc.setResidual(r);
        outputInfoForLoc.setSource(this.getSourceParam());
        return outputInfoForLoc;
    }

    public double getDetailDelta(int stn) {
        double stnLat = this.getStnLocations()[stn].getLat();
        double stnLon = this.getStnLocations()[stn].getLon();
        double srcLat = this.sourceParam.lat;
        double srcLon = this.sourceParam.lon;
        double delta = SphereUtil.distOnSphere(stnLat, stnLon, srcLat, srcLon) * 111.19;
        return delta;
    }

    public double getDetailAzimuth(int stn) {
        double stnLat = this.getStnLocations()[stn].getLat();
        double stnLon = this.getStnLocations()[stn].getLon();
        double srcLat = this.sourceParam.lat;
        double srcLon = this.sourceParam.lon;
        SphereUtil.DELTAI deltai = SphereUtil.deltai(srcLat, srcLon, stnLat, stnLon);
        return deltai.az1;
    }

    public double getDetailMl(int stn) {
        Phase phaseZ = this.getPhase(stn, "SMZ");
        Phase phaseE = this.getPhase(stn, "SME");
        Phase phaseN = this.getPhase(stn, "SMN");
        double ml = (float)this.magnitudeInf.getML(phaseZ, phaseE, phaseN, this.getDetailDelta(stn));
        if (phaseN != null) {
            phaseN.setMagName("ML");
            phaseN.setMagVal((float)ml);
            phaseN.setDistance((float)this.getDetailDelta(stn));
            phaseN.setAzimuth((float)this.getDetailAzimuth(stn));
        }
        if (phaseE != null) {
            phaseE.setMagName("ML");
            phaseE.setMagVal((float)ml);
            phaseE.setDistance((float)this.getDetailDelta(stn));
            phaseE.setAzimuth((float)this.getDetailAzimuth(stn));
        }
        if (phaseZ != null) {
            phaseZ.setMagName("ML");
            phaseZ.setMagVal((float)ml);
            phaseZ.setDistance((float)this.getDetailDelta(stn));
            phaseZ.setAzimuth((float)this.getDetailAzimuth(stn));
        }
        return ml;
    }

    public double getDetailMs(int stn) {
        Phase phaseZ = this.getPhase(stn, "LZ");
        Phase phaseE = this.getPhase(stn, "LE");
        Phase phaseN = this.getPhase(stn, "LN");
        double Ms = this.magnitudeInf.getMs(phaseZ, phaseE, phaseN, this.getDetailDelta(stn));
        if (phaseN != null) {
            phaseN.setMagName("Ms");
            phaseN.setMagVal((float)Ms);
            phaseN.setDistance((float)this.getDetailDelta(stn));
            phaseN.setAzimuth((float)this.getDetailAzimuth(stn));
        }
        if (phaseE != null) {
            phaseE.setMagName("Ms");
            phaseE.setMagVal((float)Ms);
            phaseE.setDistance((float)this.getDetailDelta(stn));
            phaseE.setAzimuth((float)this.getDetailAzimuth(stn));
        }
        if (phaseZ != null) {
            phaseZ.setMagName("Ms");
            phaseZ.setMagVal((float)Ms);
            phaseZ.setDistance((float)this.getDetailDelta(stn));
            phaseZ.setAzimuth((float)this.getDetailAzimuth(stn));
        }
        return Ms;
    }

    public double getDetailMb(int stn) {
        Phase phaseZ = this.getPhase(stn, "PMZ");
        if (phaseZ == null) {
            return Double.NaN;
        }
        double mb = this.magnitudeInf.getMb(phaseZ.getAmp(), phaseZ.getPeriod(), this.getDetailDelta(stn) / 111.19, phaseZ.getRecType());
        phaseZ.setMagVal((float)mb);
        phaseZ.setMagName("mb");
        phaseZ.setDistance((float)this.getDetailDelta(stn));
        phaseZ.setAzimuth((float)this.getDetailAzimuth(stn));
        return mb;
    }

    public Date getDetailOriginTime(int stn) {
        Vector<Phase> stnPhases = this.getStnPhases(stn);
        Vector<Phase> sv = new Vector<Phase>();
        for (Phase p : stnPhases) {
            if (p.getPhaType() != 0) continue;
            sv.add(p);
        }
        int size = sv.size();
        if (size < 2) {
            return null;
        }
        Collections.sort(sv);
        Phase fp = (Phase)sv.get(0);
        Phase lp = (Phase)sv.get(size - 1);
        double difTime = (double)lp.getPhaseTime().getTime() / 1000.0 - (double)fp.getPhaseTime().getTime() / 1000.0;
        String strPhaseType = String.valueOf(fp.getPhaseName()) + "," + lp.getPhaseName();
        double delta = this.computedTravelTime.calDelta(this.sourceParam.depth, difTime, strPhaseType);
        if (Double.isNaN(delta)) {
            return null;
        }
        int type = this.getPhaseType(fp.getPhaseName());
        double trvlTime = this.computedTravelTime.calTravelTime(this.sourceParam.depth, delta, type);
        if (Double.isNaN(trvlTime)) {
            return null;
        }
        return new Date(fp.getPhaseTime().getTime() - (long)(trvlTime * 1000.0));
    }

    public double getDetailResidual(int stn, String phaseName) {
        double residual = Double.NaN;
        try {
            Phase phase = this.getPhase(stn, phaseName);
            int type = this.getPhaseType(phaseName);
            double delta = this.getDetailDelta(stn) / 111.19;
            double trvlTime = this.computedTravelTime.calTravelTime(this.sourceParam.depth, delta, type);
            residual = phase.getPhaseTime().getTime() - (long)(trvlTime * 1000.0) - this.sourceParam.originTime.getTime();
            phase.setResi((float)(residual /= 1000.0));
            phase.setDistance((int)this.getDetailDelta(stn));
            phase.setAzimuth((float)this.getDetailAzimuth(stn));
        }
        catch (IllegalArgumentException ex) {
            return Double.NaN;
        }
        return residual;
    }

    private String getDate(Date d) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        StringBuffer strBuffer = new StringBuffer();
        cs_printf P = new cs_printf(strBuffer);
        int month = c.get(2) + 1;
        P.printf("%4d-%02d-%02d", new Integer(c.get(1)), new Integer(month), new Integer(c.get(5)));
        return strBuffer.substring(0);
    }

    private String getTime(Date d) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        long t = d.getTime();
        double sec = (double)c.get(13) + (double)(t % 1000L) / 1000.0;
        StringBuffer strBuffer = new StringBuffer();
        cs_printf P = new cs_printf(strBuffer);
        P.printf("%02d:%02d:%04.2f", new Integer(c.get(11)), new Integer(c.get(12)), new Double(sec));
        return strBuffer.substring(0);
    }

    public String getDetailLocationResult() {
        StringBuffer textArea = new StringBuffer();
        textArea.append("                    Locating Result of Earthquake:\n");
        textArea.append(" ******************************************************************************\n");
        String strTime = this.getTime(this.sourceParam.originTime);
        String strDate = this.getDate(this.sourceParam.originTime);
        textArea.append(" Origin Time  :  " + strDate + "        " + strTime + "\n");
        long latIntPart = (long)Math.floor(Math.abs(this.sourceParam.lat));
        double latDotPart = Math.abs(this.sourceParam.lat) - (double)latIntPart;
        long lonIntPart = (long)Math.floor(Math.abs(this.sourceParam.lon));
        double lonDotPart = Math.abs(this.sourceParam.lon) - (double)lonIntPart;
        StringBuffer strBuffer = new StringBuffer();
        cs_printf P = new cs_printf(strBuffer);
        P.printf(" Epicentre    :  %03d\u00b0%04.2f\u2032         %04d\u00b0%04.2f\u2032   \n", new Integer((int)this.sourceParam.lat), new Double(latDotPart *= 60.0), new Integer((int)this.sourceParam.lon), new Double(lonDotPart *= 60.0));
        P.printf(" Magnitude    :  %02.1f(ML)\t%02.1f(Ms)\t%02.1f(mb)\n", new Double(this.sourceParam.ml), new Double(this.sourceParam.ms), new Double(this.sourceParam.mb));
        textArea.append(strBuffer.substring(0));
        textArea.append(String.format(" Focal Depth  : %03.1f          Residual : %.3f\n", this.sourceParam.depth, this.sourceParam.rms));
        textArea.append("Epicentre Accuracy:   N/A(km)    Depth Accuracy:   N/A\n");
        textArea.append(String.format("%-5s %-8s %1s %-12s %-10s %-12s %-8s %7s %8s %3s %3s %3s\n", "No.", "Stname", " ", "Phase", "Date", "Time", "OTime", "t-res", "delta", "ML", "Ms", "mb"));
        int i = 0;
        while (i < this.getStnSum()) {
            boolean first = true;
            Enumeration Enu = this.stnPhases[i].elements();
            while (Enu.hasMoreElements()) {
                Phase phase = (Phase)Enu.nextElement();
                try {
                    this.getPhaseType(phase.getPhaseName());
                }
                catch (IllegalArgumentException ex) {
                    continue;
                }
                if (first) {
                    first = false;
                    textArea.append(String.format("%-5d %-8s %1s %-12s", i, String.valueOf(phase.getNetCode()) + "/" + phase.getStationCode(), phase.getClarity(), String.valueOf(phase.getWeight() == 0 ? String.valueOf(phase.getPhaseName()) + "-" : phase.getPhaseName()) + " " + phase.getWsign()));
                    Date so = this.getDetailOriginTime(i);
                    if (so != null) {
                        GregorianCalendar c = new GregorianCalendar();
                        c.setTime(so);
                        float sec = (float)c.get(13) + (float)(so.getTime() % 1000L) / 1000.0f;
                        textArea.append(String.format(" %1$tF %1$tT.%2$03d %3$02d-%4$05.2f %5$7.2f %6$8.2f", phase.getPhaseTime(), phase.getPhaseTime().getTime() % 1000L, c.get(12), Float.valueOf(sec), this.getDetailResidual(i, phase.getPhaseName()), this.getDetailDelta(i)));
                    } else {
                        textArea.append(String.format(" %1$tF %1$tT.%2$03d %3$-8s %4$7.2f %5$8.2f", phase.getPhaseTime(), phase.getPhaseTime().getTime() % 1000L, "", this.getDetailResidual(i, phase.getPhaseName()), this.getDetailDelta(i)));
                    }
                    double ml = this.getDetailMl(i);
                    if (Double.isNaN(ml)) {
                        textArea.append("    ");
                    } else {
                        textArea.append(String.format("% 2.1f", ml));
                    }
                    double ms = this.getDetailMs(i);
                    if (Double.isNaN(ms)) {
                        textArea.append("    ");
                    } else {
                        textArea.append(String.format("% 2.1f", ms));
                    }
                    double mb = this.getDetailMb(i);
                    if (Double.isNaN(mb)) {
                        textArea.append("    ");
                    } else {
                        textArea.append(String.format("% 2.1f", mb));
                    }
                    textArea.append("\n");
                    continue;
                }
                textArea.append(String.format("%-5s %-8s %1s %-12s", " ", " ", " ", String.valueOf(phase.getWeight() == 0 ? String.valueOf(phase.getPhaseName()) + "-" : phase.getPhaseName()) + "  "));
                textArea.append(String.format(" %1$tF %1$tT.%2$03d %3$-8s %4$7.2f", phase.getPhaseTime(), phase.getPhaseTime().getTime() % 1000L, "", this.getDetailResidual(i, phase.getPhaseName())));
                textArea.append("\n");
            }
            ++i;
        }
        textArea.append(" ******************************************************************************\n");
        return new String(textArea);
    }

    private double getML() {
        double MLSum = 0.0;
        int MLCounts = 0;
        double ml = 0.0;
        int i = 0;
        while (i < this.stnPhases.length) {
            double delta;
            Phase phaseZ = this.getPhase(i, "SMZ");
            Phase phaseE = this.getPhase(i, "SME");
            Phase phaseN = this.getPhase(i, "SMN");
            if (!(phaseZ != null && phaseZ.getWeight() == 0 || phaseE != null && phaseE.getWeight() == 0 || phaseN != null && phaseN.getWeight() == 0 || Double.isNaN(ml = this.magnitudeInf.getML(phaseZ, phaseE, phaseN, delta = this.getDetailDelta(i))))) {
                MLSum += ml;
                ++MLCounts;
            }
            ++i;
        }
        if (MLCounts == 0) {
            return Double.NaN;
        }
        return MLSum / (double)MLCounts;
    }

    private double getMs() {
        double MsSum = 0.0;
        int MsCounts = 0;
        double Ms = 0.0;
        int i = 0;
        while (i < this.stnPhases.length) {
            double delta;
            Phase phaseZ = this.getPhase(i, "LZ");
            Phase phaseE = this.getPhase(i, "LE");
            Phase phaseN = this.getPhase(i, "LN");
            if (!(phaseZ != null && phaseZ.getWeight() == 0 || phaseE != null && phaseE.getWeight() == 0 || phaseN != null && phaseN.getWeight() == 0 || Double.isNaN(Ms = this.magnitudeInf.getMs(phaseZ, phaseE, phaseN, delta = this.getDetailDelta(i))))) {
                MsSum += Ms;
                ++MsCounts;
            }
            ++i;
        }
        if (MsCounts == 0) {
            return Double.NaN;
        }
        return MsSum / (double)MsCounts;
    }

    private double getMb() {
        double mbSum = 0.0;
        int mbCounts = 0;
        double mb = 0.0;
        int i = 0;
        while (i < this.stnPhases.length) {
            Phase phaseZ = this.getPhase(i, "PMZ");
            if (phaseZ != null && phaseZ.getWeight() != 0) {
                double delta = this.getDetailDelta(i) / 111.19;
                mb = this.magnitudeInf.getMb(phaseZ.getAmp(), phaseZ.getPeriod(), delta, phaseZ.getRecType());
                if (!Double.isNaN(mb)) {
                    mbSum += mb;
                    ++mbCounts;
                }
            }
            ++i;
        }
        if (mbCounts == 0) {
            return Double.NaN;
        }
        return mbSum / (double)mbCounts;
    }

    public void setComputedTravelTime(ComputedTravelTime newCompTT) {
        this.computedTravelTime = newCompTT;
    }

    public void setMagnitudeInf(MagnitudeInf magnitudeInf) {
        this.magnitudeInf = magnitudeInf;
    }

    public ComputedTravelTime getComputedTravelTime() {
        return this.computedTravelTime;
    }

    public MagnitudeInf getMagnitudeInf() {
        return this.magnitudeInf;
    }
}

