/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.location.CountryTable;
import cn.org.gddsn.seis.location.LocalTable;

public final class LocalPlusCountry
implements ComputedTravelTime {
    LocalTable local = new LocalTable();
    CountryTable country = new CountryTable();

    public double calTravelTime(double[] Src, double[] Stn, String phaseType) {
        double retVal = this.local.calTravelTime(Src, Stn, phaseType);
        if (Double.isNaN(retVal)) {
            retVal = this.country.calTravelTime(Src, Stn, phaseType);
        }
        if (Double.isNaN(retVal)) {
            // empty if block
        }
        return retVal;
    }

    public double calTravelTime(double depth, double Delta, String phaseType) {
        double retVal = this.local.calTravelTime(depth, Delta, phaseType);
        if (Double.isNaN(retVal)) {
            retVal = this.country.calTravelTime(depth, Delta, phaseType);
        }
        if (Double.isNaN(retVal)) {
            // empty if block
        }
        return retVal;
    }

    public double calDelta(double depth, double time, String phaseType) {
        double retVal = this.local.calDelta(depth, time, phaseType);
        if (Double.isNaN(retVal)) {
            retVal = this.country.calDelta(depth, time, phaseType);
        }
        if (Double.isNaN(retVal)) {
            // empty if block
        }
        return retVal;
    }

    public double calTravelTime(double[] Src, double[] Stn, int phaseType) {
        return this.calTravelTime(Src, Stn, this.local.getPhaseType(phaseType));
    }

    public double calTravelTime(double depth, double Delta, int phaseType) {
        return this.calTravelTime(depth, Delta, this.local.getPhaseType(phaseType));
    }

    public double calDelta(double depth, double time, int phaseType) {
        return this.calDelta(depth, time, this.local.getPhaseType(phaseType));
    }

    public static void main(String[] args) throws Exception {
        LocalPlusCountry test = new LocalPlusCountry();
        double d = test.calTravelTime(5.0, 0.82, "Pn");
        System.out.println(d);
        d = test.calDelta(25.0, 148.6, "P,S");
        System.out.println(d);
    }
}

