/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.linalg.Distance;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.location.InputInfoForLoc;
import cn.org.gddsn.seis.location.StnLocation;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationData {
    static Logger logger = Logger.getLogger(LocationData.class);
    protected Vector<Phase>[] stnPhases = null;
    protected StnLocation[] stnLocations = null;
    private int stnSum;
    private int locPhaSum;
    private double isolateLevel = 2.0;
    protected SourceParam sourceParam = new SourceParam();

    public int getStnSum() {
        return this.stnSum;
    }

    public int getLocPhaSum() {
        return this.locPhaSum;
    }

    protected void initLocData() {
    }

    public void setInputInfoForLoc(InputInfoForLoc inputInfoForLoc) {
        this.locPhaSum = inputInfoForLoc.getLocPhaSum();
        this.stnSum = inputInfoForLoc.getLocStnSum();
        this.stnPhases = inputInfoForLoc.getStnPhases();
        this.stnLocations = inputInfoForLoc.getStnLocations();
        this.initLocData();
    }

    public Vector<Phase>[] getStnPhases() {
        return this.stnPhases;
    }

    public StnLocation[] getStnLocations() {
        return this.stnLocations;
    }

    public StnLocation getStnLocation(int i) {
        return this.stnLocations[i];
    }

    public double getIsolateLevel() {
        return this.isolateLevel;
    }

    public SourceParam getSourceParam() {
        return this.sourceParam;
    }

    public Phase getPhase(int stn, String phaseName) {
        Enumeration<Phase> Enu = this.stnPhases[stn].elements();
        while (Enu.hasMoreElements()) {
            Phase phase = Enu.nextElement();
            if (phase.getPhaseName() == null || !phase.getPhaseName().equals(new String(phaseName))) continue;
            return phase;
        }
        return null;
    }

    public Vector<Phase> getStnPhases(int stn) {
        return this.stnPhases[stn];
    }

    public boolean hasValidPhase(int stn) {
        boolean bValid = false;
        Enumeration<Phase> Enu = this.stnPhases[stn].elements();
        while (Enu.hasMoreElements()) {
            Phase phase = Enu.nextElement();
            if (phase.getWeight() != 1) continue;
            bValid = true;
            break;
        }
        return bValid;
    }

    public int isolateStation() {
        if (this.stnLocations.length < 3) {
            return -1;
        }
        double[] dst = new double[this.stnLocations.length];
        double[] a = new double[2];
        double[] b = new double[2];
        int i = 0;
        while (i < dst.length) {
            boolean valid = this.hasValidPhase(i);
            if (valid) {
                a[0] = this.stnLocations[i].getLat();
                a[1] = this.stnLocations[i].getLon();
                int j = 0;
                while (j < dst.length) {
                    valid = this.hasValidPhase(j);
                    if (valid) {
                        b[0] = this.stnLocations[j].getLat();
                        b[1] = this.stnLocations[j].getLon();
                        int n = i;
                        dst[n] = dst[n] + Distance.norm(a, b, 2);
                    }
                    ++j;
                }
            }
            ++i;
        }
        int stn = 0;
        int i2 = 0;
        while (i2 < dst.length) {
            if (dst[stn] < dst[i2]) {
                stn = i2;
            }
            ++i2;
        }
        int n = stn;
        dst[n] = dst[n] / this.isolateLevel;
        int stn1 = 0;
        int i3 = 0;
        while (i3 < dst.length) {
            if (dst[stn1] < dst[i3]) {
                stn1 = i3;
            }
            ++i3;
        }
        if (stn == stn1) {
            logger.info(String.valueOf(this.stnLocations[stn].getSta()) + " is isolate station, all phase of this station is weghted to 0");
            this.setWeightByStation(stn, 0);
            this.initLocData();
            return stn;
        }
        return -1;
    }

    public void setWeightByStation(String sta, int weight) {
        int i = 0;
        while (i < this.stnPhases.length) {
            Enumeration<Phase> Enu = this.stnPhases[i].elements();
            while (Enu.hasMoreElements()) {
                Phase phase = Enu.nextElement();
                if (!phase.getStationCode().equals(sta)) continue;
                phase.setWeight(weight);
            }
            ++i;
        }
    }

    public void setWeightByStation(int sta, int weight) {
        Enumeration<Phase> Enu = this.stnPhases[sta].elements();
        while (Enu.hasMoreElements()) {
            Phase phase = Enu.nextElement();
            phase.setWeight(weight);
        }
    }

    public void setIsolateLevel(double isolateLevel) {
        this.isolateLevel = isolateLevel;
    }

    public void setSourceParam(SourceParam sourceParam) {
        this.sourceParam = sourceParam;
    }
}

