/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.signal.Filter;
import cn.org.gddsn.signal.NumericProcess;
import cn.org.gddsn.signal.filter.design.IIRFilter;

public class MwNishimae {
    private static final double[][] MW_COEF = new double[][]{{0.9019104471844, 1.06326642596736, 6.64481386595526}, {0.91253249729915, 1.04502721008826, 6.69392303663479}, {0.91133584288839, 1.06851589019166, 6.73314100082785}, {0.91180639920049, 1.04881661641676, 6.74980156646102}, {0.89969670469653, 1.07758681783293, 6.75911314611376}, {0.91111202743185, 1.02328650510313, 6.78202587290609}};
    private static final double[] INT_AC = new double[]{1.0, -1.99888508937553, 0.99888570174608};
    private static final double[] INT_BC = new double[]{0.02498575531479, -6.2801198E-7, -0.02498637989862};
    private static final double[] BAND_AC = new double[]{1.0, -3.978872532739, 5.93686275403242, -3.93710765191372, 0.97911743077092};
    private static final double[] BAND_BC = new double[]{5.50884295E-5, 0.0, -1.1017685899E-4, 0.0, 5.50884295E-5};
    private static final double ALMOST_ZERO = 1.0E-20;

    private MwNishimae() {
    }

    public static double computeAmp(double[] wave, int srate, double gain, int phaseIdx, double delta, int mw_minute, double pct) {
        double average = MwNishimae.computeAverage(wave.length, wave);
        int i = 0;
        while (i < wave.length) {
            if (Math.abs(wave[i]) > 1.0E-20) {
                int n = i;
                wave[n] = wave[n] - average;
            }
            ++i;
        }
        int iw = (int)(pct * (double)wave.length);
        MwNishimae.doWeight(wave, iw);
        double[] vel = MwNishimae.doBandPass(wave, srate);
        double[] dis = MwNishimae.velocityToDistance(vel, srate);
        double amp = MwNishimae.rms(dis, mw_minute * 60 * srate, phaseIdx) / gain;
        return amp;
    }

    public static double computeMwp(double[] wave, int srate, double gain, int phaseIdx, double delta, int mw_minute, double pct) {
        double amp = MwNishimae.computeAmp(wave, srate, gain, phaseIdx, delta, mw_minute, pct);
        return MwNishimae.computeMwp(amp, delta, mw_minute);
    }

    public static double computeMwp(double amp, double delta, int mw_minute) {
        double mwp = MwNishimae.mw(amp, delta, mw_minute);
        return mwp;
    }

    private static double computeAverage(int n, double[] data) {
        double sum = 0.0;
        int nn = 0;
        int i = 0;
        while (i < n) {
            if (Math.abs(data[i]) > 1.0E-20) {
                sum += data[i];
                ++nn;
            }
            ++i;
        }
        return nn > 0 ? sum / (double)nn : 0.0;
    }

    private static void doWeight(double[] d, int iw) {
        int nwgt = 2 * iw;
        double[] wgt = new double[nwgt];
        int i = 0;
        while (i <= nwgt) {
            wgt[i] = Math.cos(Math.PI * (double)(i - iw) / (double)nwgt);
            ++i;
        }
        i = 0;
        while (i <= iw) {
            int n = i;
            d[n] = d[n] * wgt[i];
            int n2 = d.length - 1 - i;
            d[n2] = d[n2] * wgt[nwgt - i];
            ++i;
        }
    }

    private static double[] doBandPass(double[] wave, double srate) {
        Filter filter = MwNishimae.buildButterFilter(srate, "BP", 4, 0.005, 0.1);
        return filter.filter(wave);
    }

    private static double[] doBandPass_orig(double[] wave) {
        double[] vel = new double[wave.length];
        int i = 4;
        while (i < wave.length) {
            vel[i] = BAND_BC[0] * wave[i] + BAND_BC[1] * wave[i - 1] + BAND_BC[2] * wave[i - 2] + BAND_BC[3] * wave[i - 3] + BAND_BC[4] * wave[i - 4] - (BAND_AC[1] * vel[i - 1] + BAND_AC[2] * vel[i - 2] + BAND_AC[3] * vel[i - 3] + BAND_AC[4] * vel[i - 4]);
            ++i;
        }
        return vel;
    }

    private static double[] velocityToDistance(double[] vel, double srate) {
        return NumericProcess.trapezium(vel, 1.0 / srate);
    }

    private static double[] velocityToDistance_orig(double[] vel) {
        double[] dis = new double[vel.length];
        int i = 2;
        while (i < vel.length) {
            dis[i] = INT_BC[0] * vel[i] + INT_BC[1] * vel[i - 1] + INT_BC[2] * vel[i - 2] - (INT_AC[1] * dis[i - 1] + INT_AC[2] * dis[i - 2]);
            ++i;
        }
        return dis;
    }

    private static double rms(double[] dis, int len, int start) {
        double z0 = dis[start - 1];
        double zn = dis[start + len - 2];
        double ss = (z0 * z0 + zn * zn) / 2.0;
        int i = 1;
        while (i < len - 1) {
            double z = dis[start + i - 1];
            ss += z * z;
            ++i;
        }
        return Math.sqrt(ss / (double)len);
    }

    private static double mw(double amp, double delta, int i) {
        double HALF_RADIAN = Math.PI / 360;
        double dt = Math.sin(delta * HALF_RADIAN);
        if (amp <= 0.0) {
            return Double.NaN;
        }
        return MW_COEF[i][0] * Math.log10(amp) + MW_COEF[i][1] * Math.log10(dt) + MW_COEF[i][2];
    }

    private static Filter buildButterFilter(double srate, String filterType, int order, double fp1, double fp2) {
        IIRFilter iirFilter = new IIRFilter();
        iirFilter.setFilterType(filterType);
        iirFilter.setOrder(order * 2);
        iirFilter.setFreq1(fp1);
        iirFilter.setFreq2(fp2);
        iirFilter.setFreqPoints(250);
        iirFilter.setRate(srate);
        iirFilter.design();
        iirFilter.filterGain();
        double[] num = iirFilter.getNumCoeff();
        double[] den = iirFilter.getDenCoeff();
        double[] b = new double[num.length];
        System.arraycopy(num, 0, b, 0, num.length);
        double[] a = new double[den.length];
        System.arraycopy(den, 0, a, 0, den.length);
        return new Filter(b, a);
    }
}

