/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.location.Location;
import cn.org.gddsn.seis.location.StnLocation;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class NearLoc
extends Location {
    static Logger logger = Logger.getLogger(NearLoc.class);
    protected double Lon0;
    protected double Lat0;
    protected double[] locRes = new double[3];
    protected Date BaseDate;
    protected SphereUtil Tran;

    public NearLoc(Vector[] stnPhases, StnLocation[] stnLocations) {
        super(stnPhases, stnLocations);
        this.setOPoint();
        this.Tran = new SphereUtil(this.Lon0, this.Lat0);
        this.setBaseDate();
    }

    public double[] getLocRes() {
        return this.locRes;
    }

    private void setBaseDate() {
        this.BaseDate = new Date();
        int i = 0;
        while (i < this.stnPhases.length) {
            Enumeration Enu = this.stnPhases[i].elements();
            if (Enu.hasMoreElements()) {
                Phase phase = (Phase)Enu.nextElement();
                this.BaseDate.setTime(phase.getPhaseTime().getTime() - 120000L);
            }
            ++i;
        }
    }

    public int recLocationData(double[] x, double[] y, double[] arriveT, int phaseType) {
        String phaseName = "";
        switch (phaseType) {
            case 3: {
                phaseName = "PG";
                break;
            }
            case 4: {
                phaseName = "SG";
                break;
            }
            case 1: {
                phaseName = "PN";
                break;
            }
            case 2: {
                phaseName = "SN";
                break;
            }
            case 8: {
                phaseName = "P";
                break;
            }
            case 9: {
                phaseName = "S";
                break;
            }
            case 13: {
                phaseName = "Pg1";
                break;
            }
            case 14: {
                phaseName = "Sg1";
                break;
            }
            default: {
                logger.warn("Could not use unknow phase type to on location !");
                System.exit(-1);
            }
        }
        int m = 0;
        int i = 0;
        while (i < this.stnPhases.length) {
            Enumeration Enu = this.stnPhases[i].elements();
            while (Enu.hasMoreElements()) {
                Phase phase = (Phase)Enu.nextElement();
                if (!phase.getPhaseName().equals(new String(phaseName))) continue;
                x[m] = this.Tran.getX(this.stnLocations[i].getLon() * Math.PI / 180.0, this.stnLocations[i].getLat() * Math.PI / 180.0);
                y[m] = this.Tran.getY(this.stnLocations[i].getLon() * Math.PI / 180.0, this.stnLocations[i].getLat() * Math.PI / 180.0);
                arriveT[m] = (double)(phase.getPhaseTime().getTime() - this.BaseDate.getTime()) / 1000.0;
                ++m;
            }
            ++i;
        }
        return m;
    }

    public double[] getRectLocation(int stn) {
        double[] loc = new double[]{this.Tran.getX(this.stnLocations[stn].getLon() * Math.PI / 180.0, this.stnLocations[stn].getLat() * Math.PI / 180.0), this.Tran.getY(this.stnLocations[stn].getLon() * Math.PI / 180.0, this.stnLocations[stn].getLat() * Math.PI / 180.0), 0.0};
        return loc;
    }

    void setOPoint() {
        double lonSum = 0.0;
        double latSum = 0.0;
        int i = 0;
        while (i < this.stnLocations.length) {
            lonSum += this.stnLocations[i].getLon();
            latSum += this.stnLocations[i].getLat();
            ++i;
        }
        this.Lon0 = lonSum / (double)this.stnLocations.length * Math.PI / 180.0;
        this.Lat0 = latSum / (double)this.stnLocations.length * Math.PI / 180.0;
    }
}

