/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.optimization.SimplexMin;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.location.IterateNearlocL1Residual;

public final class SimplexAndL1Loc
extends IterateNearlocL1Residual {
    double OTime;

    private double getOTime() {
        double tt;
        double delta;
        int stnSum = this.getStnSum();
        double[] stnLat = new double[stnSum];
        double[] stnLon = new double[stnSum];
        double[] arriveT = new double[stnSum];
        double OTimeSum = 0.0;
        int OTimeCount = 0;
        int counts = this.getLocationData(stnLat, stnLon, arriveT, 3);
        int i = 0;
        while (i < counts) {
            delta = SphereUtil.distOnSphere(stnLat[i], stnLon[i], this.sourceParam.lat, this.sourceParam.lon);
            tt = this.computedTravelTime.calTravelTime(this.sourceParam.depth, delta, 3);
            if (!Double.isNaN(tt)) {
                OTimeSum += arriveT[i] - tt;
                ++OTimeCount;
            }
            ++i;
        }
        counts = this.getLocationData(stnLat, stnLon, arriveT, 1);
        i = 0;
        while (i < counts) {
            delta = SphereUtil.distOnSphere(stnLat[i], stnLon[i], this.sourceParam.lat, this.sourceParam.lon);
            tt = this.computedTravelTime.calTravelTime(this.sourceParam.depth, delta, 1);
            if (!Double.isNaN(tt)) {
                OTimeSum += arriveT[i] - tt;
                ++OTimeCount;
            }
            ++i;
        }
        counts = this.getLocationData(stnLat, stnLon, arriveT, 8);
        i = 0;
        while (i < counts) {
            delta = SphereUtil.distOnSphere(stnLat[i], stnLon[i], this.sourceParam.lat, this.sourceParam.lon);
            tt = this.computedTravelTime.calTravelTime(this.sourceParam.depth, delta, 8);
            if (!Double.isNaN(tt)) {
                OTimeSum += arriveT[i] - tt;
                ++OTimeCount;
            }
            ++i;
        }
        this.OTime = OTimeSum / (double)OTimeCount;
        return this.OTime;
    }

    public SourceParam getSourceParam() {
        SourceParam sp = super.getSourceParam();
        sp.setLocProgram("Simplex");
        return sp;
    }

    public boolean findSourceLoc() {
        double[] trySrc = new double[]{this.trySource.lat, this.trySource.lon, 10.0};
        double width = 0.5;
        double[][] p = new double[][]{{trySrc[0], trySrc[1], trySrc[2] - 5.0}, {trySrc[0], trySrc[1] + width, trySrc[2]}, {trySrc[0] + width, trySrc[1], trySrc[2]}, {trySrc[0] - width, trySrc[1] - width, trySrc[2]}};
        if (logger.isDebugEnabled()) {
            logger.debug(p[0][0] + "," + p[0][1] + "," + p[0][2]);
            logger.debug(p[1][0] + "," + p[1][1] + "," + p[1][2]);
            logger.debug(p[2][0] + "," + p[2][1] + "," + p[2][2]);
            logger.debug(p[3][0] + "," + p[3][1] + "," + p[3][2]);
        }
        SimplexMin simplexMin = new SimplexMin(p, 3, 1.0E-6);
        simplexMin.setFunk(this);
        simplexMin.SearchMin();
        double Len = p.length;
        double lat = 0.0;
        double lon = 0.0;
        double depth = 0.0;
        int i = 0;
        while (i < p.length) {
            lat += p[i][0] / Len;
            lon += p[i][1] / Len;
            depth += p[i][2] / Len;
            ++i;
        }
        if (depth < 0.0) {
            depth = 10.0;
        }
        this.sourceParam.lat = lat;
        this.sourceParam.lon = lon;
        this.sourceParam.depth = depth;
        this.sourceParam.rms = simplexMin.getResidual();
        this.sourceParam.originTime.setTime(this.BaseDate.getTime() + Math.round(this.getOTime() * 1000.0));
        return true;
    }
}

