/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.linalg.Distance;
import cn.org.gddsn.optimization.SimplexMin;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.location.CalMagnitude;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.location.MagnitudeInf;
import cn.org.gddsn.seis.location.NearLoc;
import cn.org.gddsn.seis.location.StnLocation;
import java.util.Vector;

public class SimplexLoc
extends NearLoc {
    ComputedTravelTime compTT;
    double[] trySrc;
    public static final int PG = 0;
    public static final int PGandSG = 1;
    public static final int ALL = 5;
    int usePhaseType = 5;
    int stnSum = 40;
    double residual;
    double OTime;
    private MagnitudeInf magnitudeInf = new CalMagnitude();

    public SimplexLoc(Vector[] stnPhases, StnLocation[] stnLocations, ComputedTravelTime newcompTT, double[] newtrySrc) {
        super(stnPhases, stnLocations);
        this.compTT = newcompTT;
        this.trySrc = newtrySrc;
        this.stnSum = stnLocations.length;
    }

    public void useWhatPhase(int type) {
        this.usePhaseType = type;
    }

    public double getResidual() {
        return this.residual;
    }

    public MagnitudeInf getMagnitudeInf() {
        return this.magnitudeInf;
    }

    private double getOTime() {
        double[] stnX = new double[this.stnSum];
        double[] stnY = new double[this.stnSum];
        double[] arriveT = new double[this.stnSum];
        double[] stn = new double[3];
        double OTimeSum = 0.0;
        int OTimeCount = 0;
        int counts = this.recLocationData(stnX, stnY, arriveT, 3);
        OTimeCount += counts;
        int i = 0;
        while (i < counts) {
            stn[0] = stnX[i];
            stn[1] = stnY[i];
            stn[2] = 0.0;
            OTimeSum += arriveT[i] - this.compTT.calTravelTime(this.locRes, stn, 3);
            ++i;
        }
        counts = this.recLocationData(stnX, stnY, arriveT, 1);
        OTimeCount += counts;
        i = 0;
        while (i < counts) {
            stn[0] = stnX[i];
            stn[1] = stnY[i];
            stn[2] = 0.0;
            OTimeSum += arriveT[i] - this.compTT.calTravelTime(this.locRes, stn, 1);
            ++i;
        }
        this.OTime = OTimeSum / (double)OTimeCount;
        return this.OTime;
    }

    private double getML() {
        double MLSum = 0.0;
        int MLCounts = 0;
        int i = 0;
        while (i < this.stnPhases.length) {
            block7: {
                double amp;
                block4: {
                    Phase phaseZ;
                    block6: {
                        Phase phaseN;
                        Phase phaseE;
                        block5: {
                            block3: {
                                amp = 0.0;
                                phaseZ = this.getPhase(i, "SMZ");
                                phaseE = this.getPhase(i, "SME");
                                phaseN = this.getPhase(i, "SMN");
                                if (phaseE != null || phaseN == null) break block3;
                                amp = phaseN.getPeriod() * phaseN.getAmp() / (Math.PI * 2);
                                break block4;
                            }
                            if (phaseE == null || phaseN != null) break block5;
                            amp = phaseE.getPeriod() * phaseE.getAmp() / (Math.PI * 2);
                            break block4;
                        }
                        if (phaseE == null || phaseN == null) break block6;
                        amp = (phaseN.getPeriod() * phaseN.getAmp() + phaseE.getPeriod() * phaseE.getAmp()) / (Math.PI * 2) / 2.0;
                        break block4;
                    }
                    if (phaseZ == null) break block7;
                    amp = phaseZ.getPeriod() * phaseZ.getAmp() / (Math.PI * 2);
                }
                double delta = Distance.norm(this.getRectLocation(i), this.getLocRes(), 2);
                MLSum += this.magnitudeInf.getML(amp, delta);
                ++MLCounts;
            }
            ++i;
        }
        return MLSum / (double)MLCounts;
    }

    public void findSourceLoc() {
        double[][] p = new double[][]{{this.trySrc[0], this.trySrc[1], this.trySrc[2] - 5.0}, {this.trySrc[0], this.trySrc[1] + 50.0, this.trySrc[2]}, {this.trySrc[0] + 50.0, this.trySrc[1], this.trySrc[2]}, {this.trySrc[0] - 50.0, this.trySrc[1] - 50.0, this.trySrc[2]}};
        ErrorMin aErrorMin = new ErrorMin(p, 3, 1.0E-6);
        aErrorMin.SearchMin();
        double Len = p.length;
        double lon = 0.0;
        double lat = 0.0;
        double depth = 0.0;
        int i = 0;
        while (i < p.length) {
            lon += p[i][0] / Len;
            lat += p[i][1] / Len;
            depth += p[i][2] / Len;
            ++i;
        }
        this.locRes[0] = lon;
        this.locRes[1] = lat;
        this.locRes[2] = depth;
        this.source.lon = this.Tran.getLon(lon, lat) / Math.PI * 180.0;
        this.source.lat = this.Tran.getLat(lon, lat) / Math.PI * 180.0;
        this.source.depth = depth;
        this.source.rms = this.residual;
        this.source.originTime.setTime(this.BaseDate.getTime() + Math.round(this.getOTime() * 1000.0));
        this.source.ml = this.getML();
        this.LocationSuccess = true;
    }

    public void setMagnitudeInf(MagnitudeInf magnitudeInf) {
        this.magnitudeInf = magnitudeInf;
    }

    class ErrorMin
    extends SimplexMin {
        int phsCnts;
        double arrivedSum;
        double travelsum;
        double[] T;
        double[] stnX;
        double[] stnY;
        double[] arriveT;
        double[] stn;

        ErrorMin(double[][] p, int ndim, double ftol) {
            super(p, ndim, ftol);
            this.arrivedSum = 0.0;
            this.travelsum = 0.0;
            this.stn = new double[3];
            this.T = new double[SimplexLoc.this.stnSum];
            this.stnX = new double[SimplexLoc.this.stnSum];
            this.stnY = new double[SimplexLoc.this.stnSum];
            this.arriveT = new double[SimplexLoc.this.stnSum];
        }

        private double oneErrorSum(double[] x, int phaseType) {
            this.phsCnts = SimplexLoc.this.recLocationData(this.stnX, this.stnY, this.arriveT, phaseType);
            if (this.phsCnts == 0) {
                return 0.0;
            }
            int i = 0;
            while (i < this.phsCnts) {
                this.stn[0] = this.stnX[i];
                this.stn[1] = this.stnY[i];
                this.stn[2] = 0.0;
                this.T[i] = SimplexLoc.this.compTT.calTravelTime(x, this.stn, phaseType);
                ++i;
            }
            double errorSum = 0.0;
            double error = 0.0;
            int i2 = 0;
            while (i2 < this.phsCnts) {
                error = Math.abs(this.arriveT[i2] - this.T[i2]);
                errorSum += error;
                ++i2;
            }
            return errorSum / (double)this.phsCnts;
        }

        private void doSumStempOne(double[] x, int phaseType) {
            int counts = SimplexLoc.this.recLocationData(this.stnX, this.stnY, this.arriveT, phaseType);
            this.phsCnts += counts;
            int i = 0;
            while (i < counts) {
                this.stn[0] = this.stnX[i];
                this.stn[1] = this.stnY[i];
                this.stn[2] = 0.0;
                this.T[i] = SimplexLoc.this.compTT.calTravelTime(x, this.stn, phaseType);
                this.arrivedSum += this.arriveT[i];
                this.travelsum += this.T[i];
                ++i;
            }
        }

        void doSum(double[] x) {
            this.phsCnts = 0;
            this.arrivedSum = 0.0;
            this.travelsum = 0.0;
            switch (SimplexLoc.this.usePhaseType) {
                case 0: {
                    this.doSumStempOne(x, 3);
                    break;
                }
                case 1: {
                    this.doSumStempOne(x, 3);
                    this.doSumStempOne(x, 4);
                    break;
                }
                case 5: {
                    this.doSumStempOne(x, 3);
                    this.doSumStempOne(x, 4);
                    this.doSumStempOne(x, 1);
                    this.doSumStempOne(x, 2);
                    this.doSumStempOne(x, 13);
                    this.doSumStempOne(x, 14);
                }
            }
        }

        double oneAvgErrorSum(double[] x, int phaseType) {
            int counts = SimplexLoc.this.recLocationData(this.stnX, this.stnY, this.arriveT, phaseType);
            if (counts == 0) {
                return 0.0;
            }
            int i = 0;
            while (i < counts) {
                this.stn[0] = this.stnX[i];
                this.stn[1] = this.stnY[i];
                this.stn[2] = 0.0;
                this.T[i] = SimplexLoc.this.compTT.calTravelTime(x, this.stn, phaseType);
                ++i;
            }
            double errorSum = 0.0;
            double error = 0.0;
            int i2 = 0;
            while (i2 < counts) {
                error = Math.abs(this.arriveT[i2] - this.arrivedSum / (double)this.phsCnts - (this.T[i2] - this.travelsum / (double)this.phsCnts));
                errorSum += error;
                ++i2;
            }
            return errorSum / (double)this.phsCnts;
        }

        public double funk(double[] x) {
            double retVal = 0.0;
            this.doSum(x);
            switch (SimplexLoc.this.usePhaseType) {
                case 0: {
                    retVal = this.oneAvgErrorSum(x, 3);
                    break;
                }
                case 1: {
                    retVal = this.oneAvgErrorSum(x, 3);
                    retVal += this.oneAvgErrorSum(x, 4);
                    break;
                }
                case 5: {
                    retVal = this.oneAvgErrorSum(x, 3);
                    retVal += this.oneAvgErrorSum(x, 4);
                    retVal += this.oneAvgErrorSum(x, 1);
                    retVal += this.oneAvgErrorSum(x, 2);
                    retVal += this.oneAvgErrorSum(x, 13);
                    retVal += this.oneAvgErrorSum(x, 14);
                }
            }
            SimplexLoc.this.residual = retVal;
            return retVal;
        }
    }
}

