/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.locsat;

import org.apache.log4j.Logger;

public class Interpolation {
    static Logger logger = Logger.getLogger(Interpolation.class);

    private Interpolation() {
    }

    public static float splint(float[] xa, float[] ya, float[] y2a, int n, float x) {
        int klo = 1;
        int khi = n;
        while (khi - klo > 1) {
            int k = khi + klo >> 1;
            if (xa[k] > x) {
                khi = k;
                continue;
            }
            klo = k;
        }
        float h = xa[khi] - xa[klo];
        float a = (xa[khi] - x) / h;
        float b = (x - xa[klo]) / h;
        float y = a * ya[klo] + b * ya[khi] + ((a * a * a - a) * y2a[klo] + (b * b * b - b) * y2a[khi]) * (h * h) / 6.0f;
        return y;
    }

    public static void spline(float[] x, float[] y, int n, float yp1, float ypn, float[] y2) {
        float qn;
        float un;
        float[] u = new float[n];
        if ((double)yp1 > 9.9E29) {
            u[1] = 0.0f;
            y2[1] = 0.0f;
        } else {
            y2[1] = -0.5f;
            u[1] = 3.0f / (x[2] - x[1]) * ((y[2] - y[1]) / (x[2] - x[1]) - yp1);
        }
        int i = 2;
        while (i <= n - 1) {
            float sig = (x[i] - x[i - 1]) / (x[i + 1] - x[i - 1]);
            float p = sig * y2[i - 1] + 2.0f;
            y2[i] = (sig - 1.0f) / p;
            u[i] = (y[i + 1] - y[i]) / (x[i + 1] - x[i]) - (y[i] - y[i - 1]) / (x[i] - x[i - 1]);
            u[i] = (6.0f * u[i] / (x[i + 1] - x[i - 1]) - sig * u[i - 1]) / p;
            ++i;
        }
        if ((double)ypn > 9.9E29) {
            un = 0.0f;
            qn = 0.0f;
        } else {
            qn = 0.5f;
            un = 3.0f / (x[n] - x[n - 1]) * (ypn - (y[n] - y[n - 1]) / (x[n] - x[n - 1]));
        }
        y2[n] = (un - qn * u[n - 1]) / (qn * y2[n - 1] + 1.0f);
        int k = n;
        while (k >= 1) {
            y2[k] = y2[k] * y2[k + 1] + u[k];
            --k;
        }
    }

    public void splie2(float[] x1a, float[] x2a, float[][] ya, int m, int n, float[][] y2a) {
        int j = 1;
        while (j <= m) {
            Interpolation.spline(x2a, ya[j], n, 1.0E30f, 1.0E30f, y2a[j]);
            ++j;
        }
    }

    void ratint(double[] xa, double[] ya, int n, double x, double[] y, double[] dy) {
        double TINY = 1.0E-25;
        int ns = 1;
        double[] c = new double[n + 1];
        double[] d = new double[n + 1];
        double hh = Math.abs(x - xa[1]);
        int i = 1;
        while (i <= n) {
            double h = Math.abs(x - xa[i]);
            if (h == 0.0) {
                y[0] = ya[i];
                dy[0] = 0.0;
                return;
            }
            if (h < hh) {
                ns = i;
                hh = h;
            }
            c[i] = ya[i];
            d[i] = ya[i] + TINY;
            ++i;
        }
        y[0] = ya[ns--];
        int m = 1;
        while (m < n) {
            int i2 = 1;
            while (i2 <= n - m) {
                double w = c[i2 + 1] - d[i2];
                double h = xa[i2 + m] - x;
                double t = (xa[i2] - x) * d[i2] / h;
                double dd = t - c[i2 + 1];
                if (dd == 0.0) {
                    logger.warn("Error in routine, RATINT");
                    return;
                }
                dd = w / dd;
                d[i2] = c[i2 + 1] * dd;
                c[i2] = t * dd;
                ++i2;
            }
            dy[0] = 2 * ns < n - m ? c[ns + 1] : d[ns--];
            y[0] = y[0] + dy[0];
            ++m;
        }
    }

    public static float splin2(float[] x1a, float[] x2a, float[][] ya, float[][] y2a, int m, int n, int x1, int x2) {
        float[] ytmp = new float[n + 1];
        float[] yytmp = new float[n + 1];
        int j = 1;
        while (j <= m) {
            yytmp[j] = Interpolation.splint(x2a, ya[j], y2a[j], n, x2);
            ++j;
        }
        Interpolation.spline(x1a, yytmp, m, 1.0E30f, 1.0E30f, ytmp);
        float y = Interpolation.splint(x1a, yytmp, ytmp, m, x1);
        return y;
    }
}

