/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.locsat.libloc;

import cn.org.gddsn.seis.location.locsat.libloc.Dsvdc;
import org.netlib.util.doubleW;
import org.netlib.util.floatW;
import org.netlib.util.intW;

public class LocUtil {
    public static final int MAX_PARAM = 4;
    public static final int MAX_DATA = 1200;
    public static final int MAX_STA = 1200;
    public static final int MAXTYP = 3;
    public static final double COND_NUM_LIMIT = 30000.0;
    public static final int maxdata = 1200;

    public static void azcal(float radius, float delta, float azi, float baz, floatW dcalx, double[] atx) {
        double azir = (double)azi * 0.0174532925239284;
        double rt = Math.sin((double)delta * 0.0174532925239284) * (double)radius * 0.0174532925239284;
        if (rt == 0.0) {
            rt = 1.0E-4;
        }
        dcalx.val = baz;
        atx[0] = 0.0;
        atx[1] = -Math.cos(azir) / rt;
        atx[2] = Math.sin(azir) / rt;
        atx[3] = 0.0;
    }

    public static void fstatx(int m, int n, float p, doubleW x) {
        int j = 0;
        int[] ns = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 14, 16, 18, 20, 25, 30, 40, 60, 120};
        double[] ps = new double[]{0.9, 0.95, 0.99};
        double[][] xs = new double[][]{{39.86, 8.53, 5.54, 4.54, 4.06, 3.78, 3.59, 3.46, 3.36, 3.29, 3.18, 3.1, 3.05, 3.01, 2.97, 2.92, 2.88, 2.84, 2.79, 2.75, 2.71}, {49.5, 9.0, 5.46, 4.32, 3.78, 3.46, 3.26, 3.11, 3.01, 2.92, 2.81, 2.73, 2.67, 2.62, 2.59, 2.53, 2.49, 2.44, 2.39, 2.35, 2.3}, {53.59, 9.16, 5.39, 4.19, 3.62, 3.29, 3.07, 2.92, 2.81, 2.73, 2.61, 2.52, 2.46, 2.42, 2.38, 2.32, 2.28, 2.23, 2.18, 2.13, 2.08}};
        x.val = 0.0;
        if (m < 1 || m > 3) {
            return;
        }
        if (n < 1) {
            x.val = 1000.0;
            return;
        }
        double dp = Math.abs((double)p - ps[0]);
        if (dp > 0.001) {
            return;
        }
        int i = 19;
        while (i >= 0) {
            if (n >= ns[i]) {
                j = i;
                break;
            }
            --i;
        }
        if (n != ns[j]) {
            double an1 = ns[j];
            double an2 = j < 19 ? (double)ns[j + 1] : (double)(n + 1000);
            double an = n;
            double y1 = an1 / (1.0 + an1);
            double y2 = an2 / (1.0 + an2);
            double y = an / (1.0 + an);
            double x1 = xs[m - 1][j];
            double x2 = xs[m - 1][j + 1];
            x.val = x1 + (x2 - x1) * ((y - y1) / (y2 - y1));
        } else {
            x.val = xs[m - 1][j];
        }
    }

    public static void index_array(intW n, double[] arrin, int[] indx) {
        double[] _arrin = new double[n.val + 1];
        int[] _indx = new int[n.val + 1];
        System.arraycopy(arrin, 0, _arrin, 1, n.val);
        System.arraycopy(indx, 0, _indx, 1, n.val);
        LocUtil.indexx(n, _arrin, _indx);
        System.arraycopy(_arrin, 1, arrin, 0, n.val);
        System.arraycopy(_indx, 1, indx, 0, n.val);
    }

    private static void indexx(intW n, double[] arrin, int[] indx) {
        int j = 1;
        while (j <= n.val) {
            indx[j] = j;
            ++j;
        }
        int l = (n.val >> 1) + 1;
        int ir = n.val;
        while (true) {
            double q;
            int indxt;
            if (l > 1) {
                indxt = indx[--l];
                q = arrin[indxt];
            } else {
                indxt = indx[ir];
                q = arrin[indxt];
                indx[ir] = indx[1];
                if (--ir == 1) {
                    indx[1] = indxt;
                    return;
                }
            }
            int i = l;
            j = l << 1;
            while (j <= ir) {
                if (j < ir && arrin[indx[j]] < arrin[indx[j + 1]]) {
                    ++j;
                }
                if (q < arrin[indx[j]]) {
                    indx[i] = indx[j];
                    i = j;
                    j += i;
                    continue;
                }
                j = ir + 1;
            }
            indx[i] = indxt;
        }
    }

    public static int MIN(int a, int b) {
        return a <= b ? a : b;
    }

    public static int solve_via_svd(int icov, int nd, int np, int maxp, double[] at, double[] d, float damp, doubleW cnvgtst, double[] condit, double[] xsol, double[] covar, float[] epimp, doubleW rank, intW ierr) {
        double sum;
        int icnt;
        double dscale;
        double[] e = new double[nd];
        double[] g = new double[4 * nd];
        double[] u = new double[16];
        double[] v = new double[1200 * nd];
        int M = 4;
        int N = nd;
        double[] work = new double[Math.max(3 * Math.min(M, N) + Math.max(M, N), 5 * Math.min(M, N))];
        double[] tmp = new double[4];
        double[] gscale = new double[4];
        double[] gtr = new double[4];
        double[] sval = new double[4 * nd];
        int norder = LocUtil.MIN(np, nd);
        int job = 21;
        intW info = new intW(0);
        int j = 0;
        while (j < np) {
            gscale[j] = 0.0;
            ++j;
        }
        int i = 0;
        while (i < nd) {
            j = 0;
            while (j < np) {
                dscale = at[j + i * maxp];
                int n = j++;
                gscale[n] = gscale[n] + dscale * dscale;
            }
            ++i;
        }
        j = 0;
        while (j < np) {
            gscale[j] = 1.0 / Math.sqrt(gscale[j]);
            ++j;
        }
        i = 0;
        while (i < nd) {
            j = 0;
            while (j < np) {
                g[j + i * maxp] = at[j + i * maxp] * gscale[j];
                ++j;
            }
            ++i;
        }
        double frob = 0.0;
        double rnorm = 0.0;
        double gtrnorm = 0.0;
        i = 0;
        while (i < nd) {
            rnorm += d[i] * d[i];
            j = 0;
            while (j < np) {
                dscale = g[j + i * maxp];
                frob += dscale * dscale;
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < np) {
            gtr[j] = 0.0;
            i = 0;
            while (i < nd) {
                gtr[j] = gtr[j] + g[j + i * maxp] * d[i];
                ++i;
            }
            gtrnorm += gtr[j] * gtr[j];
            ++j;
        }
        cnvgtst.val = gtrnorm / (frob * rnorm);
        Dsvdc.dsvdc(g, 0, maxp, np, nd, sval, 0, e, 0, u, 0, maxp, v, 0, 1200, work, 0, job, info);
        if (info.val >= norder) {
            ierr.val = 6;
            return 0;
        }
        int neig = norder - info.val;
        double smax = sval[info.val];
        j = info.val + 1;
        while (j < norder) {
            if (smax / sval[j] > 30000.0) {
                neig = j - 1;
                break;
            }
            ++j;
        }
        condit[0] = sval[info.val] / sval[norder - 1];
        condit[1] = sval[info.val] / sval[info.val + 1 + (neig - 1) - 1];
        if ((double)damp < 0.0) {
            if (condit[0] > 30.0) {
                icnt = info.val + 1 + (neig - 1);
                double applied_damping = 0.01;
                if (condit[0] > 300.0) {
                    applied_damping = 0.05;
                }
                if (condit[0] > 3000.0) {
                    applied_damping = 0.1;
                }
                i = info.val;
                while (i < icnt) {
                    int n = i++;
                    sval[n] = sval[n] + smax * applied_damping;
                }
            }
        } else {
            icnt = info.val + 1 + (neig - 1);
            i = info.val;
            while (i < icnt) {
                int n = i++;
                sval[n] = sval[n] + smax * (double)damp * 0.01;
            }
        }
        icnt = info.val + 1 + (neig - 1);
        j = info.val;
        while (j < icnt) {
            sum = 0.0;
            i = 0;
            while (i < nd) {
                sum += v[i * 1200 + j] * d[i];
                ++i;
            }
            tmp[j] = sum / sval[j];
            ++j;
        }
        j = 0;
        while (j < np) {
            sum = 0.0;
            icnt = info.val + 1 + (neig - 1);
            i = info.val;
            while (i < icnt) {
                sum += u[j + i * maxp] * tmp[i];
                ++i;
            }
            xsol[j] = sum * gscale[j];
            ++j;
        }
        if (icov < 2) {
            return 0;
        }
        icnt = info.val + 1 + (neig - 1);
        i = info.val;
        while (i < icnt) {
            sval[i] = 1.0 / (sval[i] * sval[i]);
            ++i;
        }
        i = 0;
        while (i < np) {
            j = 0;
            while (j <= i) {
                sum = 0.0;
                icnt = info.val + 1 + (neig - 1);
                int k = info.val;
                while (k < icnt) {
                    sum += u[i + k * maxp] * u[j + k * maxp] * sval[k];
                    ++k;
                }
                covar[i + j * maxp] = sum * gscale[j] * gscale[i];
                covar[j + i * maxp] = covar[i + j * maxp];
                ++j;
            }
            ++i;
        }
        rank.val = 0.0;
        i = 0;
        while (i < nd) {
            sum = 0.0;
            j = 0;
            while (j < np) {
                icnt = i * 1200 + j;
                sum += v[icnt] * v[icnt];
                ++j;
            }
            rank.val += sum;
            epimp[i] = (float)sum;
            ++i;
        }
        return 0;
    }

    public static void denuis(int[] idtyp, int nd, int np, double[] resid, double[] dsd, double[] at, doubleW dmean, intW inerr) {
        double[] amean = new double[4];
        inerr.val = 0;
        dmean.val = 0.0;
        double asum = 0.0;
        int m = 0;
        while (m < np) {
            amean[m] = 0.0;
            ++m;
        }
        int n = 0;
        while (n < nd) {
            double dacc = 1.0 / (dsd[n] * dsd[n]);
            if (idtyp[n] == 1) {
                m = 1;
                while (m < np) {
                    amean[m] = amean[m] + dacc * at[n * 4 + m];
                    ++m;
                }
                asum += dacc;
                dmean.val += dacc * resid[n];
            }
            ++n;
        }
        if (asum > 0.0) {
            m = 1;
            while (m < np) {
                amean[m] = amean[m] / asum;
                ++m;
            }
            dmean.val /= asum;
            n = 0;
            while (n < nd) {
                if (idtyp[n] == 1) {
                    m = 1;
                    while (m < np) {
                        at[n * 4 + m] = at[n * 4 + m] - amean[m];
                        ++m;
                    }
                    resid[n] = resid[n] - dmean.val;
                }
                ++n;
            }
        } else {
            inerr.val = 1;
        }
    }

    public static void ellips(int np, double[] covar, doubleW hymaj, doubleW hymid, doubleW hymin, doubleW hystr, doubleW hyplu, doubleW hyrak, doubleW epmaj, doubleW epmin, floatW epstr, doubleW zfint, floatW stt, floatW stx, floatW sty, floatW sxx, floatW sxy, floatW syy, floatW stz, floatW sxz, floatW syz, floatW szz) {
        double TWOPI = Math.PI * 2;
        stt.val = (float)covar[0];
        stx.val = (float)covar[1];
        sty.val = (float)covar[2];
        sxx.val = (float)covar[5];
        sxy.val = (float)covar[6];
        syy.val = (float)covar[10];
        if (np != 4) {
            stz.val = 0.0f;
            sxz.val = 0.0f;
            syz.val = 0.0f;
            szz.val = 0.0f;
        } else {
            stz.val = (float)covar[3];
            sxz.val = (float)covar[7];
            syz.val = (float)covar[11];
            szz.val = (float)covar[15];
        }
        double twosxy = 2.0 * (double)sxy.val;
        double epstrr = twosxy != 0.0 ? 0.5 * Math.atan2(twosxy, syy.val - sxx.val) : 0.0;
        double c = Math.cos(epstrr);
        double s = Math.sin(epstrr);
        double cc = c * c;
        double ss = s * s;
        double sxytcs = twosxy * c * s;
        double a2 = (double)sxx.val * ss + sxytcs + (double)syy.val * cc;
        double b2 = (double)sxx.val * cc - sxytcs + (double)syy.val * ss;
        if (epstrr < 0.0) {
            epstrr += TWOPI;
        }
        if (epstrr > TWOPI) {
            epstrr -= TWOPI;
        }
        if (epstrr > Math.PI) {
            epstrr -= Math.PI;
        }
        epmaj.val = a2 < 0.0 ? -1.0 : Math.sqrt(a2);
        epmin.val = b2 < 0.0 ? -1.0 : Math.sqrt(b2);
        epstr.val = (float)(57.2957795 * epstrr);
        zfint.val = (double)szz.val < 0.0 ? -1.0 : Math.sqrt(szz.val);
    }

    public static void check_data(String[] data_sta_id, String[] data_phase_type, String[] data_type, float[] data_std_err, int num_data, String[] sta_id, int num_sta, String[] phase_type, int num_phase_types, int[] sta_index, int[] ipwav, int[] idtyp, int[] data_error_code) {
        int n = 0;
        while (n < num_data) {
            sta_index[n] = 0;
            ipwav[n] = 0;
            idtyp[n] = 0;
            int i = 0;
            while (i < num_sta) {
                if (data_sta_id[n].trim().equals(sta_id[i].trim())) {
                    data_error_code[n] = 0;
                    sta_index[n] = i + 1;
                    int len_d_p_t = 0;
                    while (len_d_p_t < data_phase_type[n].length()) {
                        if (data_phase_type[n].charAt(len_d_p_t) == ' ') break;
                        ++len_d_p_t;
                    }
                    boolean gotoFlag = false;
                    int j = 0;
                    while (j < num_phase_types) {
                        int len_pt = 0;
                        while (len_pt < phase_type[j].length()) {
                            if (phase_type[j].charAt(len_pt) == '\u0000') break;
                            ++len_pt;
                        }
                        if (data_phase_type[n].trim().equals(phase_type[j].trim())) {
                            ipwav[n] = j + 1;
                            if (data_type[n].trim().equals("t")) {
                                idtyp[n] = 1;
                            } else if (data_type[n].trim().equals("a")) {
                                idtyp[n] = 2;
                            } else if (data_type[n].trim().equals("s")) {
                                idtyp[n] = 3;
                            } else {
                                idtyp[n] = 0;
                                data_error_code[n] = 3;
                            }
                            if ((double)data_std_err[n] < 0.0) {
                                data_error_code[n] = 4;
                            }
                            gotoFlag = true;
                            break;
                        }
                        ++j;
                    }
                    if (gotoFlag) break;
                    if (data_type[n].trim().equals("t")) {
                        idtyp[n] = 1;
                        data_error_code[n] = 2;
                        break;
                    }
                    if (data_type[n].trim().equals("s")) {
                        idtyp[n] = 3;
                        data_error_code[n] = 2;
                    } else if (data_type[n].trim().equals("a")) {
                        idtyp[n] = 2;
                    } else {
                        idtyp[n] = 0;
                        data_error_code[n] = 3;
                    }
                    if (!((double)data_std_err[n] < 0.0)) break;
                    data_error_code[n] = 4;
                    break;
                }
                data_error_code[n] = 1;
                ++i;
            }
            ++n;
        }
    }
}

