/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor.edas.awt;

import cn.org.gddsn.liss.port.edas.Edas24IPIO;
import cn.org.gddsn.seis.monitor.edas.Controler;
import cn.org.gddsn.seis.monitor.edas.awt.Das_jButtonCanel_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.Das_jButtonGet_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.Das_jButtonSet_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.EdasFrame;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import org.apache.log4j.Logger;

public class DasDialog
extends Dialog {
    static Logger logger = Logger.getLogger(DasDialog.class);
    Panel panel1 = new Panel();
    BorderLayout borderLayout1 = new BorderLayout();
    Panel jPanel1 = new Panel();
    Panel jPanel2 = new Panel();
    Button jButtonCanel = new Button();
    Button jButtonGet = new Button();
    GridLayout gridLayout1 = new GridLayout();
    Panel jPanel3 = new Panel();
    Panel jPanel4 = new Panel();
    Label jLabel1 = new Label();
    Choice jComboBoxSensor = new Choice();
    Label jLabel2 = new Label();
    Choice jComboBoxSampRate = new Choice();
    Checkbox jRadioButtonLinear = new Checkbox();
    Checkbox jRadioButtonMin = new Checkbox();
    CheckboxGroup buttonGroup1 = new CheckboxGroup();
    GridLayout gridLayout2 = new GridLayout();
    Button jButtonSet = new Button();
    Panel jPanel5 = new Panel();
    Panel jPanel6 = new Panel();
    Label jLabel3 = new Label();
    Choice jList1 = new Choice();
    Checkbox jRadioButtonV10 = new Checkbox();
    Checkbox jRadioButtonV20 = new Checkbox();
    CheckboxGroup buttonGroup2 = new CheckboxGroup();
    GridLayout gridLayout3 = new GridLayout();
    GridLayout gridLayout4 = new GridLayout();
    GridLayout gridLayout5 = new GridLayout();

    public DasDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.enableEvents(64L);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.toGUI();
    }

    public DasDialog() {
        this(new Frame(), "DAS Set", false);
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.jButtonCanel.setLabel("Cancel");
        this.jButtonCanel.addActionListener(new Das_jButtonCanel_actionAdapter(this));
        this.jButtonGet.setLabel("Get");
        this.jButtonGet.addActionListener(new Das_jButtonGet_actionAdapter(this));
        this.jPanel1.setLayout(this.gridLayout1);
        this.jPanel3.setLayout(this.gridLayout2);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(4);
        this.jLabel1.setText("Sensor:");
        this.jLabel2.setText("Sample Rate:");
        this.jRadioButtonLinear.setState(true);
        this.jRadioButtonLinear.setLabel("Linear");
        this.jRadioButtonMin.setLabel("Minimum");
        String[] mode2 = new String[]{"1:1sps", "2:10sps", "3:20sps", "4:50sps", "5:100sps", "6:125sps", "7:200sps", "8:500sps"};
        int i = 0;
        while (i < mode2.length) {
            this.jComboBoxSampRate.addItem(mode2[i]);
            ++i;
        }
        String[] mode3 = new String[]{"0:DC", "1:10S", "2:30S", "3:100S", "4:300S", "5:1000S", "6:3000S"};
        int i2 = 0;
        while (i2 < mode3.length) {
            this.jList1.addItem(mode3[i2]);
            ++i2;
        }
        this.jComboBoxSensor.addItem("Sensor A");
        this.gridLayout2.setColumns(2);
        this.gridLayout2.setRows(2);
        this.jButtonSet.setLabel("Set");
        this.jButtonSet.addActionListener(new Das_jButtonSet_actionAdapter(this));
        this.jLabel3.setText("Cut Freq:");
        this.jRadioButtonV10.setState(true);
        this.jRadioButtonV10.setLabel("10V");
        this.jRadioButtonV20.setLabel("20V");
        this.jPanel4.setLayout(this.gridLayout3);
        this.jPanel5.setLayout(this.gridLayout4);
        this.jPanel6.setLayout(this.gridLayout5);
        this.add(this.panel1);
        this.panel1.add((Component)this.jPanel1, "Center");
        this.jPanel1.add(this.jPanel3);
        this.jPanel3.add(this.jLabel1);
        this.jPanel3.add(this.jComboBoxSensor);
        this.jPanel3.add(this.jLabel2);
        this.jPanel3.add(this.jComboBoxSampRate);
        this.jPanel1.add(this.jPanel4);
        this.jPanel1.add(this.jPanel5);
        this.jPanel5.add(this.jRadioButtonV10);
        this.jPanel5.add(this.jRadioButtonV20);
        this.jPanel1.add(this.jPanel6);
        this.jPanel6.add(this.jLabel3);
        this.jPanel6.add(this.jList1);
        this.jPanel4.add(this.jRadioButtonLinear);
        this.jPanel4.add(this.jRadioButtonMin);
        this.jRadioButtonLinear.setCheckboxGroup(this.buttonGroup1);
        this.jRadioButtonMin.setCheckboxGroup(this.buttonGroup1);
        this.jRadioButtonV10.setCheckboxGroup(this.buttonGroup2);
        this.jRadioButtonV20.setCheckboxGroup(this.buttonGroup2);
        this.panel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add(this.jButtonSet);
        this.jPanel2.add(this.jButtonGet);
        this.jPanel2.add(this.jButtonCanel);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    public void jButtonGet_actionPerformed(ActionEvent e) {
        this.toGUI();
    }

    public void jButtonSet_actionPerformed(ActionEvent e) {
        this.toModel();
        this.dispose();
    }

    public void jButtonCanel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void toGUI() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            Edas24IPIO.Frame frm = edasIO.inquire(0, 5);
            Edas24IPIO.SAMPLE_RATE info = (Edas24IPIO.SAMPLE_RATE)frm.body;
            if (info.phase.get() == 4) {
                this.jRadioButtonLinear.setState(true);
            } else {
                this.jRadioButtonMin.setState(true);
            }
            this.jComboBoxSampRate.select(info.samrate.get() - 1);
            frm = edasIO.inquire(0, 3);
            Edas24IPIO.HI_FILTER filter = (Edas24IPIO.HI_FILTER)frm.body;
            this.jList1.select(filter.lowcut.get());
            frm = edasIO.inquire(0, 7);
            Edas24IPIO.INPUT_CONTROL input = (Edas24IPIO.INPUT_CONTROL)frm.body;
            if (input.range.get() == 0) {
                this.jRadioButtonV10.setState(true);
            } else {
                this.jRadioButtonV20.setState(true);
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
            frame.enableGUI(false);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }

    private void toModel() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            Edas24IPIO.SAMPLE_RATE info = new Edas24IPIO.SAMPLE_RATE();
            byte selected = this.jRadioButtonLinear.getState() ? (byte)4 : 8;
            info.phase.set(selected);
            info.samrate.set((byte)(this.jComboBoxSampRate.getSelectedIndex() + 1));
            edasIO.config(0, 5, info);
            Edas24IPIO.HI_FILTER filter = new Edas24IPIO.HI_FILTER();
            filter.lowcut.set((short)this.jList1.getSelectedIndex());
            edasIO.config(0, 3, filter);
            Edas24IPIO.INPUT_CONTROL input = new Edas24IPIO.INPUT_CONTROL();
            if (this.jRadioButtonV10.getState()) {
                input.range.set((short)0);
            } else {
                input.range.set((short)1);
            }
            filter.lowcut.set((short)this.jList1.getSelectedIndex());
            edasIO.config(0, 7, input);
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
            frame.enableGUI(false);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }
}

