/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor.edas.awt;

import cn.org.gddsn.liss.port.edas.Edas24IPIO;
import cn.org.gddsn.seis.monitor.edas.Controler;
import cn.org.gddsn.seis.monitor.edas.awt.ConfirmDialog;
import cn.org.gddsn.seis.monitor.edas.awt.IPConfigDialog_jButtonCancel_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.IPConfigDialog_jButtonGet_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.IPConfigDialog_jButtonSet_actionAdapter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import org.apache.log4j.Logger;

public class IPConfigDialog
extends Dialog {
    static Logger logger = Logger.getLogger(IPConfigDialog.class);
    Panel panel1 = new Panel();
    BorderLayout borderLayout1 = new BorderLayout();
    Panel vbox1 = new Panel();
    Panel jPanel1 = new Panel();
    Button jButtonCancel = new Button();
    Button jButtonGet = new Button();
    Button jButtonSet = new Button();
    Panel jPanel4 = new Panel();
    Panel jPanel5 = new Panel();
    Panel jPanel6 = new Panel();
    Label jLabel2 = new Label();
    TextField jTextFieldIPAddress = new TextField();
    Label jLabel3 = new Label();
    Label jLabel4 = new Label();
    TextField jTextFieldNetmask = new TextField();
    TextField jTextFieldGateway = new TextField();
    GridLayout gridLayout2 = new GridLayout();
    GridLayout gridLayout3 = new GridLayout();
    GridLayout gridLayout4 = new GridLayout();

    public IPConfigDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.enableEvents(64L);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.toGUI();
    }

    public IPConfigDialog() {
        this(new Frame(), "IPConfigDialog", false);
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.jButtonCancel.setLabel("Cancel");
        this.jButtonCancel.addActionListener(new IPConfigDialog_jButtonCancel_actionAdapter(this));
        this.jButtonGet.setLabel("Get");
        this.jButtonGet.addActionListener(new IPConfigDialog_jButtonGet_actionAdapter(this));
        this.jButtonSet.setLabel("Set");
        this.jButtonSet.addActionListener(new IPConfigDialog_jButtonSet_actionAdapter(this));
        this.jLabel2.setText("IP Address:");
        this.jLabel3.setText("Netmask: ");
        this.jLabel4.setText("Gateway: ");
        this.jTextFieldNetmask.setText("         ");
        this.jTextFieldGateway.setText("        ");
        this.jPanel6.setLayout(this.gridLayout2);
        this.jPanel5.setLayout(this.gridLayout3);
        this.jPanel4.setLayout(this.gridLayout4);
        this.add(this.panel1);
        this.panel1.add((Component)this.vbox1, "Center");
        this.vbox1.add(this.jPanel4);
        this.jPanel4.add(this.jLabel2);
        this.jPanel4.add(this.jTextFieldIPAddress);
        this.vbox1.setLayout(new GridLayout(3, 1));
        this.vbox1.add(this.jPanel5);
        this.jPanel5.add(this.jLabel3);
        this.jPanel5.add(this.jTextFieldNetmask);
        this.vbox1.add(this.jPanel6);
        this.jPanel6.add(this.jLabel4);
        this.jPanel6.add(this.jTextFieldGateway);
        this.panel1.add((Component)this.jPanel1, "South");
        this.jPanel1.add(this.jButtonSet);
        this.jPanel1.add(this.jButtonGet);
        this.jPanel1.add(this.jButtonCancel);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    public void showDialog(Dialog dlg) {
        Dimension dlgSize = dlg.getSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.pack();
        dlg.setVisible(true);
    }

    private void toGUI() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            Edas24IPIO.Frame frm = edasIO.inquire(0, 208);
            Edas24IPIO.IP info = (Edas24IPIO.IP)frm.body;
            this.jTextFieldIPAddress.setText(info.ip.get());
            this.jTextFieldNetmask.setText(info.mask.get());
            this.jTextFieldGateway.setText(info.gw.get());
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    private void toModel() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            Edas24IPIO.IP info = new Edas24IPIO.IP();
            info.ip.set(this.jTextFieldIPAddress.getText());
            info.mask.set(this.jTextFieldNetmask.getText());
            info.gw.set(this.jTextFieldGateway.getText());
            edasIO.config(0, 208, info);
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public void jButtonGet_actionPerformed(ActionEvent e) {
        this.toGUI();
    }

    public void jButtonSet_actionPerformed(ActionEvent e) {
        ConfirmDialog dialog = new ConfirmDialog((Dialog)this, "Config IP?", "Use new IP after restarted, Are you sure?");
        this.showDialog(dialog);
        if (dialog.isokay) {
            this.toModel();
        }
        this.dispose();
    }

    public void jButtonCancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

