/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor.edas.awt;

import cn.org.gddsn.liss.port.edas.Edas24IPIO;
import cn.org.gddsn.seis.monitor.edas.Controler;
import cn.org.gddsn.seis.monitor.edas.awt.EdasFrame;
import cn.org.gddsn.seis.monitor.edas.awt.SineParamDialog_jButtonCancel_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.SineParamDialog_jButtonGet_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.SineParamDialog_jButtonSet_actionAdapter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SineParamDialog
extends Dialog {
    static Logger logger = Logger.getLogger(SineParamDialog.class);
    Panel panel1 = new Panel();
    BorderLayout borderLayout1 = new BorderLayout();
    Panel vbox1 = new Panel();
    Panel jPanel1 = new Panel();
    Button jButtonCancel = new Button();
    Button jButtonGet = new Button();
    Button jButtonSet = new Button();
    Panel jPanel2 = new Panel();
    Panel jPanel3 = new Panel();
    Panel jPanel4 = new Panel();
    Panel jPanel5 = new Panel();
    Label jLabel1 = new Label();
    Choice jComboBoxSensor = new Choice();
    Checkbox jCheckBox1 = new Checkbox();
    Label jLabel2 = new Label();
    TextField jTextFieldTime = new TextField();
    Label jLabel3 = new Label();
    TextField jTextFieldInterval = new TextField();
    GridLayout gridLayout3 = new GridLayout();
    GridLayout gridLayout4 = new GridLayout();
    GridLayout gridLayout5 = new GridLayout();
    GridLayout gridLayout6 = new GridLayout();
    Panel vbox2 = new Panel();
    GridLayout gridLayout1 = new GridLayout();
    Panel sinPanel = new Panel();
    GridLayout gridLayout2 = new GridLayout();
    TextArea text_sinParam = new TextArea(5, 25);
    BorderLayout borderLayout2 = new BorderLayout();
    Panel jpanel6 = new Panel();
    GridLayout gridLayout7 = new GridLayout();
    Label jlabel4 = new Label();
    TextField jTextFieldPointNum = new TextField();

    public SineParamDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.enableEvents(64L);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.toGUI();
    }

    public SineParamDialog() {
        this(new Frame(), "SineParamDialog", false);
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.jButtonCancel.setLabel("Cancel");
        this.jButtonCancel.addActionListener(new SineParamDialog_jButtonCancel_actionAdapter(this));
        this.jButtonGet.setLabel("Get");
        this.jButtonGet.addActionListener(new SineParamDialog_jButtonGet_actionAdapter(this));
        this.jButtonSet.setLabel("Set");
        this.jButtonSet.addActionListener(new SineParamDialog_jButtonSet_actionAdapter(this));
        this.jLabel1.setText("Sensor: ");
        this.jCheckBox1.setLabel("Repeat Calibration");
        this.jLabel2.setText("Cali Time: ");
        this.jTextFieldTime.setText("1970-01-01 00:00:00");
        this.jLabel3.setText("Cali Interval(Hour): ");
        this.jTextFieldInterval.setText("         ");
        this.jPanel5.setLayout(this.gridLayout3);
        this.jPanel4.setLayout(this.gridLayout4);
        this.jPanel2.setLayout(this.gridLayout5);
        this.jPanel3.setLayout(this.gridLayout6);
        this.vbox1.setLayout(this.gridLayout1);
        this.gridLayout1.setRows(2);
        this.vbox2.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(5);
        this.text_sinParam.setText("textArea1");
        this.sinPanel.setLayout(this.borderLayout2);
        this.jpanel6.setLayout(this.gridLayout7);
        this.gridLayout7.setColumns(2);
        this.gridLayout5.setColumns(2);
        this.gridLayout6.setColumns(2);
        this.gridLayout4.setColumns(2);
        this.gridLayout3.setColumns(2);
        this.jlabel4.setText("Point Numbers");
        this.jTextFieldPointNum.setText("");
        this.add(this.panel1);
        this.panel1.add((Component)this.vbox1, "Center");
        this.jComboBoxSensor.addItem("Sensor A");
        this.jPanel2.add(this.jLabel1);
        this.jPanel2.add(this.jComboBoxSensor);
        this.vbox2.add(this.jPanel2);
        this.vbox2.add(this.jPanel3);
        this.vbox2.add(this.jPanel4);
        this.vbox2.add(this.jPanel5);
        this.vbox2.add(this.jpanel6);
        this.jpanel6.add(this.jlabel4);
        this.jpanel6.add(this.jTextFieldPointNum);
        this.vbox1.add(this.vbox2);
        this.jPanel3.add(this.jCheckBox1);
        this.jPanel4.add(this.jLabel2);
        this.jPanel4.add(this.jTextFieldTime);
        this.jPanel5.add(this.jLabel3);
        this.jPanel5.add(this.jTextFieldInterval);
        this.vbox1.add(this.sinPanel);
        this.panel1.add((Component)this.jPanel1, "South");
        this.jPanel1.add(this.jButtonSet);
        this.jPanel1.add(this.jButtonGet);
        this.jPanel1.add(this.jButtonCancel);
        this.sinPanel.add((Component)this.text_sinParam, "Center");
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    private void toGUI() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            Edas24IPIO.Frame frm = edasIO.inquire(0, 33);
            Edas24IPIO.SINE_PARAM info = (Edas24IPIO.SINE_PARAM)frm.body;
            if (info.timeSwitch.get() == 0) {
                this.jCheckBox1.setState(false);
            } else {
                this.jCheckBox1.setState(true);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.jTextFieldTime.setText(sdf.format(new Date((long)info.calTime.get() * 1000L)));
            this.jTextFieldPointNum.setText("" + info.pointNum.get());
            this.text_sinParam.setText("");
            this.text_sinParam.append("No.\tPer_num\tFre\tfactor");
            short pnum = info.pointNum.get();
            short i = 0;
            while (i < pnum) {
                this.text_sinParam.append("\n" + (i + 1) + "\t" + info.freqs[i].periods.get() + "\t" + info.freqs[i].freq.get() + "\t" + info.freqs[i].factor.get());
                i = (short)(i + 1);
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
            frame.enableGUI(false);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }

    private void toModel() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        String textAreaStr = this.text_sinParam.getText();
        StringTokenizer st = new StringTokenizer(textAreaStr);
        String[] sinpar = new String[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            sinpar[count] = st.nextToken();
            count = (short)(count + 1);
        }
        try {
            Edas24IPIO.SINE_PARAM info = new Edas24IPIO.SINE_PARAM();
            boolean selected = this.jCheckBox1.getState();
            info.timeSwitch.set((short)(selected ? 1 : 0));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            info.calTime.set((int)(sdf.parse(this.jTextFieldTime.getText()).getTime() / 1000L));
            info.pointNum.set(Short.parseShort(this.jTextFieldPointNum.getText()));
            info.freqs = new Edas24IPIO.SINE_FREQ[info.pointNum.get()];
            int j = 4;
            int i = 0;
            while (i < info.pointNum.get()) {
                info.freqs[i] = new Edas24IPIO.SINE_FREQ();
                j = (short)(j + 1);
                info.freqs[i].periods.set(Short.parseShort(sinpar[j]));
                System.out.print(String.valueOf(Short.parseShort(sinpar[j])) + "\t");
                j = (short)(j + 1);
                info.freqs[i].freq.set(Short.parseShort(sinpar[j]));
                System.out.print(String.valueOf(Short.parseShort(sinpar[j])) + "\t");
                j = (short)(j + 1);
                info.freqs[i].factor.set(Short.parseShort(sinpar[j]));
                System.out.println(Short.parseShort(sinpar[j]));
                j = (short)(j + 1);
                ++i;
            }
            Edas24IPIO.Frame ret = edasIO.config(0, 33, info);
            if (ret == null) {
                logger.warn("return null in Sine cal");
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
            frame.enableGUI(false);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }

    public void jButtonGet_actionPerformed(ActionEvent e) {
        this.toGUI();
    }

    public void jButtonSet_actionPerformed(ActionEvent e) {
        this.toModel();
    }

    public void jButtonCancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

