/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor.edas.awt;

import cn.org.gddsn.liss.port.edas.Edas24IPIO;
import cn.org.gddsn.seis.monitor.edas.Controler;
import cn.org.gddsn.seis.monitor.edas.awt.EdasFrame;
import cn.org.gddsn.seis.monitor.edas.awt.TriggerAutoDialog_detectLevel_itemAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.TriggerAutoDialog_jButtonAdd_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.TriggerAutoDialog_jButtonCancel_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.TriggerAutoDialog_jButtonDelete_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.TriggerAutoDialog_jButtonModify_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.TriggerAutoDialog_listTrigger_itemAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.TriggerAutoDialog_trigMeth_itemAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.TriggerAuto_itemAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.TriggerSensitivity;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TriggerAutoDialog
extends Dialog {
    private static final long serialVersionUID = 7808461019538162204L;
    private Edas24IPIO.Frame frm;
    static Logger logger = Logger.getLogger(TriggerAutoDialog.class);
    TriggerSensitivity localVeryHigh = new TriggerSensitivity(600, 15, 50, 3, 150, 2, 600, 1);
    TriggerSensitivity localHigh = new TriggerSensitivity(600, 15, 50, 6, 150, 4, 600, 3);
    TriggerSensitivity localNormal = new TriggerSensitivity(600, 15, 50, 9, 150, 6, 600, 4);
    TriggerSensitivity localLow = new TriggerSensitivity(600, 15, 50, 12, 150, 8, 600, 6);
    TriggerSensitivity localVeryLow = new TriggerSensitivity(600, 15, 50, 15, 150, 10, 600, 5);
    TriggerSensitivity farVeryHigh = new TriggerSensitivity(1200, 50, 150, 3, 600, 2, 5400, 1);
    TriggerSensitivity farHigh = new TriggerSensitivity(1200, 50, 150, 6, 600, 4, 5400, 2);
    TriggerSensitivity farNormal = new TriggerSensitivity(1200, 50, 150, 9, 600, 6, 5400, 3);
    TriggerSensitivity farLow = new TriggerSensitivity(1200, 50, 150, 12, 600, 9, 5400, 6);
    TriggerSensitivity farVeryLow = new TriggerSensitivity(1200, 50, 150, 15, 600, 12, 5400, 9);
    TriggerSensitivity trigSensitivity = new TriggerSensitivity();
    Panel panel1 = new Panel();
    BorderLayout borderLayout1 = new BorderLayout();
    Panel vbox1 = new Panel();
    BorderLayout borderLayout2 = new BorderLayout();
    Panel vbox2 = new Panel();
    Panel panelButton = new Panel();
    Panel panelChoiceSensor = new Panel();
    Label labelSensor = new Label("Sen:");
    Label labelTrigger = new Label("Trigger:");
    Choice choiceSensor = new Choice();
    Button jbuttonAdd = new Button();
    Button jbuttonModify = new Button();
    Button jbuttonDelete = new Button();
    Button jbuttonCancel = new Button();
    GridLayout gridLayout1 = new GridLayout();
    List listTrigger = new List();
    BorderLayout borderLayout3 = new BorderLayout();
    Panel panelTriggerParam1 = new Panel();
    Label labelTrigMeth = new Label("Trigger Method:");
    Label labelDetectLevel = new Label("Detect Level:");
    Label labelFilter = new Label("Filter:");
    Label labelDetectCh = new Label("Detect Channel:");
    GridLayout gridLayout2 = new GridLayout();
    GridLayout gridLayout3 = new GridLayout();
    Choice choiceTrigMeth = new Choice();
    Choice choiceDetectLevel = new Choice();
    Choice choiceFilter = new Choice();
    Choice choiceDetectCh = new Choice();
    Label labelLonWinLen = new Label();
    TextField txtFieLonWin = new TextField();
    Label labelShWinLen = new Label();
    TextField txtFieShoWin = new TextField();
    Label labelValWinLen = new Label();
    TextField txtFieValWin = new TextField();
    Label labelTrigVal = new Label();
    TextField txtFieTrigValu = new TextField();
    Label labelEndWinLen = new Label();
    TextField txtFieEndWin = new TextField();
    Label labelValiValue = new Label();
    TextField txtFieValiValu = new TextField();
    Label labelMaxLen = new Label();
    TextField txtFieMaxLen = new TextField();
    Label labelEndValue = new Label();
    TextField txtFieEndValu = new TextField();
    Panel panelChoice = new Panel();
    Choice cardChoice = new Choice();

    public TriggerAutoDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.enableEvents(64L);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.inquireInfo();
        this.toGUI(0);
        this.toListGUI();
    }

    public TriggerAutoDialog() {
        this(new Frame(), "TriggerAutoDialog", false);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.panelChoice, "North");
        this.panelChoice.add(this.cardChoice);
        this.cardChoice.addItem("TriggerList");
        this.cardChoice.addItem("TriggerInfo");
        this.cardChoice.addItem("TriggerParam");
        this.cardChoice.addItemListener(new TriggerAuto_itemAdapter(this));
        this.add((Component)this.panel1, "Center");
        this.panel1.setLayout(new CardLayout());
        this.panel1.add((Component)this.vbox1, "TriggerList");
        this.vbox1.setLayout(this.borderLayout2);
        this.vbox1.add((Component)this.panelChoiceSensor, "North");
        this.panelChoiceSensor.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setRows(2);
        this.panelChoiceSensor.add(this.labelSensor);
        this.panelChoiceSensor.add(this.choiceSensor);
        this.choiceSensor.addItem("A");
        this.panelChoiceSensor.add(this.labelTrigger);
        this.vbox1.add((Component)this.listTrigger, "Center");
        this.listTrigger.addItemListener(new TriggerAutoDialog_listTrigger_itemAdapter(this));
        this.panel1.add((Component)this.panelTriggerParam1, "TriggerInfo");
        this.panelTriggerParam1.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(2);
        this.gridLayout2.setRows(4);
        this.panelTriggerParam1.add(this.labelTrigMeth);
        this.panelTriggerParam1.add(this.choiceTrigMeth);
        this.choiceTrigMeth.addItem("Voltage");
        this.choiceTrigMeth.addItem("STA/LTA");
        this.choiceTrigMeth.addItemListener(new TriggerAutoDialog_trigMeth_itemAdapter(this));
        this.panelTriggerParam1.add(this.labelDetectLevel);
        this.panelTriggerParam1.add(this.choiceDetectLevel);
        this.choiceDetectLevel.addItemListener(new TriggerAutoDialog_detectLevel_itemAdapter(this));
        this.panelTriggerParam1.add(this.labelFilter);
        this.panelTriggerParam1.add(this.choiceFilter);
        this.panelTriggerParam1.add(this.labelDetectCh);
        this.panelTriggerParam1.add(this.choiceDetectCh);
        this.choiceDetectLevel.addItem("Local-VeryHighSen");
        this.choiceDetectLevel.addItem("Local-HigSensitive");
        this.choiceDetectLevel.addItem("Local-Sensitive");
        this.choiceDetectLevel.addItem("Local-LowSensitive");
        this.choiceDetectLevel.addItem("Local-VeryLowSen");
        this.choiceDetectLevel.addItem("Far-VeryHighSen");
        this.choiceDetectLevel.addItem("Far-HigSensitive");
        this.choiceDetectLevel.addItem("Far-Sensitive");
        this.choiceDetectLevel.addItem("Far-LowSensitive");
        this.choiceDetectLevel.addItem("Far-VeryLowSen");
        this.choiceDetectLevel.addItem("User-Defined");
        this.choiceFilter.addItem("HighFilter-2Hz");
        this.choiceFilter.addItem("HighFilter-1Hz");
        this.choiceFilter.addItem("HighFilter-12Sec");
        this.choiceFilter.addItem("HighFilter-15Sec");
        this.choiceDetectCh.addItem("UD");
        this.choiceDetectCh.addItem("EW");
        this.choiceDetectCh.addItem("NS");
        this.panel1.add((Component)this.vbox2, "TriggerParam");
        this.vbox2.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(2);
        this.gridLayout3.setRows(8);
        this.vbox2.add(this.labelLonWinLen);
        this.vbox2.add(this.txtFieLonWin);
        this.vbox2.add(this.labelShWinLen);
        this.vbox2.add(this.txtFieShoWin);
        this.vbox2.add(this.labelValWinLen);
        this.vbox2.add(this.txtFieValWin);
        this.vbox2.add(this.labelTrigVal);
        this.vbox2.add(this.txtFieTrigValu);
        this.vbox2.add(this.labelEndWinLen);
        this.vbox2.add(this.txtFieEndWin);
        this.vbox2.add(this.labelValiValue);
        this.vbox2.add(this.txtFieValiValu);
        this.vbox2.add(this.labelMaxLen);
        this.vbox2.add(this.txtFieMaxLen);
        this.vbox2.add(this.labelEndValue);
        this.vbox2.add(this.txtFieEndValu);
        this.labelLonWinLen.setText("LonWin(Sec)");
        this.labelShWinLen.setText("ShoWin(Sec)");
        this.labelValWinLen.setText("ValWin(Sec)");
        this.labelTrigVal.setText("TrigValu(db)");
        this.labelEndWinLen.setText("EndWin(Sec)");
        this.labelValiValue.setText("ValiValu(db)");
        this.labelMaxLen.setText("MaxLen(Sec)");
        this.labelEndValue.setText("EndValu(db)");
        this.add((Component)this.panelButton, "South");
        this.panelButton.add(this.jbuttonAdd);
        this.panelButton.add(this.jbuttonModify);
        this.panelButton.add(this.jbuttonDelete);
        this.panelButton.add(this.jbuttonCancel);
        this.jbuttonAdd.setLabel("Add");
        this.jbuttonAdd.addActionListener(new TriggerAutoDialog_jButtonAdd_actionAdapter(this));
        this.jbuttonModify.setLabel("Modify");
        this.jbuttonModify.addActionListener(new TriggerAutoDialog_jButtonModify_actionAdapter(this));
        this.jbuttonDelete.setLabel("Delete");
        this.jbuttonDelete.addActionListener(new TriggerAutoDialog_jButtonDelete_actionAdapter(this));
        this.jbuttonCancel.setLabel("Cancel");
        this.jbuttonCancel.addActionListener(new TriggerAutoDialog_jButtonCancel_actionAdapter(this));
    }

    private void inquireInfo() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            this.frm = edasIO.inquire(0, 148);
            if (this.frm == null) {
                EdasFrame frame = (EdasFrame)this.getOwner();
                frame.warnStatusBar("Get Auto Trigger info failt!");
                return;
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.warn(ex.getMessage(), ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }

    private void toGUI(int trigger) {
        Edas24IPIO.TRIGGER_AUTO info = (Edas24IPIO.TRIGGER_AUTO)this.frm.body;
        if ((this.frm.header.length.get() - 4) / 24 > 0) {
            if (info.trig[trigger].trigstyle.get() == 1) {
                this.choiceTrigMeth.select(1);
                this.StaLtaEnableGUI();
                this.StaLtaDisableGUI();
                this.StaLtaChangeLabelGUI();
            } else {
                this.choiceTrigMeth.select(0);
                this.VolEnableGUI();
                this.VolDisableGUI();
                this.VolChangeLabelGUI();
            }
            this.choiceDetectLevel.select(2);
            this.choiceFilter.select(info.trig[trigger].filter.get());
            if (this.trigSensitivity.equals(this.localVeryHigh)) {
                this.choiceDetectLevel.select(0);
            } else if (this.trigSensitivity.equals(this.localHigh)) {
                this.choiceDetectLevel.select(1);
            } else if (this.trigSensitivity.equals(this.localNormal)) {
                this.choiceDetectLevel.select(2);
            } else if (this.trigSensitivity.equals(this.localLow)) {
                this.choiceDetectLevel.select(3);
            } else if (this.trigSensitivity.equals(this.localVeryLow)) {
                this.choiceDetectLevel.select(4);
            } else if (this.trigSensitivity.equals(this.farVeryHigh)) {
                this.choiceDetectLevel.select(5);
            } else if (this.trigSensitivity.equals(this.farHigh)) {
                this.choiceDetectLevel.select(6);
            } else if (this.trigSensitivity.equals(this.farNormal)) {
                this.choiceDetectLevel.select(7);
            } else if (this.trigSensitivity.equals(this.farLow)) {
                this.choiceDetectLevel.select(8);
            } else if (this.trigSensitivity.equals(this.farVeryLow)) {
                this.choiceDetectLevel.select(9);
            } else {
                this.choiceDetectLevel.select(10);
            }
            this.txtFieLonWin.setText("" + this.trigSensitivity.LonWin / 10);
            this.txtFieShoWin.setText("" + (double)this.trigSensitivity.ShoWin / 10.0);
            this.txtFieValWin.setText("" + this.trigSensitivity.ValWin / 10);
            this.txtFieTrigValu.setText("" + this.trigSensitivity.TrigValu);
            this.txtFieEndWin.setText("" + this.trigSensitivity.EndWin / 10);
            this.txtFieValiValu.setText("" + this.trigSensitivity.ValiValu);
            this.txtFieMaxLen.setText("" + this.trigSensitivity.MaxLen);
            this.txtFieEndValu.setText("" + this.trigSensitivity.EndValu);
        }
    }

    private void toListGUI() {
        int i = 1;
        while (i <= (this.frm.header.length.get() - 4) / 24) {
            this.listTrigger.add("Trigger " + i);
            i = (short)(i + 1);
        }
    }

    public void VolDisableGUI() {
        this.choiceDetectLevel.setEnabled(false);
        this.choiceFilter.setEnabled(false);
        this.txtFieLonWin.setEnabled(false);
        this.txtFieValiValu.setEnabled(false);
    }

    public void VolEnableGUI() {
        this.choiceDetectCh.setEnabled(true);
        this.txtFieShoWin.setEnabled(true);
        this.txtFieValWin.setEnabled(true);
        this.txtFieTrigValu.setEnabled(true);
        this.txtFieEndWin.setEnabled(true);
        this.txtFieMaxLen.setEnabled(true);
        this.txtFieEndValu.setEnabled(true);
    }

    public void VolChangeLabelGUI() {
        this.labelShWinLen.setText("DetWin(Sec)");
        this.labelValWinLen.setText("DetRatio(%)");
        this.labelValiValue.setText("ValValu(gal)");
        this.labelEndValue.setText("EndValu(gal)");
    }

    public void StaLtaChangeLabelGUI() {
        this.labelShWinLen.setText("ShoWin(Sec)");
        this.labelValWinLen.setText("ValWin(Sec)");
        this.labelValiValue.setText("ValValu(db)");
        this.labelEndValue.setText("EndValu(db)");
    }

    public void StaLtaDisableGUI() {
        this.choiceFilter.setEnabled(false);
        this.choiceDetectCh.setEnabled(false);
        this.txtFieLonWin.setEnabled(false);
        this.txtFieShoWin.setEnabled(false);
        this.txtFieValWin.setEnabled(false);
        this.txtFieTrigValu.setEnabled(false);
        this.txtFieEndWin.setEnabled(false);
        this.txtFieValiValu.setEnabled(false);
        this.txtFieMaxLen.setEnabled(false);
        this.txtFieEndValu.setEnabled(false);
    }

    public void StaLtaEnableGUI() {
        this.choiceDetectLevel.setEnabled(true);
    }

    public void UserDefinedEnableGUI() {
        this.choiceDetectLevel.setEnabled(true);
        this.choiceFilter.setEnabled(true);
        this.choiceDetectCh.setEnabled(true);
        this.txtFieLonWin.setEnabled(true);
        this.txtFieShoWin.setEnabled(true);
        this.txtFieValWin.setEnabled(true);
        this.txtFieTrigValu.setEnabled(true);
        this.txtFieEndWin.setEnabled(true);
        this.txtFieValiValu.setEnabled(true);
        this.txtFieMaxLen.setEnabled(true);
        this.txtFieEndValu.setEnabled(true);
    }

    public void toMode(short trigflag) {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    public void jButtonAdd_actionPerformed(ActionEvent e) {
        this.toMode((short)99);
        this.dispose();
    }

    public void jButtonModify_actionPerformed(ActionEvent e) {
        this.toMode((short)(this.listTrigger.getSelectedIndex() + 1));
        this.dispose();
    }

    public void jButtonDelete_actionPerformed(ActionEvent e) {
        this.toMode((short)(-(this.listTrigger.getSelectedIndex() + 1)));
        this.dispose();
    }

    public void jButtonCancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void listTrigger_itemStateChanged(ItemEvent ie) {
        this.toGUI(this.listTrigger.getSelectedIndex());
    }

    public void trigMeth_itemStateChanged(ItemEvent ie) {
        switch (this.choiceTrigMeth.getSelectedIndex()) {
            case 0: {
                this.VolChangeLabelGUI();
                this.VolEnableGUI();
                this.VolDisableGUI();
                break;
            }
            case 1: {
                this.StaLtaEnableGUI();
                this.StaLtaDisableGUI();
                this.StaLtaChangeLabelGUI();
            }
        }
    }

    public void detectLevel_itemStateChanged(ItemEvent ie) {
        switch (this.choiceDetectLevel.getSelectedIndex()) {
            case 0: {
                this.txtFieTrigValu.setText("3");
                this.txtFieValiValu.setText("2");
                this.txtFieEndValu.setText("1");
                break;
            }
            case 1: {
                this.txtFieTrigValu.setText("6");
                this.txtFieValiValu.setText("4");
                this.txtFieEndValu.setText("3");
                break;
            }
            case 2: {
                this.txtFieTrigValu.setText("9");
                this.txtFieValiValu.setText("6");
                this.txtFieEndValu.setText("4");
                break;
            }
            case 3: {
                this.txtFieTrigValu.setText("12");
                this.txtFieValiValu.setText("8");
                this.txtFieEndValu.setText("6");
                break;
            }
            case 4: {
                this.txtFieTrigValu.setText("15");
                this.txtFieValiValu.setText("10");
                this.txtFieEndValu.setText("5");
                break;
            }
            case 5: {
                this.txtFieTrigValu.setText("3");
                this.txtFieValiValu.setText("2");
                this.txtFieEndValu.setText("1");
                break;
            }
            case 6: {
                this.txtFieTrigValu.setText("6");
                this.txtFieValiValu.setText("4");
                this.txtFieEndValu.setText("2");
                break;
            }
            case 7: {
                this.txtFieTrigValu.setText("9");
                this.txtFieValiValu.setText("6");
                this.txtFieEndValu.setText("3");
                break;
            }
            case 8: {
                this.txtFieTrigValu.setText("12");
                this.txtFieValiValu.setText("9");
                this.txtFieEndValu.setText("6");
                break;
            }
            case 9: {
                this.txtFieTrigValu.setText("15");
                this.txtFieValiValu.setText("12");
                this.txtFieEndValu.setText("9");
                break;
            }
            case 10: {
                this.UserDefinedEnableGUI();
            }
        }
        if (this.choiceDetectLevel.getSelectedIndex() <= 4) {
            this.txtFieLonWin.setText("60");
            this.txtFieShoWin.setText("1.5");
            this.txtFieValWin.setText("5");
            this.txtFieEndWin.setText("15");
            this.txtFieMaxLen.setText("600");
        } else {
            this.txtFieLonWin.setText("120");
            this.txtFieShoWin.setText("5");
            this.txtFieValWin.setText("15");
            this.txtFieEndWin.setText("60");
            this.txtFieMaxLen.setText("5400");
        }
    }

    public void TriggerAutoParam_itemStateChanged(ItemEvent ie) {
        CardLayout cl = (CardLayout)this.panel1.getLayout();
        cl.show(this.panel1, (String)ie.getItem());
    }
}

