/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor.edas.gui;

import cn.org.gddsn.liss.port.edas.Edas24IPIO;
import cn.org.gddsn.seis.monitor.edas.Controler;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame;
import cn.org.gddsn.seis.monitor.edas.gui.GPSStatusDialog_jButtonCancel_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.GPSStatusDialog_jButtonGet_actionAdapter;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class GPSStatusDialog
extends JDialog {
    static Logger logger = Logger.getLogger(GPSStatusDialog.class);
    JLabel jLabelSync = new JLabel();
    JTextField jTextFieldSync = new JTextField();
    JLabel jLabelStnName = new JLabel();
    JTextField jTextFieldDop = new JTextField();
    JLabel jLabel1_short_name = new JLabel();
    JTextField jTextFieldClock = new JTextField();
    JLabel jLabel_stn_sn = new JLabel();
    JTextField jTextFieldRcvStatus = new JTextField();
    JTextField jTextFieldStar = new JTextField();
    JLabel jLabel_num_of_sen = new JLabel();
    JTextField jTextFieldLat = new JTextField();
    JLabel jLabel2 = new JLabel();
    JTextField jTextFieldLong = new JTextField();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JTextField jTextFieldAlt = new JTextField();
    JTextField jTextFieldTimeErr = new JTextField();
    JTextField jTextFieldFreqErr = new JTextField();
    JButton jButtonCancel = new JButton();
    JButton jButtonGet = new JButton();
    GridLayout gridLayout1 = new GridLayout(7, 4);

    public GPSStatusDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.setDefaultCloseOperation(2);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.toGUI();
    }

    public GPSStatusDialog() {
        this(new Frame(), "GPSStatusDialog", false);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridLayout1);
        this.jLabelStnName.setToolTipText("");
        this.jLabelStnName.setText("Dop:");
        this.jLabel1_short_name.setToolTipText("");
        this.jLabel1_short_name.setText("Rcv Stat:");
        this.jLabel_stn_sn.setToolTipText("");
        this.jLabel_stn_sn.setText("GPS Clock:");
        this.jLabel_num_of_sen.setText("Star NO.");
        this.jLabel2.setText("Latitude:");
        this.jLabel3.setText("Longitude:");
        this.jLabel4.setText("Altitude");
        this.jLabel5.setText("Time Err:");
        this.jLabel6.setText("Freq Err:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new GPSStatusDialog_jButtonCancel_actionAdapter(this));
        this.jButtonGet.setText("Get");
        this.jButtonGet.addActionListener(new GPSStatusDialog_jButtonGet_actionAdapter(this));
        this.jTextFieldSync.setEditable(false);
        this.jTextFieldTimeErr.setEditable(false);
        this.jTextFieldStar.setEditable(false);
        this.jTextFieldDop.setEditable(false);
        this.jTextFieldLat.setEditable(false);
        this.jTextFieldAlt.setEditable(false);
        this.jTextFieldFreqErr.setEditable(false);
        this.jTextFieldRcvStatus.setEditable(false);
        this.jTextFieldClock.setEditable(false);
        this.jTextFieldLong.setEditable(false);
        this.gridLayout1.setRows(6);
        this.getContentPane().add((Component)this.jLabelSync, null);
        this.getContentPane().add((Component)this.jTextFieldSync, null);
        this.getContentPane().add((Component)this.jLabel_stn_sn, null);
        this.getContentPane().add((Component)this.jTextFieldClock, null);
        this.getContentPane().add((Component)this.jLabelStnName, null);
        this.getContentPane().add((Component)this.jTextFieldDop, null);
        this.getContentPane().add((Component)this.jLabel1_short_name, null);
        this.getContentPane().add((Component)this.jTextFieldRcvStatus, null);
        this.getContentPane().add((Component)this.jLabel_num_of_sen, null);
        this.getContentPane().add((Component)this.jTextFieldStar, null);
        this.getContentPane().add((Component)this.jLabel2, null);
        this.getContentPane().add((Component)this.jTextFieldLat, null);
        this.getContentPane().add((Component)this.jLabel3, null);
        this.getContentPane().add((Component)this.jTextFieldLong, null);
        this.getContentPane().add((Component)this.jLabel4, null);
        this.getContentPane().add((Component)this.jTextFieldAlt, null);
        this.getContentPane().add((Component)this.jLabel5, null);
        this.getContentPane().add((Component)this.jTextFieldTimeErr, null);
        this.getContentPane().add((Component)this.jLabel6, null);
        this.getContentPane().add((Component)this.jTextFieldFreqErr, null);
        this.getContentPane().add((Component)this.jButtonGet, null);
        this.getContentPane().add((Component)this.jButtonCancel, null);
        this.jLabelSync.setText("Sync Flag:");
    }

    public void jButtonCancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void jButtonGet_actionPerformed(ActionEvent e) {
        this.toGUI();
    }

    private void toGUI() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            Edas24IPIO.Frame frm = edasIO.inquire(0, 129);
            Edas24IPIO.GPS_INFO info = (Edas24IPIO.GPS_INFO)frm.body;
            this.jTextFieldSync.setText("" + info.sync.get());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            short year = info.year.get();
            byte month = info.month.get();
            byte day = info.day.get();
            byte hour = info.hour.get();
            byte min = info.minute.get();
            byte second = info.second.get();
            GregorianCalendar cal = new GregorianCalendar(year, month, day, hour, min, second);
            this.jTextFieldClock.setText(sdf.format(cal.getTime()));
            this.jTextFieldDop.setText("" + info.dop.get());
            this.jTextFieldRcvStatus.setText("" + info.rcvStatus.get());
            this.jTextFieldStar.setText("" + info.star.get());
            this.jTextFieldLat.setText("" + (double)info.lat.get() / 3600000.0);
            this.jTextFieldLong.setText("" + (double)info.lon.get() / 3600000.0);
            this.jTextFieldAlt.setText("" + (double)info.alt.get() / 100.0 / 1000.0);
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
            frame.enableGUI(false);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }
}

