/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.pca;

import JSci.maths.ArrayMath;
import cn.org.gddsn.linalg.Matrix;
import org.apache.log4j.Logger;

public class Polarization {
    static Logger logger = Logger.getLogger(Polarization.class);
    double[] maxEig;
    double[][] eigVec = new double[3][3];
    double[] eig = new double[3];
    double[][] nez = null;
    int start;
    int winLen;
    int[] sortIndx = null;

    public void calPolarization(double[][] nez, int start, int len) {
        this.nez = nez;
        this.start = start;
        this.winLen = len;
        double[][] tmp = new double[len][3];
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < 3) {
                tmp[i][j] = nez[start + i][j];
                ++j;
            }
            ++i;
        }
        Matrix M = Matrix.Cov(tmp, len, 3);
        Matrix.calRealSymMatrixEig(3, M.getMat(), this.eig, this.eigVec);
        this.sortIndx = this.sortEigValue();
        M = null;
        tmp = null;
    }

    public double getMaxEig() {
        return ArrayMath.max(this.eig);
    }

    public double getDegreeOfPolarization() {
        double sum = 0.0;
        int i = 0;
        while (i < 3) {
            sum += this.eig[i];
            ++i;
        }
        return ArrayMath.max(this.eig) / (sum /= 3.0);
    }

    public double getDegreeOfPolarization1() {
        double sum = 0.0;
        sum += (this.eig[0] - this.eig[1]) * (this.eig[1] - this.eig[1]);
        sum += (this.eig[0] - this.eig[2]) * (this.eig[0] - this.eig[2]);
        return (sum += (this.eig[1] - this.eig[2]) * (this.eig[1] - this.eig[2])) / (2.0 * (this.eig[0] + this.eig[1] + this.eig[2]) * (this.eig[0] + this.eig[1] + this.eig[2]));
    }

    public float getEQAzi() {
        int N = 0;
        int E2 = 1;
        int U = 2;
        Matrix M = Matrix.Cov(this.nez, this.winLen, 3);
        double[][] e = M.getMat();
        double maxRamda = (e[N][N] + e[E2][E2] + Math.sqrt((e[E2][E2] - e[N][N]) * (e[E2][E2] - e[N][N]) + 4.0 * e[E2][N] * e[E2][N])) / 2.0;
        double Azimuth = Math.atan((maxRamda - e[N][N]) / e[N][E2]) * 180.0 / Math.PI;
        if (Double.isNaN(Azimuth)) {
            logger.warn("In Polarization.getEQAzi(), your three component data should have some problem");
        }
        if (e[E2][N] > 0.0 && e[U][E2] > 0.0) {
            Azimuth += 180.0;
        }
        if (e[E2][N] < 0.0 && e[U][E2] < 0.0) {
            Azimuth += 180.0;
        }
        Azimuth = Azimuth < 0.0 ? 360.0 + Azimuth : Azimuth;
        M = null;
        return (float)Azimuth;
    }

    public float getEQAzi3() {
        int N = 0;
        int E2 = 1;
        int U = 2;
        int max = this.sortIndx[0];
        double Azimuth = Math.atan(this.eigVec[E2][max] / this.eigVec[N][max]) * 180.0 / Math.PI;
        if (this.eigVec[E2][max] * this.eigVec[N][max] > 0.0 && this.eigVec[U][max] * this.eigVec[E2][max] > 0.0) {
            Azimuth += 180.0;
        }
        if (this.eigVec[E2][max] * this.eigVec[N][max] < 0.0 && this.eigVec[U][max] * this.eigVec[E2][max] < 0.0) {
            Azimuth += 180.0;
        }
        Azimuth = Azimuth < 0.0 ? 360.0 + Azimuth : Azimuth;
        return (float)Azimuth;
    }

    public double getPolaAngle(int order) {
        int xAxis;
        int yAxis;
        if (order == 0) {
            return this.getEQAzi3();
        }
        int N = 0;
        int E2 = 1;
        int U = 2;
        if (order == 1) {
            yAxis = U;
            xAxis = E2;
        } else {
            yAxis = U;
            xAxis = N;
        }
        int max = this.sortIndx[0];
        double Azimuth = Math.atan(this.eigVec[xAxis][max] / this.eigVec[yAxis][max]) * 180.0 / Math.PI;
        return Azimuth += 180.0;
    }

    public double getIncident(int order) {
        boolean N = false;
        boolean E2 = true;
        int U = 2;
        int max = this.sortIndx[order];
        double incident = Math.acos(this.eigVec[U][max]) * 180.0 / Math.PI;
        if (incident > 90.0) {
            incident = 180.0 - incident;
        }
        return incident;
    }

    public double getPlanarity() {
        int max = this.sortIndx[0];
        int mid = this.sortIndx[1];
        int min = this.sortIndx[2];
        return 1.0 - 2.0 * this.eig[min] / (this.eig[max] + this.eig[mid]);
    }

    public double getRectilinearity() {
        int max = this.sortIndx[0];
        int mid = this.sortIndx[1];
        int min = this.sortIndx[2];
        return 1.0 - (this.eig[mid] + this.eig[min]) / (2.0 * this.eig[max]);
    }

    public double[] getEigValue() {
        double[] eigTmp = new double[3];
        int i = 0;
        while (i < eigTmp.length) {
            eigTmp[i] = this.eig[this.sortIndx[i]];
            ++i;
        }
        return eigTmp;
    }

    private int[] sortEigValue() {
        int len = 3;
        int[] sort = new int[len];
        int i = 0;
        while (i < len) {
            sort[i] = i;
            ++i;
        }
        i = 0;
        while (i < len) {
            int max = i;
            int j = i + 1;
            while (j < len) {
                if (this.eig[sort[max]] < this.eig[sort[j]]) {
                    max = j;
                }
                ++j;
            }
            int temp = sort[i];
            sort[i] = sort[max];
            sort[max] = temp;
            ++i;
        }
        return sort;
    }
}

