/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.phaseidentification;

import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.evtformat.DatabaseEvtData;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.pca.Polarization;
import java.util.Date;

public class PhaseIdentify2 {
    private int[] chanOrder = null;
    private double samp;
    private int winLenDetect = 200;
    private int stepDetect = 20;
    private double threshold = 3.5;
    private int delay = 100 / this.stepDetect;
    private double SNR = 2.0;
    private int[] winLens = new int[]{200, 50, 5};
    private Polarization polarization = new Polarization();
    private double[][] nez = null;
    private EvtData evt;

    public PhaseIdentify2(EvtData evt) {
        this.evt = evt;
    }

    public Phase[] getPhaseP() {
        if (this.chanOrder == null) {
            return null;
        }
        this.calThreeCompData();
        int minIndex = this.getEventTriggerIndex();
        int maxIndex = this.getMaxIndex();
        int midIndex = (minIndex + maxIndex) / 2;
        int[] winLenP = new int[]{200, 50, 10};
        int[] winLenS = new int[]{200, 50, 20};
        int indexPhaseP = this.getPhaseAT(minIndex, midIndex, winLenP);
        int indexPhaseS = this.getPhaseAT(midIndex, maxIndex, winLenS);
        Phase[] phase = new Phase[]{this.fillPhase(indexPhaseP, "APG", 0), this.fillPhase(indexPhaseS, "ASG", 1)};
        return phase;
    }

    public void setThreshold(double newThreshold) {
        this.threshold = newThreshold;
    }

    public void setStation(int[] newChanOrder) {
        this.chanOrder = newChanOrder;
        this.samp = this.evt.getSampleRate(this.chanOrder[0]);
    }

    private Phase fillPhase(int idx, String phaseName, int chnID) {
        Phase phase = new Phase();
        phase.setPhaseName(phaseName);
        phase.setBelongedChannelID(chnID);
        phase.setNetCode(this.evt.getNetworkCode(this.chanOrder[0]));
        phase.setStationCode(this.evt.getStationCode(this.chanOrder[0]));
        phase.setChanCode(this.evt.getChannelCode(this.chanOrder[chnID]));
        phase.setLocId(this.evt.getAuxId(this.chanOrder[0]));
        phase.offset = idx;
        long date = this.evt.getArrivalTime(this.chanOrder[0]).getTime() + (long)((double)(phase.offset * 1000) / this.samp);
        phase.setPhaseTime(new Date(date));
        this.polarization.calPolarization(this.nez, idx, this.winLenDetect);
        phase.setAzimuth(this.polarization.getEQAzi3());
        return phase;
    }

    private int getMaxIndex() {
        int chn = this.chanOrder[0];
        int max = 0;
        int i = 1;
        while (i < this.evt.getSampData(chn).length) {
            if (this.evt.getSampData(chn)[max] < this.evt.getSampData(chn)[i]) {
                max = i;
            }
            ++i;
        }
        return max + 2 * this.winLenDetect;
    }

    private int getEventTriggerIndex() {
        int minP = 2 * this.winLenDetect;
        int maxP = this.getMaxIndex();
        if (maxP >= this.evt.getSamples(this.chanOrder[0]) - 2 * this.winLenDetect) {
            maxP = this.evt.getSamples(this.chanOrder[0]) - 2 * this.winLenDetect;
        }
        double[] maxEig = new double[(maxP - minP) / this.stepDetect + 1];
        int n = 0;
        int i = minP;
        while (i < maxP) {
            this.polarization.calPolarization(this.nez, i, this.winLenDetect);
            maxEig[n] = this.polarization.getMaxEig();
            i += this.stepDetect;
            ++n;
        }
        n = this.delay;
        while (n < maxEig.length && maxEig[n] - this.threshold * maxEig[n - this.delay] <= 0.0) {
            ++n;
        }
        return minP + n * this.stepDetect + this.winLenDetect - 2 * this.winLenDetect;
    }

    private int getPhaseAT(int startIdx, int endIdx, int[] winLen) {
        double[] character = new double[endIdx - startIdx + 1];
        int i = 0;
        while (i < character.length) {
            character[i] = 1.0;
            ++i;
        }
        i = startIdx;
        while (i < endIdx) {
            int j = 0;
            while (j < winLen.length) {
                this.polarization.calPolarization(this.nez, i, winLen[j]);
                int n = i - startIdx;
                character[n] = character[n] * this.polarization.getMaxEig();
                this.polarization.calPolarization(this.nez, i - winLen[j], winLen[j]);
                int n2 = i - startIdx;
                character[n2] = character[n2] / this.polarization.getMaxEig();
                ++j;
            }
            ++i;
        }
        int maxIndx = 0;
        int i2 = character.length - 1;
        while (i2 >= 0) {
            if (character[i2] > character[maxIndx]) {
                maxIndx = i2;
            }
            --i2;
        }
        return startIdx + maxIndx;
    }

    private void calThreeCompData() {
        int chn = this.chanOrder[0];
        int samples = this.evt.getSamples(chn);
        this.nez = new double[samples][3];
        double norm = this.evt.getCalibFactor(chn);
        if (this.evt instanceof DatabaseEvtData) {
            int j = 0;
            while (j < 3) {
                double factor = this.evt.getCalibFactor(this.chanOrder[j]);
                int k = 0;
                while (k < samples) {
                    this.nez[k][j] = this.evt.getSampData(this.chanOrder[j])[k] * norm / factor;
                    ++k;
                }
                ++j;
            }
        } else {
            int j = 0;
            while (j < 3) {
                double factor = this.evt.getCalibFactor(this.chanOrder[j]);
                int k = 0;
                while (k < samples) {
                    this.nez[k][2 - j] = this.evt.getSampData(this.chanOrder[j])[k] * norm / factor;
                    ++k;
                }
                ++j;
            }
        }
    }
}

