/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.realtimeplot.awt;

import cn.org.gddsn.liss.port.event.MiniSeedPortEvent;
import cn.org.gddsn.liss.port.event.MiniSeedPortEventListener;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import org.apache.log4j.Logger;

class SimpleFrame
extends Frame
implements MiniSeedPortEventListener {
    static Logger logger = Logger.getLogger(SimpleFrame.class);
    boolean bRecord = false;
    Menu jmenuFile;
    MenuBar jmenubar;
    MenuItem jmItemStartRecord;
    MenuItem jmItemStopRecord;
    MenuItem jmItemExit;
    String[] netID;
    String[] stnCode;
    String[] locID;
    String[] chanCode;
    Hashtable tbl = new Hashtable();
    Hashtable firstTbl = new Hashtable();

    public SimpleFrame() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public SimpleFrame(String title) {
        super(title);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        this.jmenuFile = new Menu("File");
        this.jmItemStartRecord = new MenuItem("Start Record...");
        this.jmItemStartRecord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleFrame.this.jmItemStartRecord_actionPerformed(e);
            }
        });
        this.jmItemStopRecord = new MenuItem("Stop Record");
        this.jmItemStopRecord.setEnabled(false);
        this.jmItemStopRecord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleFrame.this.jmItemStopRecord_actionPerformed(e);
            }
        });
        this.jmItemExit = new MenuItem("Exit");
        this.jmenuFile.add(this.jmItemExit);
        this.jmItemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleFrame.this.jmItemExit_actionPerformed(e);
            }
        });
        this.jmenubar = new MenuBar();
        this.jmenubar.add(this.jmenuFile);
        this.setMenuBar(this.jmenubar);
    }

    synchronized void jmItemStartRecord_actionPerformed(ActionEvent e) {
        this.bRecord = true;
        this.jmItemStartRecord.setEnabled(false);
        this.jmItemStopRecord.setEnabled(true);
        try {
            int i = 0;
            while (i < this.netID.length) {
                String key = String.valueOf(this.netID[i]) + "_" + this.stnCode[i] + "_" + this.locID[i] + "_" + this.chanCode[i];
                PrintWriter pw = new PrintWriter(new FileOutputStream(key));
                this.tbl.put(key, pw);
                this.firstTbl.put(key, new Boolean(true));
                ++i;
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    synchronized void jmItemStopRecord_actionPerformed(ActionEvent e) {
        this.bRecord = false;
        this.jmItemStartRecord.setEnabled(true);
        this.jmItemStopRecord.setEnabled(false);
        int i = 0;
        while (i < this.netID.length) {
            String key = String.valueOf(this.netID[i]) + "_" + this.stnCode[i] + "_" + this.locID[i] + "_" + this.chanCode[i];
            PrintWriter pw = (PrintWriter)this.tbl.get(key);
            pw.flush();
            pw.close();
            this.tbl.remove(key);
            this.firstTbl.remove(key);
            ++i;
        }
    }

    void jmItemExit_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    public void setStationInfo(String[] netID, String[] stnCode, String[] locID, String[] chanCode) {
        this.netID = netID;
        this.stnCode = stnCode;
        this.locID = locID;
        this.chanCode = chanCode;
    }

    public synchronized void miniSeedEvent(MiniSeedPortEvent MiniSeedPortEvent2) {
        GenericMiniSeedRecord gmsRec = MiniSeedPortEvent2.getGenericMiniSeedRecord();
        if (gmsRec == null) {
            return;
        }
        if (this.bRecord) {
            String net = gmsRec.getNetwork();
            String stnCode = gmsRec.getStation();
            String locID = gmsRec.getLocID();
            String chanCode = gmsRec.getChannel();
            SimpleDateFormat dateFmt = new SimpleDateFormat("MM-dd-yyy");
            SimpleDateFormat timeFmt = new SimpleDateFormat("HH:mm:ss.ss");
            String key = String.valueOf(net) + "_" + stnCode + "_" + locID + "_" + chanCode;
            Boolean bFirst = (Boolean)this.firstTbl.get(key);
            PrintWriter pw = (PrintWriter)this.tbl.get(key);
            if (pw == null) {
                return;
            }
            if (bFirst.booleanValue()) {
                this.firstTbl.remove(key);
                this.firstTbl.put(key, new Boolean(false));
                pw.println("DATASET " + stnCode);
                pw.println("VERSION NXT");
                pw.println("SERIES " + chanCode);
                pw.println("DATE " + dateFmt.format(gmsRec.getStartTime()));
                pw.println("TIME " + timeFmt.format(gmsRec.getStartTime()));
                pw.println("FILE_TYPE ASCII");
                pw.println("NUM_SAMPS ALL");
                pw.println("INTERVAL " + 1.0 / gmsRec.getSampleRate());
                pw.println("X_OFFSET 0");
                pw.println("MAX_VAL 8388608");
                pw.println("MIN_VAL -8388608");
                pw.println("VERT_UNITS Counts");
                pw.println("HORZ_UNITS Sec");
                pw.println("COMMENT ");
                pw.println("DATA ");
            }
            gmsRec.decompress();
            int[] samps = gmsRec.getUData();
            int i = 0;
            while (i < samps.length) {
                pw.println(samps[i]);
                ++i;
            }
        }
    }
}

