/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.realtimeplot.awt;

import cn.org.gddsn.convert.CoordinateTran;
import cn.org.gddsn.liss.port.event.MiniSeedPortEvent;
import cn.org.gddsn.liss.port.event.MiniSeedPortEventListener;
import cn.org.gddsn.liss.port.sss.SSSPort;
import cn.org.gddsn.liss.port.udp.UDPPort;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.realtimeplot.awt.SimpleFrame;
import cn.org.gddsn.util.SynchronizedFixQueue;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import edu.iris.timeutils.TimeStamp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class WavePaint
extends Panel
implements MiniSeedPortEventListener {
    static Logger logger = Logger.getLogger(WavePaint.class);
    protected ChannelLocator cl = null;
    protected SynchronizedFixQueue fixQueue = new SynchronizedFixQueue(60, "realPlot");
    private static final int maxPixel = 16384;
    private transient int[] paintPixelX = new int[16384];
    private transient int[] paintPixelY = new int[16384];
    private transient int nPoints;
    private transient float lastPointX = 0.0f;
    private transient float lastPointY = 0.0f;
    CoordinateTran Tran = new CoordinateTran();
    private float TZoom = 120.0f;
    private float YZoom = 8192.0f;
    int disChn = 3;
    transient int minIndex;
    transient int maxIndex;
    boolean isDragging = false;
    Point dragBegPoint = new Point();
    Point dragEndPoint = new Point();
    float yOffset = 0.0f;
    Dimension parentDim = new Dimension(640, 480);
    BorderLayout borderLayout1 = new BorderLayout();
    float minY;
    float maxY;

    public WavePaint(ChannelLocator cl) {
        this.cl = cl;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public WavePaint() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public void setWaveData(ChannelLocator cl) {
        this.cl = cl;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                WavePaint.this.this_mouseDragged(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                WavePaint.this.this_mousePressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                WavePaint.this.this_mouseReleased(e);
            }
        });
    }

    public Dimension getSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        try {
            if (this.getParent().getSize().width != 0) {
                this.parentDim = this.getParent().getSize();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int left = this.parentDim.height - this.parentDim.height / this.disChn * this.disChn;
        return new Dimension(this.parentDim.width, this.parentDim.height / this.disChn);
    }

    void this_mousePressed(MouseEvent e) {
        if (e.isControlDown()) {
            this.YZoom /= 2.0f;
        }
        if (e.isShiftDown()) {
            this.YZoom *= 2.0f;
        }
        this.repaint();
    }

    public void zoomOut() {
        this.YZoom /= 2.0f;
        this.repaint();
    }

    public void zoomIn() {
        this.YZoom *= 2.0f;
        this.repaint();
    }

    void this_mouseDragged(MouseEvent e) {
        if (this.isDragging) {
            this.dragEndPoint = e.getPoint();
        } else {
            this.isDragging = true;
            this.dragBegPoint = e.getPoint();
        }
    }

    void this_mouseReleased(MouseEvent e) {
        if (this.isDragging) {
            this.isDragging = false;
            this.yOffset += (float)(this.dragEndPoint.y - this.dragBegPoint.y) * this.Tran.getYScale();
            this.repaint();
        }
    }

    public void miniSeedEvent(MiniSeedPortEvent MiniSeedPortEvent2) {
        GenericMiniSeedRecord gmsRec = MiniSeedPortEvent2.getGenericMiniSeedRecord();
        if (gmsRec == null) {
            return;
        }
        long ms = gmsRec.getStartTime().getTime() + (long)((double)gmsRec.getNumSamples() / gmsRec.getSampleRate()) * 1000L;
        ms -= new Date().getTime();
        if (this.cl.getStationCode().equals(gmsRec.getStation()) && this.cl.getLocID().equals(gmsRec.getLocID()) && this.cl.getChanCode().equals(gmsRec.getChannel())) {
            this.fixQueue.addBack(gmsRec);
            if (this.isShowing()) {
                Graphics g = this.getGraphics();
                if (g == null) {
                    return;
                }
                this.paintSeedBlk(gmsRec, g);
                this.drawChnInfo(gmsRec, g);
                g.dispose();
            }
        }
    }

    private float[] calcStartEnd(float start, float end, float inteval) {
        Vector<Float> vec = new Vector<Float>();
        vec.addElement(new Float(start));
        int i = 1;
        while ((float)i * inteval < end) {
            vec.addElement(new Float((float)i++ * inteval));
        }
        vec.addElement(new Float(end));
        float[] step = new float[vec.size()];
        i = 0;
        while (i < step.length) {
            Float aFloat = (Float)vec.elementAt(i);
            step[i] = aFloat.floatValue();
            ++i;
        }
        return step;
    }

    public synchronized void paintSeedBlk(GenericMiniSeedRecord gmsRec, Graphics g) {
        gmsRec.decompress();
        int[] smps = gmsRec.getUData();
        TimeStamp time = gmsRec.getStartTime();
        GregorianCalendar c = new GregorianCalendar();
        Date d = new Date(time.getTime());
        c.setTime(d);
        double leftSec = (double)(c.getTimeInMillis() / 1000L % (long)((int)this.TZoom)) + (double)time.getNanoSecs() / 1.0E9;
        Dimension dim = this.getSize();
        double xScale = gmsRec.getSampleRate() * (double)this.TZoom / (double)dim.width;
        double yScale = this.YZoom / (float)dim.height;
        float Start2 = (float)(leftSec * gmsRec.getSampleRate());
        float End2 = Start2 + (float)gmsRec.getNumSamples();
        int Count = gmsRec.getNumSamples();
        int Width = dim.width;
        Point Pre = new Point();
        Point Next = new Point();
        Point Temp = new Point();
        int X1 = 0;
        float[] se = this.calcStartEnd(Start2, End2, this.TZoom * (float)gmsRec.getSampleRate());
        int j = 0;
        while (j < se.length - 1) {
            int pEnd;
            int pStart = (int)Math.round((double)se[j] / xScale) % Width;
            if (pStart > (pEnd = (int)Math.round((double)se[j + 1] / xScale) % Width)) {
                pEnd += Width;
            }
            Point aOPixel = new Point(pStart, dim.height / 2);
            this.Tran.setTran(aOPixel, 0.0f, this.yOffset, (float)xScale, (float)yScale);
            g.setColor(this.getBackground());
            g.fillRect(pStart, 1, pEnd - pStart, dim.height - 1);
            g.setColor(Color.red);
            g.fillRect(pEnd, 1, 2, dim.height - 1);
            g.setColor(Color.blue);
            X1 = 0;
            Temp = Next = this.Tran.toPixel(X1, smps[X1]);
            int n = 0;
            Point lastPoint = this.Tran.toPixel(this.lastPointX, this.lastPointY);
            if (!lastPoint.equals(new Point(0, 0)) && lastPoint.x <= pStart) {
                this.paintPixelX[2 * n] = lastPoint.x;
                this.paintPixelY[2 * n] = lastPoint.y;
                this.paintPixelX[2 * n + 1] = lastPoint.x;
                this.paintPixelY[2 * n + 1] = lastPoint.y;
                ++n;
            }
            int x = pStart;
            while (x < pEnd) {
                int X0 = X1;
                X1 = Math.round(this.Tran.toOrgX(new Point(x + 1, 0)));
                if (X1 < 0) {
                    logger.warn("bug in paintSeedBlk: X1= " + X1 + "  x= " + x + "  " + this.Tran);
                }
                if (X1 >= Count) break;
                this.findMinMax(smps, X0, X1);
                if (this.minIndex < this.maxIndex) {
                    Pre = this.Tran.toPixel(this.minIndex, smps[this.minIndex]);
                    Next = this.Tran.toPixel(this.maxIndex, smps[this.maxIndex]);
                } else {
                    Pre = this.Tran.toPixel(this.maxIndex, smps[this.maxIndex]);
                    Next = this.Tran.toPixel(this.minIndex, smps[this.minIndex]);
                }
                this.paintPixelX[2 * n] = Temp.x;
                this.paintPixelY[2 * n] = Temp.y;
                this.paintPixelX[2 * n + 1] = Pre.x;
                this.paintPixelY[2 * n + 1] = Pre.y;
                ++n;
                Temp = Next;
                ++x;
            }
            this.nPoints = 2 * n;
            g.drawPolyline(this.paintPixelX, this.paintPixelY, this.nPoints);
            ++j;
        }
        this.lastPointX = this.Tran.toOrgX(Pre);
        this.lastPointY = this.Tran.toOrgY(Pre);
    }

    public void paint(Graphics g) {
        super.paint(g);
        int size = this.fixQueue.getSize();
        GenericMiniSeedRecord gmsRec = null;
        int i = 0;
        while (i < size) {
            gmsRec = (GenericMiniSeedRecord)this.fixQueue.at(i);
            this.paintSeedBlk(gmsRec, g);
            ++i;
        }
        if (gmsRec != null) {
            this.drawChnInfo(gmsRec, g);
        }
    }

    private void drawChnInfo(GenericMiniSeedRecord gmsRec, Graphics g) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        long ms = gmsRec.getStartTime().getTime() + (long)((double)gmsRec.getNumSamples() / gmsRec.getSampleRate() * 1000.0);
        String Buffer2 = df.format(new Date(ms));
        g.setColor(Color.red);
        int fontHeight = this.getSize().height / 20;
        if (fontHeight < 12) {
            fontHeight = 12;
        }
        if (fontHeight > 24) {
            fontHeight = 24;
        }
        g.setFont(new Font("DialogInput", 0, fontHeight));
        String name = "[" + gmsRec.getNetwork() + "/" + gmsRec.getStation() + "/" + gmsRec.getLocID() + "/" + gmsRec.getChannel() + "]";
        Buffer2 = String.valueOf(name) + " at " + Buffer2;
        FontMetrics fm = g.getFontMetrics();
        g.setColor(this.getBackground());
        g.fillRect(2, this.getSize().height - fm.getHeight(), fm.stringWidth(Buffer2), fm.getHeight());
        g.setColor(Color.red);
        g.drawString(Buffer2, 2, this.getSize().height - fm.getDescent());
        String strYOffset = "" + (int)(-this.yOffset);
        g.setColor(this.getBackground());
        g.fillRect(2, this.getSize().height / 2 - fm.getHeight() / 2, fm.stringWidth(strYOffset), fm.getHeight());
        g.setColor(Color.black);
        g.drawString(strYOffset, 2, this.getSize().height / 2 + fm.getHeight() / 2 - fm.getDescent());
        String strYZoom = "" + (int)this.YZoom;
        g.setColor(this.getBackground());
        g.fillRect(2, 0, fm.stringWidth(strYZoom), fm.getHeight());
        g.setColor(Color.black);
        g.drawString(strYZoom, 2, fm.getHeight() - fm.getDescent());
    }

    public int getMaxCount(int[] smps, int Beg, int End2) {
        int imax = Math.abs(smps[Beg]);
        int i = Beg + 1;
        while (i < End2) {
            if (imax < Math.abs(smps[i])) {
                imax = Math.abs(smps[i]);
            }
            ++i;
        }
        return imax;
    }

    public int getPPCount(int[] smps, int Beg, int End2) {
        this.findMinMax(smps, Beg, End2);
        return Math.abs(smps[this.maxIndex] - smps[this.minIndex]);
    }

    void findMinMax(int[] smps, int Beg, int End2) {
        this.minIndex = Beg;
        this.maxIndex = Beg;
        int i = Beg + 1;
        while (i < End2) {
            if (smps[this.minIndex] <= smps[i]) {
                if (smps[this.maxIndex] <= smps[i]) {
                    this.maxIndex = i;
                }
            } else {
                this.minIndex = i;
            }
            ++i;
        }
    }

    public void setTZoom(float newTZoom) {
        this.TZoom = newTZoom;
    }

    public float getTZoom() {
        return this.TZoom;
    }

    public void setYZoom(float newYZoom) {
        this.YZoom = newYZoom;
    }

    public float getYZoom() {
        return this.YZoom;
    }

    public void setDisChn(int newDisChn) {
        this.disChn = newDisChn;
    }

    public int getDisChn() {
        return this.disChn;
    }

    public static void main(String[] args) throws IOException {
        SimpleFrame frame = new SimpleFrame("IPPlot");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        boolean bTCP = true;
        Properties props = new Properties();
        props.load(new FileInputStream("IPPlot.properties"));
        String connectionType = props.getProperty("IPPlot.connection.type");
        if (connectionType == null) {
            bTCP = true;
        } else {
            if (connectionType.equalsIgnoreCase("TCP")) {
                bTCP = true;
            }
            if (connectionType.equalsIgnoreCase("UDP")) {
                bTCP = false;
            }
        }
        String host = props.getProperty("IPPlot.connection.host");
        int port = Integer.parseInt(props.getProperty("IPPlot.connection.port"));
        String user = props.getProperty("IPPlot.connection.user");
        String password = props.getProperty("IPPlot.connection.password");
        String line = props.getProperty("IPPlot.channel");
        StringTokenizer st = new StringTokenizer(line, "+");
        String[] netID = new String[st.countTokens()];
        String[] stnCode = new String[st.countTokens()];
        String[] locID = new String[st.countTokens()];
        String[] chanCode = new String[st.countTokens()];
        int j = 0;
        while (st.hasMoreTokens()) {
            StringTokenizer st0 = new StringTokenizer(st.nextToken(), " /");
            netID[j] = st0.nextToken();
            stnCode[j] = st0.nextToken();
            locID[j] = st0.nextToken();
            chanCode[j++] = st0.nextToken();
        }
        frame.setStationInfo(netID, stnCode, locID, chanCode);
        WavePaint[] wavePaintZ = new WavePaint[stnCode.length];
        int i = 0;
        while (i < wavePaintZ.length) {
            wavePaintZ[i] = new WavePaint();
            wavePaintZ[i].setWaveData(new ChannelLocator(netID[i], stnCode[i], locID[i], chanCode[i]));
            wavePaintZ[i].setDisChn(wavePaintZ.length);
            ++i;
        }
        Panel box = new Panel();
        GridLayout gridLayout1 = new GridLayout();
        box.setLayout(gridLayout1);
        gridLayout1.setColumns(1);
        gridLayout1.setHgap(0);
        gridLayout1.setRows(0);
        gridLayout1.setVgap(0);
        int i2 = 0;
        while (i2 < wavePaintZ.length) {
            box.add(wavePaintZ[i2]);
            ++i2;
        }
        frame.add((Component)box, "Center");
        frame.setSize(300, 200);
        frame.setVisible(true);
        if (bTCP) {
            SSSPort miniSeedPort = new SSSPort(host, port, user, password, stnCode);
            miniSeedPort.addMiniSeedPortEventListener(frame);
            int i3 = 0;
            while (i3 < wavePaintZ.length) {
                miniSeedPort.addMiniSeedPortEventListener(wavePaintZ[i3]);
                ++i3;
            }
        } else {
            UDPPort udpPort = new UDPPort(host, port, stnCode);
            udpPort.addMiniSeedPortEventListener(frame);
            int i4 = 0;
            while (i4 < wavePaintZ.length) {
                udpPort.addMiniSeedPortEventListener(wavePaintZ[i4]);
                ++i4;
            }
        }
    }
}

