/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.realtimeplot.gui;

import cn.org.gddsn.liss.port.AbstractMiniSeedPort;
import cn.org.gddsn.liss.port.MiniSeedStreamInf;
import cn.org.gddsn.liss.port.event.MiniSeedPortEvent;
import cn.org.gddsn.liss.port.event.MiniSeedPortEventListener;
import cn.org.gddsn.liss.port.sss.SSSPort;
import cn.org.gddsn.liss.port.udp.UDPPort;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.realtimeplot.gui.IPPlotClass;
import cn.org.gddsn.seis.realtimeplot.gui.LocaleResource;
import cn.org.gddsn.seis.realtimeplot.gui.SetupDialog;
import cn.org.gddsn.seis.realtimeplot.gui.WavePaint;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class IPPlotFrame
extends JFrame
implements MiniSeedPortEventListener {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(IPPlotFrame.class);
    boolean tcp = true;
    ChannelLocator[] channelLocator = null;
    private String[] traceList = new String[]{"3", "6", "9", "12", "15", "18", "21", "24", "27", "30", "45", "60", "90", "all"};
    private String[] timeList = new String[]{"3", "6", "15", "30", "60", "120", "180", "360", "600", "1800", "3600"};
    boolean bRecord = false;
    WavePaint[] wps = null;
    int DisChn = 6;
    int begDisChn = 0;
    private boolean alarm;
    Hashtable<String, PrintWriter> tbl = new Hashtable();
    Hashtable<String, Boolean> firstTbl = new Hashtable();
    MiniSeedStreamInf mssi = null;
    JPanel controlPanel = new JPanel();
    private JComboBox jComboBoxTrk = null;
    private JComboBox jComboBoxTraceTime = null;
    private JCheckBox jCheckBoxAutoScale = null;
    JMenu jMenu1 = new JMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenu jmenuFile;
    JMenuBar jmenubar;
    JMenuItem jmItemStartRecord;
    JMenuItem jmItemStopRecord;
    JMenuItem jMenuFileExit = new JMenuItem();
    JPanel mainPanel = new JPanel();
    JPanel wpControlPanel = new JPanel();
    Box wpPanel = new Box(1);
    JScrollBar jScrollBarV = new JScrollBar();
    Box boxHBar = new Box(0);
    JScrollBar jScrollBarH = new JScrollBar(0);
    private JCheckBox jCheckBoxDisplayChannelInfo = null;

    public IPPlotFrame() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        new PeriodFlush(5000).start();
    }

    public IPPlotFrame(String title) {
        super(title);
        this.enableEvents(64L);
        try {
            this.loadConfiguration();
            this.jbInit();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.controlPanel, "North");
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.wpControlPanel, "Center");
        this.controlPanel.add((Component)this.getJComboBoxTrk(), null);
        this.controlPanel.add((Component)this.getJCheckBoxAutoScale(), null);
        this.controlPanel.add((Component)this.getJComboBoxTraceTime(), null);
        this.controlPanel.add((Component)this.getJCheckBoxDisplayChannelInfo(), null);
        this.wpControlPanel.setLayout(new BorderLayout());
        this.wpControlPanel.add((Component)this.wpPanel, "Center");
        this.wpControlPanel.add((Component)this.jScrollBarV, "East");
        this.wpControlPanel.add((Component)this.boxHBar, "South");
        this.boxHBar.add(this.jScrollBarH);
        int hight = this.jScrollBarH.getPreferredSize().height;
        this.boxHBar.add(Box.createRigidArea(new Dimension(hight, hight)));
        this.jScrollBarV.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                IPPlotFrame.this.jScrollBarV_adjustmentValueChanged(e);
            }
        });
        this.jScrollBarH.setEnabled(false);
        this.jmenuFile = new JMenu(LocaleResource.getResourceString("file"));
        this.jmItemStartRecord = new JMenuItem(LocaleResource.getResourceString("startRecord"));
        this.setTitle(LocaleResource.getResourceString("waveformScan"));
        this.jMenu1.setText(LocaleResource.getResourceString("set"));
        this.jMenu1.setEnabled(false);
        this.jMenuItem1.setText(LocaleResource.getResourceString("channel"));
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IPPlotFrame.this.jMenuItem1_actionPerformed(e);
            }
        });
        this.jmenuFile.add(this.jmItemStartRecord);
        this.jmItemStartRecord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IPPlotFrame.this.jmItemStartRecord_actionPerformed(e);
            }
        });
        this.jmItemStopRecord = new JMenuItem(LocaleResource.getResourceString("stopRecord"));
        this.jmItemStopRecord.setEnabled(false);
        this.jmItemStopRecord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IPPlotFrame.this.jmItemStopRecord_actionPerformed(e);
            }
        });
        this.jmenuFile.add(this.jmItemStopRecord);
        this.jMenuFileExit.setText(LocaleResource.getResourceString("exit"));
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IPPlotFrame.this.jMenuFileExit_actionPerformed(e);
            }
        });
        this.jmenuFile.add(this.jMenuFileExit);
        this.jmenubar = new JMenuBar();
        this.jmenubar.add(this.jmenuFile);
        this.jmenubar.add(this.jMenu1);
        this.jMenu1.add(this.jMenuItem1);
        this.setJMenuBar(this.jmenubar);
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    synchronized void jmItemStartRecord_actionPerformed(ActionEvent e) {
        this.bRecord = true;
        this.jmItemStartRecord.setEnabled(false);
        this.jmItemStopRecord.setEnabled(true);
        try {
            int i = 0;
            while (i < this.channelLocator.length) {
                String key = this.channelLocator[i].toUnderLineString();
                PrintWriter pw = new PrintWriter(new FileOutputStream(key));
                this.tbl.put(key, pw);
                this.firstTbl.put(key, new Boolean(true));
                ++i;
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    synchronized void jmItemStopRecord_actionPerformed(ActionEvent e) {
        this.bRecord = false;
        this.jmItemStartRecord.setEnabled(true);
        this.jmItemStopRecord.setEnabled(false);
        int i = 0;
        while (i < this.channelLocator.length) {
            String key = this.channelLocator[i].toUnderLineString();
            PrintWriter pw = this.tbl.get(key);
            pw.flush();
            pw.close();
            this.tbl.remove(key);
            this.firstTbl.remove(key);
            ++i;
        }
    }

    public synchronized void miniSeedEvent(MiniSeedPortEvent MiniSeedPortEvent2) {
        GenericMiniSeedRecord gmsRec = MiniSeedPortEvent2.getGenericMiniSeedRecord();
        if (gmsRec == null) {
            return;
        }
        if (this.bRecord) {
            String net = gmsRec.getNetwork();
            String stnCode = gmsRec.getStation();
            String locID = gmsRec.getLocID();
            String chanCode = gmsRec.getChannel();
            SimpleDateFormat dateFmt = new SimpleDateFormat("MM-dd-yyy");
            SimpleDateFormat timeFmt = new SimpleDateFormat("HH:mm:ss.ss");
            String key = String.valueOf(net) + "_" + stnCode + "_" + locID + "_" + chanCode;
            Boolean bFirst = this.firstTbl.get(key);
            PrintWriter pw = this.tbl.get(key);
            if (pw == null) {
                return;
            }
            if (bFirst.booleanValue()) {
                this.firstTbl.remove(key);
                this.firstTbl.put(key, new Boolean(false));
                pw.println("DATASET " + stnCode);
                pw.println("VERSION NXT");
                pw.println("SERIES " + chanCode);
                pw.println("DATE " + dateFmt.format(gmsRec.getStartTime()));
                pw.println("TIME " + timeFmt.format(gmsRec.getStartTime()));
                pw.println("FILE_TYPE ASCII");
                pw.println("NUM_SAMPS ALL");
                pw.println("INTERVAL " + 1.0 / gmsRec.getSampleRate());
                pw.println("X_OFFSET 0");
                pw.println("MAX_VAL 8388608");
                pw.println("MIN_VAL -8388608");
                pw.println("VERT_UNITS Counts");
                pw.println("HORZ_UNITS Sec");
                pw.println("COMMENT ");
                pw.println("DATA ");
            }
            gmsRec.decompress();
            int[] samps = gmsRec.getUData();
            int i = 0;
            while (i < samps.length) {
                pw.println(samps[i]);
                ++i;
            }
        }
    }

    public void loadConfiguration() {
        AbstractMiniSeedPort client;
        this.wps = new WavePaint[this.channelLocator.length];
        String[] stationCode = new String[this.channelLocator.length];
        int i = 0;
        while (i < this.wps.length) {
            this.wps[i] = new WavePaint();
            this.wps[i].setWaveData(this.channelLocator[i]);
            this.wps[i].setDisChn(this.DisChn);
            stationCode[i] = this.channelLocator[i].getStationCode();
            ++i;
        }
        i = 0;
        while (i < this.wps.length) {
            this.wpPanel.add(this.wps[i]);
            ++i;
        }
        if (this.mssi != null) {
            this.mssi.closePort();
        }
        if (this.tcp) {
            client = (SSSPort)IPPlotClass.factory.getBean("clissRTPort");
            ((SSSPort)client).setStationCode(stationCode);
            this.mssi = client;
        } else {
            client = (UDPPort)IPPlotClass.factory.getBean("udpPort");
            ((UDPPort)client).setStationCode(stationCode);
            this.mssi = client;
        }
        this.mssi.addMiniSeedPortEventListener(this);
        i = 0;
        while (i < this.wps.length) {
            this.mssi.addMiniSeedPortEventListener(this.wps[i]);
            ++i;
        }
        this.getJComboBoxTrk().setModel(new DefaultComboBoxModel<String>(this.traceList));
    }

    void setExtenalPort(MiniSeedStreamInf amssi) {
        int i;
        if (this.mssi != null) {
            this.mssi.closePort();
            this.mssi.removeMiniSeedPortEventListener(this);
            i = 0;
            while (i < this.wps.length) {
                this.mssi.removeMiniSeedPortEventListener(this.wps[i]);
                ++i;
            }
        }
        this.mssi = amssi;
        this.mssi.addMiniSeedPortEventListener(this);
        i = 0;
        while (i < this.wps.length) {
            this.mssi.addMiniSeedPortEventListener(this.wps[i]);
            ++i;
        }
    }

    void showDialog(Dialog dlg) {
        Dimension dlgSize = dlg.getSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    void jMenuItem1_actionPerformed(ActionEvent e) {
        SetupDialog setDlg = new SetupDialog(this, LocaleResource.getResourceString("setChannel"), true);
        this.showDialog(setDlg);
        if (setDlg.isReload()) {
            this.getContentPane().removeAll();
            this.loadConfiguration();
            this.validate();
        }
        System.exit(0);
    }

    void jScrollBarV_adjustmentValueChanged(AdjustmentEvent e) {
        this.wpPanel.validate();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.begDisChn = this.jScrollBarV.getValue();
        this.wpPanel.removeAll();
        int i = this.begDisChn;
        while (i < this.begDisChn + this.DisChn) {
            this.wpPanel.add((Component)this.wps[i], null);
            ++i;
        }
        this.wpPanel.validate();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setTcp(boolean tcp) {
        this.tcp = tcp;
    }

    public void setChannelLocator(ChannelLocator[] channelLocator) {
        this.channelLocator = channelLocator;
    }

    public void setAlarm(boolean alarm) {
        this.alarm = alarm;
    }

    public void setTraceList(String[] traceList) {
        this.traceList = traceList;
    }

    public boolean isAlarm() {
        return this.alarm;
    }

    public String[] getTraceList() {
        return this.traceList;
    }

    private JComboBox getJComboBoxTraceTime() {
        if (this.jComboBoxTraceTime == null) {
            this.jComboBoxTraceTime = new JComboBox();
            this.jComboBoxTraceTime.setToolTipText("Change Trace Time");
            this.jComboBoxTraceTime.setModel(new DefaultComboBoxModel<String>(this.timeList));
            this.jComboBoxTraceTime.setSelectedItem("120");
            this.jComboBoxTraceTime.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IPPlotFrame.this.jComboBoxTraceTime_itemStateChanged(e);
                }
            });
        }
        return this.jComboBoxTraceTime;
    }

    void jComboBoxTraceTime_itemStateChanged(ActionEvent e) {
        int i = 0;
        while (i < this.wps.length) {
            this.wps[i].setTZoom(Float.parseFloat((String)this.jComboBoxTraceTime.getSelectedItem()));
            this.wps[i].repaint();
            ++i;
        }
    }

    private JCheckBox getJCheckBoxAutoScale() {
        if (this.jCheckBoxAutoScale == null) {
            this.jCheckBoxAutoScale = new JCheckBox();
            this.jCheckBoxAutoScale.setSelected(true);
            this.jCheckBoxAutoScale.setText("Auto Scale");
            this.jCheckBoxAutoScale.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    IPPlotFrame.this.jCheckBoxAutoScale_itemStateChanged(e);
                }
            });
        }
        return this.jCheckBoxAutoScale;
    }

    private void jCheckBoxAutoScale_itemStateChanged(ItemEvent e) {
        int i = 0;
        while (i < this.wps.length) {
            this.wps[i].setAutoScale(this.jCheckBoxAutoScale.isSelected());
            this.wps[i].repaint();
            ++i;
        }
    }

    private JComboBox getJComboBoxTrk() {
        if (this.jComboBoxTrk == null) {
            this.jComboBoxTrk = new JComboBox();
            this.jComboBoxTrk.setToolTipText("Change Trace Number");
            this.jComboBoxTrk.setMaximumSize(new Dimension(50, 24));
            this.jComboBoxTrk.setPreferredSize(new Dimension(50, 24));
            this.jComboBoxTrk.setMinimumSize(new Dimension(50, 24));
            this.jComboBoxTrk.setModel(new DefaultComboBoxModel<String>(this.traceList));
            this.jComboBoxTrk.setSelectedItem("all");
            this.jComboBoxTrk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IPPlotFrame.this.jComboBoxTrk_actionPerformed(e);
                }
            });
        }
        return this.jComboBoxTrk;
    }

    void jComboBoxTrk_actionPerformed(ActionEvent e) {
        String selectedItem = (String)this.jComboBoxTrk.getSelectedItem();
        if (selectedItem == "all") {
            this.DisChn = this.wps.length;
        } else {
            this.DisChn = Integer.parseInt(selectedItem);
            if (this.DisChn > this.wps.length) {
                this.DisChn = this.wps.length;
            }
        }
        this.jScrollBarV.setValues(0, this.DisChn, 0, this.wps.length);
        this.jScrollBarV.setBlockIncrement(this.DisChn - 1);
        int i = 0;
        while (i < this.wps.length) {
            this.wps[i].setDisChn(this.DisChn);
            ++i;
        }
        this.wpPanel.removeAll();
        i = this.begDisChn;
        while (i < this.begDisChn + this.DisChn) {
            this.wpPanel.add((Component)this.wps[i], null);
            ++i;
        }
        this.wpPanel.validate();
    }

    private JCheckBox getJCheckBoxDisplayChannelInfo() {
        if (this.jCheckBoxDisplayChannelInfo == null) {
            this.jCheckBoxDisplayChannelInfo = new JCheckBox();
            this.jCheckBoxDisplayChannelInfo.setText("ChanInfo");
            this.jCheckBoxDisplayChannelInfo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    int i = 0;
                    while (i < IPPlotFrame.this.wps.length) {
                        IPPlotFrame.this.wps[i].setShowChanInfo(IPPlotFrame.this.jCheckBoxDisplayChannelInfo.isSelected());
                        IPPlotFrame.this.wps[i].repaint();
                        ++i;
                    }
                }
            });
        }
        return this.jCheckBoxDisplayChannelInfo;
    }

    class PeriodFlush
    extends Timer
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            IPPlotFrame.this.jComboBoxTraceTime_itemStateChanged(e);
        }

        PeriodFlush(int ms) {
            super(ms, null);
            this.addActionListener(this);
        }
    }
}

