/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.rts;

import cn.org.gddsn.jopens.entity.EventInfo;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.service.EventExportPlugin;
import cn.org.gddsn.jopens.service.SeedExporterUtil;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.util.Log4jConfig;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class AutoExportSeedVolume
implements Runnable {
    static Logger logger = Logger.getLogger(AutoExportSeedVolume.class);
    public static ApplicationContext ctx;
    private int hourOfDay = 8;
    private int moh = 3;
    private String exportPath;
    private SeedVolumeService seedVolumeService;
    private String netRegexp;
    private String stationRegexp;

    public void run() {
        while (true) {
            Date now = new Date();
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(now);
            int hod = c.get(11);
            int amoh = c.get(12);
            long ms = now.getTime() / 86400000L * 86400000L;
            if (hod == this.hourOfDay && this.moh == amoh) {
                this.export(new Date(ms - 172800000L));
            }
            try {
                Thread.sleep(40000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void export(Date begDate) {
        Date endDate = new Date(begDate.getTime() + 86400000L);
        List<EventInfo> evtList = this.seedVolumeService.findEventInfoList(begDate, endDate);
        logger.info("export...");
        for (EventInfo ei : evtList) {
            String eid = ei.getEventId();
            logger.info("exporting " + eid);
            File exFile = new File(this.exportPath, String.valueOf(eid) + ".seed");
            this.seedVolumeExport(this.seedVolumeService, exFile.getAbsolutePath(), ei.getStartTime(), ei.getEndTime(), this.netRegexp, this.stationRegexp);
        }
        logger.info("export operation finised.");
    }

    private boolean seedVolumeExport(SeedVolumeService exportService, String exportFileName, Date startTime, Date endTime, String netRegexp, String stationRegexp) {
        SeedExporterUtil util = new SeedExporterUtil();
        EventExportPlugin seedExportPlugin = new EventExportPlugin();
        seedExportPlugin.setStationService(exportService);
        seedExportPlugin.setWaveformService(exportService);
        util.setSeedExportPlugin(seedExportPlugin);
        Dataless dl = exportService.findDefaultDataless();
        seedExportPlugin.setDataless(dl);
        util.setStartTime(startTime);
        util.setEndTime(endTime);
        util.setFile(new File(exportFileName));
        util.setNetStationRegexp(netRegexp, stationRegexp);
        try {
            util.export();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
            return false;
        }
        logger.info("exported seed volume data into " + util.getFile());
        return true;
    }

    boolean seedVolumeExport(SeedVolumeService exportService, String exportFileName, String eventId, String netRegexp, String stationRegexp) {
        SeedExporterUtil util = new SeedExporterUtil();
        EventExportPlugin seedExportPlugin = new EventExportPlugin();
        seedExportPlugin.setStationService(exportService);
        seedExportPlugin.setWaveformService(exportService);
        util.setSeedExportPlugin(seedExportPlugin);
        Dataless dl = exportService.findDatalessByEventId(eventId);
        seedExportPlugin.setDataless(dl);
        util.setEventId(eventId);
        util.setFile(new File(exportFileName));
        util.setNetStationRegexp(netRegexp, stationRegexp);
        try {
            util.export();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
            return false;
        }
        logger.info("exported seed volume data into " + util.getFile());
        return true;
    }

    public String getExportPath() {
        return this.exportPath;
    }

    public void setExportPath(String exportPath) {
        this.exportPath = exportPath;
    }

    public int getHourOfDay() {
        return this.hourOfDay;
    }

    public void setHourOfDay(int hourOfDay) {
        this.hourOfDay = hourOfDay;
    }

    public int getMoh() {
        return this.moh;
    }

    public void setMoh(int moh) {
        this.moh = moh;
    }

    public String getNetRegexp() {
        return this.netRegexp;
    }

    public void setNetRegexp(String netRegexp) {
        this.netRegexp = netRegexp;
    }

    public SeedVolumeService getSeedVolumeService() {
        return this.seedVolumeService;
    }

    public void setSeedVolumeService(SeedVolumeService seedVolumeService) {
        this.seedVolumeService = seedVolumeService;
    }

    public String getStationRegexp() {
        return this.stationRegexp;
    }

    public void setStationRegexp(String stationRegexp) {
        this.stationRegexp = stationRegexp;
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain("AutoExportSeedVolume.properties");
        ctx = new FileSystemXmlApplicationContext(new String[]{"AutoExportSeedVolume.xml"});
        AutoExportSeedVolume aesv = (AutoExportSeedVolume)ctx.getBean("aesv");
        if (args.length == 0) {
            Thread thr = new Thread(aesv);
            thr.start();
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd.HH:mm:ss");
            Date beg = sdf.parse(args[0]);
            int nday = 1;
            if (args.length > 1) {
                nday = Integer.parseInt(args[1]);
            }
            int i = 0;
            while (i < nday) {
                aesv.export(new Date(beg.getTime() + (long)(i * 24 * 3600) * 1000L));
                ++i;
            }
        }
    }
}

