/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.rts;

import cn.org.gddsn.liss.client.LissClient;
import cn.org.gddsn.liss.client.LissException;
import cn.org.gddsn.liss.client.LissOutputStream;
import cn.org.gddsn.util.Log4jConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;

public class MiniSeed2Server
implements Runnable {
    static Logger logger = Logger.getLogger(MiniSeed2Server.class);
    private LissClient lissClient = null;
    private String eventDirectory;
    private BufferedOutputStream socketOutputStream = null;
    private String[] stnCodes;

    public void run() {
        try {
            this.connectServer(this.stnCodes);
            logger.info("connected SSS");
            this.processDirectory(new File(this.eventDirectory));
            this.closeServer();
            logger.info("closed SSS");
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    private void connectServer(String[] stnCodes) throws Exception {
        this.lissClient.init();
        String[] stringArray = stnCodes;
        int n = stnCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String ns = stringArray[n2];
            try {
                this.lissClient.addStation(new String[]{ns});
            }
            catch (LissException ex) {
                logger.info(ex);
            }
            ++n2;
        }
        this.lissClient.setRtServerPassiveMode(true);
        LissOutputStream lissOutputStream = null;
        lissOutputStream = this.lissClient.storeRealTimeStream(stnCodes);
        this.socketOutputStream = new BufferedOutputStream(lissOutputStream);
    }

    private void closeServer() throws Exception {
        this.socketOutputStream.close();
        this.lissClient.quit();
    }

    private void processDirectory(File dir) throws Exception {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.processDirectory(files[i]);
            } else {
                this.processFile(files[i]);
            }
            ++i;
        }
    }

    private void processFile(File evtFile) throws Exception {
        logger.info("process " + evtFile.getPath());
        BufferedInputStream bis = null;
        byte[] buf = new byte[4096];
        int len = 0;
        try {
            bis = new BufferedInputStream(new FileInputStream(evtFile.getPath()));
            while ((len = bis.read(buf)) > 0) {
                if (buf[6] != 68 && buf[6] != 81 && buf[6] != 82) continue;
                this.socketOutputStream.write(buf, 0, len);
            }
        }
        catch (EOFException ex) {
            logger.info("EOF: " + evtFile.getPath());
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage());
            logger.warn("could not process " + evtFile);
        }
    }

    public String getEventDirectory() {
        return this.eventDirectory;
    }

    public void setEventDirectory(String eventDirectory) {
        this.eventDirectory = eventDirectory;
    }

    public LissClient getLissClient() {
        return this.lissClient;
    }

    public void setLissClient(LissClient lissClient) {
        this.lissClient = lissClient;
    }

    public String[] getStnCodes() {
        return this.stnCodes;
    }

    public void setStnCodes(String[] stnCodes) {
        this.stnCodes = stnCodes;
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain("MiniSeed2Server.properties");
        FileSystemResource res = new FileSystemResource("MiniSeed2Server.xml");
        XmlBeanFactory factory = new XmlBeanFactory(res);
        MiniSeed2Server miniSeed2Server = (MiniSeed2Server)factory.getBean("miniSeed2Server");
        miniSeed2Server.run();
    }
}

