/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.rts;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class PlayWave
implements Runnable {
    private String filename;
    private Position curPosition;
    private final int EXTERNAL_BUFFER_SIZE = 524288;
    private boolean playing = false;

    public static void main(String[] args) {
        PlayWave d = new PlayWave("audio/alarm.au");
        new Thread(d).start();
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public PlayWave(String wavfile) {
        this.filename = wavfile;
        this.curPosition = Position.NORMAL;
    }

    public PlayWave(String wavfile, Position p) {
        this.filename = wavfile;
        this.curPosition = p;
    }

    public void run() {
        this.playing = true;
        File soundFile = new File(this.filename);
        if (!soundFile.exists()) {
            System.err.println("Wave file not found: " + this.filename);
            return;
        }
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(soundFile);
        }
        catch (UnsupportedAudioFileException e1) {
            e1.printStackTrace();
            return;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        AudioFormat format = audioInputStream.getFormat();
        if (format.getEncoding() == AudioFormat.Encoding.ULAW || format.getEncoding() == AudioFormat.Encoding.ALAW) {
            AudioFormat tmp = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
            audioInputStream = AudioSystem.getAudioInputStream(tmp, audioInputStream);
            format = tmp;
        }
        SourceDataLine auline = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        try {
            auline = (SourceDataLine)AudioSystem.getLine(info);
            auline.open(format);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (auline.isControlSupported(FloatControl.Type.PAN)) {
            FloatControl pan = (FloatControl)auline.getControl(FloatControl.Type.PAN);
            if (this.curPosition == Position.RIGHT) {
                pan.setValue(1.0f);
            } else if (this.curPosition == Position.LEFT) {
                pan.setValue(-1.0f);
            }
        }
        auline.start();
        int nBytesRead = 0;
        byte[] abData = new byte[524288];
        try {
            try {
                while (nBytesRead != -1) {
                    nBytesRead = audioInputStream.read(abData, 0, abData.length);
                    if (nBytesRead < 0) continue;
                    auline.write(abData, 0, nBytesRead);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                auline.drain();
                auline.close();
                this.playing = false;
                return;
            }
        }
        finally {
            auline.drain();
            auline.close();
            this.playing = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Position {
        LEFT,
        RIGHT,
        NORMAL;

    }
}

