/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.rts;

import cn.org.gddsn.db.ConnectionPool;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.util.Log4jConfig;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;

public class WaveformMig
implements Runnable {
    static Logger logger = Logger.getLogger(WaveformMig.class);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String startTime;
    private String endTime;
    private String srcTableName = "Waveform_con_old";
    private String dstTableName = "Waveform_con";
    private int slidingInSecond = 600;
    private ConnectionPool srcPool = null;
    private ConnectionPool dstPool = null;

    public void run() {
        long ntotal;
        block35: {
            Connection srcConn = null;
            Connection dstConn = null;
            Statement srcStmt = null;
            Statement insertStatement = null;
            ResultSet srcRS = null;
            ResultSet dstRS = null;
            ntotal = 0L;
            try {
                Timestamp startTS = new Timestamp(SDF.parse(this.startTime).getTime());
                Timestamp endTS = new Timestamp(SDF.parse(this.endTime).getTime());
                srcConn = this.srcPool.getConnection();
                String ctnStr = "select * from " + this.srcTableName + " where Start_time>=? and Start_time < ? order by Start_time, Start_time_frac";
                String insertString = "INSERT INTO " + this.dstTableName + " (id,Net_code," + "Sta_code,Loc_id,Chn_code,Serial_number,Start_time,Start_time_frac," + "End_time,End_time_frac,nsamples,Samp_rate,Encode_format," + "Active_flag,Word_order,Rec_lenth,waveform,Channel_id,Event_id,Chunk_size,day_of_year,cl_hash) " + "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?)";
                dstConn = this.dstPool.getConnection();
                dstConn.setAutoCommit(false);
                insertStatement = dstConn.prepareStatement(insertString);
                GregorianCalendar c = new GregorianCalendar();
                long st = startTS.getTime();
                long ed = endTS.getTime();
                int step = this.slidingInSecond * 1000;
                long i = st;
                while (i < ed) {
                    srcStmt = srcConn.prepareStatement(ctnStr);
                    srcStmt.setTimestamp(1, new Timestamp(i));
                    srcStmt.setTimestamp(2, new Timestamp(i + (long)step));
                    logger.info("Sending data from: " + new Timestamp(i) + " to " + new Timestamp(i + (long)step));
                    srcRS = srcStmt.executeQuery();
                    while (srcRS.next()) {
                        long id = srcRS.getLong("id");
                        logger.info("" + id);
                        insertStatement.setLong(1, id);
                        String net = srcRS.getString("Net_code");
                        String sta = srcRS.getString("Sta_code");
                        String locId = srcRS.getString("Loc_id");
                        String cha = srcRS.getString("Chn_code");
                        insertStatement.setString(2, net);
                        insertStatement.setString(3, sta);
                        insertStatement.setString(4, locId);
                        insertStatement.setString(5, cha);
                        insertStatement.setInt(6, srcRS.getInt("Serial_number"));
                        insertStatement.setTimestamp(7, srcRS.getTimestamp("Start_time"));
                        insertStatement.setInt(8, srcRS.getInt("Start_time_frac"));
                        insertStatement.setTimestamp(9, srcRS.getTimestamp("End_time"));
                        insertStatement.setInt(10, srcRS.getInt("End_time_frac"));
                        insertStatement.setInt(11, srcRS.getInt("nsamples"));
                        insertStatement.setFloat(12, srcRS.getFloat("Samp_rate"));
                        insertStatement.setInt(13, srcRS.getInt("Encode_format"));
                        insertStatement.setInt(14, srcRS.getInt("Active_flag"));
                        insertStatement.setInt(15, srcRS.getInt("Word_order"));
                        insertStatement.setInt(16, srcRS.getInt("Rec_lenth"));
                        insertStatement.setBlob(17, srcRS.getBlob("waveform"));
                        insertStatement.setNull(18, -5);
                        insertStatement.setString(19, srcRS.getString("Event_id"));
                        insertStatement.setInt(20, 1);
                        c.setTime(new Date(srcRS.getTimestamp("Start_time").getTime()));
                        insertStatement.setInt(21, c.get(6));
                        ChannelLocator cl = new ChannelLocator(net, sta, locId, cha);
                        insertStatement.setInt(22, cl.hashCode());
                        insertStatement.executeUpdate();
                    }
                    srcRS.close();
                    srcStmt.close();
                    i += (long)(this.slidingInSecond * 1000);
                }
                dstConn.commit();
            }
            catch (ParseException paEx) {
                logger.warn(paEx.getMessage(), paEx);
                try {
                    if (dstRS != null) {
                        dstRS.close();
                    }
                    if (srcRS != null) {
                        srcRS.close();
                    }
                    if (srcStmt != null) {
                        srcStmt.close();
                    }
                    if (insertStatement != null) {
                        insertStatement.close();
                    }
                    if (srcConn != null) {
                        srcConn.close();
                    }
                    this.srcPool.destroy();
                    if (dstConn != null) {
                        dstConn.close();
                    }
                    this.dstPool.destroy();
                }
                catch (Exception exception) {}
                break block35;
            }
            catch (SQLException sqlEx) {
                try {
                    logger.warn(sqlEx.getMessage(), sqlEx);
                    break block35;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (dstRS != null) {
                            dstRS.close();
                        }
                        if (srcRS != null) {
                            srcRS.close();
                        }
                        if (srcStmt != null) {
                            srcStmt.close();
                        }
                        if (insertStatement != null) {
                            insertStatement.close();
                        }
                        if (srcConn != null) {
                            srcConn.close();
                        }
                        this.srcPool.destroy();
                        if (dstConn != null) {
                            dstConn.close();
                        }
                        this.dstPool.destroy();
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                if (dstRS != null) {
                    dstRS.close();
                }
                if (srcRS != null) {
                    srcRS.close();
                }
                if (srcStmt != null) {
                    srcStmt.close();
                }
                if (insertStatement != null) {
                    insertStatement.close();
                }
                if (srcConn != null) {
                    srcConn.close();
                }
                this.srcPool.destroy();
                if (dstConn != null) {
                    dstConn.close();
                }
                this.dstPool.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        logger.info("Total sent " + ntotal + " packets");
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain("WaveformMig.properties");
        FileSystemResource res = new FileSystemResource("WaveformMig.xml");
        XmlBeanFactory factory = new XmlBeanFactory(res);
        WaveformMig jdbc2Server = (WaveformMig)factory.getBean("waveformMig");
        jdbc2Server.run();
    }

    public void setSrcPool(ConnectionPool connectionPool) {
        this.srcPool = connectionPool;
    }

    public ConnectionPool getSrcPool() {
        return this.srcPool;
    }

    public String getSrcTableName() {
        return this.srcTableName;
    }

    public void setSrcTableName(String tableName) {
        this.srcTableName = tableName;
    }

    public ConnectionPool getDstPool() {
        return this.dstPool;
    }

    public void setDstPool(ConnectionPool dstPool) {
        this.dstPool = dstPool;
    }

    public String getDstTableName() {
        return this.dstTableName;
    }

    public void setDstTableName(String dstTableName) {
        this.dstTableName = dstTableName;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }
}

