/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

import JSci.maths.Complex;
import cn.org.gddsn.signal.FFT;
import cn.org.gddsn.signal.Numeric;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;

public class FFTFilter {
    private Complex[] pole;
    private Complex[] zero;
    private double norm = 1.0;
    public static final FFTFilter WoodAnderson_VEL = new FFTFilter(new Complex[]{new Complex(0.0, 0.0)}, new Complex[]{new Complex(-5.4192, 5.684), new Complex(-5.4192, -5.684)}, 0.999375);
    public static final FFTFilter WoodAnderson_VEL_GFZ = new FFTFilter(new Complex[]{new Complex(0.0, 0.0)}, new Complex[]{new Complex(-6.283185, -4.712389), new Complex(-6.283185, 4.712389)}, 1.0044);
    public static final FFTFilter WoodAnderson_DIS = new FFTFilter(new Complex[]{new Complex(0.0, 0.0), new Complex(0.0, 0.0)}, new Complex[]{new Complex(-6.283185, -4.712389), new Complex(-6.283185, 4.712389)}, 1.00448);
    public static final FFTFilter WWSSN_SP_VEL_GFZ = new FFTFilter(new Complex[]{new Complex(0.0, 0.0), new Complex(0.0, 0.0)}, new Complex[]{new Complex(-4.009271, -4.442279), new Complex(-4.009271, 4.442279), new Complex(-4.607669, -6.996659), new Complex(-4.607669, 6.996659)}, 16.131132869797597);
    public static final FFTFilter WWSSN_SP_VEL = new FFTFilter(new Complex[]{new Complex(0.0, 0.0), new Complex(0.0, 0.0)}, new Complex[]{new Complex(-3.73, 6.22), new Complex(-3.73, -6.22), new Complex(-5.61, 0.0), new Complex(-13.2, 0.0), new Complex(-21.1, 0.0)}, 531.9);
    public static final FFTFilter WWSSN_SP_DIS = new FFTFilter(new Complex[]{new Complex(0.0, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0)}, new Complex[]{new Complex(-4.009271, -4.442279), new Complex(-4.009271, 4.442279), new Complex(-4.607669, -6.996659), new Complex(-4.607669, 6.996659)}, 16.131132869797597);

    public FFTFilter() {
    }

    public FFTFilter(Complex[] zero, Complex[] pole, double norm) {
        this.zero = zero;
        this.pole = pole;
        this.norm = norm;
    }

    public void apply(double[] f, double fsamp) {
        int samp = f.length;
        int nfft = Numeric.nextPowerOf2(samp);
        double[] re = new double[nfft];
        double[] im = new double[nfft];
        int i = 0;
        while (i < nfft) {
            re[i] = i < samp ? f[i] : 0.0;
            im[i] = 0.0;
            ++i;
        }
        FFT afft = new FFT();
        afft.doFFT(re, im, nfft, -1);
        int i2 = 0;
        while (i2 <= nfft / 2) {
            double freq = (double)i2 / (double)nfft * fsamp;
            Complex a = new Complex(re[i2], im[i2]);
            Complex b = this.response(freq);
            Complex c = a.multiply(b);
            re[i2] = c.real() * this.norm;
            im[i2] = c.imag() * this.norm;
            if (i2 != 0 && i2 != nfft / 2) {
                re[nfft - i2] = re[i2];
                im[nfft - i2] = -im[i2];
            }
            ++i2;
        }
        afft.doFFT(re, im, nfft, 1);
        re = afft.getReal();
        i2 = 0;
        while (i2 < samp) {
            f[i2] = re[i2];
            ++i2;
        }
    }

    public Complex response(double freq) {
        Complex rsp = new Complex(1.0, 0.0);
        Complex jomg = new Complex(0.0, Math.PI * 2 * freq);
        Complex c = new Complex(0.0, 0.0);
        int i = 0;
        while (i < this.zero.length) {
            c = jomg.subtract(this.zero[i]);
            rsp = rsp.multiply(c);
            ++i;
        }
        i = 0;
        while (i < this.pole.length) {
            c = jomg.subtract(this.pole[i]);
            rsp = rsp.divide(c);
            ++i;
        }
        return rsp;
    }

    public static Complex response(int nz, int np, double freq, Complex[] z, Complex[] p) {
        Complex rsp = new Complex(1.0, 0.0);
        Complex jomg = new Complex(0.0, Math.PI * 2 * freq);
        Complex c = new Complex(0.0, 0.0);
        int i = 0;
        while (i < nz) {
            c = jomg.subtract(z[i]);
            rsp = rsp.multiply(c);
            ++i;
        }
        i = 0;
        while (i < np) {
            c = jomg.subtract(p[i]);
            rsp = rsp.divide(c);
            ++i;
        }
        return rsp;
    }

    public static double normalf(Complex[] zero, Complex[] pole, double A0, double freq) {
        Complex c;
        Complex rsp = new Complex(1.0, 0.0);
        Complex jomg = new Complex(0.0, Math.PI * 2 * freq);
        int i = 0;
        while (i < zero.length) {
            c = jomg.subtract(zero[i]);
            rsp = rsp.multiply(c);
            ++i;
        }
        i = 0;
        while (i < pole.length) {
            c = jomg.subtract(pole[i]);
            rsp = rsp.divide(c);
            ++i;
        }
        return rsp.mod() * A0;
    }

    public double groupDelay(double f) {
        Complex rsp1 = this.response(f);
        Complex rsp2 = this.response(f + 0.001);
        double pha1 = Math.atan2(rsp1.imag(), rsp1.real());
        double pha2 = Math.atan2(rsp2.imag(), rsp2.real());
        return -(pha2 - pha1) / 0.006283185307179587;
    }

    public double phsdelay(double f) {
        Complex rsp = this.response(f);
        double pha = Math.atan2(rsp.imag(), rsp.real());
        return -pha / (f * 2.0 * Math.PI);
    }

    public static void main(String[] args) throws Exception {
        double[] v = new double[55000];
        BufferedReader br = new BufferedReader(new FileReader("/tmp/HSH.txt"));
        int i = 0;
        while (i < v.length) {
            v[i] = Double.parseDouble(br.readLine());
            ++i;
        }
        WoodAnderson_VEL.apply(v, 50.0);
        try {
            FileWriter fos = new FileWriter("/tmp/result.txt");
            int i2 = 0;
            while (i2 < v.length) {
                fos.write(String.valueOf(v[i2]) + "\n");
                ++i2;
            }
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

