/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

import VisualNumerics.math.DoubleLU;
import VisualNumerics.math.MathException;
import cn.org.gddsn.signal.FilterDB;

public class Filter {
    private static IllegalArgumentException errException = new IllegalArgumentException("Data must have length more than 3 times filter order.");
    private double[] _b;
    private double[] _a;
    private double[] _zi;

    public static double[] filter(double[] b, double[] a, double[] x, double[] Zi) {
        int len = Math.max(b.length, a.length);
        int nb = b.length;
        int na = a.length;
        if (nb < len) {
            double[] b1 = new double[len];
            System.arraycopy(b, 0, b1, 0, nb);
            b = b1;
        }
        if (na < len) {
            double[] a1 = new double[len];
            System.arraycopy(a, 0, a1, 0, na);
            a = a1;
        }
        double[] y = new double[x.length];
        if (len - 1 > Zi.length) {
            throw errException;
        }
        int order = len - 1;
        int i = 0;
        while (i < x.length) {
            y[i] = b[0] * x[i] + Zi[0];
            int j = 0;
            while (j < order - 1) {
                Zi[j] = b[j + 1] * x[i] + Zi[j + 1] - a[j + 1] * y[i];
                ++j;
            }
            Zi[order - 1] = b[order] * x[i] - a[order] * y[i];
            ++i;
        }
        return y;
    }

    public double[] filter(double[] x) {
        return Filter.filter(this._b, this._a, x, this._zi);
    }

    public double[] filter(int[] x) {
        double[] dx = new double[x.length];
        int i = 0;
        while (i < x.length) {
            dx[i] = x[i];
            ++i;
        }
        double[] ret = this.filter(dx);
        return ret;
    }

    public int[] ifilter(int[] x) {
        double[] dx = new double[x.length];
        int i = 0;
        while (i < x.length) {
            dx[i] = x[i];
            ++i;
        }
        double[] ret = this.filter(dx);
        int[] iret = new int[x.length];
        int i2 = 0;
        while (i2 < x.length) {
            iret[i2] = (int)ret[i2];
            ++i2;
        }
        dx = null;
        ret = null;
        return iret;
    }

    public static double[] filter(double[] b, double[] a, double[] x) {
        int len = Math.max(b.length, a.length);
        double[] Zi = new double[len];
        return Filter.filter(b, a, x, Zi);
    }

    public static double[] filter(FilterDB filterDB, double[] x) {
        return Filter.filter(filterDB.getNum(), filterDB.getDen(), x);
    }

    public static double[] filtfilt(double[] b, double[] a, double[] x) {
        double swap;
        int len = x.length;
        int nb = b.length;
        int na = a.length;
        int nfilt = Math.max(nb, na);
        int nfact = 3 * (nfilt - 1);
        if (len <= nfact) {
            throw errException;
        }
        if (nb < nfilt) {
            double[] b1 = new double[nfilt];
            System.arraycopy(b, 0, b1, 0, nb);
            b = b1;
        }
        if (na < nfilt) {
            double[] a1 = new double[nfilt];
            System.arraycopy(a, 0, a1, 0, na);
            a = a1;
        }
        double[] B = new double[nfilt - 1];
        double[][] A = new double[nfilt - 1][nfilt - 1];
        int i = 0;
        while (i < nfilt - 1) {
            B[i] = b[i + 1] - a[i + 1] * b[0];
            ++i;
        }
        A[0][0] = 1.0;
        i = 0;
        while (i < nfilt - 1) {
            int j = 0;
            while (j < nfilt - 1) {
                if (j == 0) {
                    double[] dArray = A[i];
                    int n = j;
                    dArray[n] = dArray[n] + a[i + 1];
                } else if (i == j) {
                    A[i][j] = 1.0;
                } else if (i + 1 == j) {
                    A[i][j] = -1.0;
                }
                ++j;
            }
            ++i;
        }
        double[] zi = new double[nfilt - 1];
        try {
            DoubleLU aLU = new DoubleLU(A);
            zi = aLU.solve(B);
        }
        catch (MathException aLU) {
            // empty catch block
        }
        B = null;
        A = null;
        double[] y = new double[len + 2 * nfact];
        int i2 = 0;
        while (i2 < nfact) {
            y[i2] = 2.0 * x[0] - x[nfact - i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < len) {
            y[i2 + nfact] = x[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < nfact) {
            y[i2 + len + nfact] = 2.0 * x[len - 1] - x[len - 2 - i2];
            ++i2;
        }
        double[] tmpZi = new double[zi.length];
        int i3 = 0;
        while (i3 < tmpZi.length) {
            tmpZi[i3] = zi[i3] * y[0];
            ++i3;
        }
        y = Filter.filter(b, a, y, tmpZi);
        int ylen = y.length - 1;
        int i4 = 0;
        while (i4 < y.length / 2) {
            swap = y[i4];
            y[i4] = y[ylen - i4];
            y[ylen - i4] = swap;
            ++i4;
        }
        i4 = 0;
        while (i4 < tmpZi.length) {
            tmpZi[i4] = zi[i4] * y[0];
            ++i4;
        }
        y = Filter.filter(b, a, y, tmpZi);
        ylen = y.length - 1;
        i4 = 0;
        while (i4 < y.length / 2) {
            swap = y[i4];
            y[i4] = y[ylen - i4];
            y[ylen - i4] = swap;
            ++i4;
        }
        double[] ret = new double[len];
        int i5 = 0;
        while (i5 < len) {
            ret[i5] = y[nfact + i5];
            ++i5;
        }
        y = null;
        tmpZi = null;
        return ret;
    }

    public double[] filtfilt(double[] x) {
        return Filter.filtfilt(this._b, this._a, x);
    }

    public int[] filtfilt(int[] x) {
        double[] dx = new double[x.length];
        int i = 0;
        while (i < x.length) {
            dx[i] = x[i];
            ++i;
        }
        double[] ret = this.filtfilt(dx);
        int[] iret = new int[x.length];
        int i2 = 0;
        while (i2 < x.length) {
            iret[i2] = (int)ret[i2];
            ++i2;
        }
        dx = null;
        ret = null;
        return iret;
    }

    public double[] getNumCoef() {
        return this._b;
    }

    public double[] getDenCoef() {
        return this._a;
    }

    public static int[] filtfilt(double[] b, double[] a, int[] x) {
        double[] dx = new double[x.length];
        int i = 0;
        while (i < x.length) {
            dx[i] = x[i];
            ++i;
        }
        double[] ret = Filter.filtfilt(b, a, dx);
        int[] iret = new int[x.length];
        int i2 = 0;
        while (i2 < x.length) {
            iret[i2] = (int)ret[i2];
            ++i2;
        }
        dx = null;
        ret = null;
        return iret;
    }

    public static double[] filtfilt(FilterDB filterDB, double[] x) {
        return Filter.filtfilt(filterDB.getNum(), filterDB.getDen(), x);
    }

    public Filter(double[] b, double[] a) {
        this._b = b;
        this._a = a;
        int len = Math.max(b.length, a.length);
        this._zi = new double[len];
    }

    public Filter(FilterDB db) {
        this._b = db.getNum();
        this._a = db.getDen();
        int len = Math.max(this._b.length, this._a.length);
        this._zi = new double[len];
    }
}

