/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

public class FirResample {
    private int interp_factor_L;
    private int decim_factor_M;
    private int num_taps_per_phase;
    private double[] p_H;
    private double[] p_Z;
    private int p_current_phase;

    public FirResample(double[] fir, int interp_factor_L, int decim_factor_M) {
        this.interp_factor_L = interp_factor_L;
        this.decim_factor_M = decim_factor_M;
        this.p_H = fir;
        if (this.p_H.length % interp_factor_L != 0) {
            throw new IllegalArgumentException("The number of taps in the filter must be divisible by interp_factor_L.");
        }
        this.num_taps_per_phase = this.p_H.length / interp_factor_L;
        this.p_Z = new double[this.num_taps_per_phase];
        this.p_current_phase = interp_factor_L;
    }

    public int getCurrentPhase() {
        return this.p_current_phase;
    }

    public double[] getDelayLineArray() {
        return this.p_Z;
    }

    /*
     * Unable to fully structure code
     */
    public int resamp0(double[] p_inp, int offInp, int num_inp, double[] p_out, int offOut) {
        phase_num = this.p_current_phase;
        idxIn = offInp;
        idxOut = offOut;
        idxCoeff = 0;
        num_out = 0;
        ** GOTO lbl30
        {
            phase_num -= this.interp_factor_L;
            tap = this.num_taps_per_phase - 1;
            while (tap >= 1) {
                this.p_Z[tap] = this.p_Z[tap - 1];
                --tap;
            }
            this.p_Z[0] = p_inp[idxIn++];
            if (--num_inp == 0) ** GOTO lbl17
            do {
                if (phase_num >= this.interp_factor_L) continue block0;
lbl17:
                // 3 sources

                while (phase_num < this.interp_factor_L) {
                    idxCoeff = phase_num;
                    sum = 0.0;
                    tap = 0;
                    while (tap < this.num_taps_per_phase) {
                        sum += this.p_H[idxCoeff] * this.p_Z[tap];
                        idxCoeff += this.interp_factor_L;
                        ++tap;
                    }
                    p_out[idxOut++] = sum;
                    ++num_out;
                    phase_num += this.decim_factor_M;
                }
lbl30:
                // 2 sources

            } while (num_inp > 0);
        }
        this.p_current_phase = phase_num;
        return num_out;
    }

    public int resamp1(double[] p_inp, int offInp, int num_inp, double[] p_out, int offOut) {
        int phase_num = this.p_current_phase;
        int idxIn = offInp;
        int idxOut = offOut;
        int idxCoeff = 0;
        int num_out = 0;
        while (num_inp > 0) {
            int num_new_samples = 0;
            while (phase_num >= this.interp_factor_L) {
                phase_num -= this.interp_factor_L;
                ++num_new_samples;
                if (--num_inp == 0) break;
            }
            if (num_new_samples >= this.num_taps_per_phase) {
                idxIn += num_new_samples - this.num_taps_per_phase;
                num_new_samples = this.num_taps_per_phase;
            }
            int tap = this.num_taps_per_phase - 1;
            while (tap >= num_new_samples) {
                this.p_Z[tap] = this.p_Z[tap - num_new_samples];
                --tap;
            }
            tap = num_new_samples - 1;
            while (tap >= 0) {
                this.p_Z[tap] = p_inp[idxIn++];
                --tap;
            }
            while (phase_num < this.interp_factor_L) {
                idxCoeff = phase_num;
                double sum = 0.0;
                tap = 0;
                while (tap < this.num_taps_per_phase) {
                    sum += this.p_H[idxCoeff] * this.p_Z[tap];
                    idxCoeff += this.interp_factor_L;
                    ++tap;
                }
                p_out[idxOut++] = sum;
                ++num_out;
                phase_num += this.decim_factor_M;
            }
        }
        this.p_current_phase = phase_num;
        return num_out;
    }
}

