/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

import java.io.BufferedWriter;
import java.io.FileWriter;

public class HilbFir {
    public static final int WINDOW_RECTANGULAR = 0;
    public static final int WINDOW_HAMMING = 1;
    public static final int WINDOW_VON_HANN = 2;
    public static final int WINDOW_BLACKMAN = 3;
    public static final int WINDOW_BARTLETT = 4;
    public static final int WINDOW_BLACKMAN_HARRIS = 5;
    int filter_length;
    double[] coeffs;
    double[][] response;
    double[][] impulse;
    double[] amp;
    double[] phase;
    double[] delay;
    int win_type;

    public HilbFir(int filter_length, int win_type) {
        if (filter_length % 2 != 1) {
            --filter_length;
        }
        this.filter_length = filter_length;
        this.win_type = win_type;
        this.coeffs = new double[filter_length];
        this.response = new double[256][2];
        this.impulse = new double[256][2];
        this.amp = new double[128];
        this.phase = new double[128];
        this.delay = new double[128];
    }

    public double[] getCoeffs() {
        this.design_Hilbert_filter();
        if (this.win_type != 0) {
            this.window_coefficients(this.win_type, this.filter_length);
        }
        return this.coeffs;
    }

    public void calResponse() {
        int i = 0;
        while (i < 256) {
            this.impulse[i][0] = 0.0;
            this.impulse[i][1] = 0.0;
            this.response[i][0] = 0.0;
            this.response[i][1] = 0.0;
            ++i;
        }
        int j = 0;
        while (j <= this.filter_length / 2) {
            this.response[j][0] = this.coeffs[j + this.filter_length / 2];
            ++j;
        }
        int k = 0;
        while (k < this.filter_length / 2) {
            this.response[256 - this.filter_length / 2 + k][0] = this.coeffs[k];
            ++k;
        }
        this.response = this.fft_1d(this.response);
        int l = 0;
        while (l < 128) {
            this.amp[l] = this.response[l][0] * this.response[l][0] + this.response[l][1] * this.response[l][1];
            this.amp[l] = Math.sqrt(this.amp[l]);
            if (this.amp[l] != 0.0) {
                this.amp[l] = 20.0 * Math.log(this.amp[l]) / Math.log(10.0);
            }
            this.phase[l] = Math.atan2(this.response[l][1], this.response[l][0]);
            ++l;
        }
        int i1 = 0;
        while (i1 < 127) {
            this.delay[i1] = -(this.phase[i1 + 1] - this.phase[i1]) * 128.0 / Math.PI;
            ++i1;
        }
        this.delay[127] = -(this.phase[127] - this.phase[126]) * 128.0 / Math.PI;
        this.delay[0] = -1.0E-4;
        this.delay[127] = 1.0E-4;
        this.amp[0] = this.amp[1];
        this.phase[0] = 0.999 * this.phase[1];
        this.phase[127] = 1.001 * this.phase[126];
    }

    void design_Hilbert_filter() {
        int i = this.filter_length;
        int j1 = (i - 1) / 2;
        int j = 0;
        while (j < i) {
            this.coeffs[j] = 0.0;
            ++j;
        }
        int k = j1 + 1;
        while (k < i) {
            this.coeffs[k] = 1.0 / (double)(k - j1);
            k += 2;
        }
        int l = 0;
        while (l < j1) {
            this.coeffs[l] = -this.coeffs[i - l - 1];
            ++l;
        }
        int i1 = 0;
        while (i1 < i) {
            int n = i1++;
            this.coeffs[n] = this.coeffs[n] / 1.5707963267948966;
        }
    }

    void window_coefficients(int i, int j) {
        int i2 = j;
        double d = Math.PI * 2;
        switch (i) {
            default: {
                break;
            }
            case 1: {
                int k = 0;
                while (k < i2) {
                    int n = k;
                    this.coeffs[n] = this.coeffs[n] * (0.54 - 0.46 * Math.cos(d * (double)k / (double)(i2 - 1)));
                    ++k;
                }
                break;
            }
            case 2: {
                int l = 0;
                while (l < i2) {
                    int n = l;
                    this.coeffs[n] = this.coeffs[n] * (0.5 * (1.0 - Math.cos(d * (double)l / (double)(i2 - 1))));
                    ++l;
                }
                break;
            }
            case 3: {
                int i1 = 0;
                while (i1 < i2) {
                    int n = i1;
                    this.coeffs[n] = this.coeffs[n] * (0.42 - 0.5 * Math.cos(d * (double)i1 / (double)(i2 - 1)) + 0.08 * Math.cos(2.0 * d * (double)i1 / (double)(i2 - 1)));
                    ++i1;
                }
            }
            case 4: {
                int j1 = 0;
                while (j1 <= (i2 - 1) / 2) {
                    int n = j1;
                    this.coeffs[n] = this.coeffs[n] * (2.0 * (double)j1 / (double)(i2 - 1));
                    ++j1;
                }
                int k1 = (i2 - 1) / 2;
                while (k1 < i2) {
                    int n = k1;
                    this.coeffs[n] = this.coeffs[n] * (2.0 - 2.0 * (double)k1 / (double)(i2 - 1));
                    ++k1;
                }
                break;
            }
            case 5: {
                double d1 = 0.35875;
                double d2 = 0.48829;
                double d3 = 0.14128;
                double d4 = 0.01168;
                int l1 = 0;
                while (l1 < i2) {
                    int n = l1;
                    this.coeffs[n] = this.coeffs[n] * (d1 - d2 * Math.cos(d * ((double)l1 + 0.5) / (double)i2) + d3 * Math.cos(d * 2.0 * ((double)l1 + 0.5) / (double)i2) - d4 * Math.cos(d * 3.0 * ((double)l1 + 0.5) / (double)i2));
                    ++l1;
                }
                break block0;
            }
        }
    }

    double[][] fft_1d(double[][] ad) {
        int l2 = ad.length;
        int i = (int)(Math.log(l2) / Math.log(2.0) + 0.5);
        int j = l2 / 2;
        int k1 = 1;
        int j2 = 1;
        while (j2 < l2) {
            if (j2 < k1) {
                double d4 = ad[j2 - 1][0];
                double d7 = ad[j2 - 1][1];
                ad[j2 - 1][0] = ad[k1 - 1][0];
                ad[j2 - 1][1] = ad[k1 - 1][1];
                ad[k1 - 1][0] = d4;
                ad[k1 - 1][1] = d7;
            }
            int k = j;
            while (k < k1) {
                k1 -= k;
                k /= 2;
            }
            k1 += k;
            ++j2;
        }
        int l = 1;
        while (l <= i) {
            int i1 = (int)(Math.exp((double)l * Math.log(2.0)) + 0.5);
            int j1 = i1 / 2;
            double d = 1.0;
            double d1 = 0.0;
            double d2 = Math.cos(Math.PI / (double)j1);
            double d3 = -Math.sin(Math.PI / (double)j1);
            int l1 = 1;
            while (l1 <= j1) {
                int k2 = l1;
                while (k2 <= l2) {
                    int i2 = k2 + j1;
                    double d5 = ad[i2 - 1][0] * d - d1 * ad[i2 - 1][1];
                    double d8 = ad[i2 - 1][1] * d + d1 * ad[i2 - 1][0];
                    ad[i2 - 1][0] = ad[k2 - 1][0] - d5;
                    ad[i2 - 1][1] = ad[k2 - 1][1] - d8;
                    ad[k2 - 1][0] = ad[k2 - 1][0] + d5;
                    ad[k2 - 1][1] = ad[k2 - 1][1] + d8;
                    k2 += i1;
                }
                double d6 = d * d2 - d3 * d1;
                d1 = d2 * d1 + d3 * d;
                d = d6;
                ++l1;
            }
            ++l;
        }
        return ad;
    }

    public static void main(String[] args) throws Exception {
        HilbFir hilbFir1 = new HilbFir(99, 1);
        double[] coeffs = hilbFir1.getCoeffs();
        BufferedWriter fwrtr = new BufferedWriter(new FileWriter("hilbfir.txt"));
        int i = 0;
        while (i < coeffs.length) {
            System.out.println(coeffs[i]);
            fwrtr.write("" + coeffs[i]);
            fwrtr.newLine();
            ++i;
        }
        fwrtr.close();
    }
}

