/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

import cn.org.gddsn.signal.Hilbert;
import cn.org.gddsn.signal.TFR;

public class TFRUtil {
    private TFR tfr;
    double[] time;
    double[] freq;
    double[] value;
    double[] signal;

    public void setTfr(TFR tfr) {
        this.tfr = tfr;
    }

    public void setSignal(double[] sig) {
        this.signal = sig;
        double[] h = Hilbert.hilbert(this.signal);
        double[][] s = new double[2][this.signal.length];
        int i = 0;
        while (i < this.signal.length) {
            s[0][i] = this.signal[i];
            s[1][i] = h[i];
            ++i;
        }
        h = null;
        int xlen = this.signal.length;
        int tlag = this.tfr.getTlag();
        int fftlen = this.tfr.getFftlen();
        int tstep = this.tfr.getTstep();
        double[][] v = new double[xlen - 2 * tlag][fftlen / 2];
        this.tfr.aok(s, tlag, xlen - 2 * tlag, v);
        this.time = new double[(xlen - 2 * tlag) / tstep * fftlen / 2];
        this.freq = new double[(xlen - 2 * tlag) / tstep * fftlen / 2];
        this.value = new double[(xlen - 2 * tlag) / tstep * fftlen / 2];
        int n = 0;
        int t = 0;
        while (t < v.length / tstep) {
            int f = 0;
            while (f < fftlen / 2) {
                this.value[n] = Math.abs(v[t][f]);
                this.time[n] = tlag + t * tstep;
                this.freq[n] = f;
                ++n;
                ++f;
            }
            ++t;
        }
        v = null;
    }

    public double[] getSignal() {
        return this.signal;
    }

    public TFR getTfr() {
        return this.tfr;
    }

    public double[] getTime() {
        return this.time;
    }

    public double[] getValue() {
        return this.value;
    }

    public double[] getFreq() {
        return this.freq;
    }
}

