/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.CombFilter;
import cn.org.gddsn.signal.filter.Complex;

class DelayFilter
extends CombFilter {
    DelayFilter() {
        super(1);
    }

    void getResponse(double w, Complex c) {
        if (this.n > 212) {
            c.set(1.0);
        } else {
            super.getResponse(w, c);
        }
    }

    void setCutoff(double f) {
    }

    int select() {
        this.auxLabels[0] = "Delay";
        this.auxBars[0] = 300;
        this.auxLabels[1] = "Strength";
        this.auxBars[1] = 700;
        return 2;
    }

    void setup() {
        this.n = this.auxBars[0] * 16384 / 1000;
        this.mult = (double)this.auxBars[1] / 1250.0;
        this.peak = 1.0 / (1.0 - this.mult);
    }

    void getInfo(String[] x) {
        x[0] = "Delay (IIR)";
        x[1] = "Delay: " + this.n + " samples, " + this.getUnitText((double)this.n / (double)this.sampleRate, "s");
        double tl = 340.0 * (double)this.n / (double)this.sampleRate / 2.0;
        x[2] = "Echo Distance: " + this.getUnitText(tl, "m");
        if (tl > 1.0) {
            x[2] = String.valueOf(x[2]) + " (" + tl * 3.28084 + " ft)";
        }
    }
}

