/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.Complex;
import cn.org.gddsn.signal.filter.DirectFilter;
import cn.org.gddsn.signal.filter.FFT;
import cn.org.gddsn.signal.filter.FilterType;

abstract class FIRFilterType
extends FilterType {
    double[] response;

    FIRFilterType() {
    }

    void getResponse(double w, Complex c) {
        if (this.response == null) {
            c.set(0.0);
            return;
        }
        int off = (int)((double)this.response.length * w / (Math.PI * 2));
        if ((off &= 0xFFFFFFFE) < 0) {
            off = 0;
        }
        if (off >= this.response.length) {
            off = this.response.length - 2;
        }
        c.set(this.response[off], this.response[off + 1]);
    }

    void setResponse(DirectFilter f) {
        int i;
        this.response = new double[8192];
        if (f.nList.length != f.aList.length) {
            f.nList = new int[f.aList.length];
            i = 0;
            while (i != f.aList.length) {
                f.nList[i] = i;
                ++i;
            }
        }
        i = 0;
        while (i != f.aList.length) {
            this.response[f.nList[i] * 2] = f.aList[i];
            ++i;
        }
        new FFT(this.response.length / 2).transform(this.response, false);
        double maxresp = 0.0;
        int j = 0;
        while (j != this.response.length) {
            double r2 = this.response[j] * this.response[j] + this.response[j + 1] * this.response[j + 1];
            if (maxresp < r2) {
                maxresp = r2;
            }
            j += 2;
        }
        maxresp = Math.sqrt(maxresp);
        j = 0;
        while (j != this.response.length) {
            int n = j++;
            this.response[n] = this.response[n] / maxresp;
        }
        j = 0;
        while (j != f.aList.length) {
            int n = j++;
            f.aList[n] = f.aList[n] / maxresp;
        }
    }
}

