/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.Complex;
import cn.org.gddsn.signal.filter.Filter;

abstract class FilterType {
    public static final double log10 = 2.302585092994046;
    int sampleRate;
    int[] auxBars;
    String[] auxLabels;
    int windowType;
    int kaiserParameter;

    FilterType() {
    }

    int select() {
        return 0;
    }

    void setup() {
    }

    abstract void getResponse(double var1, Complex var3);

    int getPoleCount() {
        return 0;
    }

    int getZeroCount() {
        return 0;
    }

    void getPole(int i, Complex c) {
        c.set(0.0);
    }

    void getZero(int i, Complex c) {
        c.set(0.0);
    }

    abstract Filter genFilter();

    void getInfo(String[] x) {
    }

    boolean needsWindow() {
        return false;
    }

    void setCutoff(double f) {
        this.auxBars[0] = (int)(2000.0 * f);
    }

    String getOmegaText(double wc) {
        return String.valueOf((int)(wc * (double)this.sampleRate / (Math.PI * 2))) + " Hz";
    }

    double getWindow(int i, int n) {
        if (n == 1) {
            return 1.0;
        }
        double x = Math.PI * 2 * (double)i / (double)(n - 1);
        double n2 = n / 2;
        switch (this.windowType) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return 0.54 - 0.46 * Math.cos(x);
            }
            case 2: {
                return 0.5 - 0.5 * Math.cos(x);
            }
            case 3: {
                return 0.42 - 0.5 * Math.cos(x) + 0.08 * Math.cos(2.0 * x);
            }
            case 4: {
                double kaiserAlphaPi = (double)this.kaiserParameter * Math.PI / 120.0;
                double q = (double)(2 * i) / (double)n - 1.0;
                return this.bessi0(kaiserAlphaPi * Math.sqrt(1.0 - q * q));
            }
            case 5: {
                return (double)i < n2 ? (double)i / n2 : 2.0 - (double)i / n2;
            }
            case 6: {
                double xt = ((double)i - n2) / n2;
                return 1.0 - xt * xt;
            }
        }
        return 0.0;
    }

    double bessi0(double x) {
        double ans;
        double d;
        double ax = Math.abs(x);
        if (d < 3.75) {
            double y = x / 3.75;
            y *= y;
            ans = 1.0 + y * (3.5156229 + y * (3.0899424 + y * (1.2067492 + y * (0.2659732 + y * (0.0360768 + y * 0.0045813)))));
        } else {
            double y = 3.75 / ax;
            ans = Math.exp(ax) / Math.sqrt(ax) * (0.39894228 + y * (0.01328592 + y * (0.00225319 + y * (-0.00157565 + y * (0.00916281 + y * (-0.02057706 + y * (0.02635537 + y * (-0.01647633 + y * 0.00392377))))))));
        }
        return ans;
    }

    String getUnitText(double v, String u) {
        double va = Math.abs(v);
        if (va < 1.0E-17) {
            return "0 " + u;
        }
        if (va < 1.0E-12) {
            return String.valueOf(v * 1.0E15) + " f" + u;
        }
        if (va < 1.0E-9) {
            return String.valueOf(v * 1.0E12) + " p" + u;
        }
        if (va < 1.0E-6) {
            return String.valueOf(v * 1.0E9) + " n" + u;
        }
        if (va < 0.001) {
            return String.valueOf(v * 1000000.0) + " \u03bc" + u;
        }
        if (va < 0.01 || u.compareTo("m") != 0 && va < 1.0) {
            return String.valueOf(v * 1000.0) + " m" + u;
        }
        if (va < 1.0) {
            return String.valueOf(v * 100.0) + " c" + u;
        }
        if (va < 1000.0) {
            return String.valueOf(v) + " " + u;
        }
        if (va < 1000000.0) {
            return String.valueOf(v * 0.001) + " k" + u;
        }
        if (va < 1.0E9) {
            return String.valueOf(v * 1.0E-6) + " M" + u;
        }
        if (va < 1.0E12) {
            return String.valueOf(v * 1.0E-9) + " G" + u;
        }
        if (va < 1.0E15) {
            return String.valueOf(v * 1.0E-12) + " T" + u;
        }
        return String.valueOf(v) + " " + u;
    }
}

