/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.DirectFilter;
import cn.org.gddsn.signal.filter.FIRFilterType;
import cn.org.gddsn.signal.filter.Filter;

class GaussianFilter
extends FIRFilterType {
    int n;
    double cw;

    GaussianFilter() {
    }

    int select() {
        this.auxLabels[0] = "Offset";
        this.auxBars[0] = 100;
        this.auxLabels[1] = "Width";
        this.auxBars[1] = 100;
        this.auxLabels[2] = "Order";
        this.auxBars[2] = 160;
        return 3;
    }

    void setup() {
        this.n = this.auxBars[2];
        this.cw = (double)this.auxBars[0] * Math.PI / 1000.0;
    }

    Filter genFilter() {
        DirectFilter f = new DirectFilter();
        f.aList = new double[this.n];
        double w = (double)this.auxBars[1] / 100000.0;
        int n2 = this.n / 2;
        int i = 0;
        while (i != this.n) {
            int ii = i - n2;
            f.aList[i] = Math.exp(-w * (double)ii * (double)ii) * Math.cos((double)ii * this.cw) * this.getWindow(i, this.n);
            ++i;
        }
        this.setResponse(f);
        return f;
    }

    boolean needsWindow() {
        return true;
    }

    void getInfo(String[] x) {
        x[0] = "Gaussian (FIR)";
        x[1] = "Order: " + this.n;
    }
}

