/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.DirectFilter;
import cn.org.gddsn.signal.filter.FIRFilterType;
import cn.org.gddsn.signal.filter.Filter;

class MovingAverageFilter
extends FIRFilterType {
    double n;
    int ni;

    MovingAverageFilter() {
    }

    int select() {
        this.auxLabels[0] = "Cutoff Frequency";
        this.auxBars[0] = 500;
        return 1;
    }

    void setup() {
        this.n = 2000.0 / (double)this.auxBars[0];
        if (this.n > 1000.0) {
            this.n = 1000.0;
        }
        this.ni = (int)this.n;
    }

    Filter genFilter() {
        DirectFilter f = new DirectFilter();
        f.aList = new double[this.ni + 1];
        int i = 0;
        while (i != this.ni) {
            f.aList[i] = 1.0 / this.n;
            ++i;
        }
        f.aList[i] = (this.n - (double)this.ni) / this.n;
        this.setResponse(f);
        return f;
    }

    void getInfo(String[] x) {
        x[0] = "Moving Average (FIR)";
        x[1] = "Cutoff: " + this.getOmegaText(Math.PI * 2 / this.n);
        x[2] = "Length: " + this.n;
    }
}

