/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.DirectFilter;
import cn.org.gddsn.signal.filter.Filter;
import cn.org.gddsn.signal.filter.IIRFilterType;

class PluckedStringFilter
extends IIRFilterType {
    int n;
    double mult;

    PluckedStringFilter() {
    }

    int select() {
        this.auxLabels[0] = "Fundamental";
        this.auxBars[0] = 20;
        this.auxLabels[1] = "Sharpness";
        this.auxBars[1] = 970;
        return 2;
    }

    void setup() {
        this.n = 2000 / this.auxBars[0];
        this.mult = 0.5 * Math.exp(-0.5 + (double)this.auxBars[1] / 2000.0);
    }

    Filter genFilter() {
        DirectFilter f = new DirectFilter();
        f.aList = new double[]{1.0, 1.0, 0.0, 0.0};
        f.bList = new double[]{1.0, 0.0, -this.mult, -this.mult};
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = this.n;
        nArray[3] = this.n + 1;
        f.nList = nArray;
        this.setResponse(f);
        return f;
    }

    void getInfo(String[] x) {
        x[0] = "Plucked String (IIR); Resonance every " + this.getOmegaText(Math.PI * 2 / (double)this.n);
        x[1] = "Delay: " + this.n + " samples, " + this.getUnitText((double)this.n / (double)this.sampleRate, "s");
    }
}

