/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.Complex;
import cn.org.gddsn.signal.filter.IIRFilterType;

class ResonatorFilter
extends IIRFilterType {
    double r;
    double wc;

    ResonatorFilter() {
    }

    int select() {
        this.auxLabels[0] = "Resonant Frequency";
        this.auxBars[0] = 500;
        this.auxLabels[1] = "Sharpness";
        this.auxBars[1] = 900;
        return 2;
    }

    void setup() {
        this.wc = (double)this.auxBars[0] * Math.PI / 1000.0;
        double rolldb = (double)(-this.auxBars[1] * 3) / 1000.0;
        this.r = 1.0 - Math.pow(10.0, rolldb);
    }

    void getPole(int i, Complex c1) {
        c1.setMagPhase(this.r, i == 1 ? -this.wc : this.wc);
    }

    int getPoleCount() {
        return 2;
    }

    void getInfo(String[] x) {
        x[0] = "Reson (IIR)";
        x[1] = "Res. Frequency: " + this.getOmegaText(this.wc);
    }
}

