/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.DirectFilter;
import cn.org.gddsn.signal.filter.FIRFilterType;
import cn.org.gddsn.signal.filter.Filter;

class SincLowPassFilter
extends FIRFilterType {
    int n;
    double wc;
    double mult;
    double peak;
    double[] resp;
    boolean invert;

    SincLowPassFilter() {
    }

    int select() {
        this.auxLabels[0] = "Cutoff Frequency";
        this.auxLabels[1] = "Order";
        this.auxBars[0] = this.invert ? 500 : 100;
        this.auxBars[1] = 120;
        return 2;
    }

    void setup() {
        this.wc = (double)this.auxBars[0] * Math.PI / 1000.0;
        this.n = this.auxBars[1];
    }

    Filter genFilter() {
        DirectFilter f = new DirectFilter();
        f.aList = new double[this.n];
        int n2 = this.n / 2;
        double sum = 0.0;
        int i = 0;
        while (i != this.n) {
            int ii = i - n2;
            f.aList[i] = (ii == 0 ? this.wc : Math.sin(this.wc * (double)ii) / (double)ii) * this.getWindow(i, this.n);
            sum += f.aList[i];
            ++i;
        }
        i = 0;
        while (i != this.n) {
            int n = i++;
            f.aList[n] = f.aList[n] / sum;
        }
        if (this.invert) {
            i = 0;
            while (i != this.n) {
                f.aList[i] = -f.aList[i];
                ++i;
            }
            int n = n2;
            f.aList[n] = f.aList[n] + 1.0;
        }
        if (this.n == 1) {
            f.aList[0] = 1.0;
        }
        this.setResponse(f);
        return f;
    }

    void getInfo(String[] x) {
        x[0] = "Cutoff freq: " + this.getOmegaText(this.wc);
        x[1] = "Order: " + this.n;
    }

    boolean needsWindow() {
        return true;
    }
}

