/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.DirectFilter;
import cn.org.gddsn.signal.filter.FIRFilterType;
import cn.org.gddsn.signal.filter.Filter;

class TriangleFilter
extends FIRFilterType {
    int ni;
    double n;

    TriangleFilter() {
    }

    int select() {
        this.auxLabels[0] = "Cutoff Frequency";
        this.auxBars[0] = 500;
        return 1;
    }

    void setup() {
        this.n = 4000.0 / (double)this.auxBars[0];
        if (this.n > 1000.0) {
            this.n = 1000.0;
        }
        this.ni = (int)this.n;
    }

    Filter genFilter() {
        DirectFilter f = new DirectFilter();
        f.aList = new double[this.ni + 1];
        double sum = 0.0;
        double n2 = this.n / 2.0;
        int i = 0;
        while ((double)i < this.n) {
            double q = 0.0;
            q = (double)i < n2 ? (double)i / n2 : 2.0 - (double)i / n2;
            sum += q;
            f.aList[i] = q;
            ++i;
        }
        i = 0;
        while (i != f.aList.length) {
            int n = i++;
            f.aList[n] = f.aList[n] / sum;
        }
        this.setResponse(f);
        return f;
    }

    void getInfo(String[] x) {
        x[0] = "Triangle (FIR)";
        x[1] = "Cutoff: " + this.getOmegaText(Math.PI * 4 / this.n);
        x[2] = "Length: " + this.n;
    }
}

