/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter.design;

public class RemezFIRFilter {
    public static final int BANDPASS = 1;
    public static final int DIFFERENTIATOR = 2;
    public static final int HILBERT = 3;
    public static final int NEGATIVE = 0;
    public static final int POSITIVE = 1;
    public static final int GRIDDENSITY = 16;
    public static final int MAXITERATIONS = 40;
    double pi = Math.PI;
    double pi2 = 2.0 * this.pi;
    int numtaps;

    void createDenseGrid(int r, int numtaps, int numband, double[] bands, double[] des, double[] weight, int gridSize, double[] grid, double[] d, double[] w, int symmetry) {
        double delf = 0.5 / (double)(16 * r);
        if (symmetry == 0 && delf > bands[0]) {
            bands[0] = delf;
        }
        int j = 0;
        int band = 0;
        while (band < numband) {
            grid[j] = bands[2 * band];
            double lowf = bands[2 * band];
            double highf = bands[2 * band + 1];
            int k = (int)Math.round((highf - lowf) / delf);
            int i = 0;
            while (i < k) {
                d[j] = des[band];
                w[j] = weight[band];
                grid[j] = lowf;
                lowf += delf;
                ++j;
                ++i;
            }
            grid[j - 1] = highf;
            ++band;
        }
        if (symmetry == 0 && grid[gridSize - 1] > 0.5 - delf && numtaps % 2 != 0) {
            grid[gridSize - 1] = 0.5 - delf;
        }
    }

    void initialGuess(int r, int[] ext, int gridSize) {
        int i = 0;
        while (i <= r) {
            ext[i] = i * (gridSize - 1) / r;
            ++i;
        }
    }

    void calcParms(int r, int[] ext, double[] grid, double[] d, double[] w, double[] ad, double[] x, double[] y) {
        double denom;
        int i = 0;
        while (i <= r) {
            x[i] = Math.cos(this.pi2 * grid[ext[i]]);
            ++i;
        }
        int ld = (r - 1) / 15 + 1;
        int i2 = 0;
        while (i2 <= r) {
            denom = 1.0;
            double xi = x[i2];
            int j = 0;
            while (j < ld) {
                int k = j;
                while (k <= r) {
                    if (k != i2) {
                        denom *= 2.0 * (xi - x[k]);
                    }
                    k += ld;
                }
                ++j;
            }
            if (Math.abs(denom) < 1.0E-5) {
                denom = 1.0E-5;
            }
            ad[i2] = 1.0 / denom;
            ++i2;
        }
        denom = 0.0;
        double numer = 0.0;
        double sign = 1.0;
        i2 = 0;
        while (i2 <= r) {
            numer += ad[i2] * d[ext[i2]];
            denom += sign * ad[i2] / w[ext[i2]];
            sign = -sign;
            ++i2;
        }
        double delta = numer / denom;
        sign = 1.0;
        i2 = 0;
        while (i2 <= r) {
            y[i2] = d[ext[i2]] - sign * delta / w[ext[i2]];
            sign = -sign;
            ++i2;
        }
    }

    double computeA(double freq, int r, double[] ad, double[] x, double[] y) {
        double numer = 0.0;
        double denom = 0.0;
        double xc = Math.cos(this.pi2 * freq);
        int i = 0;
        while (i <= r) {
            double c = xc - x[i];
            if (Math.abs(c) < 1.0E-7) {
                numer = y[i];
                denom = 1.0;
                break;
            }
            c = ad[i] / c;
            denom += c;
            numer += c * y[i];
            ++i;
        }
        return numer / denom;
    }

    void calcError(int r, double[] ad, double[] x, double[] y, int gridSize, double[] grid, double[] d, double[] w, double[] e) {
        int i = 0;
        while (i < gridSize) {
            double A = this.computeA(grid[i], r, ad, x, y);
            e[i] = w[i] * (d[i] - A);
            ++i;
        }
    }

    void search(int r, int[] ext, int gridSize, double[] e) {
        int[] foundExt = new int[gridSize];
        int k = 0;
        if (e[0] > 0.0 && e[0] > e[1] || e[0] < 0.0 && e[0] < e[1]) {
            foundExt[k++] = 0;
        }
        int i = 1;
        while (i < gridSize - 1) {
            if (e[i] >= e[i - 1] && e[i] > e[i + 1] && e[i] > 0.0 || e[i] <= e[i - 1] && e[i] < e[i + 1] && e[i] < 0.0) {
                foundExt[k++] = i;
            }
            ++i;
        }
        int j = gridSize - 1;
        if (e[j] > 0.0 && e[j] > e[j - 1] || e[j] < 0.0 && e[j] < e[j - 1]) {
            foundExt[k++] = j;
        }
        int extra = k - (r + 1);
        while (extra > 0) {
            boolean up = e[foundExt[0]] > 0.0;
            int l = 0;
            boolean alt = true;
            j = 1;
            while (j < k) {
                if (Math.abs(e[foundExt[j]]) < Math.abs(e[foundExt[l]])) {
                    l = j;
                }
                if (up && e[foundExt[j]] < 0.0) {
                    up = false;
                } else if (!up && e[foundExt[j]] > 0.0) {
                    up = true;
                } else {
                    alt = false;
                    break;
                }
                ++j;
            }
            if (alt && extra == 1) {
                l = Math.abs(e[foundExt[k - 1]]) < Math.abs(e[foundExt[0]]) ? foundExt[k - 1] : foundExt[0];
            }
            j = l;
            while (j < k) {
                foundExt[j] = foundExt[j + 1];
                ++j;
            }
            --k;
            --extra;
        }
        int i2 = 0;
        while (i2 <= r) {
            ext[i2] = foundExt[i2];
            ++i2;
        }
    }

    double[] freqSample(double[] A, int symm) {
        int N = this.numtaps;
        double M = ((double)N - 1.0) / 2.0;
        double[] h = new double[N];
        if (symm == 1) {
            if (N % 2 != 0) {
                int n = 0;
                while (n < N) {
                    double val = A[0];
                    double x = this.pi2 * ((double)n - M) / (double)N;
                    int k = 1;
                    while ((double)k <= M) {
                        val += 2.0 * A[k] * Math.cos(x * (double)k);
                        ++k;
                    }
                    h[n] = val / (double)N;
                    ++n;
                }
            } else {
                int n = 0;
                while (n < N) {
                    double val = A[0];
                    double x = this.pi2 * ((double)n - M) / (double)N;
                    int k = 1;
                    while (k <= N / 2 - 1) {
                        val += 2.0 * A[k] * Math.cos(x * (double)k);
                        ++k;
                    }
                    h[n] = val / (double)N;
                    ++n;
                }
            }
        } else if (N % 2 != 0) {
            int n = 0;
            while (n < N) {
                double val = 0.0;
                double x = this.pi2 * ((double)n - M) / (double)N;
                int k = 1;
                while ((double)k <= M) {
                    val += 2.0 * A[k] * Math.sin(x * (double)k);
                    ++k;
                }
                h[n] = val / (double)N;
                ++n;
            }
        } else {
            int n = 0;
            while (n < N) {
                double val = A[N / 2] * Math.sin(this.pi * ((double)n - M));
                double x = this.pi2 * ((double)n - M) / (double)N;
                int k = 1;
                while (k <= N / 2 - 1) {
                    val += 2.0 * A[k] * Math.sin(x * (double)k);
                    ++k;
                }
                h[n] = val / (double)N;
                ++n;
            }
        }
        return h;
    }

    boolean isDone(int r, int[] ext, double[] e) {
        double max;
        double min = max = Math.abs(e[ext[0]]);
        int i = 1;
        while (i <= r) {
            double current = Math.abs(e[ext[i]]);
            if (current < min) {
                min = current;
            }
            if (current > max) {
                max = current;
            }
            ++i;
        }
        return (max - min) / max < 1.0E-4;
    }

    public double[] remez(int n, double[] bands, double[] des, double[] weight, int type) {
        double c;
        int i;
        this.numtaps = n;
        int symmetry = type == 1 ? 1 : 0;
        int r = this.numtaps / 2;
        if (this.numtaps % 2 != 0 && symmetry == 1) {
            ++r;
        }
        int gridSize = 0;
        int numband = des.length;
        int i2 = 0;
        while (i2 < numband) {
            gridSize += (int)Math.round((double)(2 * r * 16) * (bands[2 * i2 + 1] - bands[2 * i2]));
            ++i2;
        }
        if (symmetry == 0) {
            --gridSize;
        }
        double[] grid = new double[gridSize];
        double[] d = new double[gridSize];
        double[] w = new double[gridSize];
        double[] e = new double[gridSize];
        double[] x = new double[r + 1];
        double[] y = new double[r + 1];
        double[] ad = new double[r + 1];
        double[] taps = new double[r + 1];
        int[] ext = new int[r + 1];
        this.createDenseGrid(r, this.numtaps, numband, bands, des, weight, gridSize, grid, d, w, symmetry);
        this.initialGuess(r, ext, gridSize);
        if (type == 2) {
            i = 0;
            while (i < gridSize) {
                if (d[i] > 1.0E-4) {
                    int n2 = i;
                    w[n2] = w[n2] / grid[i];
                }
                ++i;
            }
        }
        if (symmetry == 1) {
            if (this.numtaps % 2 == 0) {
                i = 0;
                while (i < gridSize) {
                    c = Math.cos(this.pi * grid[i]);
                    int n3 = i;
                    d[n3] = d[n3] / c;
                    int n4 = i++;
                    w[n4] = w[n4] * c;
                }
            }
        } else if (this.numtaps % 2 != 0) {
            i = 0;
            while (i < gridSize) {
                c = Math.sin(this.pi2 * grid[i]);
                int n5 = i;
                d[n5] = d[n5] / c;
                int n6 = i++;
                w[n6] = w[n6] * c;
            }
        } else {
            i = 0;
            while (i < gridSize) {
                c = Math.sin(this.pi * grid[i]);
                int n7 = i;
                d[n7] = d[n7] / c;
                int n8 = i++;
                w[n8] = w[n8] * c;
            }
        }
        int iter = 0;
        while (iter < 40) {
            this.calcParms(r, ext, grid, d, w, ad, x, y);
            this.calcError(r, ad, x, y, gridSize, grid, d, w, e);
            this.search(r, ext, gridSize, e);
            if (this.isDone(r, ext, e)) break;
            ++iter;
        }
        if (iter == 40) {
            System.out.println("Reached maximum iteration count.\nResults may be bad.\n");
        }
        this.calcParms(r, ext, grid, d, w, ad, x, y);
        int i3 = 0;
        while (i3 <= this.numtaps / 2) {
            c = symmetry == 1 ? (this.numtaps % 2 != 0 ? 1.0 : Math.cos(this.pi * (double)i3 / (double)this.numtaps)) : (this.numtaps % 2 != 0 ? Math.sin(this.pi2 * (double)i3 / (double)this.numtaps) : Math.sin(this.pi * (double)i3 / (double)this.numtaps));
            taps[i3] = this.computeA((double)i3 / (double)this.numtaps, r, ad, x, y) * c;
            ++i3;
        }
        return this.freqSample(taps, symmetry);
    }
}

