/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.seismograph;

import JSci.maths.ArrayMath;
import JSci.maths.Complex;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.signal.FFT;

public class Emulate {
    public static final int LPSRO = 1;
    public static final int KIRNOS = 2;
    public static final int WWSSNLP = 3;
    public static final int WWSSNSP = 4;
    public static final int WA = 5;
    final double lpsro_a = 92384.54528458492;
    final double lpsro_f = 0.04;
    final int[] lpsro_n = new int[]{7, 19};
    final Complex[] lpsro_p = new Complex[]{new Complex(-4.648, 3.463), new Complex(-4.648, -3.463), new Complex(-0.1179, 0.0), new Complex(-40.73, 0.0), new Complex(-100.0, 0.0), new Complex(-0.15, 0.0), new Complex(-264.0, 0.0), new Complex(-3.928, 0.0), new Complex(-0.282, 0.0), new Complex(-0.201, 0.241), new Complex(-0.201, -0.241), new Complex(-0.1337, 0.1001), new Complex(-0.1337, -0.1001), new Complex(-0.0251, 0.0), new Complex(-0.00924, 0.0), new Complex(-0.8547, 0.2555), new Complex(-0.8547, -0.2555), new Complex(-0.5415, 0.6834), new Complex(-0.5415, -0.6834)};
    final Complex[] lpsro_z = new Complex[]{new Complex(-0.1243, 0.0), new Complex(-47.62, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0)};
    final double kirnos_a = 83.559;
    final double kirnos_f = 0.5;
    final int[] kirnos_n = new int[]{3, 4};
    final Complex[] kirnos_z = new Complex[]{new Complex(0.0, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0)};
    final Complex[] kirnos_p = new Complex[]{new Complex(-0.127, 0.25), new Complex(-0.127, -0.25), new Complex(-0.263, 0.0), new Complex(-83.6, 0.0)};
    final double wa_a = 0.999375;
    final double wa_f = 10.0;
    final int[] wa_n = new int[]{2, 2};
    final Complex[] wa_z = new Complex[]{new Complex(0.0, 0.0), new Complex(0.0, 0.0)};
    final Complex[] wa_p = new Complex[]{new Complex(-5.4192, 5.6848), new Complex(-5.4192, -5.6848)};
    final double wwsslp_a = 0.84546;
    final double wwsslp_f = 0.06666666666666667;
    final int[] wwsslp_n = new int[]{3, 4};
    final Complex[] wwsslp_z = new Complex[]{new Complex(0.0, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0)};
    final Complex[] wwsslp_p = new Complex[]{new Complex(-0.411, 0.0252), new Complex(-0.411, -0.0252), new Complex(-0.0486, 0.0), new Complex(-0.0874, 0.0)};
    final double wwsssp_a = 531.98;
    final double wwsssp_f = 1.0;
    final int[] wwsssp_n = new int[]{3, 5};
    final Complex[] wwsssp_z = new Complex[]{new Complex(0.0, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0)};
    final Complex[] wwsssp_p = new Complex[]{new Complex(-3.73, 6.22), new Complex(-3.73, -6.22), new Complex(-5.61, 0.0), new Complex(-13.2, 0.0), new Complex(-21.1, 0.0)};

    double[] taper(double[] fr, int n, int perc) {
        int nz = (int)((double)(n * perc) / 100.0);
        double x = 1.5707963267948966 / (double)nz;
        int m = 0;
        while (m < nz) {
            fr[m] = fr[m] * (double)((float)Math.sin((double)m * x));
            ++m;
        }
        m = n - nz;
        while (m < n) {
            fr[m] = fr[m] * (double)((float)Math.sin((double)(n - m) * x));
            ++m;
        }
        return fr;
    }

    private Complex response(int nz, int np, double freq, Complex[] z, Complex[] p) {
        Complex rsp = new Complex(1.0, 0.0);
        Complex jomg = new Complex(0.0, Math.PI * 2 * freq);
        Complex c = new Complex(0.0, 0.0);
        int i = 0;
        while (i < nz) {
            c = jomg.subtract(z[i]);
            rsp = rsp.multiply(c);
            ++i;
        }
        i = 0;
        while (i < np) {
            c = jomg.subtract(p[i]);
            rsp = rsp.divide(c);
            ++i;
        }
        return rsp;
    }

    private double normalf(EvtData evt, int chn, double freq) {
        Complex rsp = new Complex(1.0, 0.0);
        Complex jomg = new Complex(0.0, Math.PI * 2 * freq);
        Complex c = new Complex(0.0, 0.0);
        Complex[] zero = evt.getZero(chn);
        int i = 0;
        while (i < evt.getZeroNum(chn)) {
            c = jomg.subtract(zero[i]);
            rsp = rsp.multiply(c);
            ++i;
        }
        Complex[] pole = evt.getPole(chn);
        i = 0;
        while (i < evt.getPoleNum(chn)) {
            c = jomg.subtract(pole[i]);
            rsp = rsp.divide(c);
            ++i;
        }
        return rsp.mod() * evt.getScaleFactor(chn);
    }

    public boolean emulate(EvtData evt, int chn, int type) {
        Complex[] z;
        Complex[] p;
        int nz;
        int np;
        double F0;
        double A0;
        int nfft = 8;
        int zc = 0;
        Complex c = new Complex(0.0, 0.0);
        Complex b = new Complex(0.0, 0.0);
        Complex a = new Complex(0.0, 0.0);
        int samp = evt.getSamples(chn);
        while (samp >= nfft) {
            nfft *= 2;
        }
        double[] re = new double[nfft];
        double[] im = new double[nfft];
        switch (type) {
            case 1: {
                A0 = 92384.54528458492;
                F0 = 0.04;
                np = this.lpsro_n[1];
                nz = this.lpsro_n[0];
                p = this.lpsro_p;
                z = this.lpsro_z;
                evt.setInstrumentType(chn, "LPSRO");
                break;
            }
            case 2: {
                A0 = 83.559;
                F0 = 0.5;
                np = this.kirnos_n[1];
                nz = this.kirnos_n[0];
                p = this.kirnos_p;
                z = this.kirnos_z;
                evt.setInstrumentType(chn, "SK");
                break;
            }
            case 3: {
                A0 = 0.84546;
                F0 = 0.06666666666666667;
                np = this.wwsslp_n[1];
                nz = this.wwsslp_n[0];
                p = this.wwsslp_p;
                z = this.wwsslp_z;
                evt.setInstrumentType(chn, "763");
                break;
            }
            case 4: {
                A0 = 531.98;
                F0 = 1.0;
                np = this.wwsssp_n[1];
                nz = this.wwsssp_n[0];
                p = this.wwsssp_p;
                z = this.wwsssp_z;
                evt.setInstrumentType(chn, "WWSSNSP");
                break;
            }
            case 5: {
                A0 = 0.999375;
                F0 = 10.0;
                np = this.wa_n[1];
                nz = this.wa_n[0];
                p = this.wa_p;
                z = this.wa_z;
                evt.setInstrumentType(chn, "W.A.");
                break;
            }
            default: {
                return false;
            }
        }
        double mean = ArrayMath.mean(evt.getSampData(chn));
        int i = 0;
        while (i < nfft) {
            re[i] = i < samp ? evt.getSampData(chn)[i] - mean : 0.0;
            im[i] = 0.0;
            ++i;
        }
        if (evt.getOriginalType(chn) == 1) {
            evt.setOriginalType(chn, 0);
            zc = 1;
        } else if (evt.getOriginalType(chn) == 2) {
            evt.setOriginalType(chn, 0);
            zc = 2;
        } else {
            zc = 0;
        }
        evt.setCalibFactor(chn, evt.getCalibFactor(chn) * 100.0 * this.normalf(evt, chn, F0));
        evt.setCalper(chn, F0);
        FFT afft = new FFT();
        afft.doFFT(re, im, nfft, -1);
        re = afft.getReal();
        im = afft.getIm();
        i = 0;
        while (i <= nfft / 2) {
            double freq = (double)i / (double)nfft * evt.getSampleRate(chn);
            a = new Complex(re[i], im[i]);
            b = this.response(nz - zc, np, freq, z, p);
            c = a.multiply(b);
            re[i] = c.real() * A0;
            im[i] = c.imag() * A0;
            if (i != 0 && i != nfft / 2) {
                re[nfft - i] = re[i];
                im[nfft - i] = -im[i];
            }
            ++i;
        }
        afft.doFFT(re, im, nfft, 1);
        re = afft.getReal();
        i = 0;
        while (i < samp) {
            int n = i++;
            re[n] = re[n] * 100.0;
        }
        evt.setSampData(chn, re);
        zc = 0;
        int new_np = evt.getPoleNum(chn) + np;
        int new_nz = evt.getZeroNum(chn) + nz - zc;
        Complex[] new_pole = new Complex[new_np];
        Complex[] new_zero = new Complex[new_nz];
        i = 0;
        while (i < evt.getPoleNum(chn)) {
            new_pole[i] = evt.getPole(chn)[i];
            ++i;
        }
        i = 0;
        while (i < evt.getZeroNum(chn)) {
            new_zero[i] = evt.getZero(chn)[i];
            ++i;
        }
        Complex ctemp = null;
        i = 0;
        while (i < nz - zc) {
            new_zero[evt.getZeroNum((int)chn) + i] = ctemp = z[i].multiply(1.0);
            ++i;
        }
        i = 0;
        while (i < np) {
            new_pole[evt.getPoleNum((int)chn) + i] = ctemp = p[i].multiply(1.0);
            ++i;
        }
        evt.setCalper(chn, F0);
        evt.setScaleFactor(chn, 1.0 / this.normalf(evt, chn, F0) * evt.getScaleFactor(chn));
        evt.setPole(chn, new_pole);
        evt.setZero(chn, new_zero);
        return true;
    }
}

